/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.effects;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.GameSettings;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.collections.ObjectArray;
import org.orecruncher.sndctrl.api.effects.AbstractEntityEffect;
import org.orecruncher.sndctrl.api.effects.IEntityEffectManager;

@OnlyIn(value=Dist.CLIENT)
public class EntityEffectManager
implements IEntityEffectManager {
    private static final List<String> DUMMY_EFFECTS = ImmutableList.of((Object)"Dummy EffectHandler");
    private static final List<String> NO_EFFECTS = ImmutableList.of((Object)"No Effects");
    protected final LivingEntity subject;
    protected final ObjectArray<AbstractEntityEffect> activeEffects;
    protected boolean isActive = true;
    protected double rangeToPlayer;

    public EntityEffectManager(@Nonnull LivingEntity entity) {
        this.subject = entity;
        this.activeEffects = null;
    }

    public EntityEffectManager(@Nonnull LivingEntity entity, @Nonnull ObjectArray<AbstractEntityEffect> effects) {
        this.subject = entity;
        this.activeEffects = effects;
        for (AbstractEntityEffect ee : this.activeEffects) {
            ee.intitialize(this);
        }
    }

    public void update() {
        if (!this.isActive()) {
            return;
        }
        this.isActive = this.isEntityAlive();
        if (this.activeEffects != null) {
            this.rangeToPlayer = this.subject.func_70068_e((Entity)this.thePlayer());
            for (AbstractEntityEffect eff : this.activeEffects) {
                if (!this.isActive && !eff.receiveLastCall()) continue;
                eff.update();
            }
        }
    }

    public void die() {
        this.isActive = false;
        if (this.activeEffects != null) {
            for (AbstractEntityEffect e : this.activeEffects) {
                e.die();
            }
        }
    }

    @Nonnull
    public List<String> getAttachedEffects() {
        if (this.activeEffects == null) {
            return DUMMY_EFFECTS;
        }
        if (this.activeEffects.size() == 0) {
            return NO_EFFECTS;
        }
        return this.activeEffects.stream().map(AbstractEntityEffect::toString).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public LivingEntity getEntity() {
        return this.subject;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public boolean isEntityAlive() {
        return this.subject.func_70089_S();
    }

    @Override
    public double rangeToPlayerSq() {
        return this.rangeToPlayer;
    }

    @Override
    public boolean isFirstPersonView() {
        GameSettings settings = GameUtils.getGameSettings();
        return settings.func_243230_g() == PointOfView.FIRST_PERSON;
    }

    @Override
    public void addParticle(@Nonnull Particle particle) {
        GameUtils.getMC().field_71452_i.func_78873_a(particle);
    }

    @Override
    public boolean isActivePlayer(@Nonnull LivingEntity player) {
        PlayerEntity ep = this.thePlayer();
        return ep.func_145782_y() == player.func_145782_y();
    }

    @Override
    @Nonnull
    public PlayerEntity thePlayer() {
        return GameUtils.getPlayer();
    }
}

