/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.fml;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.orecruncher.lib.GameUtils;

public final class ForgeUtils {
    private ForgeUtils() {
    }

    @Nonnull
    public static Optional<? extends ModContainer> findModContainer(@Nonnull String modId) {
        return ModList.get().getModContainerById(modId);
    }

    @Nonnull
    public static Optional<IModInfo> getModInfo(@Nonnull String modId) {
        return ForgeUtils.findModContainer(modId).map(ModContainer::getModInfo);
    }

    @Nonnull
    public static String getModDisplayName(@Nonnull String modId) {
        if ("minecraft".equalsIgnoreCase(modId)) {
            return "Minecraft";
        }
        return ForgeUtils.getModInfo(modId).map(IModInfo::getDisplayName).orElse("UNKNOWN");
    }

    @Nonnull
    public static String getModDisplayName(@Nonnull ResourceLocation resource) {
        Objects.requireNonNull(resource);
        return ForgeUtils.getModDisplayName(resource.func_110624_b());
    }

    @Nullable
    public static ArtifactVersion getForgeVersion() {
        return ForgeUtils.getModInfo("forge").map(IModInfo::getVersion).orElse(null);
    }

    @Nonnull
    public static List<String> getModIdList() {
        List<String> result = ModList.get().getModFiles().stream().flatMap(e -> e.getMods().stream()).map(IModInfo::getModId).distinct().collect(Collectors.toList());
        result.remove("minecraft");
        result.add(0, "minecraft");
        return result;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nonnull
    public static Collection<ResourcePackInfo> getEnabledResourcePacks() {
        return GameUtils.getMC().func_195548_H().func_198980_d();
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nonnull
    public static List<String> getResourcePackIdList() {
        return ForgeUtils.getEnabledResourcePacks().stream().flatMap(e -> e.func_195796_e().func_195759_a(ResourcePackType.CLIENT_RESOURCES).stream()).collect(Collectors.toList());
    }

    @Nonnull
    public static Collection<Biome> getBiomes() {
        return ForgeRegistries.BIOMES.getValues();
    }

    @Nonnull
    public static Collection<BlockState> getBlockStates() {
        return StreamSupport.stream(ForgeRegistries.BLOCKS.spliterator(), false).map(block -> block.func_176194_O().func_177619_a()).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

