/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.math;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;

public class BlockRayTrace {
    private static final double NUDGE = -1.0E-7;
    final IBlockReader world;
    final RayTraceContext.BlockMode blockMode;
    final RayTraceContext.FluidMode fluidMode;
    final ISelectionContext selectionCtx;
    Vector3d start;
    Vector3d end;

    public BlockRayTrace(@Nonnull IBlockReader world, @Nonnull RayTraceContext.BlockMode bm, @Nonnull RayTraceContext.FluidMode fm) {
        this(world, Vector3d.field_186680_a, Vector3d.field_186680_a, bm, fm);
    }

    public BlockRayTrace(@Nonnull IBlockReader world, @Nonnull Vector3d start, @Nonnull Vector3d end, @Nonnull RayTraceContext.BlockMode bm, @Nonnull RayTraceContext.FluidMode fm) {
        this.world = world;
        this.start = start;
        this.end = end;
        this.blockMode = bm;
        this.fluidMode = fm;
        this.selectionCtx = ISelectionContext.func_216377_a();
    }

    @Nonnull
    public BlockRayTraceResult trace() {
        return this.traceLoop();
    }

    @Nonnull
    public BlockRayTraceResult trace(@Nonnull Vector3d start, @Nonnull Vector3d end) {
        this.start = start;
        this.end = end;
        return this.traceLoop();
    }

    @Nonnull
    private BlockRayTraceResult traceLoop() {
        int posZ;
        int posY;
        if (this.start.equals((Object)this.end)) {
            return this.miss();
        }
        double lerpX = MathHelper.func_219803_d((double)-1.0E-7, (double)this.start.field_72450_a, (double)this.end.field_72450_a);
        double lerpY = MathHelper.func_219803_d((double)-1.0E-7, (double)this.start.field_72448_b, (double)this.end.field_72448_b);
        double lerpZ = MathHelper.func_219803_d((double)-1.0E-7, (double)this.start.field_72449_c, (double)this.end.field_72449_c);
        int posX = MathHelper.func_76128_c((double)lerpX);
        BlockPos.Mutable mutablePos = new BlockPos.Mutable(posX, posY = MathHelper.func_76128_c((double)lerpY), posZ = MathHelper.func_76128_c((double)lerpZ));
        BlockRayTraceResult traceResult = this.hitCheck((BlockPos)mutablePos);
        if (traceResult == null) {
            double xLerp = MathHelper.func_219803_d((double)-1.0E-7, (double)this.end.field_72450_a, (double)this.start.field_72450_a);
            double yLerp = MathHelper.func_219803_d((double)-1.0E-7, (double)this.end.field_72448_b, (double)this.start.field_72448_b);
            double zLerp = MathHelper.func_219803_d((double)-1.0E-7, (double)this.end.field_72449_c, (double)this.start.field_72449_c);
            double lenX = xLerp - lerpX;
            double lenY = yLerp - lerpY;
            double lenZ = zLerp - lerpZ;
            int dirX = MathHelper.func_219802_k((double)lenX);
            int dirY = MathHelper.func_219802_k((double)lenY);
            int dirZ = MathHelper.func_219802_k((double)lenZ);
            double deltaX = dirX == 0 ? Double.MAX_VALUE : (double)dirX / lenX;
            double deltaY = dirY == 0 ? Double.MAX_VALUE : (double)dirY / lenY;
            double deltaZ = dirZ == 0 ? Double.MAX_VALUE : (double)dirZ / lenZ;
            double X = deltaX * (dirX > 0 ? 1.0 - MathHelper.func_181162_h((double)lerpX) : MathHelper.func_181162_h((double)lerpX));
            double Y = deltaY * (dirY > 0 ? 1.0 - MathHelper.func_181162_h((double)lerpY) : MathHelper.func_181162_h((double)lerpY));
            double Z = deltaZ * (dirZ > 0 ? 1.0 - MathHelper.func_181162_h((double)lerpZ) : MathHelper.func_181162_h((double)lerpZ));
            do {
                if (X > 1.0 && Y > 1.0 && Z > 1.0) {
                    return this.miss();
                }
                if (X < Y) {
                    if (X < Z) {
                        posX += dirX;
                        X += deltaX;
                        continue;
                    }
                    posZ += dirZ;
                    Z += deltaZ;
                    continue;
                }
                if (Y < Z) {
                    posY += dirY;
                    Y += deltaY;
                    continue;
                }
                posZ += dirZ;
                Z += deltaZ;
            } while ((traceResult = this.hitCheck((BlockPos)mutablePos.func_181079_c(posX, posY, posZ))) == null);
        }
        return traceResult;
    }

    @Nonnull
    private BlockRayTraceResult miss() {
        Vector3d directionVec = this.start.func_178788_d(this.end);
        return BlockRayTraceResult.func_216352_a((Vector3d)this.end, (Direction)Direction.func_210769_a((double)directionVec.field_72450_a, (double)directionVec.field_72448_b, (double)directionVec.field_72449_c), (BlockPos)new BlockPos(this.end));
    }

    @Nullable
    private BlockRayTraceResult hitCheck(@Nonnull BlockPos pos) {
        double fluidDistance;
        VoxelShape voxelFluidShape;
        VoxelShape voxelShape;
        BlockRayTraceResult traceResult = null;
        BlockState state = this.world.func_180495_p(pos);
        if (!state.isAir(this.world, pos) && !(voxelShape = this.blockMode.get(state, this.world, pos, this.selectionCtx)).func_197766_b()) {
            traceResult = this.world.func_217296_a(this.start, this.end, pos, voxelShape, state);
        }
        BlockRayTraceResult fluidTraceResult = null;
        FluidState fluidState = state.func_204520_s();
        if (!fluidState.func_206888_e() && this.fluidMode.func_222248_a(fluidState) && !(voxelFluidShape = state.func_196954_c(this.world, pos)).func_197766_b()) {
            fluidTraceResult = voxelFluidShape.func_212433_a(this.start, this.end, pos);
        }
        if (traceResult == fluidTraceResult) {
            return null;
        }
        if (fluidTraceResult == null) {
            return traceResult;
        }
        if (traceResult == null) {
            return fluidTraceResult;
        }
        double blockDistance = this.start.func_72436_e(traceResult.func_216347_e());
        return blockDistance <= (fluidDistance = this.start.func_72436_e(fluidTraceResult.func_216347_e())) ? traceResult : fluidTraceResult;
    }
}

