/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.scripting;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import org.orecruncher.lib.Lib;
import org.orecruncher.lib.collections.ObjectArray;
import org.orecruncher.lib.logging.IModLog;
import org.orecruncher.lib.scripting.LibraryFunctions;
import org.orecruncher.lib.scripting.ScriptEngineLoader;
import org.orecruncher.lib.scripting.VariableSet;

public final class ExecutionContext {
    private static final IModLog LOGGER = Lib.LOGGER;
    private static final String FUNCTION_SHELL = "%s;";
    private final String contextName;
    private final ScriptEngine engine;
    private final ObjectArray<VariableSet<?>> variables = new ObjectArray(8);
    private final Map<String, CompiledScript> compiled = new HashMap<String, CompiledScript>();
    private final CompiledScript error;

    public ExecutionContext(@Nonnull String contextName) {
        this.contextName = contextName;
        this.engine = ScriptEngineLoader.getEngine();
        this.error = this.makeFunction("'<ERROR>'");
        this.engine.put("lib", new LibraryFunctions());
        Lib.LOGGER.info("JavaScript engine provided: %s", this.engine.getFactory().getEngineName());
    }

    public void put(@Nonnull String name, @Nullable Object obj) {
        this.engine.put(name, obj);
    }

    public void add(@Nonnull VariableSet<?> varSet) {
        if (this.engine.get(varSet.getSetName()) != null) {
            throw new IllegalStateException(String.format("Variable set '%s' already defined!", varSet.getSetName()));
        }
        this.variables.add(varSet);
        this.engine.put(varSet.getSetName(), varSet.getInterface());
    }

    public String getName() {
        return this.contextName;
    }

    public void update() {
        this.variables.forEach(VariableSet::update);
    }

    public boolean check(@Nonnull String script) {
        Optional<Object> result = this.eval(script);
        if (result.isPresent()) {
            return "true".equalsIgnoreCase(result.toString());
        }
        return false;
    }

    @Nonnull
    public Optional<Object> eval(@Nonnull String script) {
        CompiledScript func = this.compiled.get(script);
        if (func == null) {
            func = this.makeFunction(script);
            this.compiled.put(script, func);
        }
        try {
            Object result = func.eval();
            return Optional.ofNullable(result);
        }
        catch (Throwable t) {
            LOGGER.error(t, "Error execution script: %s", script);
            this.compiled.put(script, this.error);
            return Optional.of("ERROR?");
        }
    }

    @Nonnull
    private CompiledScript makeFunction(@Nonnull String script) {
        String source = String.format(FUNCTION_SHELL, script);
        try {
            return ((Compilable)((Object)this.engine)).compile(source);
        }
        catch (Throwable t) {
            LOGGER.error(t, "Error compiling script: %s", source);
            return this.error;
        }
    }
}

