/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.audio;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.sndctrl.api.sound.ISoundInstance;
import org.orecruncher.sndctrl.audio.WrappedSoundInstance;

@OnlyIn(value=Dist.CLIENT)
public class EntitySoundInstance
extends WrappedSoundInstance {
    @Nonnull
    private final Entity entity;
    private float x;
    private float y;
    private float z;

    public EntitySoundInstance(@Nonnull Entity entity, @Nonnull ISoundInstance sound) {
        super(sound);
        this.entity = Objects.requireNonNull(entity);
        this.updatePosition();
    }

    @Override
    public double func_147649_g() {
        return this.x;
    }

    @Override
    public double func_147654_h() {
        return this.y;
    }

    @Override
    public double func_147651_i() {
        return this.z;
    }

    @Override
    public boolean func_147667_k() {
        return !this.entity.func_70089_S() || super.func_147667_k();
    }

    @Override
    public int getPlayDelay() {
        return this.sound.getPlayDelay();
    }

    @Override
    public void setPlayDelay(int delay) {
        this.sound.setPlayDelay(delay);
    }

    private void updatePosition() {
        Vector3d box = this.entity.func_174813_aQ().func_189972_c();
        this.x = (float)box.field_72450_a;
        this.y = (float)box.field_72448_b;
        this.z = (float)box.field_72449_c;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_147667_k() && !this.func_217861_m()) {
            this.updatePosition();
        }
    }

    @Nonnull
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.entity.toString()).addValue((Object)this.func_147650_b().toString()).addValue((Object)this.func_184365_d().toString()).addValue((Object)this.func_147656_j().toString()).addValue((Object)this.getState().toString()).add("v", this.func_147653_e()).add("p", this.func_147655_f()).add("x", this.func_147649_g()).add("y", this.func_147654_h()).add("z", this.func_147651_i()).toString();
    }
}

