/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.audio;

import com.google.common.base.MoreObjects;
import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.TickCounter;
import org.orecruncher.lib.math.MathStuff;
import org.orecruncher.sndctrl.api.sound.IFadableSoundInstance;
import org.orecruncher.sndctrl.api.sound.ISoundCategory;
import org.orecruncher.sndctrl.api.sound.ISoundInstance;
import org.orecruncher.sndctrl.audio.WrappedSoundInstance;

@OnlyIn(value=Dist.CLIENT)
public class FadableSoundInstance
extends WrappedSoundInstance
implements IFadableSoundInstance {
    private static final float INITIAL_FADE = 2.0E-5f;
    private static final float FADE_AMOUNT = 0.02f;
    private boolean isFading;
    private float fadeScale = 2.0E-5f;
    private float fadeScaleTarget = 1.0f;
    private boolean isDonePlaying;
    private long lastTick = TickCounter.getTickCount();

    public FadableSoundInstance(@Nonnull ISoundInstance sound, @Nonnull ISoundCategory category) {
        super(sound, category);
    }

    public FadableSoundInstance(@Nonnull ISoundInstance sound) {
        super(sound);
    }

    @Override
    public void noFade() {
        this.isFading = false;
        this.fadeScale = this.fadeScaleTarget;
    }

    @Override
    public float func_147653_e() {
        return super.func_147653_e() * this.fadeScale;
    }

    @Override
    public boolean func_147667_k() {
        return this.isDonePlaying || super.func_147667_k();
    }

    @Override
    public void func_73660_a() {
        long tickDelta = TickCounter.getTickCount() - this.lastTick;
        if (tickDelta < 1L) {
            return;
        }
        super.func_73660_a();
        if (this.func_147667_k()) {
            return;
        }
        this.lastTick = TickCounter.getTickCount();
        if (this.fadeScale < this.fadeScaleTarget && !this.isFading()) {
            this.fadeScale += 0.02f * (float)tickDelta;
        } else if (this.isFading() || this.fadeScale > this.fadeScaleTarget) {
            this.fadeScale -= 0.02f * (float)tickDelta;
        }
        this.fadeScale = MathStuff.clamp(this.fadeScale, 0.0f, this.fadeScaleTarget);
        if (Float.compare(this.fadeScale, 0.0f) == 0) {
            this.isDonePlaying = true;
        }
    }

    @Override
    public void fade() {
        this.isFading = true;
    }

    @Override
    public void unfade() {
        this.isFading = false;
    }

    @Override
    public boolean isFading() {
        return this.isFading;
    }

    @Override
    public void setFadeVolume(float scale) {
        this.fadeScaleTarget = MathStuff.clamp1(scale);
    }

    @Nonnull
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.func_147650_b().toString()).addValue((Object)this.getSoundCategory().toString()).addValue((Object)this.getState().toString()).add("v", this.func_147653_e()).add("p", this.func_147655_f()).add("f", this.fadeScale).toString();
    }
}

