/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.config;

import java.util.Optional;
import javax.annotation.Nonnull;
import me.shedaniel.clothconfig2.forge.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.forge.api.ConfigBuilder;
import me.shedaniel.clothconfig2.forge.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.forge.impl.builders.SubCategoryBuilder;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.config.ClothAPIFactory;
import org.orecruncher.sndctrl.config.Config;
import org.orecruncher.sndctrl.library.IndividualSoundConfig;

@OnlyIn(value=Dist.CLIENT)
public class ConfigGenerator {
    @Nonnull
    public static SubCategoryBuilder generate(@Nonnull ConfigBuilder builder, @Nonnull ConfigEntryBuilder entryBuilder) {
        SubCategoryBuilder modCategory = ClothAPIFactory.createSubCategory(entryBuilder, "sndctrl.modname", TextFormatting.GOLD, false);
        SubCategoryBuilder subCategory = ClothAPIFactory.createSubCategory(entryBuilder, "sndctrl.cfg.logging", TextFormatting.YELLOW, false);
        subCategory.add((AbstractConfigListEntry)ClothAPIFactory.createBoolean(builder, Config.CLIENT.logging.enableLogging));
        subCategory.add((AbstractConfigListEntry)ClothAPIFactory.createInteger(builder, Config.CLIENT.logging.flagMask));
        modCategory.add((AbstractConfigListEntry)subCategory.build());
        subCategory = ClothAPIFactory.createSubCategory(entryBuilder, "sndctrl.cfg.sound", TextFormatting.YELLOW, false);
        subCategory.add((AbstractConfigListEntry)ClothAPIFactory.createBoolean(builder, Config.CLIENT.sound.enableEnhancedSounds));
        subCategory.add((AbstractConfigListEntry)ClothAPIFactory.createBoolean(builder, Config.CLIENT.sound.enableMonoConversion));
        subCategory.add((AbstractConfigListEntry)ClothAPIFactory.createBoolean(builder, Config.CLIENT.sound.enableOcclusionCalcs));
        subCategory.add((AbstractConfigListEntry)ClothAPIFactory.createBoolean(builder, Config.CLIENT.sound.occludeWeather));
        subCategory.add((AbstractConfigListEntry)ClothAPIFactory.createBoolean(builder, Config.CLIENT.sound.occludeRecords));
        subCategory.add((AbstractConfigListEntry)ClothAPIFactory.createInteger(builder, Config.CLIENT.sound.cullInterval));
        subCategory.add((AbstractConfigListEntry)ClothAPIFactory.createIntegerSlider(builder, Config.CLIENT.sound.backgroundThreadWorkers));
        subCategory.add((AbstractConfigListEntry)ClothAPIFactory.createStringList(builder, Config.CLIENT.sound.individualSounds, v -> {
            if (!IndividualSoundConfig.isValid(v)) {
                return Optional.of(new TranslationTextComponent("sndctrl.message.cfg.soundconfig.invalid"));
            }
            return Optional.empty();
        }));
        subCategory.add((AbstractConfigListEntry)ClothAPIFactory.createStringList(builder, Config.CLIENT.sound.startupSoundList, null));
        modCategory.add((AbstractConfigListEntry)subCategory.build());
        subCategory = ClothAPIFactory.createSubCategory(entryBuilder, "sndctrl.cfg.effects", TextFormatting.YELLOW, false);
        subCategory.add((AbstractConfigListEntry)ClothAPIFactory.createBoolean(builder, Config.CLIENT.effects.fixupRandoms));
        subCategory.add((AbstractConfigListEntry)ClothAPIFactory.createIntegerSlider(builder, Config.CLIENT.effects.effectRange));
        modCategory.add((AbstractConfigListEntry)subCategory.build());
        return modCategory;
    }
}

