/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.client.gui.widget.Slider;
import org.orecruncher.lib.gui.ColorPalette;
import org.orecruncher.sndctrl.api.sound.Category;
import org.orecruncher.sndctrl.api.sound.ISoundCategory;
import org.orecruncher.sndctrl.config.Config;

@OnlyIn(value=Dist.CLIENT)
public class QuickVolumeScreen
extends Screen
implements Slider.ISlider {
    private static final int CONTROL_WIDTH = 160;
    private static final int CONTROL_HEIGHT = 20;
    private static final int CONTROL_SPACING = 5;
    private static final Button.IPressable NULL_PRESSABLE = b -> {};
    private static final ITextComponent SUFFIX = new StringTextComponent("%");
    private static final ITextComponent FOOTER = new TranslationTextComponent("sndctrl.text.quickvolumemenu.footer");
    private static final ITextComponent TITLE = new TranslationTextComponent("sndctrl.text.quickvolumemenu.title");
    private static final ITextComponent OCCLUSION = new TranslationTextComponent("sndctrl.text.quickvolumemenu.occlusion");
    private final List<ISoundCategory> categories = new ArrayList<ISoundCategory>();
    private final List<Slider> sliders = new ArrayList<Slider>();
    private Button occlusionToggle;
    private int footerY;

    protected QuickVolumeScreen() {
        super(TITLE);
    }

    protected void func_231160_c_() {
        this.categories.clear();
        this.sliders.clear();
        this.categories.addAll(Category.getCategoriesForMenu());
        int leftSide = (this.field_230708_k_ - 160) / 2;
        int totalHeight = (this.categories.size() + 1) * 25;
        int top = (this.field_230709_l_ - totalHeight) / 2;
        for (ISoundCategory category : this.categories) {
            Slider slider = new Slider(leftSide, top, 160, 20, this.getSliderLabel(category.getTextComponent()), SUFFIX, 0.0, 100.0, (double)((int)(category.getVolumeScale() * 100.0f)), false, true, NULL_PRESSABLE, (Slider.ISlider)this);
            slider.field_230691_m_ = top;
            top += 25;
            this.func_230480_a_((Widget)slider);
            this.sliders.add(slider);
        }
        this.occlusionToggle = new Button(leftSide, top, 160, 20, this.generateTextForSetting(Config.CLIENT.sound.enableOcclusionCalcs), this::buttonPress);
        this.func_230480_a_((Widget)this.occlusionToggle);
        this.footerY = top += 25;
    }

    protected void buttonPress(@Nonnull Button button) {
        Config.CLIENT.sound.enableOcclusionCalcs.set((Object)((Boolean)Config.CLIENT.sound.enableOcclusionCalcs.get() == false ? 1 : 0));
        this.occlusionToggle.func_238482_a_(this.generateTextForSetting(Config.CLIENT.sound.enableOcclusionCalcs));
    }

    protected ITextComponent generateTextForSetting(@Nonnull ForgeConfigSpec.BooleanValue value) {
        IFormattableTextComponent txt = OCCLUSION.func_230531_f_().func_240702_b_(": ");
        if (((Boolean)value.get()).booleanValue()) {
            txt.func_230529_a_(DialogTexts.field_240630_a_);
        } else {
            txt.func_230529_a_(DialogTexts.field_240631_b_);
        }
        return txt;
    }

    protected ITextComponent getSliderLabel(@Nonnull ITextComponent text) {
        return ((IFormattableTextComponent)text).func_230529_a_((ITextComponent)new StringTextComponent(": "));
    }

    public boolean func_231177_au__() {
        return false;
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        for (Slider slider : this.sliders) {
            if (!slider.func_231047_b_(mouseX, mouseY)) continue;
            slider.sliderValue = slider.sliderValue + (double)(0.05f * (float)(delta > 0.0 ? 1 : -1));
            slider.updateSlider();
            break;
        }
        return false;
    }

    public boolean func_231048_c_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        for (Slider slider : this.sliders) {
            slider.dragging = false;
        }
        return false;
    }

    public void onChangeSliderValue(@Nonnull Slider slider) {
        int idx;
        for (idx = 0; idx < this.sliders.size() && this.sliders.get(idx) != slider; ++idx) {
        }
        if (idx >= this.sliders.size()) {
            return;
        }
        ISoundCategory category = this.categories.get(idx);
        category.setVolumeScale((float)slider.getValueInt() / 100.0f);
    }

    public void func_230430_a_(@Nonnull MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        QuickVolumeScreen.func_238472_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (ITextComponent)FOOTER, (int)(this.field_230708_k_ / 2), (int)this.footerY, (int)ColorPalette.WHITE.rgb());
    }
}

