/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.library;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.math.MathStuff;

@OnlyIn(value=Dist.CLIENT)
public final class IndividualSoundConfig {
    private static final String BLOCK_TOKEN = "block";
    private static final String CULL_TOKEN = "cull";
    private static final String DELIMITER = " ";
    public static final int DEFAULT_VOLUME_SCALE = 100;
    public static final int VOLUME_SCALE_MIN = 0;
    public static final int VOLUME_SCALE_MAX = 400;
    private final ResourceLocation location;
    private boolean isBocked;
    private boolean isCulled;
    private int volumeScale;

    public IndividualSoundConfig(@Nonnull ResourceLocation location) {
        this(location, false, false, 100);
    }

    public IndividualSoundConfig(@Nonnull ResourceLocation location, boolean isBlocked, boolean isCulled, int volumeScale) {
        this.location = location;
        this.isBocked = isBlocked;
        this.isCulled = isCulled;
        this.volumeScale = MathStuff.clamp(volumeScale, 0, 400);
    }

    public IndividualSoundConfig(@Nonnull IndividualSoundConfig source) {
        this.location = source.location;
        this.isBocked = source.isBocked;
        this.isCulled = source.isCulled;
        this.volumeScale = source.volumeScale;
    }

    public static boolean isValid(@Nonnull String text) {
        return IndividualSoundConfig.createFrom(text) != null;
    }

    private static boolean isResourceNameValid(@Nonnull String text) {
        if (!text.contains(":")) {
            return false;
        }
        ResourceLocation loc = ResourceLocation.func_208304_a((String)text);
        if (loc == null) {
            return false;
        }
        return loc.func_110623_a().length() > 0;
    }

    @Nullable
    public static IndividualSoundConfig createFrom(@Nonnull String entry) {
        IndividualSoundConfig result = null;
        String[] parts = entry.split(DELIMITER);
        if (parts.length == 0 || parts.length > 4) {
            return null;
        }
        if (IndividualSoundConfig.isResourceNameValid(parts[0])) {
            ResourceLocation res = new ResourceLocation(parts[0]);
            boolean isCulled = false;
            boolean isBlocked = false;
            int volumeControl = 100;
            for (int i = 1; i < parts.length; ++i) {
                if (CULL_TOKEN.compareToIgnoreCase(parts[i]) == 0) {
                    isCulled = true;
                    continue;
                }
                if (BLOCK_TOKEN.compareToIgnoreCase(parts[i]) == 0) {
                    isBlocked = true;
                    continue;
                }
                try {
                    volumeControl = MathStuff.clamp(Integer.parseInt(parts[i]), 0, 400);
                    continue;
                }
                catch (Throwable t) {
                    return null;
                }
            }
            result = new IndividualSoundConfig(res, isBlocked, isCulled, volumeControl);
        }
        return result;
    }

    @Nonnull
    public ResourceLocation getLocation() {
        return this.location;
    }

    public boolean isDefault() {
        return !this.isBocked && !this.isCulled && this.volumeScale == 100;
    }

    public boolean isBlocked() {
        return this.isBocked;
    }

    public void setIsBlocked(boolean flag) {
        this.isBocked = flag;
    }

    public boolean isCulled() {
        return this.isCulled;
    }

    public void setIsCulled(boolean flag) {
        this.isCulled = flag;
    }

    public float getVolumeScale() {
        return (float)this.volumeScale / 100.0f;
    }

    public int getVolumeScaleInt() {
        return this.volumeScale;
    }

    public void setVolumeScaleInt(int scale) {
        this.volumeScale = MathStuff.clamp(scale, 0, 400);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.location.toString());
        if (this.isBocked) {
            builder.append(DELIMITER).append(BLOCK_TOKEN);
        }
        if (this.isCulled) {
            builder.append(DELIMITER).append(CULL_TOKEN);
        }
        if (this.volumeScale != 100) {
            builder.append(DELIMITER).append(this.volumeScale);
        }
        return builder.toString();
    }
}

