/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiDynamicHorizontalRateBar;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.client.gui.element.text.InputValidator;
import mekanism.common.inventory.container.tile.EmptyTileContainer;
import mekanism.common.util.text.TextUtils;
import mekanism.generators.client.gui.element.GuiFissionReactorTab;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.content.fission.FissionReactorMultiblockData;
import mekanism.generators.common.network.PacketGeneratorsGuiInteract;
import mekanism.generators.common.tile.fission.TileEntityFissionReactorCasing;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;

public class GuiFissionReactorStats
extends GuiMekanismTile<TileEntityFissionReactorCasing, EmptyTileContainer<TileEntityFissionReactorCasing>> {
    private GuiTextField rateLimitField;

    public GuiFissionReactorStats(EmptyTileContainer<TileEntityFissionReactorCasing> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_((Widget)new GuiFissionReactorTab((IGuiWrapper)this, (TileEntityFissionReactorCasing)this.tile, GuiFissionReactorTab.FissionReactorTab.MAIN));
        this.func_230480_a_((Widget)new GuiDynamicHorizontalRateBar((IGuiWrapper)this, new GuiBar.IBarInfoHandler(){

            public ITextComponent getTooltip() {
                return GeneratorsLang.GAS_BURN_RATE.translate(new Object[]{((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)((GuiFissionReactorStats)GuiFissionReactorStats.this).tile).getMultiblock()).lastBurnRate});
            }

            public double getLevel() {
                return Math.min(1.0, ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)((GuiFissionReactorStats)GuiFissionReactorStats.this).tile).getMultiblock()).lastBurnRate / (double)((TileEntityFissionReactorCasing)GuiFissionReactorStats.this.tile).getMaxBurnRate());
            }
        }, 5, 114, this.field_146999_f - 12));
        this.rateLimitField = new GuiTextField((IGuiWrapper)this, 77, 128, 49, 12);
        this.func_230480_a_((Widget)this.rateLimitField);
        this.rateLimitField.setEnterHandler(this::setRateLimit);
        this.rateLimitField.setInputValidator(InputValidator.DECIMAL);
        this.rateLimitField.setMaxStringLength(4);
        this.rateLimitField.addCheckmarkButton(this::setRateLimit);
    }

    private void setRateLimit() {
        if (!this.rateLimitField.getText().isEmpty()) {
            try {
                double limit = Double.parseDouble(this.rateLimitField.getText());
                if (limit >= 0.0 && limit <= (double)((TileEntityFissionReactorCasing)this.tile).getMaxBurnRate()) {
                    limit = (double)Math.round(limit * 100.0) / 100.0;
                    MekanismGenerators.packetHandler.sendToServer(new PacketGeneratorsGuiInteract(PacketGeneratorsGuiInteract.GeneratorsGuiInteraction.INJECTION_RATE, (TileEntity)this.tile, limit));
                    this.rateLimitField.setText("");
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        this.drawTitleText(matrix, (ITextComponent)GeneratorsLang.FISSION_REACTOR_STATS.translate(new Object[0]), this.field_238743_q_);
        FissionReactorMultiblockData multiblock = (FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock();
        this.drawTextScaledBound(matrix, (ITextComponent)GeneratorsLang.FISSION_HEAT_STATISTICS.translate(new Object[0]), 6.0f, 20.0f, this.headingTextColor(), this.field_146999_f - 12);
        this.drawTextScaledBound(matrix, (ITextComponent)GeneratorsLang.FISSION_HEAT_CAPACITY.translate(new Object[]{TextUtils.format((long)((long)multiblock.heatCapacitor.getHeatCapacity()))}), 6.0f, 32.0f, this.titleTextColor(), this.field_146999_f - 12);
        this.drawTextScaledBound(matrix, (ITextComponent)GeneratorsLang.FISSION_SURFACE_AREA.translate(new Object[]{TextUtils.format((long)multiblock.surfaceArea)}), 6.0f, 42.0f, this.titleTextColor(), this.field_146999_f - 12);
        this.drawTextScaledBound(matrix, (ITextComponent)GeneratorsLang.FISSION_BOIL_EFFICIENCY.translate(new Object[]{((TileEntityFissionReactorCasing)this.tile).getBoilEfficiency()}), 6.0f, 52.0f, this.titleTextColor(), this.field_146999_f - 12);
        this.drawTextScaledBound(matrix, (ITextComponent)GeneratorsLang.FISSION_FUEL_STATISTICS.translate(new Object[0]), 6.0f, 68.0f, this.headingTextColor(), this.field_146999_f - 12);
        this.drawTextScaledBound(matrix, (ITextComponent)GeneratorsLang.FISSION_MAX_BURN_RATE.translate(new Object[]{TextUtils.format((long)((TileEntityFissionReactorCasing)this.tile).getMaxBurnRate())}), 6.0f, 80.0f, this.titleTextColor(), this.field_146999_f - 12);
        this.drawTextScaledBound(matrix, (ITextComponent)GeneratorsLang.FISSION_RATE_LIMIT.translate(new Object[]{multiblock.rateLimit}), 6.0f, 90.0f, this.titleTextColor(), this.field_146999_f - 12);
        this.drawTextScaledBound(matrix, (ITextComponent)GeneratorsLang.FISSION_CURRENT_BURN_RATE.translate(new Object[0]), 6.0f, 104.0f, this.titleTextColor(), this.field_146999_f - 12);
        this.drawTextScaledBound(matrix, (ITextComponent)GeneratorsLang.FISSION_SET_RATE_LIMIT.translate(new Object[0]), 6.0f, 130.0f, this.titleTextColor(), 69.0f);
        super.drawForegroundText(matrix, mouseX, mouseY);
    }
}

