/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.content.fusion;

import java.util.List;
import mekanism.common.lib.multiblock.MultiblockCache;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.generators.common.content.fusion.FusionReactorMultiblockData;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public class FusionReactorCache
extends MultiblockCache<FusionReactorMultiblockData> {
    private double plasmaTemperature = -1.0;
    private int injectionRate = -1;
    private boolean burning;

    private int getInjectionRate() {
        if (this.injectionRate == -1) {
            return 2;
        }
        return this.injectionRate;
    }

    public void merge(MultiblockCache<FusionReactorMultiblockData> mergeCache, List<ItemStack> rejectedItems) {
        super.merge(mergeCache, rejectedItems);
        this.plasmaTemperature = Math.max(this.plasmaTemperature, ((FusionReactorCache)mergeCache).plasmaTemperature);
        this.injectionRate = Math.max(this.injectionRate, ((FusionReactorCache)mergeCache).injectionRate);
        this.burning |= ((FusionReactorCache)mergeCache).burning;
    }

    public void apply(FusionReactorMultiblockData data) {
        super.apply((MultiblockData)data);
        if (this.plasmaTemperature >= 0.0) {
            data.plasmaTemperature = this.plasmaTemperature;
        }
        data.setInjectionRate(this.getInjectionRate());
        data.setBurning(this.burning);
        data.updateTemperatures();
    }

    public void sync(FusionReactorMultiblockData data) {
        super.sync((MultiblockData)data);
        this.plasmaTemperature = data.plasmaTemperature;
        this.injectionRate = data.getInjectionRate();
        this.burning = data.isBurning();
    }

    public void load(CompoundNBT nbtTags) {
        super.load(nbtTags);
        this.plasmaTemperature = nbtTags.func_74769_h("plasmaTemp");
        this.injectionRate = nbtTags.func_74762_e("injectionRate");
        this.burning = nbtTags.func_74767_n("burning");
    }

    public void save(CompoundNBT nbtTags) {
        super.save(nbtTags);
        nbtTags.func_74780_a("plasmaTemp", this.plasmaTemperature);
        nbtTags.func_74768_a("injectionRate", this.getInjectionRate());
        nbtTags.func_74757_a("burning", this.burning);
    }
}

