/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.network;

import java.util.function.Supplier;
import mekanism.api.functions.TriConsumer;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.WorldUtils;
import mekanism.generators.common.tile.fission.TileEntityFissionReactorCasing;
import mekanism.generators.common.tile.fission.TileEntityFissionReactorLogicAdapter;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorBlock;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorController;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorLogicAdapter;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketGeneratorsGuiInteract {
    private final GeneratorsGuiInteraction interaction;
    private final BlockPos tilePosition;
    private final double extra;

    public PacketGeneratorsGuiInteract(GeneratorsGuiInteraction interaction, TileEntity tile) {
        this(interaction, tile.func_174877_v());
    }

    public PacketGeneratorsGuiInteract(GeneratorsGuiInteraction interaction, TileEntity tile, double extra) {
        this(interaction, tile.func_174877_v(), extra);
    }

    public PacketGeneratorsGuiInteract(GeneratorsGuiInteraction interaction, BlockPos tilePosition) {
        this(interaction, tilePosition, 0.0);
    }

    public PacketGeneratorsGuiInteract(GeneratorsGuiInteraction interaction, BlockPos tilePosition, double extra) {
        this.interaction = interaction;
        this.tilePosition = tilePosition;
        this.extra = extra;
    }

    public static void handle(PacketGeneratorsGuiInteract message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            TileEntityMekanism tile;
            ServerPlayerEntity player = ctx.getSender();
            if (player != null && (tile = (TileEntityMekanism)WorldUtils.getTileEntity(TileEntityMekanism.class, (IBlockReader)player.field_70170_p, (BlockPos)message.tilePosition)) != null) {
                message.interaction.consume(tile, (PlayerEntity)player, message.extra);
            }
        });
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketGeneratorsGuiInteract pkt, PacketBuffer buf) {
        buf.func_179249_a((Enum)pkt.interaction);
        buf.func_179255_a(pkt.tilePosition);
        buf.writeDouble(pkt.extra);
    }

    public static PacketGeneratorsGuiInteract decode(PacketBuffer buf) {
        return new PacketGeneratorsGuiInteract((GeneratorsGuiInteraction)buf.func_179257_a(GeneratorsGuiInteraction.class), buf.func_179259_c(), buf.readDouble());
    }

    public static enum GeneratorsGuiInteraction {
        INJECTION_RATE((TriConsumer<TileEntityMekanism, PlayerEntity, Double>)((TriConsumer)(tile, player, extra) -> {
            if (tile instanceof TileEntityFusionReactorBlock) {
                ((TileEntityFusionReactorController)((Object)tile)).setInjectionRateFromPacket((int)Math.round(extra));
            } else if (tile instanceof TileEntityFissionReactorCasing) {
                ((TileEntityFissionReactorCasing)((Object)tile)).setRateLimitFromPacket((double)extra);
            }
        })),
        LOGIC_TYPE((TriConsumer<TileEntityMekanism, PlayerEntity, Double>)((TriConsumer)(tile, player, extra) -> {
            if (tile instanceof TileEntityFissionReactorLogicAdapter) {
                ((TileEntityFissionReactorLogicAdapter)tile).setLogicTypeFromPacket(TileEntityFissionReactorLogicAdapter.FissionReactorLogic.byIndexStatic((int)Math.round(extra)));
            } else if (tile instanceof TileEntityFusionReactorLogicAdapter) {
                ((TileEntityFusionReactorLogicAdapter)tile).setLogicTypeFromPacket(TileEntityFusionReactorLogicAdapter.FusionReactorLogic.byIndexStatic((int)Math.round(extra)));
            }
        })),
        FISSION_ACTIVE((TriConsumer<TileEntityMekanism, PlayerEntity, Double>)((TriConsumer)(tile, player, extra) -> {
            if (tile instanceof TileEntityFissionReactorCasing) {
                ((TileEntityFissionReactorCasing)((Object)tile)).setReactorActive(Math.round(extra) == 1L);
            }
        }));

        private final TriConsumer<TileEntityMekanism, PlayerEntity, Double> consumerForTile;

        private GeneratorsGuiInteraction(TriConsumer<TileEntityMekanism, PlayerEntity, Double> consumerForTile) {
            this.consumerForTile = consumerForTile;
        }

        public void consume(TileEntityMekanism tile, PlayerEntity player, double extra) {
            this.consumerForTile.accept((Object)tile, (Object)player, (Object)extra);
        }
    }
}

