/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.AutomationType;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableDouble;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.chemical.GasInventorySlot;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.tile.TileEntityGenerator;
import net.minecraft.tileentity.TileEntity;

public class TileEntityGasGenerator
extends TileEntityGenerator {
    private static final long MAX_GAS = 18000L;
    public FuelTank fuelTank;
    private long burnTicks;
    private int maxBurnTicks;
    private FloatingLong generationRate = FloatingLong.ZERO;
    private double gasUsedLastTick;
    private GasInventorySlot fuelSlot;
    private EnergyInventorySlot energySlot;

    public TileEntityGasGenerator() {
        super((IBlockProvider)GeneratorsBlocks.GAS_BURNING_GENERATOR, ((FloatingLong)MekanismConfig.general.FROM_H2.get()).multiply(2L));
    }

    @Nonnull
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks() {
        ChemicalTankHelper builder = ChemicalTankHelper.forSide(() -> ((TileEntityGasGenerator)this).getDirection());
        this.fuelTank = new FuelTank((IContentsListener)this);
        builder.addTank((IChemicalTank)this.fuelTank, new RelativeSide[]{RelativeSide.LEFT, RelativeSide.RIGHT, RelativeSide.BACK, RelativeSide.TOP, RelativeSide.BOTTOM});
        return builder.build();
    }

    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(() -> ((TileEntityGasGenerator)this).getDirection());
        this.fuelSlot = GasInventorySlot.fill((IGasTank)this.fuelTank, (IContentsListener)this, (int)17, (int)35);
        builder.addSlot((IInventorySlot)this.fuelSlot, new RelativeSide[]{RelativeSide.FRONT, RelativeSide.LEFT, RelativeSide.BACK, RelativeSide.TOP, RelativeSide.BOTTOM});
        this.energySlot = EnergyInventorySlot.drain((IEnergyContainer)this.getEnergyContainer(), (IContentsListener)this, (int)143, (int)35);
        builder.addSlot((IInventorySlot)this.energySlot, new RelativeSide[]{RelativeSide.RIGHT});
        this.fuelSlot.setSlotOverlay(SlotOverlay.MINUS);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        boolean operate;
        super.onUpdateServer();
        this.energySlot.drainContainer();
        this.fuelSlot.fillTank();
        boolean bl = operate = (!this.fuelTank.isEmpty() || this.burnTicks > 0L) && MekanismUtils.canFunction((TileEntity)this);
        if (operate && this.getEnergyContainer().insert(this.generationRate, Action.SIMULATE, AutomationType.INTERNAL).isZero()) {
            this.setActive(true);
            if (!this.fuelTank.isEmpty() && ((Gas)this.fuelTank.getType()).has(GasAttributes.Fuel.class)) {
                GasAttributes.Fuel fuel = (GasAttributes.Fuel)((Gas)this.fuelTank.getType()).get(GasAttributes.Fuel.class);
                this.maxBurnTicks = fuel.getBurnTicks();
                this.generationRate = fuel.getEnergyPerTick();
            }
            long toUse = this.getToUse();
            FloatingLong toUseGeneration = this.generationRate.multiply(toUse);
            this.output = ((FloatingLong)MekanismConfig.general.FROM_H2.get()).max(toUseGeneration).multiply(2L);
            long total = this.burnTicks + this.fuelTank.getStored() * (long)this.maxBurnTicks;
            total -= toUse;
            this.getEnergyContainer().insert(toUseGeneration, Action.EXECUTE, AutomationType.INTERNAL);
            if (!this.fuelTank.isEmpty()) {
                this.fuelTank.setStack(new GasStack((GasStack)this.fuelTank.getStack(), total / (long)this.maxBurnTicks));
            }
            this.burnTicks = total % (long)this.maxBurnTicks;
            this.gasUsedLastTick = (double)toUse / (double)this.maxBurnTicks;
        } else {
            if (!operate) {
                this.reset();
            }
            this.gasUsedLastTick = 0.0;
            this.setActive(false);
        }
    }

    private void reset() {
        this.burnTicks = 0L;
        this.maxBurnTicks = 0;
        this.generationRate = FloatingLong.ZERO;
        this.output = ((FloatingLong)MekanismConfig.general.FROM_H2.get()).multiply(2L);
    }

    private long getToUse() {
        if (this.generationRate.isZero() || this.fuelTank.isEmpty()) {
            return 0L;
        }
        long max = (long)Math.ceil(256.0 * ((double)this.fuelTank.getStored() / (double)this.fuelTank.getCapacity()));
        max = Math.min((long)this.maxBurnTicks * this.fuelTank.getStored() + this.burnTicks, max);
        max = Math.min((long)this.getEnergyContainer().getNeeded().divide(this.generationRate).intValue(), max);
        return max;
    }

    public FloatingLong getGenerationRate() {
        return this.generationRate;
    }

    public double getUsed() {
        return (double)Math.round(this.gasUsedLastTick * 100.0) / 100.0;
    }

    public int getMaxBurnTicks() {
        return this.maxBurnTicks;
    }

    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((long)this.fuelTank.getStored(), (long)this.fuelTank.getCapacity());
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableFloatingLong.create(this::getGenerationRate, value -> {
            this.generationRate = value;
        }));
        container.track((ISyncableData)SyncableFloatingLong.create(() -> this.output, value -> {
            this.output = value;
        }));
        container.track((ISyncableData)SyncableDouble.create(this::getUsed, value -> {
            this.gasUsedLastTick = value;
        }));
        container.track((ISyncableData)SyncableInt.create(this::getMaxBurnTicks, value -> {
            this.maxBurnTicks = value;
        }));
    }

    private class FuelTank
    extends ChemicalTankBuilder.BasicGasTank {
        protected FuelTank(IContentsListener listener) {
            super(18000L, ChemicalTankBuilder.GAS.notExternal, ChemicalTankBuilder.GAS.alwaysTrueBi, gas -> gas.has(GasAttributes.Fuel.class), null, listener);
        }

        public void setStack(@Nonnull GasStack stack) {
            boolean wasEmpty = this.isEmpty();
            super.setStack((ChemicalStack)stack);
            this.recheckOutput(stack, wasEmpty);
        }

        public void setStackUnchecked(@Nonnull GasStack stack) {
            boolean wasEmpty = this.isEmpty();
            super.setStackUnchecked((ChemicalStack)stack);
            this.recheckOutput(stack, wasEmpty);
        }

        private void recheckOutput(@Nonnull GasStack stack, boolean wasEmpty) {
            if (wasEmpty && !stack.isEmpty() && ((Gas)this.getType()).has(GasAttributes.Fuel.class)) {
                TileEntityGasGenerator.this.output = ((GasAttributes.Fuel)((Gas)this.getType()).get(GasAttributes.Fuel.class)).getEnergyPerTick().multiply(2L);
            }
        }
    }
}

