/*
BSLex (BSL Edit) by LexBoosT
*/

//Settings//
#include "/lib/settings.glsl"

//Fragment Shader///////////////////////////////////////////////////////////////////////////////////
#ifdef FSH

//Varyings//
varying vec2 texCoord;
uniform float frameTimeCounter;
varying vec4 color;

uniform float rainStrengthS;

//Uniforms//
uniform sampler2D texture;
uniform int heldItemId;

#ifdef CONSISTENT_ENCHANT
uniform int worldTime;
uniform ivec2 eyeBrightnessSmooth;
uniform float rainStrength;
#endif

#ifdef MAGICAL_GLINT
#include "/lib/color/hue.glsl"
#endif

#ifdef CONSISTENT_ENCHANT
float night = clamp((worldTime-13000.0)/300.0,0.0,1.0)-clamp((worldTime-22800.0)/200.0,0.0,1.0);
float cavelight = pow(eyeBrightnessSmooth.y / 255.0, 6.0) * 1.0 + (0.7 + 0.5*night);
#endif

//Program//
void main(){
    
    vec4 multiplier = color;
    
    #ifdef MODE_RAGE
    if(heldItemId==10267||heldItemId==10268||heldItemId==10276||heldItemId==10278||heldItemId==10283){
        multiplier = vec4 (1.0,0.0,0.0,1.0);
    }
    else
    {
        #endif
        #ifdef MAGICAL_GLINT
        multiplier = vec4(hue(frameTimeCounter * MAGICAL_GLINT_SPEED ), 1.0);
        #endif
        #ifdef MODE_RAGE
    }
    #endif
    
    
    vec4 albedo = texture2D(texture, texCoord ) * multiplier;
    
    #ifdef CONSISTENT_ENCHANT
    vec3 lighting = vec3(1.0+ (0.4*rainStrength - 0.4*rainStrength*night));
    lighting /= 0.8 - 0.5*night;
    lighting /= cavelight;
    
    albedo.rgb = pow(albedo.rgb*0.33, lighting);
    #else
    albedo.rgb = pow(albedo.rgb,vec3(2.2));
    #endif
    
    albedo.rgb *= GLINT_INTENSITY;
    
    /* DRAWBUFFERS:0 */
    gl_FragData[0]=albedo;
    
}

#endif

//Vertex Shader/////////////////////////////////////////////////////////////////////////////////////
#ifdef VSH

//Varyings//
varying vec2 texCoord;

varying vec4 color;
varying vec4 position;
//Uniforms//
#if AA>1
uniform int frameCounter;
uniform float viewWidth;
uniform float viewHeight;
#endif

uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;

uniform float frameTimeCounter;

//Includes//
#if AA>1
#include "/lib/util/jitter.glsl"
#endif
#ifdef WORLD_CURVATURE
#include "/lib/vertex/worldCurvature.glsl"
#endif

//Program//
void main(){
    texCoord=(gl_TextureMatrix[0]*gl_MultiTexCoord0).xy;
    
    color=gl_Color;
    
    vec4 position=gbufferModelViewInverse*gl_ModelViewMatrix*gl_Vertex;
    
    vec4 temppos=gl_ProjectionMatrix*gbufferModelView*position;
    
    if((temppos.z/temppos.w)<.56)//hand
    {
        
        #ifdef MOUVEMENTS_MAINS
        position-=vec4(.03*sin(frameTimeCounter*3.*SPEED_MOOVE),.015*cos(frameTimeCounter*4.*SPEED_MOOVE),0.,0.)*gbufferModelView;
        #endif
        
        #ifdef MOUVEMENTS_MAINS_2
        position.y+=sin(frameTimeCounter*3.*SPEED_MOOVE)*.015;
        position.z-=cos(frameTimeCounter*4.*SPEED_MOOVE)*.0015;
        #endif
        
        position=gbufferModelView*position;
        
        position.z-=ADVANCE_HAND_POS;
        position.y+=ADVANCE_HAND_POS2;
        position.x+=DECALLAGE_MAINS;
        
        gl_Position=gl_ProjectionMatrix*position;
        
    }
    else
    {
        #ifdef WORLD_CURVATURE
        if(gl_ProjectionMatrix[2][2]<-.5)position.y-=WorldCurvature(position.xz);
        #endif
        
        #ifdef MOUVEMENT_CAM
        position+=vec4(.03*sin(frameTimeCounter*3.*SPEED_MOOVE),.015*cos(frameTimeCounter*4.*SPEED_MOOVE),0.,0.)*gbufferModelView;
        #endif
        gl_Position=gl_ProjectionMatrix*gbufferModelView*position;
    }
    
    #if AA>1
    gl_Position.xy=TAAJitter(gl_Position.xy,gl_Position.w);
    #endif
}

#endif