/*
BSLex (BSL Edit) by LexBoosT
*/

//Settings//
#include "/lib/settings.glsl"

//Fragment Shader///////////////////////////////////////////////////////////////////////////////////
#ifdef FSH

//Varyings//
varying vec2 texCoord;

varying vec3 normal;
varying vec3 sunVec, upVec, eastVec;

varying vec4 color;

//Uniforms//
uniform int isEyeInWater;
uniform int worldTime;

uniform float rainStrength;
uniform float rainStrengthS;
uniform float screenBrightness;
uniform float timeAngle, timeBrightness;

uniform ivec2 eyeBrightnessSmooth;

uniform sampler2D texture;

//Common Variables//
float eBS = eyeBrightnessSmooth.y / 255.0;
float sunVisibility = clamp(dot(sunVec, upVec) + 0.05, 0.0, 0.1) * 10.0;
float moonVisibility = clamp(dot(-sunVec, upVec) + 0.05, 0.0, 0.1) * 10.0;

//Includes//
#include "/lib/color/lightColor.glsl"

//Program//
void main(){
	#ifndef CLOUDS
	vec4 albedo = texture2D(texture, texCoord.xy);
	albedo.rgb = pow(albedo.rgb,vec3(2.2));
	
	float vanillaDiffuse = clamp(0.25 * dot(normal, upVec) + 0.75,0.5,1.0);
	albedo.rgb *= lightCol * (vanillaDiffuse * (0.3 * sunVisibility + 0.2));
	
	albedo.a *= 0.5 * color.a;
	#else
	vec4 albedo = vec4(0.0);
	#endif
	
	/* DRAWBUFFERS:0 */
	gl_FragData[0] = albedo;
	
	#ifdef ADVANCED_MATERIALS
	/* DRAWBUFFERS:0367 */
	gl_FragData[1]=vec4(0.,0.,0.,1.);
	gl_FragData[2]=vec4(0.,0.,0.,1.);
	gl_FragData[3]=vec4(0.,0.,0.,1.);
	#endif
}

#endif

//Vertex Shader/////////////////////////////////////////////////////////////////////////////////////
#ifdef VSH

//Varyings//
varying vec2 texCoord;

varying vec3 normal;
varying vec3 sunVec,upVec,eastVec;

varying vec4 color;
varying vec4 position;

//Uniforms//
#if AA>1
uniform int frameCounter;

uniform float viewWidth;
uniform float viewHeight;
#include "/lib/util/jitter.glsl"
#endif

uniform float timeAngle;

uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;
uniform float frameTimeCounter;

//Program//
void main(){
	texCoord=(gl_TextureMatrix[0]*gl_MultiTexCoord0).xy;
	
	color=gl_Color;
	
	normal=normalize(gl_NormalMatrix*gl_Normal);
	
	vec4 position=gbufferModelViewInverse*gl_ModelViewMatrix*gl_Vertex;
	
	const vec2 sunRotationData=vec2(cos(sunPathRotation*.01745329251994),-sin(sunPathRotation*.01745329251994));
	float ang=fract(timeAngle-.25);
	ang=(ang+(cos(ang*3.14159265358979)*-.5+.5-ang)/3.)*6.28318530717959;
	sunVec=normalize((gbufferModelView*vec4(vec3(-sin(ang),cos(ang)*sunRotationData)*2000.,1.)).xyz);
	
	upVec=normalize(gbufferModelView[1].xyz);
	eastVec=normalize(gbufferModelView[0].xyz);
	
	gl_Position=ftransform();
	
	#ifdef MOUVEMENT_CAM
	position+=vec4(.03*sin(frameTimeCounter*3.*SPEED_MOOVE),.015*cos(frameTimeCounter*4.*SPEED_MOOVE),0.,0.)*gbufferModelView;
	#endif
	
	#if AA>1
	gl_Position.xy=TAAJitter(gl_Position.xy,gl_Position.w);
	#endif
}

#endif