/*
BSLex (BSL Edit) by LexBoosT
*/

//Settings//
#include "/lib/settings.glsl"

//Fragment Shader///////////////////////////////////////////////////////////////////////////////////
#ifdef FSH

//Extensions//

//Varyings//
varying vec2 texCoord, lmCoord;

varying vec3 normal;
varying vec3 sunVec, upVec, eastVec;

varying vec4 color;

#ifdef ADVANCED_MATERIALS
varying float dist;

varying vec3 binormal, tangent;
varying vec3 viewVector;

varying vec4 vTexCoord, vTexCoordAM;
#endif

//Uniforms//
uniform int entityId;
uniform int frameCounter;
uniform int isEyeInWater;
uniform int worldTime;
uniform int heldItemId;
uniform int heldItemId2;

#ifdef DYNAMIC_HAND_LIGHT
	uniform int heldBlockLightValue;
	uniform int heldBlockLightValue2;
#endif

uniform float frameTimeCounter;
uniform float nightVision;
uniform float rainStrength;
uniform float rainStrengthS;
uniform float screenBrightness;
uniform float shadowFade;
uniform float timeAngle, timeBrightness;
uniform float viewWidth, viewHeight;

uniform ivec2 eyeBrightnessSmooth;

uniform vec4 entityColor;

uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;

uniform sampler2D texture;

#ifdef WATER_CAUSTICS
#ifdef OVERWORLD
uniform vec3 cameraPosition;
uniform sampler2D noisetex;
#endif
#endif

#ifdef ADVANCED_MATERIALS
uniform ivec2 atlasSize;
uniform sampler2D specular;
uniform sampler2D normals;
#endif

uniform vec3 fogColor;

//Common Variables//
float eBS = eyeBrightnessSmooth.y / 255.0;
float sunVisibility  = clamp(dot( sunVec,upVec) + 0.05, 0.0, 0.1) * 10.0;
float moonVisibility = clamp(dot(-sunVec,upVec) + 0.05, 0.0, 0.1) * 10.0;

#ifdef ADVANCED_MATERIALS
vec2 dcdx = dFdx(texCoord);
vec2 dcdy = dFdy(texCoord);
#endif

vec3 lightVec = sunVec * ((timeAngle < 0.5325 || timeAngle > 0.9675) ? 1.0 : -1.0);

//Common Functions//
float GetLuminance(vec3 color){
	return dot(color,vec3(0.299, 0.587, 0.114));
}

float InterleavedGradientNoise(){
	float n = 52.9829189 * fract(0.06711056 * gl_FragCoord.x + 0.00583715 * gl_FragCoord.y);
	return fract(n + frameCounter / 8.0);
}

//Includes//
#include "/lib/color/blocklightColor.glsl"
#include "/lib/color/dimensionColor.glsl"
#include "/lib/util/dither.glsl"
#include "/lib/util/spaceConversion.glsl"
#include "/lib/lighting/forwardLighting.glsl"

#ifdef WATER_CAUSTICS
#ifdef OVERWORLD
#include "/lib/color/waterColor.glsl"
#include "/lib/lighting/caustics.glsl"
#endif
#endif

#if AA >1
#include "/lib/util/jitter.glsl"
#endif

#ifdef ADVANCED_MATERIALS
#include "/lib/color/specularColor.glsl"
#include "/lib/util/encode.glsl"
#include "/lib/reflections/complexFresnel.glsl"
#include "/lib/surface/ggx.glsl"
#include "/lib/surface/materialGbuffers.glsl"
#include "/lib/surface/parallax.glsl"
#endif

#if MC_VERSION >= 11500
#undef PARALLAX
#undef SELF_SHADOW
#endif

#ifdef TECHNO_XP
#include "/lib/color/hue.glsl"
#endif

//Program//
void main(){
	
	vec4 multiplier = color;
	
	
	if (entityId == 10002 && color.g > color.b + 0.1) {
		#ifdef TECHNO_XP
		float variant = floor(texCoord.x * 4.0) + floor(texCoord.y * 4.0) * 4.0;
		multiplier = vec4(hue(frameTimeCounter * 0.5 + variant * 0.1), 1.0);
		#else
		multiplier.a = 1.0;
		#endif
	}
	
	vec4 albedo = texture2D(texture, texCoord) * multiplier;
	
	vec3 newNormal = normal;
	float smoothness = 0.0, metalness = 0.0;
	vec3 baseReflectance = vec3(0.04);
	
	#ifdef LIGHTNING_BOLT_FIX
	float lightningBolt = float(entityId == 22258);
	if (lightningBolt > 0.5) albedo.rgb = vec3(10.0, 12.5, 15.0), albedo.a = 0.1;
	#endif
	
	#ifdef ADVANCED_MATERIALS
	vec2 newCoord = vTexCoord.st * vTexCoordAM.pq + vTexCoordAM.st;
	float parallaxFade = clamp((dist - PARALLAX_DISTANCE) / 32.0, 0.0, 1.0);
	float skipAdvMat = float(entityId == 10018);
	
	#ifdef PARALLAX
	if (skipAdvMat < 0.5){
		newCoord = GetParallaxCoord(parallaxFade);
		albedo = texture2DGradARB(texture, newCoord, dcdx, dcdy) * color;
	}
	#endif
	
	float skyOcclusion = 0.0;
	vec3 fresnel3 = vec3(0.0);
	#endif
	
	albedo.rgb = mix(albedo.rgb, entityColor.rgb, entityColor.a);
	
	if (albedo.a > 0.001 && lightningBolt < 0.5){
		
		vec2 lightmap = clamp(lmCoord, vec2(0.0), vec2(1.0));
		
		float emissive = float(entityColor.a > 0.05) * 0.125;
		
		#ifdef FLASH_VICTIME

		bool flash = false;

		#ifdef FLASH_SWORD
			if((heldItemId==10278) || (heldItemId==10267) || ( heldItemId == 10268) || (heldItemId == 10272) || (heldItemId == 10276) || (heldItemId == 10283) ||
			   (heldItemId2==10278) || (heldItemId2==10267) || ( heldItemId2 == 10268) || (heldItemId2 == 10272) || (heldItemId2 == 10276) || (heldItemId2 == 10283))
			   flash = true;
		#endif

		#ifdef FLASH_AXE
			if((heldItemId==10746) || (heldItemId==10279) || ( heldItemId == 10286) || (heldItemId == 10258) || (heldItemId == 10275) || (heldItemId == 10271) ||
			   (heldItemId2==10746) || (heldItemId2==10279) || ( heldItemId2 == 10286) || (heldItemId2 == 10258) || (heldItemId2 == 10275) || (heldItemId2 == 10271))
				flash = true;
		#endif
		#ifdef FLASH_BOW
			if((heldItemId==10262) || (heldItemId == 10261) ||
			   (heldItemId2==10262) || (heldItemId2 == 10261))
			   	flash = true;
		#endif
		#ifdef FLASH_TRIDENT
			if((heldItemId == 19999)||
			   (heldItemId2 == 19999))
			   	flash = true;
		#endif
		#ifdef FLASH_SNOWBALL
			if((heldItemId == 10332 || 
			    heldItemId2 == 10332 ))
				flash = true;
		#endif
		#ifdef FLASH_FISHING
			if((heldItemId == 10346) || 
			    (heldItemId2 == 10346))
				flash = true;
		#endif
		#ifdef FLASH_EGG
			if((heldItemId == 10344 || 
			    heldItemId2 == 10344))
				flash = true;
		#endif
			if(flash)
			{
				if(entityId != 10401 && entityId != 10311 && entityId != 10312 && entityId != 10313 && entityId != 10187)	{
				
					float oscillation = 0;
					
					#ifdef OSCILLATION
					oscillation = sin(frameTimeCounter * OSCILLATION_SPEED);
					oscillation = oscillation * oscillation;
					#endif
					emissive = mix(INTENSITE_FLASH_VICTIME / 10,emissive,oscillation);	
				}
			}
		#endif
		
		vec3 screenPos = vec3(gl_FragCoord.xy / vec2(viewWidth, viewHeight), gl_FragCoord.z);
		#if AA > 1
		vec3 viewPos = ToNDC(vec3(TAAJitter(screenPos.xy, -0.5), screenPos.z));
		#else
		vec3 viewPos = ToNDC(screenPos);
		#endif
		vec3 worldPos = ToWorld(viewPos);
		
		float lViewPos = length(viewPos.xyz);

		#ifdef ADVANCED_MATERIALS
		float metalness = 0.0, f0 = 0.0, ao = 1.0;
		vec3 normalMap = vec3(0.0, 0.0, 1.0);
		
		GetMaterials(smoothness, metalness, f0, emissive, ao, normalMap, newCoord, dcdx, dcdy);
		
		#if MC_VERSION >= 11500
		normalMap = vec3(0.0, 0.0, 1.0);
		#endif
		
		mat3 tbnMatrix = mat3(tangent.x, binormal.x, normal.x,
			tangent.y, binormal.y, normal.y,
		tangent.z, binormal.z, normal.z);
		
		if (normalMap.x > -0.999 && normalMap.y > -0.999 && skipAdvMat < 0.5)
		newNormal = clamp(normalize(normalMap * tbnMatrix), vec3(-1.0), vec3(1.0));
		#endif
		
		albedo.rgb = pow(albedo.rgb, vec3(2.2));
		
		#ifdef WHITE_WORLD
		#ifdef ENTITIESW
		albedo.rgb = vec3(0.5);
		#endif
		#endif
		#ifdef BLACK_WORLD
		#ifdef ENTITIESW
		albedo.rgb = vec3(0.0);
		#endif
		#endif
		
		float NoL = clamp(dot(newNormal, lightVec) * 1.01 - 0.01, 0.0, 1.0);
		
		float NoU = clamp(dot(newNormal, upVec), -1.0, 1.0);
		float NoE = clamp(dot(newNormal, eastVec), -1.0, 1.0);
		float vanillaDiffuse = (0.25 * NoU + 0.75) + (0.667 - abs(NoE)) * (1.0 - abs(NoU)) * 0.15;
		vanillaDiffuse*= vanillaDiffuse;
		
		float parallaxShadow = 1.0;
		#ifdef ADVANCED_MATERIALS
		vec3 rawAlbedo = albedo.rgb * 0.999 + 0.001;
		albedo.rgb *= ao;
		
		#ifdef REFLECTION_SPECULAR
		float roughnessSqr = (1.0 - smoothness) * (1.0 - smoothness);
		albedo.rgb *= (1.0 - metalness * (1.0 - roughnessSqr));
		#endif
		
		float doParallax = 0.0;
		#ifdef SELF_SHADOW
		#ifdef OVERWORLD
		doParallax = float(lightmap.y > 0.0 && NoL > 0.0);
		#endif
		#ifdef END
		doParallax = float(NoL > 0.0);
		#endif
		
		if (doParallax > 0.5){
			parallaxShadow = GetParallaxShadow(parallaxFade, newCoord, lightVec, tbnMatrix);
			NoL *= parallaxShadow;
		}
		#endif
		#endif
		
		vec3 shadow = vec3(0.0);
		GetLighting(albedo.rgb, shadow, viewPos, lViewPos, worldPos, lightmap, 1.0, NoL, vanillaDiffuse,
		parallaxShadow, emissive, 0.0,0.0);
		
		#ifdef ADVANCED_MATERIALS
		skyOcclusion = lightmap.y * lightmap.y * (3.0 - 2.0 * lightmap.y);
		
		vec3 baseReflectance = mix(vec3(f0), rawAlbedo, metalness);
		float fresnel = pow(clamp(1.0 + dot(newNormal, normalize(viewPos.xyz)), 0.0, 1.0), 5.0);
		
		fresnel3 = mix(baseReflectance, vec3(1.0), fresnel);
		#if MATERIAL_FORMAT == 1
		if (f0 >= 0.9 && f0 < 1.0) {
			baseReflectance = GetMetalCol(f0);
			fresnel3 = ComplexFresnel(fresnel, f0);
			#ifdef ALBEDO_METAL
			fresnel3 *= rawAlbedo;
			#endif
		}
		#endif
		
		float so = pow(max(ao * 2.0 - 1.0, 0.0), 2.0);
		fresnel3 *= so;
		albedo.rgb = albedo.rgb * (1.0 - fresnel3 * smoothness * smoothness * (1.0 - metalness));
		
		#if defined OVERWORLD || defined END
		vec3 specularColor = GetSpecularColor(lightmap.y, metalness, baseReflectance);
		
		albedo.rgb += GetSpecularHighlight(newNormal, viewPos, lightVec, smoothness, baseReflectance,
		specularColor, 0.0, shadow * vanillaDiffuse, 1.0);
		#endif
		
		#if defined REFLECTION_SPECULAR && defined REFLECTION_ROUGH
		normalMap = mix(vec3(0.0, 0.0, 1.0), normalMap, smoothness);
		newNormal = clamp(normalize(normalMap * tbnMatrix), vec3(-1.0), vec3(1.0));
		#endif
		#endif
		
		#if defined WATER_CAUSTICS && defined OVERWORLD
		if (isEyeInWater == 1) {
			float skyLightMap = lightmap.y * lightmap.y * (3.0 - 2.0 * lightmap.y);
			shadow *= NoL;
			albedo.rgb = GetCaustics(albedo.rgb, worldPos.xyz, cameraPosition.xyz, shadow, skyLightMap, lightmap.x);
		}
		#endif
	}
	
	
	/* DRAWBUFFERS:0 */
	gl_FragData[0] = albedo;
	
	#if defined ADVANCED_MATERIALS && defined REFLECTION_SPECULAR
	/* DRAWBUFFERS:0367 */
	gl_FragData[1]=vec4(smoothness,skyOcclusion,0.,1.);
	gl_FragData[2]=vec4(EncodeNormal(newNormal),float(gl_FragCoord.z<1.),1.);
	gl_FragData[3]=vec4(fresnel3,1.);
	#endif
}

#endif

//Vertex Shader/////////////////////////////////////////////////////////////////////////////////////
#ifdef VSH

//Varyings//
varying vec2 texCoord,lmCoord;

varying vec3 normal;
varying vec3 sunVec,upVec,eastVec;
varying vec4 color;
varying vec4 position;

#ifdef ADVANCED_MATERIALS
varying float dist;

varying vec3 binormal,tangent;
varying vec3 viewVector;

varying vec4 vTexCoord,vTexCoordAM;
#endif

//Uniforms//
uniform int worldTime;

uniform float frameTimeCounter;
uniform float timeAngle;
uniform int heldItemId;
uniform int heldItemId2;
uniform vec3 cameraPosition;

uniform mat4 gbufferModelView,gbufferModelViewInverse;

#if AA>1
uniform int frameCounter;
uniform float viewWidth,viewHeight;
#endif

//Attributes//
attribute vec4 mc_Entity;

#ifdef ADVANCED_MATERIALS
attribute vec4 mc_midTexCoord;
attribute vec4 at_tangent;
#endif

//Includes//
#if AA>1
#include "/lib/util/jitter.glsl"
#endif

#ifdef WORLD_CURVATURE
#include "/lib/vertex/worldCurvature.glsl"
#endif

//Program//
void main(){
	texCoord=(gl_TextureMatrix[0]*gl_MultiTexCoord0).xy;
	
	lmCoord=(gl_TextureMatrix[1]*gl_MultiTexCoord1).xy;
	lmCoord=clamp((lmCoord-.03125)*1.06667,0.,1.);
	
	normal=normalize(gl_NormalMatrix*gl_Normal);
	
	#ifdef ADVANCED_MATERIALS
	tangent=normalize(gl_NormalMatrix*at_tangent.xyz);
	binormal=normalize(gl_NormalMatrix*cross(at_tangent.xyz,gl_Normal.xyz)*at_tangent.w);
	
	mat3 tbnMatrix=mat3(tangent.x,binormal.x,normal.x,
		tangent.y,binormal.y,normal.y,
	tangent.z,binormal.z,normal.z);
	
	viewVector=tbnMatrix*(gl_ModelViewMatrix*gl_Vertex).xyz;
	
	dist=length(gl_ModelViewMatrix*gl_Vertex);
	
	vec2 midCoord=(gl_TextureMatrix[0]*mc_midTexCoord).st;
	vec2 texMinMidCoord=texCoord-midCoord;
	
	vTexCoordAM.pq=abs(texMinMidCoord)*2;
	vTexCoordAM.st=min(texCoord,midCoord-texMinMidCoord);
	
	vTexCoord.xy=sign(texMinMidCoord)*.5+.5;
	#endif
	
	color=gl_Color;
	
	const vec2 sunRotationData=vec2(cos(sunPathRotation*.01745329251994),-sin(sunPathRotation*.01745329251994));
	float ang=fract(timeAngle-.25);
	ang=(ang+(cos(ang*3.14159265358979)*-.5+.5-ang)/3.)*6.28318530717959;
	sunVec=normalize((gbufferModelView*vec4(vec3(-sin(ang),cos(ang)*sunRotationData)*2000.,1.)).xyz);
	
	upVec=normalize(gbufferModelView[1].xyz);
	eastVec=normalize(gbufferModelView[0].xyz);
	
	vec4 position=gbufferModelViewInverse*gl_ModelViewMatrix*gl_Vertex;
	
	#ifdef WORLD_CURVATURE
	position.y-=WorldCurvature(position.xz);
	#else
	gl_Position=ftransform();
	#endif
	
	#ifdef MOUVEMENT_CAM
	position+=vec4(.03*sin(frameTimeCounter*3.*SPEED_MOOVE),.015*cos(frameTimeCounter*4.*SPEED_MOOVE),0.,0.)*gbufferModelView;
	#endif
	
	gl_Position=gl_ProjectionMatrix*gbufferModelView*position;
	
	#if AA>1
	gl_Position.xy=TAAJitter(gl_Position.xy,gl_Position.w);
	#endif
}

#endif