/*
BSLex (BSL Edit) by LexBoosT
*/

//Settings//
#include "/lib/settings.glsl"

//Fragment Shader///////////////////////////////////////////////////////////////////////////////////
#ifdef FSH

//Varyings//
varying vec2 texCoord;

varying vec3 upVec, sunVec;

varying mat3 moonRotMatrix;

varying vec4 color;

//Uniforms//
uniform float nightVision;
uniform float rainStrength;
uniform float rainStrengthS;
uniform float screenBrightness;
uniform float timeAngle, timeBrightness;
uniform float viewWidth, viewHeight;
uniform int worldTime;

uniform ivec2 eyeBrightnessSmooth;

uniform mat4 gbufferProjectionInverse;

uniform vec3 skyColor;
uniform vec3 fogColor;

uniform sampler2D texture;
uniform sampler2D gaux1;

#ifdef END
uniform float frameTimeCounter;

uniform vec3 cameraPosition;

uniform mat4 gbufferModelViewInverse;

uniform sampler2D noisetex;
#endif

//Common Variables//
float eBS = eyeBrightnessSmooth.y / 255.0;
float sunVisibility = clamp(dot(sunVec, upVec) + 0.05, 0.0, 0.1) * 10.0;
float moonVisibility = clamp(dot(-sunVec, upVec) + 0.05, 0.0, 0.1) * 10.0;

//Common Functions//
float GetLuminance(vec3 color){
	return dot(color,vec3(0.299, 0.587, 0.114));
}

//Includes//
#ifdef OVERWORLD
#include "/lib/color/lightColor.glsl"
#endif
#if defined END && defined CLOUDS
#include "/lib/color/lightColor.glsl"
#include "/lib/color/endColor.glsl"
#include "/lib/color/skyColor.glsl"
#include "/lib/util/dither.glsl"
#include "/lib/atmospherics/clouds.glsl"
#include "/lib/atmospherics/sky.glsl"
#endif

//Program//
void main(){
	
	#if (defined END) || (defined OVERWORLD && !defined ROUND_SUN_MOON)
	vec4 albedo = texture2D(texture, texCoord.xy);
	#else
	vec4 albedo = vec4(0.0);
	#endif
	
	#if (defined END && defined CLOUDS) || (defined OVERWORLD && !defined ROUND_SUN_MOON)
	vec4 screenPos = vec4(gl_FragCoord.xy / vec2(viewWidth, viewHeight), gl_FragCoord.z, 1.0);
	vec4 viewPos = gbufferProjectionInverse * (screenPos * 2.0 - 1.0);
	viewPos /= viewPos.w;
	#endif
	
	#if defined OVERWORLD && !defined ROUND_SUN_MOON
	vec3 nViewPos = normalize(viewPos.xyz);
	float NdotU = max(dot(nViewPos, upVec), 0.0);
	albedo.a *= clamp((NdotU+0.01)*8, 0.0, 1.0);
	albedo *= color;
	albedo.rgb = pow(albedo.rgb,vec3(2.2)) * SKYBOX_BRIGHTNESS * albedo.a;
	
	#ifdef CLOUDS
	if (albedo.a > 0.0){
		float cloudAlpha = texture2D(gaux1, gl_FragCoord.xy / vec2(viewWidth, viewHeight)).r;
		float alphaMult = 1.0 - 0.6 * rainStrengthS;
		albedo.a *= 1.0 - cloudAlpha / (alphaMult * alphaMult);
	}
	#endif
	
	#ifdef SKY_DESATURATION
	vec3 desat = GetLuminance(albedo.rgb) * pow(lightNight,vec3(1.6)) * 4.0;
	albedo.rgb = mix(desat, albedo.rgb, sunVisibility);
	#endif
	#endif
	
	#ifdef END
	albedo.rgb = pow(albedo.rgb,vec3(2.2)) * SKYBOX_BRIGHTNESS * 0.01;
	
	#ifdef END_CLOUDS
	#ifdef CLOUDS
	float dither = Bayer64(gl_FragCoord.xy);
	vec4 cloud = DrawEndCloud(viewPos.xyz, dither, endCol.rgb);
	albedo.rgb = mix(albedo.rgb, cloud.rgb, cloud.a);
	#endif
	#endif
	
	#endif
	
	/* DRAWBUFFERS:0 */
	gl_FragData[0]=albedo;
}

#endif

//Vertex Shader/////////////////////////////////////////////////////////////////////////////////////
#ifdef VSH

//Varyings//
varying vec2 texCoord;

varying vec3 sunVec,upVec;

varying mat3 moonRotMatrix;

varying vec4 color;

//Uniforms//
uniform float timeAngle;

uniform mat4 gbufferModelView;

#if AA>1
uniform int frameCounter;
uniform float viewWidth,viewHeight;
#endif

#include "/lib/util/moonrot.glsl"

//Includes//
#if AA>1
#include "/lib/util/jitter.glsl"
#endif

//Program//
void main(){
	texCoord=(gl_TextureMatrix[0]*gl_MultiTexCoord0).xy;
	
	color=gl_Color;
	
	const vec2 sunRotationData=vec2(cos(sunPathRotation*.01745329251994),-sin(sunPathRotation*.01745329251994));
	float ang=fract(timeAngle-.25);
	ang=(ang+(cos(ang*3.14159265358979)*-.5+.5-ang)/3.)*6.28318530717959;
	vec3 usunvec = vec3(-sin(ang),cos(ang)*sunRotationData);
	sunVec=normalize((gbufferModelView*vec4(usunvec*2000.,1.)).xyz);
	
	moonRotMatrix = getMoonRotMatrix(usunvec);

	upVec=normalize(gbufferModelView[1].xyz);
	
	gl_Position=ftransform();
	
	#if AA>1
	gl_Position.xy=TAAJitter(gl_Position.xy,gl_Position.w);
	#endif
}

#endif