/*
BSLex (BSL Edit) by LexBoosT
*/

//Settings//
#include "/lib/settings.glsl"

//Fragment Shader///////////////////////////////////////////////////////////////////////////////////
#ifdef FSH

//Varyings//
varying vec2 texCoord;
uniform int entityId;
//Uniforms//
uniform sampler2D texture;

//Program//
void main(){
	vec4 albedo = texture2D(texture, texCoord);
	
	albedo.rgb = pow(albedo.rgb,vec3(2.2));
	
	#ifdef WHITE_WORLD
	#ifdef SPIDER_EYESW
	albedo.rgb = vec3(2.0);
	#endif
	#endif
	
	#ifdef COLORED_EYES
	#if SPIDER_EYES == 1
	albedo.rgb=vec3(1.0, 0.0, 0.0) * 4;
	
	#elif SPIDER_EYES == 2
	albedo.rgb=vec3(0.749, 0.0, 1.0) * 4;
	
	#elif SPIDER_EYES == 3
	albedo.rgb=vec3(0.0, 0.0157, 1.0) * 15;
	
	#elif SPIDER_EYES == 4
	albedo.rgb=vec3(0.0, 0.2667, 0.0431) * 4;
	
	#elif SPIDER_EYES == 5
	albedo.rgb=vec3(1.0, 0.9333, 0.0078) * 4;
	#endif
	
	#endif
	/* DRAWBUFFERS:04 */
	gl_FragData[0] = clamp(albedo*1.0,0.0,1.0);
	
	#ifdef ADVANCED_MATERIALS
	/* DRAWBUFFERS:0367 */
	gl_FragData[1]=vec4(0.,0.,0.,1.);
	gl_FragData[2]=vec4(0.,0.,0.,1.);
	gl_FragData[3]=vec4(0.,0.,0.,1.);
	#endif
}

#endif

//Vertex Shader/////////////////////////////////////////////////////////////////////////////////////
#ifdef VSH

//Varyings//
varying vec2 texCoord;
varying vec4 position;

//Uniforms//
#if AA>1
uniform int frameCounter;
uniform float viewWidth,viewHeight;
#endif

uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;

uniform float frameTimeCounter;

//Includes//
#if AA>1
#include "/lib/util/jitter.glsl"
#endif

#ifdef WORLD_CURVATURE
#include "/lib/vertex/worldCurvature.glsl"
#endif

//Program//
void main(){
	texCoord=(gl_TextureMatrix[0]*gl_MultiTexCoord0).xy;
	
	vec4 position=gbufferModelViewInverse*gl_ModelViewMatrix*gl_Vertex;
	
	#ifdef WORLD_CURVATURE
	position.y-=WorldCurvature(position.xz);
	#endif
	
	#ifdef MOUVEMENT_CAM
	position+=vec4(.03*sin(frameTimeCounter*3.*SPEED_MOOVE),.015*cos(frameTimeCounter*4.*SPEED_MOOVE),0.,0.)*gbufferModelView;
	#endif
	
	gl_Position=gl_ProjectionMatrix*gbufferModelView*position;
	
	#if AA>1
	gl_Position.xy=TAAJitter(gl_Position.xy,gl_Position.w);
	#endif
}

#endif