/*
BSLex (BSL Edit) by LexBoosT
*/

//Settings//
#include "/lib/settings.glsl"

//Fragment Shader///////////////////////////////////////////////////////////////////////////////////
#ifdef FSH

//Extensions//

//Varyings//
varying float mat, recolor;
varying float visibleblock;
varying vec2 texCoord, lmCoord;

varying vec3 normal;
varying vec3 sunVec, upVec, eastVec;

varying vec4 color;
varying vec4 position;

#ifdef ADVANCED_MATERIALS
varying float dist;

varying vec3 binormal, tangent;
varying vec3 viewVector;

varying vec4 vTexCoord, vTexCoordAM;
#endif

//Uniforms//
uniform int blockEntityId;
uniform int frameCounter;
uniform int isEyeInWater;
uniform int worldTime;
uniform int heldItemId;
uniform int heldItemId2;

#ifdef DYNAMIC_HAND_LIGHT
	uniform int heldBlockLightValue;
	uniform int heldBlockLightValue2;
#endif

uniform float frameTimeCounter;
uniform float nightVision;
uniform float rainStrength;
uniform float rainStrengthS;
uniform float screenBrightness;
uniform float shadowFade;
uniform float timeAngle, timeBrightness;
uniform float viewWidth, viewHeight;

uniform ivec2 eyeBrightnessSmooth;

uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;
uniform vec3 cameraPosition;
uniform sampler2D texture;
uniform sampler2D noisetex;

#ifdef ADVANCED_MATERIALS
uniform ivec2 atlasSize;
uniform sampler2D specular;
uniform sampler2D normals;

#ifdef REFLECTION_RAIN
uniform float wetness;
uniform mat4 gbufferModelView;

#endif
#endif

uniform vec3 fogColor;

//Common Variables//
float eBS = eyeBrightnessSmooth.y / 255.0;
float sunVisibility  = clamp(dot( sunVec,upVec) + 0.05, 0.0, 0.1) * 10.0;
float moonVisibility = clamp(dot(-sunVec,upVec) + 0.05, 0.0, 0.1) * 10.0;

#ifdef ADVANCED_MATERIALS
vec2 dcdx = dFdx(texCoord);
vec2 dcdy = dFdy(texCoord);
#endif

vec3 lightVec = sunVec * ((timeAngle < 0.5325 || timeAngle > 0.9675) ? 1.0 : -1.0);

//Common Functions//
float GetLuminance(vec3 color){
	return dot(color,vec3(0.299, 0.587, 0.114));
}

float InterleavedGradientNoise(){
	float n = 52.9829189 * fract(0.06711056 * gl_FragCoord.x + 0.00583715 * gl_FragCoord.y);
	return fract(n + frameCounter / 8.0);
}

//Includes//
#include "/lib/color/blocklightColor.glsl"
#include "/lib/color/dimensionColor.glsl"
#include "/lib/util/dither.glsl"
#include "/lib/util/spaceConversion.glsl"
#include "/lib/lighting/forwardLighting.glsl"

#ifdef WATER_CAUSTICS
#ifdef OVERWORLD
#include "/lib/color/waterColor.glsl"
#include "/lib/lighting/caustics.glsl"
#endif
#endif

#if AA >1
#include "/lib/util/jitter.glsl"
#endif

#ifdef ADVANCED_MATERIALS
#include "/lib/color/specularColor.glsl"
#include "/lib/util/encode.glsl"
#include "/lib/reflections/complexFresnel.glsl"
#include "/lib/surface/ggx.glsl"
#include "/lib/surface/directionalLightmap.glsl"
#include "/lib/surface/materialGbuffers.glsl"
#include "/lib/surface/parallax.glsl"

#ifdef REFLECTION_RAIN
#include "/lib/reflections/rainPuddles.glsl"
#endif
#endif

//Program//
void main(){
	
	#ifdef DETECTEUR_CAVE
	if(visibleblock>0.5){
		#endif
		
		vec4 albedo = texture2D(texture, texCoord) * vec4(color.rgb, 1.0);
		
		vec3 newNormal = normal;
		float smoothness = 0.0, metalness = 0.0;
		vec3 baseReflectance = vec3(0.04);

		#ifdef ADVANCED_MATERIALS
		vec2 newCoord = vTexCoord.st * vTexCoordAM.pq + vTexCoordAM.st;
		float parallaxFade = clamp((dist - PARALLAX_DISTANCE) / 32.0, 0.0, 1.0);
		float skipAdvMat = float(blockEntityId == 10401);
		
		#ifdef PARALLAX
		if(skipAdvMat < 0.5){
			newCoord = GetParallaxCoord(parallaxFade);
			albedo = texture2DGradARB(texture, newCoord, dcdx, dcdy) * vec4(color.rgb, 1.0);
		}
		#endif
		
		float skyOcclusion = 0.0;
		vec3 fresnel3 = vec3(0.0);
		#endif
		
		if (albedo.a > 0.001){
			
			vec2 lightmap = clamp(lmCoord, vec2(0.0), vec2(1.0));
			
			float foliage  = float(mat > 0.98 && mat < 1.02);
			
			float emissiveIntensity = 0.25 * EMISSIVE_BRIGHTNESS;
			float emissive = float(mat > 1.98 && mat < 2.02) * emissiveIntensity;
			float lava     = float(mat > 2.98 && mat < 3.02) * emissiveIntensity;
			
			#ifndef SHADOW_SUBSURFACE
			foliage = 0.0;
			#endif
			
			vec3 screenPos = vec3(gl_FragCoord.xy / vec2(viewWidth, viewHeight), gl_FragCoord.z);
			#if AA > 1
			vec3 viewPos = ToNDC(vec3(TAAJitter(screenPos.xy, -0.5), screenPos.z));
			#else
			vec3 viewPos = ToNDC(screenPos);
			#endif
			vec3 worldPos = ToWorld(viewPos);
			
			float lViewPos = length(viewPos.xyz);

			#ifdef ADVANCED_MATERIALS
			float metalness = 0.0, f0 = 0.0, ao = 1.0;
			vec3 normalMap = vec3(0.0, 0.0, 1.0);
			GetMaterials(smoothness, metalness, f0, emissive, ao, normalMap, newCoord, dcdx, dcdy);
			
			mat3 tbnMatrix = mat3(tangent.x, binormal.x, normal.x,
				tangent.y, binormal.y, normal.y,
			tangent.z, binormal.z, normal.z);
			
			if (normalMap.x > -0.999 && normalMap.y > -0.999)
			newNormal = clamp(normalize(normalMap * tbnMatrix), vec3(-1.0), vec3(1.0));
			#endif
			
			albedo.rgb = pow(albedo.rgb, vec3(2.2));
			
			float ec = GetLuminance(albedo.rgb) * 1.7;
			#ifdef EMISSIVE_RECOLOR
			if (recolor > 0.5){
				albedo.rgb = blocklightCol * pow(ec, 1.5) / (BLOCKLIGHT_I * BLOCKLIGHT_I);
				albedo.rgb /= 0.7 * albedo.rgb + 0.7;
			}
			if (lava > 0.02){
				albedo.rgb = pow(blocklightCol * ec / BLOCKLIGHT_I, vec3(2.0));
				albedo.rgb /= 0.5 * albedo.rgb + 0.5;
			}
			#else
			if (recolor > 0.5){
				albedo.rgb *= ec * 0.25 + 0.5;
			}
			#endif
			
			#ifdef WHITE_WORLD
			#ifdef TERRAINW
			albedo.rgb = vec3(0.5);
			#endif
			#endif
			#ifdef BLACK_WORLD
			#ifdef TERRAINW
			albedo.rgb = vec3(0.0);
			#endif
			#endif
			
			float NoL = clamp(dot(newNormal, lightVec) * 1.01 - 0.01, 0.0, 1.0);
			float NoU = clamp(dot(newNormal, upVec), -1.0, 1.0);
			float NoE = clamp(dot(newNormal, eastVec), -1.0, 1.0);
			float vanillaDiffuse = (0.25 * NoU + 0.75) + (0.667 - abs(NoE)) * (1.0 - abs(NoU)) * 0.15;
			vanillaDiffuse*= vanillaDiffuse * (foliage > 0.5 ? 1.8 : 1.0);
			
			float parallaxShadow = 1.0;
			#ifdef ADVANCED_MATERIALS
			vec3 rawAlbedo = albedo.rgb * 0.999 + 0.001;
			albedo.rgb *= ao;
			
			#ifdef REFLECTION_SPECULAR
			float roughnessSqr = (1.0 - smoothness) * (1.0 - smoothness);
			albedo.rgb *= (1.0 - metalness * (1.0 - roughnessSqr));
			#endif
			
			float doParallax = 0.0;
			#ifdef SELF_SHADOW
			#ifdef OVERWORLD
			doParallax = float(lightmap.y > 0.0 && NoL > 0.0);
			#endif
			#ifdef END
			doParallax = float(NoL > 0.0);
			#endif
			
			if (doParallax > 0.5 && skipAdvMat < 0.5){
				parallaxShadow = GetParallaxShadow(parallaxFade, newCoord, lightVec, tbnMatrix);
			}
			#endif
			
			#ifdef DIRECTIONAL_LIGHTMAP
			mat3 lightmapTBN = GetLightmapTBN(viewPos);
			lightmap.x = DirectionalLightmap(lightmap.x, lmCoord.x, newNormal, lightmapTBN);
			lightmap.y = DirectionalLightmap(lightmap.y, lmCoord.y, newNormal, lightmapTBN);
			#endif
			#endif
			
			vec3 shadow = vec3(0.0);
			GetLighting(albedo.rgb, shadow, viewPos, lViewPos, worldPos, lightmap, color.a, NoL, vanillaDiffuse,
			parallaxShadow, emissive + lava, foliage,0.0);
			
			#ifdef ADVANCED_MATERIALS
			float puddles = 0.0;
			#if defined REFLECTION_RAIN && defined OVERWORLD
			NoU = clamp(NoU, 0.0, 1.0);
			
			#if REFLECTION_RAIN_TYPE == 0
			puddles = GetPuddles(worldPos) * NoU * wetness;
			#else
			puddles = NoU * wetness;
			#endif
			
			#ifdef WEATHER_PERBIOME
			float weatherweight = isCold + isDesert + isMesa + isSavanna;
			puddles *= 1.0 - weatherweight;
			#endif
			
			puddles *= clamp(lightmap.y * 32.0 - 31.0, 0.0, 1.0);
			
			smoothness = mix(smoothness, 1.0, puddles);
			f0 = max(f0, puddles * 0.02);
			
			albedo.rgb *= 1.0 - (puddles * 0.15);
			
			if (puddles > 0.001 && rainStrengthS > 0.001){
				mat3 tbnMatrix = mat3(tangent.x, binormal.x, normal.x,
					tangent.y, binormal.y, normal.y,
				tangent.z, binormal.z, normal.z);
				
				vec3 puddleNormal = GetPuddleNormal(worldPos, viewPos, tbnMatrix);
				newNormal = normalize(mix(newNormal, puddleNormal, puddles * rainStrengthS));
			}
			#endif
			
			skyOcclusion = lightmap.y * lightmap.y * (3.0 - 2.0 * lightmap.y);
			
			vec3 baseReflectance = mix(vec3(f0), rawAlbedo, metalness);
			float fresnel = pow(clamp(1.0 + dot(newNormal, normalize(viewPos.xyz)), 0.0, 1.0), 5.0);
			
			fresnel3 = mix(baseReflectance, vec3(1.0), fresnel);
			#if MATERIAL_FORMAT == 1
			if (f0 >= 0.9 && f0 < 1.0) {
				baseReflectance = GetMetalCol(f0);
				fresnel3 = ComplexFresnel(pow(fresnel, 0.2), f0);
				#ifdef ALBEDO_METAL
				fresnel3 *= rawAlbedo;
				#endif
			}
			#endif
			
			float aoSquared = ao * ao;
				  shadow *= aoSquared; fresnel3 *= aoSquared;
				  albedo.rgb = albedo.rgb * (1.0 - fresnel3 * smoothness * smoothness * (1.0 - metalness));
		
			
			#if defined OVERWORLD || defined END
			vec3 specularColor = GetSpecularColor(lightmap.y, metalness, baseReflectance);
			
			albedo.rgb += GetSpecularHighlight(newNormal, viewPos, lightVec, smoothness, baseReflectance,
			specularColor, foliage, shadow * vanillaDiffuse, 1.0);
			#endif
			
			#if defined REFLECTION_SPECULAR && defined REFLECTION_ROUGH
			if (normalMap.x > -0.999 && normalMap.y > -0.999){
				normalMap = mix(vec3(0.0, 0.0, 1.0), normalMap, smoothness);
				newNormal = mix(normalMap * tbnMatrix, newNormal, 1.0 - pow(1.0 - puddles, 4.0));
				newNormal = clamp(normalize(newNormal), vec3(-1.0), vec3(1.0));
			}
			#endif
			#endif
			
			#if defined WATER_CAUSTICS && defined OVERWORLD
			if (isEyeInWater == 1) {
				float skyLightMap = lightmap.y * lightmap.y * (3.0 - 2.0 * lightmap.y);
				shadow *= NoL;
				albedo.rgb = GetCaustics(albedo.rgb, worldPos.xyz, cameraPosition.xyz, shadow, skyLightMap, lightmap.x);
			}
			#endif
			
			#ifdef SHOW_LIGHT_LEVELS
			float showLightLevelFactor = fract(frameTimeCounter / 2.0);
			if (showLightLevelFactor > 0.5) showLightLevelFactor = 1 - showLightLevelFactor;
			if (lmCoord.x < 0.5 && vanillaDiffuse > 0.99) albedo.rgb += mix(albedo.rgb,vec3(SLV_R, SLV_G, SLV_B),SLV_I /10) * showLightLevelFactor;
			#endif
			
		} else discard;
		
		
		
		/* DRAWBUFFERS:0 */
		gl_FragData[0] = albedo;
		
		
		
		#if defined ADVANCED_MATERIALS && defined REFLECTION_SPECULAR
		/* DRAWBUFFERS:0367 */
		gl_FragData[1]=vec4(smoothness,skyOcclusion,0.,1.);
		gl_FragData[2]=vec4(EncodeNormal(newNormal),float(gl_FragCoord.z<1.),1.);
		gl_FragData[3]=vec4(fresnel3,1.);
		
		#endif
		
		#ifdef DETECTEUR_CAVE
	}
	else
	{
		discard;
	}
	#endif
	
}

#endif

//Vertex Shader/////////////////////////////////////////////////////////////////////////////////////
#ifdef VSH

//Varyings//
varying float mat,recolor;

varying vec2 texCoord,lmCoord;

varying vec3 normal;
varying vec3 sunVec,upVec,eastVec;

varying vec4 color;
varying vec4 position;
#ifdef ADVANCED_MATERIALS
varying float dist;
varying vec3 binormal,tangent;
varying vec3 viewVector;
varying vec4 vTexCoord,vTexCoordAM;
#endif

//Uniforms//
uniform int worldTime;

varying float visibleblock;
uniform float frameTimeCounter;
uniform float timeAngle;

uniform vec3 cameraPosition;

uniform mat4 gbufferModelView,gbufferModelViewInverse;
uniform mat4 gbufferProjection;

#if AA>1
uniform int frameCounter;
uniform float viewWidth,viewHeight;
#endif

//Attributes//
attribute vec4 mc_Entity;
attribute vec4 mc_midTexCoord;

#ifdef ADVANCED_MATERIALS
attribute vec4 at_tangent;
#endif

//Includes//
#include "/lib/vertex/waving.glsl"

#if AA>1
#include "/lib/util/jitter.glsl"
#endif

#ifdef WORLD_CURVATURE
#include "/lib/vertex/worldCurvature.glsl"
#endif

//Program//
void main(){
	
	#ifdef DETECTEUR_CAVE
	if(mc_Entity.x==10003||mc_Entity.x==10002||mc_Entity.x==10999){visibleblock=0.;}else{visibleblock=1.;};
	#else
	visibleblock=1.;
	#endif
	
	texCoord=(gl_TextureMatrix[0]*gl_MultiTexCoord0).xy;
	
	lmCoord=(gl_TextureMatrix[1]*gl_MultiTexCoord1).xy;
	lmCoord=clamp((lmCoord-.03125)*1.06667,0.,1.);
	
	normal=normalize(gl_NormalMatrix*gl_Normal);
	
	#ifdef ADVANCED_MATERIALS
	binormal=normalize(gl_NormalMatrix*cross(at_tangent.xyz,gl_Normal.xyz)*at_tangent.w);
	tangent=normalize(gl_NormalMatrix*at_tangent.xyz);
	
	mat3 tbnMatrix=mat3(tangent.x,binormal.x,normal.x,
		tangent.y,binormal.y,normal.y,
	tangent.z,binormal.z,normal.z);
	
	viewVector=tbnMatrix*(gl_ModelViewMatrix*gl_Vertex).xyz;
	
	dist=length(gl_ModelViewMatrix*gl_Vertex);
	
	vec2 midCoord=(gl_TextureMatrix[0]*mc_midTexCoord).st;
	vec2 texMinMidCoord=texCoord-midCoord;
	
	vTexCoordAM.pq=abs(texMinMidCoord)*2;
	vTexCoordAM.st=min(texCoord,midCoord-texMinMidCoord);
	
	vTexCoord.xy=sign(texMinMidCoord)*.5+.5;
	#endif
	
	color=gl_Color;
	
	mat=0.;recolor=0.;
	
	if(mc_Entity.x==10100||mc_Entity.x==10101||mc_Entity.x==10102||mc_Entity.x==10103||
		mc_Entity.x==10104||mc_Entity.x==10105||mc_Entity.x==10106||mc_Entity.x==10107||
	mc_Entity.x==10108||mc_Entity.x==10109)
	mat=1.;

	if(mc_Entity.x==10200||mc_Entity.x==10207||mc_Entity.x==10210||mc_Entity.x==10214||
		mc_Entity.x==10215||mc_Entity.x==10216||mc_Entity.x==10226||mc_Entity.x==10231||
		mc_Entity.x==10249||mc_Entity.x==10250||mc_Entity.x==10251||mc_Entity.x==10252||
	mc_Entity.x==10253)
	mat=2.;

	#ifdef OVERWORLD 
	if(mc_Entity.x==10248)
	mat=3.,color.a*=.40,color.rgb*=sqrt(OVERWORLD_LAVA_BRIGHTNESS);
	#endif

	#ifdef NETHER
	if(mc_Entity.x==10248)
	mat=3.,color.a*=.40,color.rgb*=sqrt(NETHER_LAVA_BRIGHTNESS);
	#endif

	#ifdef END
	if(mc_Entity.x==10248)
	mat=3.,color.a*=.40,color.rgb*=sqrt(END_LAVA_BRIGHTNESS);
	#endif

	if(mc_Entity.x==10216||mc_Entity.x==10231||mc_Entity.x==10226||mc_Entity.x==10250||
	mc_Entity.x==10251||mc_Entity.x==10253)
	recolor=1.;
	
	if(mc_Entity.x==10215||mc_Entity.x==10231||mc_Entity.x==10248||mc_Entity.x==10249||
	mc_Entity.x==10251)
	lmCoord.x=1.;
	
	if(mc_Entity.x==10245)
	lmCoord.x-=.0667;
	
	if(mc_Entity.x==10400)
	color.a=1.;
	
	const vec2 sunRotationData=vec2(cos(sunPathRotation*.01745329251994),-sin(sunPathRotation*.01745329251994));
	float ang=fract(timeAngle-.25);
	ang=(ang+(cos(ang*3.14159265358979)*-.5+.5-ang)/3.)*6.28318530717959;
	sunVec=normalize((gbufferModelView*vec4(vec3(-sin(ang),cos(ang)*sunRotationData)*2000.,1.)).xyz);
	
	upVec=normalize(gbufferModelView[1].xyz);
	eastVec=normalize(gbufferModelView[0].xyz);
	
	vec4 position=gbufferModelViewInverse*gl_ModelViewMatrix*gl_Vertex;
	
	float istopv=gl_MultiTexCoord0.t<mc_midTexCoord.t?1.:0.;
	position.xyz=WavingBlocks(position.xyz,istopv,lmCoord.y);
	
	#ifdef WORLD_CURVATURE
	position.y-=WorldCurvature(position.xz);
	#endif
	
	#ifdef MOUVEMENT_CAM
	position+=vec4(.03*sin(frameTimeCounter*3.*SPEED_MOOVE),.015*cos(frameTimeCounter*4.*SPEED_MOOVE),0.,0.)*gbufferModelView;
	#endif
	
	gl_Position=gl_ProjectionMatrix*gbufferModelView*position;
	
	#if AA>1
	gl_Position.xy=TAAJitter(gl_Position.xy,gl_Position.w);
	#endif
	
}

#endif