/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.spawn;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.Trade;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NoChargeException;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.spawn.SpawnStorage;
import net.ess3.api.IUser;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.event.player.PlayerTeleportEvent;

public class Commandspawn
extends EssentialsCommand {
    public Commandspawn() {
        super("spawn");
    }

    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        Trade charge = new Trade(this.getName(), this.ess);
        charge.isAffordableFor((IUser)user);
        if (args.length > 0 && user.isAuthorized("essentials.spawn.others")) {
            User otherUser = this.getPlayer(server, user, args, 0);
            this.respawn(user, otherUser, charge);
            if (!otherUser.equals((Object)user)) {
                otherUser.sendMessage(I18n._((String)"teleportAtoB", (Object[])new Object[]{user.getDisplayName(), "spawn"}));
                user.sendMessage(I18n._((String)"teleporting", (Object[])new Object[0]));
            }
        } else {
            this.respawn(user, user, charge);
        }
        throw new NoChargeException();
    }

    protected void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        User user = this.getPlayer(server, args, 0, true, false);
        this.respawn(null, user, null);
        user.sendMessage(I18n._((String)"teleportAtoB", (Object[])new Object[]{"Console", "spawn"}));
        sender.sendMessage(I18n._((String)"teleporting", (Object[])new Object[0]));
    }

    private void respawn(User teleportOwner, User teleportee, Trade charge) throws Exception {
        SpawnStorage spawns = (SpawnStorage)this.module;
        Location spawn = spawns.getSpawn(teleportee.getGroup());
        if (teleportOwner == null) {
            teleportee.getTeleport().now(spawn, false, PlayerTeleportEvent.TeleportCause.COMMAND);
        } else {
            teleportOwner.getTeleport().teleportPlayer((IUser)teleportee, spawn, charge, PlayerTeleportEvent.TeleportCause.COMMAND);
        }
    }
}

