/*
 * Decompiled with CFR 0.152.
 */
package com.avalon.servershop;

import com.avalon.listener.InventoryClick;
import com.avalon.listener.PlayerListener;
import com.avalon.servershop.ShopCommand;
import com.avalon.utils.FileUtils;
import com.avalon.utils.ItemBuilder;
import com.avalon.utils.Lang;
import com.avalon.utils.LanguageUtil;
import com.avalon.utils.util;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class ServerShop
extends JavaPlugin {
    public final Logger log = Logger.getLogger("Minecraft");
    private static ServerShop instance;
    public static Economy econ;
    public static Permission permission;
    public Inventory slist;
    public HashMap<Integer, Inventory> shops = new HashMap();
    public HashMap<String, Integer> ShopSelect = new HashMap();
    public static HashMap<String, String> PermissionShopItems;
    public static HashMap<String, Integer> PermissionShopCooldown;
    public static HashMap<String, Long> PermissionCooldownPlayer;
    public static HashMap<String, String> CommandShopItems;
    public static HashMap<String, Integer> CommandShopCooldown;
    public static HashMap<String, Long> CommandShopCooldownPlayer;
    public static HashMap<String, String> PlayerShopItems;
    public static HashMap<String, Integer> PlayerShopCooldown;
    public static HashMap<String, Long> PlayerShopCooldownPlayer;
    public ArrayList<String> BlockedCommands = new ArrayList();

    static {
        econ = null;
        permission = null;
        PermissionShopItems = new HashMap();
        PermissionShopCooldown = new HashMap();
        PermissionCooldownPlayer = new HashMap();
        CommandShopItems = new HashMap();
        CommandShopCooldown = new HashMap();
        CommandShopCooldownPlayer = new HashMap();
        PlayerShopItems = new HashMap();
        PlayerShopCooldown = new HashMap();
        PlayerShopCooldownPlayer = new HashMap();
    }

    public void onLoad() {
        instance = this;
    }

    public void onEnable() {
        if (!this.setupEconomy()) {
            this.getLogger().warning("Could not load plugin due Vault compatible economy plugin installed.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.getLogger().info("Plugin is using " + econ.getName() + " as economy system!");
        if (!this.setupPermissions()) {
            this.getLogger().warning("Could not load plugin due No Vault compatible permission plugin installed.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.getLogger().info("Plugin is using " + permission.getName() + " as permission system!");
        new LanguageUtil();
        File configlist = new File(String.valueOf(this.getDataFolder().getAbsolutePath()) + File.separator + "config.yml");
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
        if (!configlist.exists()) {
            FileUtils.setupMainConfig();
        }
        FileUtils.setupItemShopConfig();
        FileUtils.updateConfig();
        this.reloadConfig();
        this.createInventory();
        util.LogsEnabled = this.getConfig().getBoolean("main.EnableLogs");
        util.pricetype = Material.getMaterial((String)this.getConfig().getString("main.Item_Currency").toUpperCase().replace(' ', '_'));
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryClick(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        this.getCommand("shop").setExecutor((CommandExecutor)new ShopCommand(this));
    }

    public static ServerShop getInstance() {
        return instance;
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        econ = (Economy)rsp.getProvider();
        return econ != null;
    }

    private boolean setupPermissions() {
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Permission.class);
        permission = (Permission)rsp.getProvider();
        return permission != null;
    }

    private boolean setupNPC() {
        return this.getServer().getPluginManager().getPlugin("Citizens") != null;
    }

    public void createInventory() {
        ConfigurationSection ShopList = this.getConfig().getConfigurationSection("list");
        for (String key : ShopList.getKeys(false)) {
            ConfigurationSection item = ShopList.getConfigurationSection(key);
            int id = Integer.parseInt(key);
            String Shopname = ChatColor.translateAlternateColorCodes((char)'&', (String)item.getString("name"));
            Inventory tmp = Bukkit.createInventory(null, (int)item.getInt("size"), (String)Shopname);
            this.debug("Added Shop to Hashmap with ID " + id);
            this.shops.put(id, tmp);
            String ShopTitel = ChatColor.stripColor((String)Shopname);
            this.ShopSelect.put(ShopTitel, id);
            if (item.getBoolean("returnbutton")) {
                ItemStack returnButton = new ItemBuilder(Material.REDSTONE_BLOCK).name(ChatColor.YELLOW + "Return").lore(Arrays.asList(ChatColor.GRAY + "Return to", ChatColor.GRAY + "the shop selection.")).build();
                tmp.setItem(tmp.getSize() - 1, returnButton);
                this.debug("Added Return button to Inventory with ID " + id);
                this.AddItemToShops(ShopTitel);
                continue;
            }
            this.AddItemToShops(ShopTitel);
        }
        File configlist = new File(String.valueOf(this.getDataFolder().getAbsolutePath()) + File.separator + "config.yml");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)configlist);
        int slots = cfg.getInt("main.slots");
        this.slist = Bukkit.createInventory(null, (int)slots, (String)"Shop");
        ConfigurationSection ShopListAdd = cfg.getConfigurationSection("list");
        for (String key : ShopListAdd.getKeys(false)) {
            ConfigurationSection item = ShopListAdd.getConfigurationSection(key);
            ItemStack category = util.StringToItemstack(item.getString("icon"));
            ArrayList<String> description = new ArrayList<String>();
            if (item.isSet("description")) {
                for (String sl : item.getStringList("description")) {
                    description.add(ChatColor.translateAlternateColorCodes((char)'&', (String)sl));
                }
                category = new ItemBuilder(category).lore(description).build();
            }
            if (item.isSet("name")) {
                category = new ItemBuilder(category).name(ChatColor.translateAlternateColorCodes((char)'&', (String)item.getString("name"))).build();
            }
            this.slist.setItem(Integer.parseInt(key), category);
        }
    }

    private String PriceToString(Double price) {
        String BuyPrice = price == 0.0 ? ChatColor.GREEN + "Free" : (price == -1.0 ? ChatColor.RED + "Unable to be sold." : String.valueOf(price));
        return BuyPrice;
    }

    private String SellToString(Double sell) {
        String SellPrice = sell == 0.0 ? ChatColor.GREEN + "Free" : (sell == -1.0 ? ChatColor.RED + "Unable to be sold." : String.valueOf(sell));
        return SellPrice;
    }

    public void AddItemToShops(String name) {
        File configlist = new File(String.valueOf(this.getDataFolder().getAbsolutePath()) + File.separator + "shops" + File.separator + name + ".yml");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)configlist);
        ConfigurationSection wareSection = cfg.getConfigurationSection("stock");
        if (!configlist.exists()) {
            try {
                configlist.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (wareSection == null) {
            this.log.warning("[Shop] File '" + configlist.getName() + "' is emtpy. Cannot add items to Inventory.");
            return;
        }
        for (String key : wareSection.getKeys(false)) {
            ItemMeta Meta;
            Inventory tmp;
            String rawDisplayName;
            String DisplayName;
            float endbetrag;
            ArrayList<String> lore;
            ItemStack add;
            int amount;
            String reward;
            ConfigurationSection item = wareSection.getConfigurationSection(key);
            int position = Integer.parseInt(key);
            this.debug("Inventory Position: " + key);
            String type = item.getString("Type");
            if (type.equalsIgnoreCase("Item")) {
                reward = item.getString("Reward").replace(':', ' ');
                amount = item.getInt("Amount");
                if (amount > 64) {
                    amount = 64;
                }
                add = util.StringToItemstack(reward);
                add.setAmount(amount);
                Inventory tmp2 = this.shops.get(this.ShopSelect.get(name));
                ItemMeta Meta2 = add.getItemMeta();
                String displayname = item.getString("Displayname");
                if (displayname != null) {
                    displayname = ChatColor.translateAlternateColorCodes((char)'&', (String)displayname);
                }
                Meta2.setDisplayName(displayname);
                List loreRemove = null;
                Meta2.setLore(loreRemove);
                lore = new ArrayList<String>();
                lore.add(ChatColor.RED + "------------- Item -------------");
                lore.add(Lang.SHOP_ITEM_DISPLAY_DESCRIPTION.toString());
                if (item.isSet("Discount")) {
                    int discount = item.getInt("Discount");
                    endbetrag = util.calculateDiscount((float)item.getDouble("Price"), discount, "endbetrag");
                    lore.add(ChatColor.YELLOW + ChatColor.BOLD + "Price " + ChatColor.RESET + ChatColor.GREEN + "$" + endbetrag + " / $" + this.SellToString(item.getDouble("Sell")));
                } else {
                    String var1 = Lang.SHOP_ITEM_DISPLAY_PRICE.toString().replace("%buyprice%", this.PriceToString(item.getDouble("Price"))).replace("%sellprice%", this.SellToString(item.getDouble("Sell")));
                    lore.add(var1);
                }
                String var2 = Lang.SHOP_ITEM_DISPLA_PRICETYPE.toString().replace("%pricetype%", item.getString("Pricetype"));
                lore.add(var2);
                if (item.isSet("Discount")) {
                    int discount = item.getInt("Discount");
                    lore.add("");
                    lore.add(ChatColor.BOLD + ChatColor.AQUA + "On Sale!!");
                    lore.add(ChatColor.GREEN + "Save now " + discount + "% upon purchase! ");
                    lore.add(ChatColor.GREEN + util.calculateDiscount((float)item.getDouble("Price"), discount, "endbetrag") + ChatColor.AQUA + " instead of " + ChatColor.RED + ChatColor.STRIKETHROUGH + this.PriceToString(item.getDouble("Price")));
                }
                if (item.isSet("lore")) {
                    for (String sl : item.getStringList("lore")) {
                        lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)sl));
                    }
                }
                lore.add(ChatColor.RED + "-------------------------------");
                Meta2.setLore(lore);
                add.setItemMeta(Meta2);
                lore.clear();
                if (item.isSet("Enchantments")) {
                    String ench = item.getString("Enchantments");
                    String[] stringArray = ench.split(";");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String e = stringArray[n2];
                        Enchantment en = Enchantment.getByName((String)e.split(":")[0]);
                        if (en != null) {
                            add.addUnsafeEnchantment(en, Integer.valueOf(e.split(":")[1]).intValue());
                        } else {
                            this.log.warning("[ERROR] - Enchantment not found (" + e.split(":")[0] + ")");
                        }
                        ++n2;
                    }
                }
                tmp2.setItem(position, add);
                continue;
            }
            if (type.equalsIgnoreCase("Permission")) {
                reward = item.getString("Reward").replace(':', ' ');
                amount = 1;
                if (amount > 64) {
                    amount = 64;
                }
                add = util.StringToItemstack(reward);
                add.setAmount(amount);
                DisplayName = ChatColor.translateAlternateColorCodes((char)'&', (String)item.getString("Displayname"));
                rawDisplayName = ChatColor.stripColor((String)DisplayName);
                if (DisplayName == null) {
                    this.log.warning("[ERROR] Displayname cant be null!");
                    continue;
                }
                if (PermissionShopItems.containsKey(String.valueOf(name) + rawDisplayName)) {
                    this.log.warning("[ERROR] You cannot add multiple items with the same displayname in Permission Shops (" + DisplayName + ")");
                    continue;
                }
                PermissionShopItems.put(String.valueOf(name) + rawDisplayName, item.getString("Permission"));
                tmp = this.shops.get(this.ShopSelect.get(name));
                Meta = add.getItemMeta();
                Meta.setDisplayName(DisplayName);
                lore = new ArrayList();
                lore.add(ChatColor.GREEN + "Type: " + type);
                lore.add("");
                if (item.isSet("Discount")) {
                    int discount = item.getInt("Discount");
                    endbetrag = util.calculateDiscount((float)item.getDouble("Price"), discount, "endbetrag");
                    lore.add(ChatColor.YELLOW + "Price: " + endbetrag);
                } else {
                    lore.add(ChatColor.YELLOW + "Price: " + this.PriceToString(item.getDouble("Price")));
                }
                lore.add(ChatColor.YELLOW + "Pricetype: " + item.getString("Pricetype"));
                if (item.isSet("Discount")) {
                    int discount = item.getInt("Discount");
                    lore.add("");
                    lore.add(ChatColor.BOLD + ChatColor.AQUA + "On Sale!!");
                    lore.add(ChatColor.GREEN + "Save now " + discount + "% upon purchase! ");
                    lore.add(ChatColor.GREEN + util.calculateDiscount((float)item.getDouble("Price"), discount, "endbetrag") + ChatColor.AQUA + " instead of " + ChatColor.RED + ChatColor.STRIKETHROUGH + this.PriceToString(item.getDouble("Price")));
                }
                lore.add("");
                if (item.isSet("Cooldown")) {
                    int delay = item.getInt("Cooldown");
                    PermissionShopCooldown.put(String.valueOf(name) + rawDisplayName, delay);
                }
                if (item.isSet("lore")) {
                    for (String sl : item.getStringList("lore")) {
                        lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)sl));
                    }
                }
                Meta.setLore(lore);
                add.setItemMeta(Meta);
                tmp.setItem(position, add);
                continue;
            }
            if (type.equalsIgnoreCase("Command")) {
                reward = item.getString("Reward").replace(':', ' ');
                amount = 1;
                if (amount > 64) {
                    amount = 64;
                }
                add = util.StringToItemstack(reward);
                add.setAmount(amount);
                DisplayName = ChatColor.translateAlternateColorCodes((char)'&', (String)item.getString("Displayname"));
                rawDisplayName = ChatColor.stripColor((String)DisplayName);
                if (DisplayName == null) {
                    this.log.warning("[ERROR] Displayname cant be null!");
                    continue;
                }
                if (CommandShopItems.containsKey(String.valueOf(name) + rawDisplayName)) {
                    this.log.warning("[ERROR] You cannot add multiple items with the same displayname in Command Shops (" + DisplayName + ")");
                    continue;
                }
                CommandShopItems.put(String.valueOf(name) + rawDisplayName, item.getString("Command"));
                tmp = this.shops.get(this.ShopSelect.get(name));
                Meta = add.getItemMeta();
                Meta.setDisplayName(DisplayName);
                lore = new ArrayList();
                lore.add(ChatColor.GREEN + "Type: " + type);
                lore.add("");
                if (item.isSet("Discount")) {
                    int discount = item.getInt("Discount");
                    endbetrag = util.calculateDiscount((float)item.getDouble("Price"), discount, "endbetrag");
                    lore.add(ChatColor.YELLOW + "Price: " + endbetrag);
                } else {
                    lore.add(ChatColor.YELLOW + "Price: " + this.PriceToString(item.getDouble("Price")));
                }
                lore.add(ChatColor.YELLOW + "Pricetype: " + item.getString("Pricetype"));
                if (item.isSet("Discount")) {
                    int discount = item.getInt("Discount");
                    lore.add("");
                    lore.add(ChatColor.BOLD + ChatColor.AQUA + "On Sale!!");
                    lore.add(ChatColor.GREEN + "Save now " + discount + "% upon purchase! ");
                    lore.add(ChatColor.GREEN + util.calculateDiscount((float)item.getDouble("Price"), discount, "endbetrag") + ChatColor.AQUA + " instead of " + ChatColor.RED + ChatColor.STRIKETHROUGH + this.PriceToString(item.getDouble("Price")));
                }
                lore.add("");
                if (item.isSet("Cooldown")) {
                    int delay = item.getInt("Cooldown");
                    CommandShopCooldown.put(String.valueOf(name) + rawDisplayName, delay);
                }
                if (item.isSet("lore")) {
                    for (String sl : item.getStringList("lore")) {
                        lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)sl));
                    }
                }
                Meta.setLore(lore);
                add.setItemMeta(Meta);
                tmp.setItem(position, add);
                continue;
            }
            if (!type.equalsIgnoreCase("PlayerCommand")) continue;
            reward = item.getString("Reward").replace(':', ' ');
            amount = 1;
            if (amount > 64) {
                amount = 64;
            }
            add = util.StringToItemstack(reward);
            add.setAmount(amount);
            DisplayName = ChatColor.translateAlternateColorCodes((char)'&', (String)item.getString("Displayname"));
            rawDisplayName = ChatColor.stripColor((String)DisplayName);
            if (DisplayName == null) {
                this.log.warning("Displayname cant be null!");
                continue;
            }
            if (PlayerShopItems.containsKey(String.valueOf(name) + rawDisplayName)) {
                this.log.warning("[ERROR] You cannot add multiple items with the same displayname in Command Shops (" + DisplayName + ")");
                continue;
            }
            PlayerShopItems.put(String.valueOf(name) + rawDisplayName, item.getString("Command"));
            this.BlockedCommands.add(item.getString("Command"));
            tmp = this.shops.get(this.ShopSelect.get(name));
            Meta = add.getItemMeta();
            Meta.setDisplayName(DisplayName);
            lore = new ArrayList();
            lore.add(ChatColor.GREEN + "Type: " + type);
            lore.add("");
            if (item.isSet("Discount")) {
                int discount = item.getInt("Discount");
                endbetrag = util.calculateDiscount((float)item.getDouble("Price"), discount, "endbetrag");
                lore.add(ChatColor.YELLOW + "Price: " + endbetrag);
            } else {
                lore.add(ChatColor.YELLOW + "Price: " + this.PriceToString(item.getDouble("Price")));
            }
            lore.add(ChatColor.YELLOW + "Pricetype: " + item.getString("Pricetype"));
            if (item.isSet("Discount")) {
                int discount = item.getInt("Discount");
                lore.add("");
                lore.add(ChatColor.BOLD + ChatColor.AQUA + "On Sale!!");
                lore.add(ChatColor.GREEN + "Save now " + discount + "% upon purchase! ");
                lore.add(ChatColor.GREEN + util.calculateDiscount((float)item.getDouble("Price"), discount, "endbetrag") + ChatColor.AQUA + " instead of " + ChatColor.RED + ChatColor.STRIKETHROUGH + this.PriceToString(item.getDouble("Price")));
            }
            lore.add("");
            if (item.isSet("Cooldown")) {
                int delay = item.getInt("Cooldown");
                PlayerShopCooldown.put(String.valueOf(name) + rawDisplayName, delay);
            }
            if (item.isSet("lore")) {
                for (String sl : item.getStringList("lore")) {
                    lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)sl));
                }
            }
            Meta.setLore(lore);
            add.setItemMeta(Meta);
            tmp.setItem(position, add);
        }
    }

    public void debug(String msg) {
        if (this.getConfig().getBoolean("main.Debug")) {
            this.log.info("[Debug] " + msg);
        }
    }

    public void sendConsoleMessage(String message) {
        Bukkit.getConsoleSender().sendMessage("[ServerShop-GUI] " + message);
    }

    public void reloadConfig() {
        super.reloadConfig();
        for (Map.Entry<Integer, Inventory> ntc : this.shops.entrySet()) {
            ntc.getValue().clear();
        }
        new LanguageUtil();
        PlayerShopItems.clear();
        CommandShopItems.clear();
        PermissionShopItems.clear();
        if (this.slist != null) {
            this.slist.clear();
        }
        this.createInventory();
    }
}

