/*
 * Decompiled with CFR 0.152.
 */
package com.avalon.utils;

import com.avalon.servershop.ServerShop;
import com.avalon.utils.Lang;
import java.io.File;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class LanguageUtil {
    public LanguageUtil() {
        this.loadLang();
    }

    public void loadLang() {
        File lang = new File(ServerShop.getInstance().getDataFolder(), "lang.yml");
        if (!lang.exists()) {
            try {
                ServerShop.getInstance().getDataFolder().mkdir();
                lang.createNewFile();
                if (lang != null) {
                    YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((File)lang);
                    defConfig.save(lang);
                    Lang.setFile(defConfig);
                }
            }
            catch (IOException e) {
                ServerShop.getInstance().log.warning("\u00a7cCouldn't create language file.");
                Bukkit.getPluginManager().disablePlugin((Plugin)ServerShop.getInstance());
            }
        }
        YamlConfiguration conf = YamlConfiguration.loadConfiguration((File)lang);
        Lang[] langArray = Lang.values();
        int n = langArray.length;
        int n2 = 0;
        while (n2 < n) {
            Lang item = langArray[n2];
            if (conf.getString(item.getPath()) == null) {
                conf.set(item.getPath(), (Object)item.getDefault());
            }
            ++n2;
        }
        Lang.setFile(conf);
        try {
            conf.save(lang);
        }
        catch (IOException e) {
            ServerShop.getInstance().log.warning("\u00a7cFailed to save lang.yml.");
            ServerShop.getInstance().log.warning("\u00a7cReport this stack trace to crysis992.");
            e.printStackTrace();
        }
    }
}

