/*
 * Decompiled with CFR 0.152.
 */
package org.anjocaido.groupmanager.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.anjocaido.groupmanager.data.DataUnit;

public abstract class Variables
implements Cloneable {
    private DataUnit owner;
    protected final Map<String, Object> variables = Collections.synchronizedMap(new HashMap());

    public Variables(DataUnit owner) {
        this.owner = owner;
    }

    public void addVar(String name, Object o) {
        if (o == null) {
            return;
        }
        if (this.variables.containsKey(name)) {
            this.variables.remove(name);
        }
        this.variables.put(name, o);
        this.owner.flagAsChanged();
    }

    public Object getVarObject(String name) {
        return this.variables.get(name);
    }

    public String getVarString(String name) {
        Object o = this.variables.get(name);
        try {
            return o == null ? "" : o.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public Boolean getVarBoolean(String name) {
        Object o = this.variables.get(name);
        try {
            return o == null ? false : Boolean.parseBoolean(o.toString());
        }
        catch (Exception e) {
            return false;
        }
    }

    public Integer getVarInteger(String name) {
        Object o = this.variables.get(name);
        try {
            return o == null ? -1 : Integer.parseInt(o.toString());
        }
        catch (Exception e) {
            return -1;
        }
    }

    public Double getVarDouble(String name) {
        Object o = this.variables.get(name);
        try {
            return o == null ? -1.0 : Double.parseDouble(o.toString());
        }
        catch (Exception e) {
            return -1.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getVarKeyList() {
        Map<String, Object> map = this.variables;
        synchronized (map) {
            return this.variables.keySet().toArray(new String[0]);
        }
    }

    public boolean hasVar(String name) {
        return this.variables.containsKey(name);
    }

    public int getSize() {
        return this.variables.size();
    }

    public void removeVar(String name) {
        try {
            this.variables.remove(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.owner.flagAsChanged();
    }

    public static Object parseVariableValue(String value) {
        try {
            Integer i = Integer.parseInt(value);
            return i;
        }
        catch (NumberFormatException e) {
            try {
                Double d = Double.parseDouble(value);
                return d;
            }
            catch (NumberFormatException numberFormatException) {
                if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("on")) {
                    return true;
                }
                if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no") || value.equalsIgnoreCase("off")) {
                    return false;
                }
                return value;
            }
        }
    }

    public void clearVars() {
        this.variables.clear();
        this.owner.flagAsChanged();
    }

    public DataUnit getOwner() {
        return this.owner;
    }

    public boolean isEmpty() {
        return this.variables.isEmpty();
    }
}

