/*
 * Decompiled with CFR 0.152.
 */
package org.anjocaido.groupmanager.dataholder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.anjocaido.groupmanager.data.Group;
import org.anjocaido.groupmanager.data.User;
import org.anjocaido.groupmanager.dataholder.WorldDataHolder;

public class OverloadedWorldHolder
extends WorldDataHolder {
    protected final Map<String, User> overloadedUsers = Collections.synchronizedMap(new HashMap());

    public OverloadedWorldHolder(WorldDataHolder ph) {
        super(ph.getName());
        this.setGroupsFile(ph.getGroupsFile());
        this.setUsersFile(ph.getUsersFile());
        this.groups = ph.groups;
        this.users = ph.users;
    }

    @Override
    public User getUser(String userName) {
        String userNameLowered = userName.toLowerCase();
        if (this.overloadedUsers.containsKey(userNameLowered)) {
            return this.overloadedUsers.get(userNameLowered);
        }
        if (this.getUsers().containsKey(userNameLowered)) {
            return this.getUsers().get(userNameLowered);
        }
        User newUser = this.createUser(userName);
        this.setUsersChanged(true);
        return newUser;
    }

    @Override
    public void addUser(User theUser) {
        if (theUser.getDataSource() != this) {
            theUser = theUser.clone(this);
        }
        if (theUser == null) {
            return;
        }
        if (theUser.getGroup() == null || !this.getGroups().containsKey(theUser.getGroupName().toLowerCase())) {
            theUser.setGroup(this.getDefaultGroup());
        }
        if (this.overloadedUsers.containsKey(theUser.getName().toLowerCase())) {
            this.overloadedUsers.remove(theUser.getName().toLowerCase());
            this.overloadedUsers.put(theUser.getName().toLowerCase(), theUser);
            return;
        }
        this.removeUser(theUser.getName());
        this.getUsers().put(theUser.getName().toLowerCase(), theUser);
        this.setUsersChanged(true);
    }

    @Override
    public boolean removeUser(String userName) {
        if (this.overloadedUsers.containsKey(userName.toLowerCase())) {
            this.overloadedUsers.remove(userName.toLowerCase());
            return true;
        }
        if (this.getUsers().containsKey(userName.toLowerCase())) {
            this.getUsers().remove(userName.toLowerCase());
            this.setUsersChanged(true);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeGroup(String groupName) {
        if (groupName.equals(this.getDefaultGroup())) {
            return false;
        }
        Map<String, Group> map = this.getGroups();
        synchronized (map) {
            for (String key : this.getGroups().keySet()) {
                User user;
                if (!groupName.equalsIgnoreCase(key)) continue;
                this.getGroups().remove(key);
                Map<String, User> map2 = this.getUsers();
                synchronized (map2) {
                    for (String userKey : this.getUsers().keySet()) {
                        user = this.getUsers().get(userKey);
                        if (!user.getGroupName().equalsIgnoreCase(key)) continue;
                        user.setGroup(this.getDefaultGroup());
                    }
                }
                map2 = this.overloadedUsers;
                synchronized (map2) {
                    for (String userKey : this.overloadedUsers.keySet()) {
                        user = this.overloadedUsers.get(userKey);
                        if (!user.getGroupName().equalsIgnoreCase(key)) continue;
                        user.setGroup(this.getDefaultGroup());
                    }
                }
                this.setGroupsChanged(true);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<User> getUserList() {
        ArrayList<User> overloadedList = new ArrayList<User>();
        Map<String, User> map = this.getUsers();
        synchronized (map) {
            Collection<User> normalList = this.getUsers().values();
            for (User u : normalList) {
                if (this.overloadedUsers.containsKey(u.getName().toLowerCase())) {
                    overloadedList.add(this.overloadedUsers.get(u.getName().toLowerCase()));
                    continue;
                }
                overloadedList.add(u);
            }
        }
        return overloadedList;
    }

    public boolean isOverloaded(String userName) {
        return this.overloadedUsers.containsKey(userName.toLowerCase());
    }

    public void overloadUser(String userName) {
        if (!this.isOverloaded(userName)) {
            User theUser = this.getUser(userName);
            if (this.overloadedUsers.containsKey((theUser = theUser.clone()).getName().toLowerCase())) {
                this.overloadedUsers.remove(theUser.getName().toLowerCase());
            }
            this.overloadedUsers.put(theUser.getName().toLowerCase(), theUser);
        }
    }

    public void removeOverload(String userName) {
        this.overloadedUsers.remove(userName.toLowerCase());
    }

    public User surpassOverload(String userName) {
        if (!this.isOverloaded(userName)) {
            return this.getUser(userName);
        }
        if (this.getUsers().containsKey(userName.toLowerCase())) {
            return this.getUsers().get(userName.toLowerCase());
        }
        User newUser = this.createUser(userName);
        return newUser;
    }
}

