/*
 * Decompiled with CFR 0.152.
 */
package org.anjocaido.groupmanager.dataholder;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.anjocaido.groupmanager.GroupManager;
import org.anjocaido.groupmanager.data.Group;
import org.anjocaido.groupmanager.data.User;
import org.anjocaido.groupmanager.dataholder.GroupsDataHolder;
import org.anjocaido.groupmanager.dataholder.UsersDataHolder;
import org.anjocaido.groupmanager.events.GMGroupEvent;
import org.anjocaido.groupmanager.events.GMSystemEvent;
import org.anjocaido.groupmanager.events.GMUserEvent;
import org.anjocaido.groupmanager.permissions.AnjoPermissionsHandler;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.reader.UnicodeReader;

public class WorldDataHolder {
    protected String name;
    protected GroupsDataHolder groups = new GroupsDataHolder();
    protected UsersDataHolder users = new UsersDataHolder();
    protected AnjoPermissionsHandler permissionsHandler;

    public WorldDataHolder(String worldName) {
        this.name = worldName;
    }

    public WorldDataHolder(String worldName, GroupsDataHolder groups, UsersDataHolder users) {
        this.name = worldName;
        this.groups = groups;
        this.users = users;
    }

    public void updateDataSource() {
        this.groups.setDataSource(this);
        this.users.setDataSource(this);
    }

    public User getUser(String userName) {
        if (this.getUsers().containsKey(userName.toLowerCase())) {
            return this.getUsers().get(userName.toLowerCase());
        }
        User newUser = this.createUser(userName);
        return newUser;
    }

    public void addUser(User theUser) {
        if (theUser.getDataSource() != this) {
            theUser = theUser.clone(this);
        }
        if (theUser == null) {
            return;
        }
        if (theUser.getGroup() == null) {
            theUser.setGroup(this.groups.getDefaultGroup());
        }
        this.removeUser(theUser.getName());
        this.getUsers().put(theUser.getName().toLowerCase(), theUser);
        this.setUsersChanged(true);
        if (GroupManager.isLoaded()) {
            GroupManager.getGMEventHandler().callEvent(theUser, GMUserEvent.Action.USER_ADDED);
        }
    }

    public boolean removeUser(String userName) {
        if (this.getUsers().containsKey(userName.toLowerCase())) {
            this.getUsers().remove(userName.toLowerCase());
            this.setUsersChanged(true);
            if (GroupManager.isLoaded()) {
                GroupManager.getGMEventHandler().callEvent(userName, GMUserEvent.Action.USER_REMOVED);
            }
            return true;
        }
        return false;
    }

    public boolean isUserDeclared(String userName) {
        return this.getUsers().containsKey(userName.toLowerCase());
    }

    public void setDefaultGroup(Group group) {
        if (!this.getGroups().containsKey(group.getName().toLowerCase()) || group.getDataSource() != this) {
            this.addGroup(group);
        }
        this.groups.setDefaultGroup(this.getGroup(group.getName()));
        this.setGroupsChanged(true);
        if (GroupManager.isLoaded()) {
            GroupManager.getGMEventHandler().callEvent(GMSystemEvent.Action.DEFAULT_GROUP_CHANGED);
        }
    }

    public Group getDefaultGroup() {
        return this.groups.getDefaultGroup();
    }

    public Group getGroup(String groupName) {
        if (groupName.toLowerCase().startsWith("g:")) {
            return GroupManager.getGlobalGroups().getGroup(groupName);
        }
        return this.getGroups().get(groupName.toLowerCase());
    }

    public boolean groupExists(String groupName) {
        if (groupName.toLowerCase().startsWith("g:")) {
            return GroupManager.getGlobalGroups().hasGroup(groupName);
        }
        return this.getGroups().containsKey(groupName.toLowerCase());
    }

    public void addGroup(Group groupToAdd) {
        if (groupToAdd.getName().toLowerCase().startsWith("g:")) {
            GroupManager.getGlobalGroups().addGroup(groupToAdd);
            GroupManager.getGMEventHandler().callEvent(groupToAdd, GMGroupEvent.Action.GROUP_ADDED);
            return;
        }
        if (groupToAdd.getDataSource() != this) {
            groupToAdd = groupToAdd.clone(this);
        }
        this.removeGroup(groupToAdd.getName());
        this.getGroups().put(groupToAdd.getName().toLowerCase(), groupToAdd);
        this.setGroupsChanged(true);
        if (GroupManager.isLoaded()) {
            GroupManager.getGMEventHandler().callEvent(groupToAdd, GMGroupEvent.Action.GROUP_ADDED);
        }
    }

    public boolean removeGroup(String groupName) {
        if (groupName.toLowerCase().startsWith("g:")) {
            return GroupManager.getGlobalGroups().removeGroup(groupName);
        }
        if (this.getDefaultGroup() != null && groupName.equalsIgnoreCase(this.getDefaultGroup().getName())) {
            return false;
        }
        if (this.getGroups().containsKey(groupName.toLowerCase())) {
            this.getGroups().remove(groupName.toLowerCase());
            this.setGroupsChanged(true);
            if (GroupManager.isLoaded()) {
                GroupManager.getGMEventHandler().callEvent(groupName.toLowerCase(), GMGroupEvent.Action.GROUP_REMOVED);
            }
            return true;
        }
        return false;
    }

    public User createUser(String userName) {
        if (this.getUsers().containsKey(userName.toLowerCase())) {
            return null;
        }
        User newUser = new User(this, userName);
        newUser.setGroup(this.groups.getDefaultGroup(), false);
        this.addUser(newUser);
        this.setUsersChanged(true);
        return newUser;
    }

    public Group createGroup(String groupName) {
        if (groupName.toLowerCase().startsWith("g:")) {
            Group newGroup = new Group(groupName);
            return GroupManager.getGlobalGroups().newGroup(newGroup);
        }
        if (this.getGroups().containsKey(groupName.toLowerCase())) {
            return null;
        }
        Group newGroup = new Group(this, groupName);
        this.addGroup(newGroup);
        this.setGroupsChanged(true);
        return newGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Group> getGroupList() {
        Map<String, Group> map = this.getGroups();
        synchronized (map) {
            return new ArrayList<Group>(this.getGroups().values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<User> getUserList() {
        Map<String, User> map = this.getUsers();
        synchronized (map) {
            return new ArrayList<User>(this.getUsers().values());
        }
    }

    public void reload() {
        try {
            this.reloadGroups();
            this.reloadUsers();
        }
        catch (Exception ex) {
            Logger.getLogger(WorldDataHolder.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void reloadGroups() {
        GroupManager.setLoaded(false);
        try {
            WorldDataHolder ph = new WorldDataHolder(this.getName());
            WorldDataHolder.loadGroups(ph, this.getGroupsFile());
            this.resetGroups();
            for (Group tempGroup : ph.getGroupList()) {
                tempGroup.clone(this);
            }
            this.setDefaultGroup(this.getGroup(ph.getDefaultGroup().getName()));
            this.removeGroupsChangedFlag();
            this.setTimeStampGroups(this.getGroupsFile().lastModified());
            ph = null;
        }
        catch (Exception ex) {
            Logger.getLogger(WorldDataHolder.class.getName()).log(Level.WARNING, null, ex);
        }
        GroupManager.setLoaded(true);
        GroupManager.getGMEventHandler().callEvent(GMSystemEvent.Action.RELOADED);
    }

    public void reloadUsers() {
        GroupManager.setLoaded(false);
        try {
            WorldDataHolder ph = new WorldDataHolder(this.getName());
            for (Group tempGroup : this.getGroupList()) {
                tempGroup.clone(ph);
            }
            ph.setDefaultGroup(ph.getGroup(this.getDefaultGroup().getName()));
            WorldDataHolder.loadUsers(ph, this.getUsersFile());
            this.resetUsers();
            for (User tempUser : ph.getUserList()) {
                tempUser.clone(this);
            }
            this.removeUsersChangedFlag();
            this.setTimeStampUsers(this.getUsersFile().lastModified());
            ph = null;
        }
        catch (Exception ex) {
            Logger.getLogger(WorldDataHolder.class.getName()).log(Level.WARNING, null, ex);
        }
        GroupManager.setLoaded(true);
        GroupManager.getGMEventHandler().callEvent(GMSystemEvent.Action.RELOADED);
    }

    public void loadGroups(File groupsFile) {
        GroupManager.setLoaded(false);
        try {
            this.setGroupsFile(groupsFile);
            WorldDataHolder.loadGroups(this, groupsFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("The file which should contain groups does not exist!\n" + groupsFile.getPath());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Error accessing the groups file!\n" + groupsFile.getPath());
        }
        GroupManager.setLoaded(true);
    }

    public void loadUsers(File usersFile) {
        GroupManager.setLoaded(false);
        try {
            this.setUsersFile(usersFile);
            WorldDataHolder.loadUsers(this, usersFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("The file which should contain users does not exist!\n" + usersFile.getPath());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Error accessing the users file!\n" + usersFile.getPath());
        }
        GroupManager.setLoaded(true);
    }

    public static WorldDataHolder load(String worldName, File groupsFile, File usersFile) throws FileNotFoundException, IOException {
        WorldDataHolder ph = new WorldDataHolder(worldName);
        GroupManager.setLoaded(false);
        if (groupsFile != null) {
            WorldDataHolder.loadGroups(ph, groupsFile);
        }
        if (usersFile != null) {
            WorldDataHolder.loadUsers(ph, usersFile);
        }
        GroupManager.setLoaded(true);
        return ph;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void loadGroups(WorldDataHolder ph, File groupsFile) throws FileNotFoundException, IOException {
        Map groupsRootDataNode;
        Yaml yamlGroups = new Yaml((BaseConstructor)new SafeConstructor());
        if (!groupsFile.exists()) {
            throw new IllegalArgumentException("The file which should contain groups does not exist!\n" + groupsFile.getPath());
        }
        FileInputStream groupsInputStream = new FileInputStream(groupsFile);
        try {
            groupsRootDataNode = (Map)yamlGroups.load((Reader)new UnicodeReader((InputStream)groupsInputStream));
            if (groupsRootDataNode == null) {
                throw new NullPointerException();
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("The following file couldn't pass on Parser.\n" + groupsFile.getPath(), ex);
        }
        finally {
            groupsInputStream.close();
        }
        HashMap inheritance = new HashMap();
        Map allGroupsNode = null;
        try {
            allGroupsNode = (Map)groupsRootDataNode.get("groups");
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Your " + groupsFile.getPath() + " file is invalid. See console for details.", ex);
        }
        if (allGroupsNode == null) {
            throw new IllegalArgumentException("You have no groups in " + groupsFile.getPath() + ".");
        }
        Iterator groupItr = allGroupsNode.keySet().iterator();
        Integer groupCount = 0;
        while (groupItr.hasNext()) {
            String groupKey;
            try {
                Integer n = groupCount;
                Integer n2 = groupCount = Integer.valueOf(groupCount + 1);
                groupKey = (String)groupItr.next();
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Invalid group name for group entry (" + groupCount + ") in file: " + groupsFile.getPath(), ex);
            }
            Map thisGroupNode = null;
            try {
                thisGroupNode = (Map)allGroupsNode.get(groupKey);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Invalid child nodes for group '" + groupKey + "' in file: " + groupsFile.getPath(), ex);
            }
            Group thisGrp = ph.createGroup(groupKey);
            if (thisGrp == null) {
                throw new IllegalArgumentException("I think this Group was declared more than once: " + groupKey + " in file: " + groupsFile.getPath());
            }
            Object nodeData = null;
            try {
                nodeData = thisGroupNode.get("default");
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Bad format found in 'permissions' for group: " + groupKey + " in file: " + groupsFile.getPath());
            }
            if (nodeData != null && Boolean.parseBoolean(nodeData.toString())) {
                if (ph.getDefaultGroup() != null) {
                    GroupManager.logger.warning("The group '" + thisGrp.getName() + "' is claiming to be default where '" + ph.getDefaultGroup().getName() + "' already was.");
                    GroupManager.logger.warning("Overriding first default request in file: " + groupsFile.getPath());
                }
                ph.setDefaultGroup(thisGrp);
            }
            nodeData = null;
            try {
                nodeData = thisGroupNode.get("permissions");
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Bad format found in 'permissions' for '" + groupKey + "' in file: " + groupsFile.getPath());
            }
            if (nodeData != null) {
                if (nodeData instanceof List) {
                    try {
                        for (Object o : (List)nodeData) {
                            try {
                                if (o.toString().isEmpty()) continue;
                                thisGrp.addPermission(o.toString());
                            }
                            catch (NullPointerException ex) {}
                        }
                    }
                    catch (Exception ex) {
                        throw new IllegalArgumentException("Invalid formatting found in 'permissions' section for group: " + thisGrp.getName() + " in file: " + groupsFile.getPath(), ex);
                    }
                } else {
                    if (!(nodeData instanceof String)) throw new IllegalArgumentException("Unknown type of 'permissions' node(Should be String or List<String>) for group:  " + thisGrp.getName() + " in file: " + groupsFile.getPath());
                    if (!nodeData.toString().isEmpty()) {
                        thisGrp.addPermission((String)nodeData);
                    }
                }
                thisGrp.sortPermissions();
            }
            nodeData = null;
            try {
                nodeData = thisGroupNode.get("info");
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Bad format found in 'info' section for group: " + groupKey + " in file: " + groupsFile.getPath());
            }
            if (nodeData == null) {
                GroupManager.logger.warning("The group '" + thisGrp.getName() + "' has no 'info' section!");
                GroupManager.logger.warning("Using default values: " + groupsFile.getPath());
            } else {
                if (!(nodeData instanceof Map)) throw new IllegalArgumentException("Unknown entry found in 'info' section for group: " + thisGrp.getName() + " in file: " + groupsFile.getPath());
                try {
                    if (nodeData != null) {
                        thisGrp.setVariables((Map)nodeData);
                    }
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Invalid formatting found in 'info' section for group: " + thisGrp.getName() + " in file: " + groupsFile.getPath(), ex);
                }
            }
            nodeData = null;
            try {
                nodeData = thisGroupNode.get("inheritance");
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Bad format found in 'inheritance' section for group: " + groupKey + " in file: " + groupsFile.getPath());
            }
            if (nodeData != null && !(nodeData instanceof List)) throw new IllegalArgumentException("Unknown entry found in 'inheritance' section for group: " + thisGrp.getName() + " in file: " + groupsFile.getPath());
            if (nodeData == null || !(nodeData instanceof List)) continue;
            try {
                for (String grp : (List)nodeData) {
                    if (inheritance.get(groupKey) == null) {
                        inheritance.put(groupKey, new ArrayList());
                    }
                    ((List)inheritance.get(groupKey)).add(grp);
                }
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Invalid formatting found in 'inheritance' section for group: " + thisGrp.getName() + " in file: " + groupsFile.getPath(), ex);
            }
        }
        if (ph.getDefaultGroup() == null) {
            throw new IllegalArgumentException("There was no Default Group declared in file: " + groupsFile.getPath());
        }
        for (String group : inheritance.keySet()) {
            List inheritedList = (List)inheritance.get(group);
            Group thisGroup = ph.getGroup(group);
            if (thisGroup == null) continue;
            for (String inheritedKey : inheritedList) {
                if (inheritedKey == null) continue;
                Group inheritedGroup = ph.getGroup(inheritedKey);
                if (inheritedGroup != null) {
                    thisGroup.addInherits(inheritedGroup);
                    continue;
                }
                GroupManager.logger.warning("Inherited group '" + inheritedKey + "' not found for group " + thisGroup.getName() + ". Ignoring entry in file: " + groupsFile.getPath());
            }
        }
        ph.removeGroupsChangedFlag();
        ph.setGroupsFile(groupsFile);
        ph.setTimeStampGroups(groupsFile.lastModified());
    }

    protected static void loadUsers(WorldDataHolder ph, File usersFile) throws FileNotFoundException, IOException {
        Map usersRootDataNode;
        Yaml yamlUsers = new Yaml((BaseConstructor)new SafeConstructor());
        if (!usersFile.exists()) {
            throw new IllegalArgumentException("The file which should contain users does not exist!\n" + usersFile.getPath());
        }
        FileInputStream usersInputStream = new FileInputStream(usersFile);
        try {
            usersRootDataNode = (Map)yamlUsers.load((Reader)new UnicodeReader((InputStream)usersInputStream));
            if (usersRootDataNode == null) {
                throw new NullPointerException();
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("The following file couldn't pass on Parser.\n" + usersFile.getPath(), ex);
        }
        finally {
            usersInputStream.close();
        }
        Map allUsersNode = null;
        try {
            allUsersNode = (Map)usersRootDataNode.get("users");
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Your " + usersFile.getPath() + " file is invalid. See console for details.", ex);
        }
        if (allUsersNode != null) {
            Iterator usersItr = allUsersNode.keySet().iterator();
            Integer userCount = 0;
            while (usersItr.hasNext()) {
                String usersKey;
                Object node;
                try {
                    Integer n = userCount;
                    Integer n2 = userCount = Integer.valueOf(userCount + 1);
                    node = usersItr.next();
                    usersKey = node instanceof Integer ? Integer.toString((Integer)node) : node.toString();
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Invalid node type for user entry (" + userCount + ") in file: " + usersFile.getPath(), ex);
                }
                Map thisUserNode = null;
                try {
                    thisUserNode = (Map)allUsersNode.get(node);
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Bad format found for user: " + usersKey + " in file: " + usersFile.getPath());
                }
                User thisUser = ph.createUser(usersKey);
                if (thisUser == null) {
                    throw new IllegalArgumentException("I think this user was declared more than once: " + usersKey + " in file: " + usersFile.getPath());
                }
                Object nodeData = null;
                try {
                    nodeData = thisUserNode.get("permissions");
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Bad format found in 'permissions' for user: " + usersKey + " in file: " + usersFile.getPath());
                }
                if (nodeData != null) {
                    try {
                        if (nodeData instanceof List) {
                            for (Object o : (List)nodeData) {
                                if (o.toString().isEmpty()) continue;
                                thisUser.addPermission(o.toString());
                            }
                        } else if (nodeData instanceof String && !nodeData.toString().isEmpty()) {
                            thisUser.addPermission(nodeData.toString());
                        }
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    thisUser.sortPermissions();
                }
                nodeData = null;
                try {
                    nodeData = thisUserNode.get("subgroups");
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Bad format found in 'subgroups' for user: " + usersKey + " in file: " + usersFile.getPath());
                }
                if (nodeData != null) {
                    if (nodeData instanceof List) {
                        for (Object o : (List)nodeData) {
                            if (o == null) {
                                GroupManager.logger.warning("Invalid Subgroup data for user: " + thisUser.getName() + ". Ignoring entry in file: " + usersFile.getPath());
                                continue;
                            }
                            Group subGrp = ph.getGroup(o.toString());
                            if (subGrp != null) {
                                thisUser.addSubGroup(subGrp);
                                continue;
                            }
                            GroupManager.logger.warning("Subgroup '" + o.toString() + "' not found for user: " + thisUser.getName() + ". Ignoring entry in file: " + usersFile.getPath());
                        }
                    } else if (nodeData instanceof String) {
                        Group subGrp = ph.getGroup(nodeData.toString());
                        if (subGrp != null) {
                            thisUser.addSubGroup(subGrp);
                        } else {
                            GroupManager.logger.warning("Subgroup '" + nodeData.toString() + "' not found for user: " + thisUser.getName() + ". Ignoring entry in file: " + usersFile.getPath());
                        }
                    }
                }
                nodeData = null;
                try {
                    nodeData = thisUserNode.get("info");
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Bad format found in 'info' section for user: " + usersKey + " in file: " + usersFile.getPath());
                }
                if (nodeData != null) {
                    if (nodeData instanceof Map) {
                        thisUser.setVariables((Map)nodeData);
                    } else {
                        throw new IllegalArgumentException("Unknown entry found in 'info' section for user: " + thisUser.getName() + " in file: " + usersFile.getPath());
                    }
                }
                nodeData = null;
                try {
                    nodeData = thisUserNode.get("group");
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Bad format found in 'group' section for user: " + usersKey + " in file: " + usersFile.getPath());
                }
                if (nodeData != null) {
                    Group hisGroup = ph.getGroup(nodeData.toString());
                    if (hisGroup == null) {
                        GroupManager.logger.warning("There is no group " + thisUserNode.get("group").toString() + ", as stated for player " + thisUser.getName() + ": Set to '" + ph.getDefaultGroup().getName() + "' for file: " + usersFile.getPath());
                        hisGroup = ph.getDefaultGroup();
                    }
                    thisUser.setGroup(hisGroup);
                    continue;
                }
                thisUser.setGroup(ph.getDefaultGroup());
            }
        }
        ph.removeUsersChangedFlag();
        ph.setUsersFile(usersFile);
        ph.setTimeStampUsers(usersFile.lastModified());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeGroups(WorldDataHolder ph, File groupsFile) {
        HashMap root = new HashMap();
        HashMap groupsMap = new HashMap();
        root.put("groups", groupsMap);
        Map<String, Group> map = ph.getGroups();
        synchronized (map) {
            for (String groupKey : ph.getGroups().keySet()) {
                Group group = ph.getGroups().get(groupKey);
                HashMap<String, Object> aGroupMap = new HashMap<String, Object>();
                groupsMap.put(group.getName(), aGroupMap);
                if (ph.getDefaultGroup() == null) {
                    GroupManager.logger.severe("There is no default group for world: " + ph.getName());
                }
                aGroupMap.put("default", group.equals(ph.getDefaultGroup()));
                HashMap<String, Object> infoMap = new HashMap<String, Object>();
                aGroupMap.put("info", infoMap);
                for (String infoKey : group.getVariables().getVarKeyList()) {
                    infoMap.put(infoKey, group.getVariables().getVarObject(infoKey));
                }
                aGroupMap.put("inheritance", group.getInherits());
                aGroupMap.put("permissions", group.getPermissionList());
            }
        }
        if (!root.isEmpty()) {
            DumperOptions opt = new DumperOptions();
            opt.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            Yaml yaml = new Yaml(opt);
            try {
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(groupsFile), "UTF-8");
                String newLine = System.getProperty("line.separator");
                out.write("# Group inheritance" + newLine);
                out.write("#" + newLine);
                out.write("# Any inherited groups prefixed with a g: are global groups" + newLine);
                out.write("# and are inherited from the GlobalGroups.yml." + newLine);
                out.write("#" + newLine);
                out.write("# Groups without the g: prefix are groups local to this world" + newLine);
                out.write("# and are defined in the this groups.yml file." + newLine);
                out.write("#" + newLine);
                out.write("# Local group inheritances define your promotion tree when using 'manpromote/mandemote'" + newLine);
                out.write(newLine);
                yaml.dump(root, (Writer)out);
                out.close();
            }
            catch (UnsupportedEncodingException ex) {
            }
            catch (FileNotFoundException ex) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        ph.setGroupsFile(groupsFile);
        ph.setTimeStampGroups(groupsFile.lastModified());
        ph.removeGroupsChangedFlag();
        if (GroupManager.isLoaded()) {
            GroupManager.getGMEventHandler().callEvent(GMSystemEvent.Action.SAVED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeUsers(WorldDataHolder ph, File usersFile) {
        HashMap root = new HashMap();
        LinkedHashMap usersMap = new LinkedHashMap();
        root.put("users", usersMap);
        Map<String, User> map = ph.getUsers();
        synchronized (map) {
            for (String userKey : new TreeSet<String>(ph.getUsers().keySet())) {
                User user = ph.getUsers().get(userKey);
                if ((user.getGroup() == null || user.getGroup().equals(ph.getDefaultGroup())) && user.getPermissionList().isEmpty() && user.getVariables().isEmpty() && user.isSubGroupsEmpty()) continue;
                LinkedHashMap<String, Object> aUserMap = new LinkedHashMap<String, Object>();
                usersMap.put(user.getName(), aUserMap);
                if (user.getGroup() == null) {
                    aUserMap.put("group", ph.getDefaultGroup().getName());
                } else {
                    aUserMap.put("group", user.getGroup().getName());
                }
                aUserMap.put("subgroups", user.subGroupListStringCopy());
                aUserMap.put("permissions", user.getPermissionList());
                if (user.getVariables().getSize() <= 0) continue;
                HashMap<String, Object> infoMap = new HashMap<String, Object>();
                aUserMap.put("info", infoMap);
                for (String infoKey : user.getVariables().getVarKeyList()) {
                    infoMap.put(infoKey, user.getVariables().getVarObject(infoKey));
                }
            }
        }
        if (!root.isEmpty()) {
            DumperOptions opt = new DumperOptions();
            opt.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            Yaml yaml = new Yaml(opt);
            try {
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(usersFile), "UTF-8");
                yaml.dump(root, (Writer)out);
                out.close();
            }
            catch (UnsupportedEncodingException ex) {
            }
            catch (FileNotFoundException ex) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        ph.setUsersFile(usersFile);
        ph.setTimeStampUsers(usersFile.lastModified());
        ph.removeUsersChangedFlag();
        if (GroupManager.isLoaded()) {
            GroupManager.getGMEventHandler().callEvent(GMSystemEvent.Action.SAVED);
        }
    }

    @Deprecated
    public static void reloadOldPlugins(Server server) {
        PluginManager pm = server.getPluginManager();
        Plugin[] plugins = pm.getPlugins();
        for (int i = 0; i < plugins.length; ++i) {
            try {
                plugins[i].getClass().getMethod("setupPermissions", new Class[0]).invoke((Object)plugins[i], new Object[0]);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public AnjoPermissionsHandler getPermissionsHandler() {
        if (this.permissionsHandler == null) {
            this.permissionsHandler = new AnjoPermissionsHandler(this);
        }
        return this.permissionsHandler;
    }

    public void setUsersChanged(boolean haveUsersChanged) {
        this.users.setUsersChanged(haveUsersChanged);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean haveUsersChanged() {
        if (this.users.HaveUsersChanged()) {
            return true;
        }
        Map<String, User> map = this.users.getUsers();
        synchronized (map) {
            for (User u : this.users.getUsers().values()) {
                if (!u.isChanged()) continue;
                return true;
            }
        }
        return false;
    }

    public void setGroupsChanged(boolean setGroupsChanged) {
        this.groups.setGroupsChanged(setGroupsChanged);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean haveGroupsChanged() {
        if (this.groups.HaveGroupsChanged()) {
            return true;
        }
        Map<String, Group> map = this.groups.getGroups();
        synchronized (map) {
            for (Group g : this.groups.getGroups().values()) {
                if (!g.isChanged()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUsersChangedFlag() {
        this.setUsersChanged(false);
        Map<String, User> map = this.getUsers();
        synchronized (map) {
            for (User u : this.getUsers().values()) {
                u.flagAsSaved();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroupsChangedFlag() {
        this.setGroupsChanged(false);
        Map<String, Group> map = this.getGroups();
        synchronized (map) {
            for (Group g : this.getGroups().values()) {
                g.flagAsSaved();
            }
        }
    }

    public File getUsersFile() {
        return this.users.getUsersFile();
    }

    public void setUsersFile(File file) {
        this.users.setUsersFile(file);
    }

    public File getGroupsFile() {
        return this.groups.getGroupsFile();
    }

    public void setGroupsFile(File file) {
        this.groups.setGroupsFile(file);
    }

    public String getName() {
        return this.name;
    }

    public void resetGroups() {
        this.groups.resetGroups();
    }

    public void resetUsers() {
        this.users.resetUsers();
    }

    public Map<String, Group> getGroups() {
        return this.groups.getGroups();
    }

    public Map<String, User> getUsers() {
        return this.users.getUsers();
    }

    public GroupsDataHolder getGroupsObject() {
        return this.groups;
    }

    public void setGroupsObject(GroupsDataHolder groupsDataHolder) {
        this.groups = groupsDataHolder;
    }

    public UsersDataHolder getUsersObject() {
        return this.users;
    }

    public void setUsersObject(UsersDataHolder usersDataHolder) {
        this.users = usersDataHolder;
    }

    public long getTimeStampGroups() {
        return this.groups.getTimeStampGroups();
    }

    public long getTimeStampUsers() {
        return this.users.getTimeStampUsers();
    }

    protected void setTimeStampGroups(long timeStampGroups) {
        this.groups.setTimeStampGroups(timeStampGroups);
    }

    protected void setTimeStampUsers(long timeStampUsers) {
        this.users.setTimeStampUsers(timeStampUsers);
    }

    public void setTimeStamps() {
        if (this.getGroupsFile() != null) {
            this.setTimeStampGroups(this.getGroupsFile().lastModified());
        }
        if (this.getUsersFile() != null) {
            this.setTimeStampUsers(this.getUsersFile().lastModified());
        }
    }
}

