/*
 * Decompiled with CFR 0.152.
 */
package org.anjocaido.groupmanager.dataholder.worlds;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.anjocaido.groupmanager.GroupManager;
import org.anjocaido.groupmanager.dataholder.OverloadedWorldHolder;
import org.anjocaido.groupmanager.dataholder.WorldDataHolder;
import org.anjocaido.groupmanager.permissions.AnjoPermissionsHandler;
import org.anjocaido.groupmanager.utils.Tasks;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class WorldsHolder {
    private Map<String, OverloadedWorldHolder> worldsData = new HashMap<String, OverloadedWorldHolder>();
    private Map<String, String> mirrorsGroup = new HashMap<String, String>();
    private Map<String, String> mirrorsUser = new HashMap<String, String>();
    private String serverDefaultWorldName;
    private GroupManager plugin;
    private File worldsFolder;

    public WorldsHolder(GroupManager plugin) {
        this.plugin = plugin;
        this.resetWorldsHolder();
    }

    public Map<String, String> getMirrorsGroup() {
        return this.mirrorsGroup;
    }

    public Map<String, String> getMirrorsUser() {
        return this.mirrorsUser;
    }

    public boolean isWorldKnown(String name) {
        return this.worldsData.containsKey(name.toLowerCase());
    }

    public void resetWorldsHolder() {
        this.worldsData = new HashMap<String, OverloadedWorldHolder>();
        this.mirrorsGroup = new HashMap<String, String>();
        this.mirrorsUser = new HashMap<String, String>();
        this.verifyFirstRun();
        this.initialLoad();
        if (this.serverDefaultWorldName == null) {
            throw new IllegalStateException("There is no default group! OMG!");
        }
    }

    private void initialLoad() {
        this.initialWorldLoading();
        this.mirrorSetUp();
        this.loadAllSearchedWorlds();
    }

    private void initialWorldLoading() {
        this.loadWorld(this.serverDefaultWorldName);
    }

    private void loadAllSearchedWorlds() {
        for (World world : this.plugin.getServer().getWorlds()) {
            GroupManager.logger.log(Level.FINE, "Checking data for " + world.getName() + ".");
            if (this.worldsData.containsKey(world.getName().toLowerCase()) || this.mirrorsGroup.containsKey(world.getName().toLowerCase()) && this.mirrorsUser.containsKey(world.getName().toLowerCase())) continue;
            if (this.worldsData.containsKey("all_unnamed_worlds")) {
                String usersMirror = this.mirrorsUser.get("all_unnamed_worlds");
                String groupsMirror = this.mirrorsGroup.get("all_unnamed_worlds");
                if (usersMirror != null) {
                    this.mirrorsUser.put(world.getName().toLowerCase(), usersMirror);
                }
                if (groupsMirror != null) {
                    this.mirrorsGroup.put(world.getName().toLowerCase(), groupsMirror);
                }
            }
            GroupManager.logger.log(Level.FINE, "Creating folders for " + world.getName() + ".");
            this.setupWorldFolder(world.getName());
        }
        for (File folder : this.worldsFolder.listFiles()) {
            if (!folder.isDirectory() || folder.getName().startsWith(".")) continue;
            GroupManager.logger.info("World Found: " + folder.getName());
            if (this.worldsData.containsKey(folder.getName().toLowerCase()) || this.mirrorsGroup.containsKey(folder.getName().toLowerCase()) && this.mirrorsUser.containsKey(folder.getName().toLowerCase())) continue;
            this.setupWorldFolder(folder.getName());
            this.loadWorld(folder.getName().toLowerCase());
        }
    }

    public void mirrorSetUp() {
        this.mirrorsGroup.clear();
        this.mirrorsUser.clear();
        Map<String, Object> mirrorsMap = this.plugin.getGMConfig().getMirrorsMap();
        HashSet<String> mirroredWorlds = new HashSet<String>();
        if (mirrorsMap != null) {
            for (String source : mirrorsMap.keySet()) {
                this.setupWorldFolder(source);
                if (!this.worldsData.containsKey(source.toLowerCase())) {
                    this.loadWorld(source);
                }
                if (mirrorsMap.get(source) instanceof ArrayList) {
                    ArrayList mirrorList = (ArrayList)mirrorsMap.get(source);
                    for (Object o : mirrorList) {
                        String world = o.toString().toLowerCase();
                        if (world != this.serverDefaultWorldName) {
                            try {
                                this.mirrorsGroup.remove(world);
                                this.mirrorsUser.remove(world);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            this.mirrorsGroup.put(world, this.getWorldData(source).getName());
                            this.mirrorsUser.put(world, this.getWorldData(source).getName());
                            mirroredWorlds.add(o.toString());
                            continue;
                        }
                        GroupManager.logger.log(Level.WARNING, "Mirroring error with " + o.toString() + ". Recursive loop detected!");
                    }
                    continue;
                }
                if (!(mirrorsMap.get(source) instanceof Map)) continue;
                Map subSection = (Map)mirrorsMap.get(source);
                for (Object key : subSection.keySet()) {
                    if (((String)key).toLowerCase() != this.serverDefaultWorldName) {
                        if (subSection.get(key) instanceof ArrayList) {
                            ArrayList mirrorList = (ArrayList)subSection.get(key);
                            for (Object o : mirrorList) {
                                String type = o.toString().toLowerCase();
                                try {
                                    if (type.equals("groups")) {
                                        this.mirrorsGroup.remove(((String)key).toLowerCase());
                                    }
                                    if (type.equals("users")) {
                                        this.mirrorsUser.remove(((String)key).toLowerCase());
                                    }
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                if (type.equals("groups")) {
                                    this.mirrorsGroup.put(((String)key).toLowerCase(), this.getWorldData(source).getName());
                                    GroupManager.logger.log(Level.FINE, "Adding groups mirror for " + key + ".");
                                }
                                if (!type.equals("users")) continue;
                                this.mirrorsUser.put(((String)key).toLowerCase(), this.getWorldData(source).getName());
                                GroupManager.logger.log(Level.FINE, "Adding users mirror for " + key + ".");
                            }
                            mirroredWorlds.add((String)key);
                            continue;
                        }
                        throw new IllegalStateException("Unknown mirroring format for " + (String)key);
                    }
                    GroupManager.logger.log(Level.WARNING, "Mirroring error with " + (String)key + ". Recursive loop detected!");
                }
            }
            for (String world : mirroredWorlds) {
                if (this.worldsData.containsKey(world.toLowerCase())) continue;
                GroupManager.logger.log(Level.FINE, "No data for " + world + ".");
                this.setupWorldFolder(world);
                this.loadWorld(world, true);
            }
        }
    }

    public void reloadAll() {
        GroupManager.getGlobalGroups().load();
        ArrayList<OverloadedWorldHolder> alreadyDone = new ArrayList<OverloadedWorldHolder>();
        for (OverloadedWorldHolder w : this.worldsData.values()) {
            if (alreadyDone.contains(w)) continue;
            if (!this.mirrorsGroup.containsKey(w.getName().toLowerCase())) {
                w.reloadGroups();
            }
            if (!this.mirrorsUser.containsKey(w.getName().toLowerCase())) {
                w.reloadUsers();
            }
            alreadyDone.add(w);
        }
    }

    public void reloadWorld(String worldName) {
        if (!this.mirrorsGroup.containsKey(worldName.toLowerCase())) {
            this.getWorldData(worldName).reloadGroups();
        }
        if (!this.mirrorsUser.containsKey(worldName.toLowerCase())) {
            this.getWorldData(worldName).reloadUsers();
        }
    }

    public void saveChanges() {
        this.saveChanges(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean saveChanges(boolean overwrite) {
        boolean changed = false;
        ArrayList<OverloadedWorldHolder> alreadyDone = new ArrayList<OverloadedWorldHolder>();
        Tasks.removeOldFiles(this.plugin, this.plugin.getBackupFolder());
        if (GroupManager.getGlobalGroups().haveGroupsChanged()) {
            GroupManager.getGlobalGroups().writeGroups(overwrite);
        } else if (GroupManager.getGlobalGroups().getTimeStampGroups() < GroupManager.getGlobalGroups().getGlobalGroupsFile().lastModified()) {
            System.out.print("Newer GlobalGroups file found (Loading changes)!");
            GroupManager.getGlobalGroups().load();
        }
        Iterator<OverloadedWorldHolder> i$ = this.worldsData.values().iterator();
        while (true) {
            OverloadedWorldHolder w;
            block17: {
                block16: {
                    if (!i$.hasNext()) {
                        return changed;
                    }
                    w = i$.next();
                    if (alreadyDone.contains(w)) continue;
                    if (w == null) {
                        GroupManager.logger.severe("WHAT HAPPENED?");
                        continue;
                    }
                    if (!this.mirrorsGroup.containsKey(w.getName().toLowerCase())) {
                        if (w.haveGroupsChanged()) {
                            if (overwrite || !overwrite && w.getTimeStampGroups() >= w.getGroupsFile().lastModified()) {
                                this.backupFile(w, true);
                                WorldDataHolder.writeGroups(w, w.getGroupsFile());
                                changed = true;
                                break block16;
                            } else {
                                GroupManager.logger.log(Level.WARNING, "Newer Groups file found for " + w.getName() + ", but we have local changes!");
                                throw new IllegalStateException("Unable to save unless you issue a '/mansave force'");
                            }
                        }
                        if (w.getTimeStampGroups() < w.getGroupsFile().lastModified()) {
                            System.out.print("Newer Groups file found (Loading changes)!");
                            this.backupFile(w, true);
                            w.reloadGroups();
                            changed = true;
                        }
                    }
                }
                if (!this.mirrorsUser.containsKey(w.getName().toLowerCase())) {
                    if (w.haveUsersChanged()) {
                        if (overwrite || !overwrite && w.getTimeStampUsers() >= w.getUsersFile().lastModified()) {
                            this.backupFile(w, false);
                            WorldDataHolder.writeUsers(w, w.getUsersFile());
                            changed = true;
                            break block17;
                        } else {
                            GroupManager.logger.log(Level.WARNING, "Newer Users file found for " + w.getName() + ", but we have local changes!");
                            throw new IllegalStateException("Unable to save unless you issue a '/mansave force'");
                        }
                    }
                    if (w.getTimeStampUsers() < w.getUsersFile().lastModified()) {
                        System.out.print("Newer Users file found (Loading changes)!");
                        this.backupFile(w, false);
                        w.reloadUsers();
                        changed = true;
                    }
                }
            }
            alreadyDone.add(w);
        }
    }

    private void backupFile(OverloadedWorldHolder w, Boolean groups) {
        File backupFile = new File(this.plugin.getBackupFolder(), "bkp_" + w.getName() + (groups != false ? "_g_" : "_u_") + Tasks.getDateString() + ".yml");
        try {
            Tasks.copy(groups != false ? w.getGroupsFile() : w.getUsersFile(), backupFile);
        }
        catch (IOException ex) {
            GroupManager.logger.log(Level.SEVERE, null, ex);
        }
    }

    public OverloadedWorldHolder getWorldData(String worldName) {
        String worldNameLowered = worldName.toLowerCase();
        if (this.worldsData.containsKey(worldNameLowered)) {
            return this.getUpdatedWorldData(worldNameLowered);
        }
        if (this.worldsData.containsKey("all_unnamed_worlds")) {
            GroupManager.logger.finest("Requested world " + worldName + " not found or badly mirrored. Returning all_unnamed_worlds world...");
            return this.getUpdatedWorldData("all_unnamed_worlds");
        }
        GroupManager.logger.finest("Requested world " + worldName + " not found or badly mirrored. Returning default world...");
        return this.getDefaultWorld();
    }

    private OverloadedWorldHolder getUpdatedWorldData(String worldName) {
        String worldNameLowered = worldName.toLowerCase();
        if (this.worldsData.containsKey(worldNameLowered)) {
            OverloadedWorldHolder data = this.worldsData.get(worldNameLowered);
            data.updateDataSource();
            return data;
        }
        return null;
    }

    public OverloadedWorldHolder getWorldDataByPlayerName(String playerName) {
        List matchPlayer = this.plugin.getServer().matchPlayer(playerName);
        if (matchPlayer.size() == 1) {
            return this.getWorldData((Player)matchPlayer.get(0));
        }
        return null;
    }

    public OverloadedWorldHolder getWorldData(Player player) {
        return this.getWorldData(player.getWorld().getName());
    }

    public AnjoPermissionsHandler getWorldPermissions(String worldName) {
        return this.getWorldData(worldName).getPermissionsHandler();
    }

    public AnjoPermissionsHandler getWorldPermissions(Player player) {
        return this.getWorldData(player).getPermissionsHandler();
    }

    public AnjoPermissionsHandler getWorldPermissionsByPlayerName(String playerName) {
        OverloadedWorldHolder dh = this.getWorldDataByPlayerName(playerName);
        if (dh != null) {
            return dh.getPermissionsHandler();
        }
        return null;
    }

    private void verifyFirstRun() {
        if (this.plugin.getServer().getName().equalsIgnoreCase("BukkitForge")) {
            this.serverDefaultWorldName = "overworld";
        } else {
            Properties server = new Properties();
            try {
                server.load(new FileInputStream(new File("server.properties")));
                this.serverDefaultWorldName = server.getProperty("level-name").toLowerCase();
            }
            catch (IOException ex) {
                GroupManager.logger.log(Level.SEVERE, null, ex);
            }
        }
        this.setupWorldFolder(this.serverDefaultWorldName);
    }

    public void setupWorldFolder(String worldName) {
        File defaultWorldFolder;
        String worldNameLowered = worldName.toLowerCase();
        this.worldsFolder = new File(this.plugin.getDataFolder(), "worlds");
        if (!this.worldsFolder.exists()) {
            this.worldsFolder.mkdirs();
        }
        if (!(defaultWorldFolder = new File(this.worldsFolder, worldNameLowered)).exists() && !this.mirrorsGroup.containsKey(worldNameLowered) || !this.mirrorsUser.containsKey(worldNameLowered)) {
            File casedWorldFolder = new File(this.worldsFolder, worldName);
            if (casedWorldFolder.exists() && casedWorldFolder.getName().toLowerCase().equals(worldNameLowered)) {
                casedWorldFolder.renameTo(new File(this.worldsFolder, worldNameLowered));
            } else {
                defaultWorldFolder.mkdirs();
            }
        }
        if (defaultWorldFolder.exists()) {
            File usersFile;
            InputStream template;
            File groupsFile;
            if (!(this.mirrorsGroup.containsKey(worldNameLowered) || (groupsFile = new File(defaultWorldFolder, "groups.yml")).exists() && groupsFile.length() != 0L)) {
                template = this.plugin.getResourceAsStream("groups.yml");
                try {
                    Tasks.copy(template, groupsFile);
                }
                catch (IOException ex) {
                    GroupManager.logger.log(Level.SEVERE, null, ex);
                }
            }
            if (!(this.mirrorsUser.containsKey(worldNameLowered) || (usersFile = new File(defaultWorldFolder, "users.yml")).exists() && usersFile.length() != 0L)) {
                template = this.plugin.getResourceAsStream("users.yml");
                try {
                    Tasks.copy(template, usersFile);
                }
                catch (IOException ex) {
                    GroupManager.logger.log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public boolean cloneWorld(String fromWorld, String toWorld) {
        File fromWorldFolder = new File(this.worldsFolder, fromWorld.toLowerCase());
        File toWorldFolder = new File(this.worldsFolder, toWorld.toLowerCase());
        if (toWorldFolder.exists() || !fromWorldFolder.exists()) {
            return false;
        }
        File fromWorldGroups = new File(fromWorldFolder, "groups.yml");
        File fromWorldUsers = new File(fromWorldFolder, "users.yml");
        if (!fromWorldGroups.exists() || !fromWorldUsers.exists()) {
            return false;
        }
        File toWorldGroups = new File(toWorldFolder, "groups.yml");
        File toWorldUsers = new File(toWorldFolder, "users.yml");
        toWorldFolder.mkdirs();
        try {
            Tasks.copy(fromWorldGroups, toWorldGroups);
            Tasks.copy(fromWorldUsers, toWorldUsers);
        }
        catch (IOException ex) {
            Logger.getLogger(WorldsHolder.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        return true;
    }

    public void loadWorld(String worldName) {
        this.loadWorld(worldName, false);
    }

    public void loadWorld(String worldName, Boolean isMirror) {
        String worldNameLowered = worldName.toLowerCase();
        if (this.worldsData.containsKey(worldNameLowered)) {
            this.worldsData.get(worldNameLowered).reload();
            return;
        }
        GroupManager.logger.finest("Trying to load world " + worldName + "...");
        File thisWorldFolder = new File(this.worldsFolder, worldNameLowered);
        if (isMirror.booleanValue() || thisWorldFolder.exists() && thisWorldFolder.isDirectory()) {
            File usersFile;
            File groupsFile = this.mirrorsGroup.containsKey(worldNameLowered) ? null : new File(thisWorldFolder, "groups.yml");
            File file = usersFile = this.mirrorsUser.containsKey(worldNameLowered) ? null : new File(thisWorldFolder, "users.yml");
            if (groupsFile != null && !groupsFile.exists()) {
                throw new IllegalArgumentException("Groups file for world '" + worldName + "' doesnt exist: " + groupsFile.getPath());
            }
            if (usersFile != null && !usersFile.exists()) {
                throw new IllegalArgumentException("Users file for world '" + worldName + "' doesnt exist: " + usersFile.getPath());
            }
            WorldDataHolder tempHolder = new WorldDataHolder(worldNameLowered);
            if (this.mirrorsGroup.containsKey(worldNameLowered)) {
                tempHolder.setGroupsObject(this.getWorldData(this.mirrorsGroup.get(worldNameLowered)).getGroupsObject());
            } else {
                tempHolder.loadGroups(groupsFile);
            }
            if (this.mirrorsUser.containsKey(worldNameLowered)) {
                tempHolder.setUsersObject(this.getWorldData(this.mirrorsUser.get(worldNameLowered)).getUsersObject());
            } else {
                tempHolder.loadUsers(usersFile);
            }
            OverloadedWorldHolder thisWorldData = new OverloadedWorldHolder(tempHolder);
            tempHolder = null;
            thisWorldData.setTimeStamps();
            if (thisWorldData != null) {
                GroupManager.logger.finest("Successful load of world " + worldName + "...");
                this.worldsData.put(worldNameLowered, thisWorldData);
                return;
            }
        }
    }

    public boolean isInList(String worldName) {
        return this.worldsData.containsKey(worldName.toLowerCase()) || this.mirrorsGroup.containsKey(worldName.toLowerCase()) || this.mirrorsUser.containsKey(worldName.toLowerCase());
    }

    public boolean hasOwnData(String worldName) {
        return this.worldsData.containsKey(worldName.toLowerCase()) && (!this.mirrorsGroup.containsKey(worldName.toLowerCase()) || !this.mirrorsUser.containsKey(worldName.toLowerCase()));
    }

    public OverloadedWorldHolder getDefaultWorld() {
        return this.getUpdatedWorldData(this.serverDefaultWorldName);
    }

    public ArrayList<OverloadedWorldHolder> allWorldsDataList() {
        ArrayList<OverloadedWorldHolder> list = new ArrayList<OverloadedWorldHolder>();
        for (String world : this.worldsData.keySet()) {
            OverloadedWorldHolder data;
            if (world.equalsIgnoreCase("all_unnamed_worlds") || list.contains(data = this.getWorldData(world))) continue;
            String worldNameLowered = data.getName().toLowerCase();
            String usersMirror = this.mirrorsUser.get(worldNameLowered);
            String groupsMirror = this.mirrorsGroup.get(worldNameLowered);
            if (usersMirror != null && groupsMirror != null && usersMirror == groupsMirror) {
                data = this.getWorldData(usersMirror.toLowerCase());
                if (list.contains(data)) continue;
                list.add(data);
                continue;
            }
            list.add(data);
        }
        return list;
    }
}

