/*
 * Decompiled with CFR 0.152.
 */
package org.anjocaido.groupmanager.permissions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.anjocaido.groupmanager.GroupManager;
import org.anjocaido.groupmanager.data.Group;
import org.anjocaido.groupmanager.data.User;
import org.anjocaido.groupmanager.dataholder.WorldDataHolder;
import org.anjocaido.groupmanager.permissions.PermissionsReaderInterface;
import org.anjocaido.groupmanager.utils.PermissionCheckResult;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class AnjoPermissionsHandler
extends PermissionsReaderInterface {
    WorldDataHolder ph = null;

    public AnjoPermissionsHandler(WorldDataHolder holder) {
        this.ph = holder;
    }

    @Override
    public boolean has(Player player, String permission) {
        return this.permission(player, permission);
    }

    @Override
    public boolean permission(Player player, String permission) {
        return this.checkUserPermission(this.ph.getUser(player.getName()).updatePlayer(player), permission);
    }

    public boolean permission(String playerName, String permission) {
        return this.checkUserPermission(this.ph.getUser(playerName), permission);
    }

    @Override
    public String getGroup(String userName) {
        return this.ph.getUser(userName).getGroup().getName();
    }

    @Override
    public List<String> getAllPlayersPermissions(String userName) {
        ArrayList<String> perms = new ArrayList<String>();
        perms.addAll(this.getAllPlayersPermissions(userName, true));
        return perms;
    }

    @Override
    public Set<String> getAllPlayersPermissions(String userName, Boolean includeChildren) {
        HashSet<String> playerPermArray = new HashSet<String>();
        playerPermArray.addAll(this.populatePerms(this.ph.getUser(userName).getPermissionList(), includeChildren));
        ArrayList<String> alreadyProcessed = new ArrayList<String>();
        for (String group : this.getGroups(userName)) {
            if (alreadyProcessed.contains(group)) continue;
            alreadyProcessed.add(group);
            Set<Object> groupPermArray = new HashSet();
            groupPermArray = group.startsWith("g:") && GroupManager.getGlobalGroups().hasGroup(group) ? this.populatePerms(GroupManager.getGlobalGroups().getGroupsPermissions(group), includeChildren) : this.populatePerms(this.ph.getGroup(group).getPermissionList(), includeChildren);
            for (String perm : groupPermArray) {
                boolean negated = perm.startsWith("-");
                if ((negated || playerPermArray.contains(perm) || playerPermArray.contains("-" + perm)) && (!negated || playerPermArray.contains(perm.substring(1)) || playerPermArray.contains("-" + perm))) continue;
                playerPermArray.add(perm);
            }
        }
        return playerPermArray;
    }

    private Set<String> populatePerms(List<String> permsList, boolean includeChildren) {
        ArrayList<String> perms = new ArrayList<String>(permsList);
        HashSet<String> permArray = new HashSet<String>();
        Boolean allPerms = false;
        if (perms.contains("*")) {
            permArray.addAll(GroupManager.BukkitPermissions.getAllRegisteredPermissions(includeChildren));
            allPerms = true;
            perms.remove("*");
            perms.remove("groupmanager.noofflineperms");
        }
        for (String perm : perms) {
            Map<String, Boolean> children;
            boolean negated = perm.startsWith("-");
            if (permArray.contains(perm)) continue;
            permArray.add(perm);
            if (negated && permArray.contains(perm.substring(1))) {
                permArray.remove(perm.substring(1));
            }
            if (!includeChildren && (!negated || !allPerms.booleanValue()) || (children = GroupManager.BukkitPermissions.getAllChildren(negated ? perm.substring(1) : perm, new HashSet<String>())) == null || !negated) continue;
            if (allPerms.booleanValue()) {
                for (String child : children.keySet()) {
                    if (!children.get(child).booleanValue() || !permArray.contains(child)) continue;
                    permArray.remove(child);
                }
                continue;
            }
            for (String child : children.keySet()) {
                if (!children.get(child).booleanValue() || permArray.contains(child) || permArray.contains("-" + child)) continue;
                permArray.add(child);
            }
        }
        return permArray;
    }

    @Override
    public boolean inGroup(String name, String group) {
        if (this.hasGroupInInheritance(this.ph.getUser(name).getGroup(), group)) {
            return true;
        }
        for (Group subGroup : this.ph.getUser(name).subGroupListCopy()) {
            if (!this.hasGroupInInheritance(subGroup, group)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getUserPrefix(String user) {
        String prefix = this.ph.getUser(user).getVariables().getVarString("prefix");
        if (prefix.length() != 0) {
            return prefix;
        }
        return this.getGroupPrefix(this.getGroup(user));
    }

    @Override
    public String getUserSuffix(String user) {
        String suffix = this.ph.getUser(user).getVariables().getVarString("suffix");
        if (suffix.length() != 0) {
            return suffix;
        }
        return this.getGroupSuffix(this.getGroup(user));
    }

    public String getPrimaryGroup(String user) {
        return this.getGroup(user);
    }

    public boolean canUserBuild(String userName) {
        return this.getPermissionBoolean(userName, "build");
    }

    @Override
    public String getGroupPrefix(String groupName) {
        Group g = this.ph.getGroup(groupName);
        if (g == null) {
            return "";
        }
        return g.getVariables().getVarString("prefix");
    }

    @Override
    public String getGroupSuffix(String groupName) {
        Group g = this.ph.getGroup(groupName);
        if (g == null) {
            return "";
        }
        return g.getVariables().getVarString("suffix");
    }

    @Override
    public boolean canGroupBuild(String groupName) {
        Group g = this.ph.getGroup(groupName);
        if (g == null) {
            return false;
        }
        return g.getVariables().getVarBoolean("build");
    }

    @Override
    public String getGroupPermissionString(String groupName, String variable) {
        Group start = this.ph.getGroup(groupName);
        if (start == null) {
            return null;
        }
        Group result = this.nextGroupWithVariable(start, variable);
        if (result == null) {
            return null;
        }
        return result.getVariables().getVarString(variable);
    }

    @Override
    public int getGroupPermissionInteger(String groupName, String variable) {
        Group start = this.ph.getGroup(groupName);
        if (start == null) {
            return -1;
        }
        Group result = this.nextGroupWithVariable(start, variable);
        if (result == null) {
            return -1;
        }
        return result.getVariables().getVarInteger(variable);
    }

    @Override
    public boolean getGroupPermissionBoolean(String group, String variable) {
        Group start = this.ph.getGroup(group);
        if (start == null) {
            return false;
        }
        Group result = this.nextGroupWithVariable(start, variable);
        if (result == null) {
            return false;
        }
        return result.getVariables().getVarBoolean(variable);
    }

    @Override
    public double getGroupPermissionDouble(String group, String variable) {
        Group start = this.ph.getGroup(group);
        if (start == null) {
            return -1.0;
        }
        Group result = this.nextGroupWithVariable(start, variable);
        if (result == null) {
            return -1.0;
        }
        return result.getVariables().getVarDouble(variable);
    }

    @Override
    public String getUserPermissionString(String user, String variable) {
        User auser = this.ph.getUser(user);
        if (auser == null) {
            return "";
        }
        return auser.getVariables().getVarString(variable);
    }

    @Override
    public int getUserPermissionInteger(String user, String variable) {
        User auser = this.ph.getUser(user);
        if (auser == null) {
            return -1;
        }
        return auser.getVariables().getVarInteger(variable);
    }

    @Override
    public boolean getUserPermissionBoolean(String user, String variable) {
        User auser = this.ph.getUser(user);
        if (auser == null) {
            return false;
        }
        return auser.getVariables().getVarBoolean(variable);
    }

    @Override
    public double getUserPermissionDouble(String user, String variable) {
        User auser = this.ph.getUser(user);
        if (auser == null) {
            return -1.0;
        }
        return auser.getVariables().getVarDouble(variable);
    }

    @Override
    public String getPermissionString(String user, String variable) {
        User auser = this.ph.getUser(user);
        if (auser == null) {
            return "";
        }
        if (auser.getVariables().hasVar(variable)) {
            return auser.getVariables().getVarString(variable);
        }
        Group start = auser.getGroup();
        if (start == null) {
            return "";
        }
        Group result = this.nextGroupWithVariable(start, variable);
        if (result == null) {
            if (!auser.isSubGroupsEmpty()) {
                for (Group subGroup : auser.subGroupListCopy()) {
                    result = this.nextGroupWithVariable(subGroup, variable);
                    if (result == null) continue;
                }
            }
            if (result == null) {
                return "";
            }
        }
        return result.getVariables().getVarString(variable);
    }

    @Override
    public int getPermissionInteger(String user, String variable) {
        User auser = this.ph.getUser(user);
        if (auser == null) {
            return -1;
        }
        if (auser.getVariables().hasVar(variable)) {
            return auser.getVariables().getVarInteger(variable);
        }
        Group start = auser.getGroup();
        if (start == null) {
            return -1;
        }
        Group result = this.nextGroupWithVariable(start, variable);
        if (result == null) {
            if (!auser.isSubGroupsEmpty()) {
                for (Group subGroup : auser.subGroupListCopy()) {
                    result = this.nextGroupWithVariable(subGroup, variable);
                    if (result == null) continue;
                }
            }
            if (result == null) {
                return -1;
            }
        }
        return result.getVariables().getVarInteger(variable);
    }

    @Override
    public boolean getPermissionBoolean(String user, String variable) {
        User auser = this.ph.getUser(user);
        if (auser == null) {
            return false;
        }
        if (auser.getVariables().hasVar(variable)) {
            return auser.getVariables().getVarBoolean(variable);
        }
        Group start = auser.getGroup();
        if (start == null) {
            return false;
        }
        Group result = this.nextGroupWithVariable(start, variable);
        if (result == null) {
            if (!auser.isSubGroupsEmpty()) {
                for (Group subGroup : auser.subGroupListCopy()) {
                    result = this.nextGroupWithVariable(subGroup, variable);
                    if (result == null) continue;
                }
            }
            if (result == null) {
                return false;
            }
        }
        return result.getVariables().getVarBoolean(variable);
    }

    @Override
    public double getPermissionDouble(String user, String variable) {
        User auser = this.ph.getUser(user);
        if (auser == null) {
            return -1.0;
        }
        if (auser.getVariables().hasVar(variable)) {
            return auser.getVariables().getVarDouble(variable);
        }
        Group start = auser.getGroup();
        if (start == null) {
            return -1.0;
        }
        Group result = this.nextGroupWithVariable(start, variable);
        if (result == null) {
            if (!auser.isSubGroupsEmpty()) {
                for (Group subGroup : auser.subGroupListCopy()) {
                    result = this.nextGroupWithVariable(subGroup, variable);
                    if (result == null) continue;
                }
            }
            if (result == null) {
                return -1.0;
            }
        }
        return result.getVariables().getVarDouble(variable);
    }

    public PermissionCheckResult checkUserOnlyPermission(User user, String permission) {
        user.sortPermissions();
        PermissionCheckResult result = new PermissionCheckResult();
        result.askedPermission = permission;
        result.owner = user;
        for (String access : user.getPermissionList()) {
            result.resultType = this.comparePermissionString(access, permission);
            if (result.resultType == PermissionCheckResult.Type.NOTFOUND) continue;
            result.accessLevel = access;
            return result;
        }
        result.resultType = PermissionCheckResult.Type.NOTFOUND;
        return result;
    }

    public PermissionCheckResult checkGroupOnlyPermission(Group group, String permission) {
        group.sortPermissions();
        PermissionCheckResult result = new PermissionCheckResult();
        result.owner = group;
        result.askedPermission = permission;
        for (String access : group.getPermissionList()) {
            result.resultType = this.comparePermissionString(access, permission);
            if (result.resultType == PermissionCheckResult.Type.NOTFOUND) continue;
            result.accessLevel = access;
            return result;
        }
        result.resultType = PermissionCheckResult.Type.NOTFOUND;
        return result;
    }

    public boolean checkUserPermission(User user, String permission) {
        PermissionCheckResult result = this.checkFullGMPermission(user, permission, true);
        return result.resultType == PermissionCheckResult.Type.EXCEPTION || result.resultType == PermissionCheckResult.Type.FOUND;
    }

    public PermissionCheckResult checkFullUserPermission(User user, String targetPermission) {
        return this.checkFullGMPermission(user, targetPermission, true);
    }

    public PermissionCheckResult checkFullGMPermission(User user, String targetPermission, Boolean checkBukkit) {
        if (user == null || targetPermission == null || targetPermission.isEmpty() || !Bukkit.getServer().getOnlineMode() && this.checkPermission((User)user, (String)"groupmanager.noofflineperms", (Boolean)Boolean.valueOf((boolean)false)).resultType == PermissionCheckResult.Type.FOUND) {
            PermissionCheckResult result = new PermissionCheckResult();
            result.accessLevel = targetPermission;
            result.resultType = PermissionCheckResult.Type.NOTFOUND;
            return result;
        }
        return this.checkPermission(user, targetPermission, checkBukkit);
    }

    private PermissionCheckResult checkPermission(User user, String targetPermission, Boolean checkBukkit) {
        Player player;
        PermissionCheckResult result = new PermissionCheckResult();
        result.accessLevel = targetPermission;
        result.resultType = PermissionCheckResult.Type.NOTFOUND;
        if (checkBukkit.booleanValue() && (player = user.getBukkitPlayer()) != null && player.hasPermission(targetPermission)) {
            result.resultType = PermissionCheckResult.Type.FOUND;
            result.owner = user;
            return result;
        }
        PermissionCheckResult resultUser = this.checkUserOnlyPermission(user, targetPermission);
        if (resultUser.resultType != PermissionCheckResult.Type.NOTFOUND) {
            resultUser.accessLevel = targetPermission;
            return resultUser;
        }
        PermissionCheckResult resultGroup = this.checkGroupPermissionWithInheritance(user.getGroup(), targetPermission);
        if (resultGroup.resultType != PermissionCheckResult.Type.NOTFOUND) {
            resultGroup.accessLevel = targetPermission;
            return resultGroup;
        }
        for (Group subGroup : user.subGroupListCopy()) {
            PermissionCheckResult resultSubGroup = this.checkGroupPermissionWithInheritance(subGroup, targetPermission);
            if (resultSubGroup.resultType == PermissionCheckResult.Type.NOTFOUND) continue;
            resultSubGroup.accessLevel = targetPermission;
            return resultSubGroup;
        }
        return result;
    }

    public Group nextGroupWithVariable(Group start, String targetVariable) {
        if (start == null || targetVariable == null) {
            return null;
        }
        LinkedList<Group> stack = new LinkedList<Group>();
        ArrayList<Group> alreadyVisited = new ArrayList<Group>();
        stack.push(start);
        alreadyVisited.add(start);
        while (!stack.isEmpty()) {
            Group now = (Group)stack.pop();
            if (now.getVariables().hasVar(targetVariable)) {
                return now;
            }
            for (String sonName : now.getInherits()) {
                Group son = this.ph.getGroup(sonName);
                if (son == null || alreadyVisited.contains(son)) continue;
                stack.push(son);
                alreadyVisited.add(son);
            }
        }
        return null;
    }

    public boolean hasGroupInInheritance(Group start, String askedGroup) {
        if (start == null || askedGroup == null) {
            return false;
        }
        LinkedList<Group> stack = new LinkedList<Group>();
        ArrayList<Group> alreadyVisited = new ArrayList<Group>();
        stack.push(start);
        alreadyVisited.add(start);
        while (!stack.isEmpty()) {
            Group now = (Group)stack.pop();
            if (now.getName().equalsIgnoreCase(askedGroup)) {
                return true;
            }
            for (String sonName : now.getInherits()) {
                Group son = this.ph.getGroup(sonName);
                if (son == null || alreadyVisited.contains(son)) continue;
                stack.push(son);
                alreadyVisited.add(son);
            }
        }
        return false;
    }

    public PermissionCheckResult checkGroupPermissionWithInheritance(Group start, String targetPermission) {
        if (start == null || targetPermission == null) {
            return null;
        }
        LinkedList<Group> stack = new LinkedList<Group>();
        ArrayList<Group> alreadyVisited = new ArrayList<Group>();
        stack.push(start);
        alreadyVisited.add(start);
        while (!stack.isEmpty()) {
            Group now = (Group)stack.pop();
            PermissionCheckResult resultNow = this.checkGroupOnlyPermission(now, targetPermission);
            if (!resultNow.resultType.equals((Object)PermissionCheckResult.Type.NOTFOUND)) {
                resultNow.accessLevel = targetPermission;
                return resultNow;
            }
            for (String sonName : now.getInherits()) {
                Group son = this.ph.getGroup(sonName);
                if (son == null || alreadyVisited.contains(son)) continue;
                stack.add(son);
                alreadyVisited.add(son);
            }
        }
        PermissionCheckResult result = new PermissionCheckResult();
        result.askedPermission = targetPermission;
        result.resultType = PermissionCheckResult.Type.NOTFOUND;
        return result;
    }

    public ArrayList<String> listAllGroupsInherited(Group start) {
        if (start == null) {
            return null;
        }
        LinkedList<Group> stack = new LinkedList<Group>();
        ArrayList<String> alreadyVisited = new ArrayList<String>();
        stack.push(start);
        alreadyVisited.add(start.getName());
        while (!stack.isEmpty()) {
            Group now = (Group)stack.pop();
            for (String sonName : now.getInherits()) {
                Group son = this.ph.getGroup(sonName);
                if (son == null || alreadyVisited.contains(son.getName())) continue;
                stack.push(son);
                alreadyVisited.add(son.getName());
            }
        }
        return alreadyVisited;
    }

    public PermissionCheckResult.Type comparePermissionString(String userAccessLevel, String fullPermissionName) {
        int userAccessLevelLength;
        if (userAccessLevel == null || fullPermissionName == null || fullPermissionName.length() == 0 || (userAccessLevelLength = userAccessLevel.length()) == 0) {
            return PermissionCheckResult.Type.NOTFOUND;
        }
        PermissionCheckResult.Type result = PermissionCheckResult.Type.FOUND;
        int userAccessLevelOffset = 0;
        if (userAccessLevel.charAt(0) == '+') {
            userAccessLevelOffset = 1;
            result = PermissionCheckResult.Type.EXCEPTION;
        } else if (userAccessLevel.charAt(0) == '-') {
            userAccessLevelOffset = 1;
            result = PermissionCheckResult.Type.NEGATION;
        }
        if (fullPermissionName.equals(userAccessLevel)) {
            return result;
        }
        if ("groupmanager.noofflineperms".equals(fullPermissionName)) {
            result = PermissionCheckResult.Type.NOTFOUND;
        }
        if ("*".regionMatches(0, userAccessLevel, userAccessLevelOffset, userAccessLevelLength - userAccessLevelOffset)) {
            return result;
        }
        int fullPermissionNameOffset = fullPermissionName.charAt(0) == '+' || fullPermissionName.charAt(0) == '-' ? 1 : 0;
        if (userAccessLevel.charAt(userAccessLevel.length() - 1) == '*') {
            return userAccessLevel.regionMatches(true, userAccessLevelOffset, fullPermissionName, fullPermissionNameOffset, userAccessLevelLength - userAccessLevelOffset - 1) ? result : PermissionCheckResult.Type.NOTFOUND;
        }
        return userAccessLevel.regionMatches(true, userAccessLevelOffset, fullPermissionName, fullPermissionNameOffset, Math.max(userAccessLevelLength - userAccessLevelOffset, fullPermissionName.length() - fullPermissionNameOffset)) ? result : PermissionCheckResult.Type.NOTFOUND;
    }

    @Override
    public String[] getGroups(String userName) {
        ArrayList<String> allGroups = this.listAllGroupsInherited(this.ph.getUser(userName).getGroup());
        for (Group subg : this.ph.getUser(userName).subGroupListCopy()) {
            allGroups.addAll(this.listAllGroupsInherited(subg));
        }
        String[] arr = new String[allGroups.size()];
        return allGroups.toArray(arr);
    }

    private Group breadthFirstSearch(Group start, String targerPermission) {
        if (start == null || targerPermission == null) {
            return null;
        }
        LinkedList<Group> stack = new LinkedList<Group>();
        ArrayList<Group> alreadyVisited = new ArrayList<Group>();
        stack.push(start);
        alreadyVisited.add(start);
        while (!stack.isEmpty()) {
            Group now = (Group)stack.pop();
            PermissionCheckResult resultNow = this.checkGroupOnlyPermission(now, targerPermission);
            if (resultNow.resultType.equals((Object)PermissionCheckResult.Type.EXCEPTION) || resultNow.resultType.equals((Object)PermissionCheckResult.Type.FOUND)) {
                return now;
            }
            if (resultNow.resultType.equals((Object)PermissionCheckResult.Type.NEGATION)) {
                return null;
            }
            for (String sonName : now.getInherits()) {
                Group son = this.ph.getGroup(sonName);
                if (son == null || alreadyVisited.contains(son)) continue;
                stack.push(son);
                alreadyVisited.add(son);
            }
        }
        return null;
    }

    @Override
    public Group getDefaultGroup() {
        return this.ph.getDefaultGroup();
    }

    @Override
    public String getInfoString(String entryName, String path, boolean isGroup) {
        if (isGroup) {
            Group data = this.ph.getGroup(entryName);
            if (data == null) {
                return null;
            }
            return data.getVariables().getVarString(path);
        }
        User data = this.ph.getUser(entryName);
        if (data == null) {
            return null;
        }
        return data.getVariables().getVarString(path);
    }

    @Override
    public int getInfoInteger(String entryName, String path, boolean isGroup) {
        if (isGroup) {
            Group data = this.ph.getGroup(entryName);
            if (data == null) {
                return -1;
            }
            return data.getVariables().getVarInteger(path);
        }
        User data = this.ph.getUser(entryName);
        if (data == null) {
            return -1;
        }
        return data.getVariables().getVarInteger(path);
    }

    @Override
    public double getInfoDouble(String entryName, String path, boolean isGroup) {
        if (isGroup) {
            Group data = this.ph.getGroup(entryName);
            if (data == null) {
                return -1.0;
            }
            return data.getVariables().getVarDouble(path);
        }
        User data = this.ph.getUser(entryName);
        if (data == null) {
            return -1.0;
        }
        return data.getVariables().getVarDouble(path);
    }

    @Override
    public boolean getInfoBoolean(String entryName, String path, boolean isGroup) {
        if (isGroup) {
            Group data = this.ph.getGroup(entryName);
            if (data == null) {
                return false;
            }
            return data.getVariables().getVarBoolean(path);
        }
        User data = this.ph.getUser(entryName);
        if (data == null) {
            return false;
        }
        return data.getVariables().getVarBoolean(path);
    }

    @Override
    public void addUserInfo(String name, String path, Object data) {
        this.ph.getUser(name).getVariables().addVar(path, data);
    }

    @Override
    public void removeUserInfo(String name, String path) {
        this.ph.getUser(name).getVariables().removeVar(path);
    }

    @Override
    public void addGroupInfo(String name, String path, Object data) {
        this.ph.getGroup(name).getVariables().addVar(path, data);
    }

    @Override
    public void removeGroupInfo(String name, String path) {
        this.ph.getGroup(name).getVariables().removeVar(path);
    }
}

