/*
 * Decompiled with CFR 0.152.
 */
package org.anjocaido.groupmanager.permissions;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.anjocaido.groupmanager.GroupManager;
import org.anjocaido.groupmanager.data.User;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class BukkitPermissions {
    protected WeakHashMap<String, PermissionAttachment> attachments = new WeakHashMap();
    protected LinkedHashMap<String, Permission> registeredPermissions = new LinkedHashMap();
    protected GroupManager plugin;
    protected boolean dumpAllPermissions = true;
    protected boolean dumpMatchedPermissions = true;
    private boolean player_join = false;
    private static Field permissions;

    public boolean isPlayer_join() {
        return this.player_join;
    }

    public void setPlayer_join(boolean player_join) {
        this.player_join = player_join;
    }

    public BukkitPermissions(GroupManager plugin) {
        this.plugin = plugin;
        this.reset();
        this.registerEvents();
        GroupManager.logger.info("Superperms support enabled.");
    }

    public void reset() {
        this.collectPermissions();
        this.updateAllPlayers();
    }

    private void registerEvents() {
        PluginManager manager = this.plugin.getServer().getPluginManager();
        manager.registerEvents((Listener)new PlayerEvents(), (Plugin)this.plugin);
        manager.registerEvents((Listener)new BukkitEvents(), (Plugin)this.plugin);
    }

    public void collectPermissions() {
        this.registeredPermissions.clear();
        for (Permission perm : Bukkit.getPluginManager().getPermissions()) {
            this.registeredPermissions.put(perm.getName().toLowerCase(), perm);
        }
    }

    public void updatePermissions(Player player) {
        this.updatePermissions(player, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePermissions(Player player, String world) {
        PermissionAttachment attachment;
        if (player == null || !GroupManager.isLoaded()) {
            return;
        }
        String name = player.getName();
        User user = this.plugin.getWorldsHolder().getWorldData(player.getWorld().getName()).getUser(name);
        if (user != null) {
            user.updatePlayer(player);
        }
        if (this.attachments.containsKey(name)) {
            attachment = this.attachments.get(name);
        } else {
            attachment = player.addAttachment((Plugin)this.plugin);
            this.attachments.put(name, attachment);
        }
        if (world == null) {
            world = player.getWorld().getName();
        }
        List<String> playerPermArray = new ArrayList<String>(this.plugin.getWorldsHolder().getWorldData(world).getPermissionsHandler().getAllPlayersPermissions(name, false));
        LinkedHashMap<String, Boolean> newPerms = new LinkedHashMap<String, Boolean>();
        playerPermArray = this.sort(playerPermArray);
        Boolean value = false;
        for (String permission : playerPermArray) {
            value = !permission.startsWith("-");
            newPerms.put(value != false ? permission : permission.substring(1), value);
        }
        if (!Bukkit.getServer().getOnlineMode() && newPerms.containsKey("groupmanager.noofflineperms") && ((Boolean)newPerms.get("groupmanager.noofflineperms")).booleanValue()) {
            this.removeAttachment(name);
            return;
        }
        try {
            Permissible i$ = attachment.getPermissible();
            synchronized (i$) {
                Map orig = (Map)permissions.get(attachment);
                orig.clear();
                orig.putAll(newPerms);
                attachment.getPermissible().recalculatePermissions();
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        GroupManager.logger.finest("Attachment updated for: " + name);
    }

    private List<String> sort(List<String> permList) {
        ArrayList<String> result = new ArrayList<String>();
        for (String key : permList) {
            if (key.isEmpty()) continue;
            String a = key.charAt(0) == '-' ? key.substring(1) : key;
            Map<String, Boolean> allchildren = GroupManager.BukkitPermissions.getAllChildren(a, new HashSet<String>());
            if (allchildren != null) {
                ListIterator<String> itr = result.listIterator();
                while (itr.hasNext()) {
                    String node = (String)itr.next();
                    String b = node.charAt(0) == '-' ? node.substring(1) : node;
                    if (!allchildren.containsKey(b)) continue;
                    itr.set(key);
                    itr.add(node);
                    break;
                }
            }
            if (result.contains(key)) continue;
            result.add(key);
        }
        return result;
    }

    public List<String> getAllRegisteredPermissions(boolean includeChildren) {
        ArrayList<String> perms = new ArrayList<String>();
        for (String key : this.registeredPermissions.keySet()) {
            Map<String, Boolean> children;
            if (perms.contains(key)) continue;
            perms.add(key);
            if (!includeChildren || (children = this.getAllChildren(key, new HashSet<String>())) == null) continue;
            for (String node : children.keySet()) {
                if (perms.contains(node)) continue;
                perms.add(node);
            }
        }
        return perms;
    }

    public Map<String, Boolean> getAllChildren(String node, Set<String> playerPermArray) {
        LinkedList<String> stack = new LinkedList<String>();
        HashMap<String, Boolean> alreadyVisited = new HashMap<String, Boolean>();
        stack.push(node);
        alreadyVisited.put(node, true);
        while (!stack.isEmpty()) {
            String now = (String)stack.pop();
            Map<String, Boolean> children = this.getChildren(now);
            if (children == null || playerPermArray.contains("-" + now)) continue;
            for (String childName : children.keySet()) {
                if (alreadyVisited.containsKey(childName)) continue;
                stack.push(childName);
                alreadyVisited.put(childName, children.get(childName));
            }
        }
        alreadyVisited.remove(node);
        if (!alreadyVisited.isEmpty()) {
            return alreadyVisited;
        }
        return null;
    }

    public Map<String, Boolean> getChildren(String node) {
        Permission perm = this.registeredPermissions.get(node.toLowerCase());
        if (perm == null) {
            return null;
        }
        return perm.getChildren();
    }

    public List<String> listPerms(Player player) {
        ArrayList<String> perms = new ArrayList<String>();
        perms.add("Effective Permissions:");
        for (PermissionAttachmentInfo info : player.getEffectivePermissions()) {
            if (!info.getValue()) continue;
            perms.add(" " + info.getPermission() + " = " + info.getValue());
        }
        return perms;
    }

    public void updateAllPlayers() {
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            this.updatePermissions(player);
        }
    }

    public void updatePlayer(Player player) {
        if (player != null) {
            this.updatePermissions(player, null);
        }
    }

    private void removeAttachment(String playerName) {
        if (this.attachments.containsKey(playerName)) {
            this.attachments.get(playerName).remove();
            this.attachments.remove(playerName);
        }
    }

    public void removeAllAttachments() {
        for (String key : this.attachments.keySet()) {
            this.attachments.get(key).remove();
        }
        this.attachments.clear();
    }

    static {
        try {
            permissions = PermissionAttachment.class.getDeclaredField("permissions");
            permissions.setAccessible(true);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    protected class BukkitEvents
    implements Listener {
        protected BukkitEvents() {
        }

        @EventHandler(priority=EventPriority.NORMAL)
        public void onPluginEnable(PluginEnableEvent event) {
            if (!GroupManager.isLoaded()) {
                return;
            }
            BukkitPermissions.this.collectPermissions();
            BukkitPermissions.this.updateAllPlayers();
        }

        @EventHandler(priority=EventPriority.NORMAL)
        public void onPluginDisable(PluginDisableEvent event) {
            BukkitPermissions.this.collectPermissions();
        }
    }

    protected class PlayerEvents
    implements Listener {
        protected PlayerEvents() {
        }

        @EventHandler(priority=EventPriority.LOWEST)
        public void onPlayerJoin(PlayerJoinEvent event) {
            BukkitPermissions.this.setPlayer_join(true);
            Player player = event.getPlayer();
            GroupManager.logger.finest("Player Join event: " + player.getName());
            BukkitPermissions.this.removeAttachment(player.getName());
            if (BukkitPermissions.this.plugin.getWorldsHolder().getWorldData(player.getWorld().getName()).getUser(player.getName()) != null) {
                BukkitPermissions.this.setPlayer_join(false);
                BukkitPermissions.this.updatePermissions(event.getPlayer());
            }
            BukkitPermissions.this.setPlayer_join(false);
        }

        @EventHandler(priority=EventPriority.LOWEST)
        public void onPlayerChangeWorld(PlayerChangedWorldEvent event) {
            BukkitPermissions.this.updatePermissions(event.getPlayer(), event.getPlayer().getWorld().getName());
        }

        @EventHandler(priority=EventPriority.HIGHEST)
        public void onPlayerQuit(PlayerQuitEvent event) {
            if (!GroupManager.isLoaded()) {
                return;
            }
            Player player = event.getPlayer();
            BukkitPermissions.this.removeAttachment(player.getName());
        }
    }
}

