/*
 * Decompiled with CFR 0.152.
 */
package org.anjocaido.groupmanager.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.List;
import org.anjocaido.groupmanager.GroupManager;
import org.anjocaido.groupmanager.data.Group;

public abstract class Tasks {
    public static String getStackTraceAsString(Exception exception) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        exception.printStackTrace(pw);
        return sw.toString();
    }

    public static void copy(InputStream src, File dst) throws IOException {
        int len;
        InputStream in = src;
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((OutputStream)out).close();
        try {
            in.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static void copy(File src, File dst) throws IOException {
        FileInputStream in = new FileInputStream(src);
        Tasks.copy(in, dst);
    }

    public static void appendStringToFile(String data, String file) throws IOException {
        FileWriter outStream = new FileWriter("." + System.getProperty("file.separator") + file, true);
        BufferedWriter out = new BufferedWriter(outStream);
        data.replaceAll("\n", System.getProperty("line.separator"));
        out.append(new SimpleDateFormat("yyyy-MM-dd HH-mm").format(System.currentTimeMillis()));
        out.append(System.getProperty("line.separator"));
        out.append(data);
        out.append(System.getProperty("line.separator"));
        out.close();
    }

    public static void removeOldFiles(GroupManager gm, File folder) {
        if (folder.isDirectory()) {
            long oldTime = System.currentTimeMillis() - (long)gm.getGMConfig().getBackupDuration().intValue() * 60L * 60L * 1000L;
            for (File olds : folder.listFiles()) {
                if (!olds.isFile() || olds.lastModified() >= oldTime) continue;
                try {
                    olds.delete();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public static String getDateString() {
        GregorianCalendar now = new GregorianCalendar();
        String date = "";
        date = date + now.get(5);
        date = date + "-";
        date = date + now.get(10);
        date = date + "-";
        date = date + now.get(12);
        return date;
    }

    public static String getStringListInString(List<String> list) {
        if (list == null) {
            return "";
        }
        String result = "";
        for (int i = 0; i < list.size(); ++i) {
            result = result + list.get(i);
            if (i >= list.size() - 1) continue;
            result = result + ", ";
        }
        return result;
    }

    public static String getStringArrayInString(String[] list) {
        if (list == null) {
            return "";
        }
        String result = "";
        for (int i = 0; i < list.length; ++i) {
            result = result + list[i];
            if (i >= list.length - 1) continue;
            result = result + ", ";
        }
        return result;
    }

    public static String getGroupListInString(List<Group> list) {
        if (list == null) {
            return "";
        }
        String result = "";
        for (int i = 0; i < list.size(); ++i) {
            result = result + list.get(i).getName();
            if (i >= list.size() - 1) continue;
            result = result + ", ";
        }
        return result;
    }

    public static String join(String[] arr, String separator) {
        if (arr.length == 0) {
            return "";
        }
        String out = arr[0].toString();
        for (int i = 1; i < arr.length; ++i) {
            out = out + separator + arr[i];
        }
        return out;
    }
}

