/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ICraftingHandler;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.IPickupNotifier;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.registry.BlockProxy;
import cpw.mods.fml.common.registry.BlockTracker;
import cpw.mods.fml.common.registry.GameData;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_6_R3.CraftWorld;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerChangedWorldEvent;

public class GameRegistry {
    private static Multimap<ModContainer, BlockProxy> blockRegistry = ArrayListMultimap.create();
    private static Set<IWorldGenerator> worldGenerators = Sets.newHashSet();
    private static List<IFuelHandler> fuelHandlers = Lists.newArrayList();
    private static List<ICraftingHandler> craftingHandlers = Lists.newArrayList();
    private static List<IPickupNotifier> pickupHandlers = Lists.newArrayList();
    private static List<IPlayerTracker> playerTrackers = Lists.newArrayList();
    private static Map<String, Boolean> configWorldGenCache = new HashMap<String, Boolean>();
    private static Map<String, String> worldGenMap = new HashMap<String, String>();

    public static void registerWorldGenerator(IWorldGenerator generator) {
        String modId = Loader.instance().activeModContainer().getModId();
        modId = modId.replaceAll("[^A-Za-z0-9]", "");
        modId.replace(" ", "_");
        worldGenerators.add(generator);
        worldGenMap.put(generator.getClass().getName(), modId);
    }

    public static void generateWorld(int chunkX, int chunkZ, abw world, ado chunkGenerator, ado chunkProvider) {
        long worldSeed = world.H();
        Random fmlRandom = new Random(worldSeed);
        long xSeed = fmlRandom.nextLong() >> 3;
        long zSeed = fmlRandom.nextLong() >> 3;
        long chunkSeed = xSeed * (long)chunkX + zSeed * (long)chunkZ ^ worldSeed;
        boolean before = true;
        if (world instanceof js) {
            before = ((js)world).b.a;
            ((js)world).b.a = true;
        }
        for (IWorldGenerator generator : worldGenerators) {
            if (!configWorldGenCache.containsKey(generator.getClass().getName())) {
                String modId = worldGenMap.get(generator.getClass().getName());
                String generatorName = "";
                generatorName = modId + "-" + generator.getClass().getSimpleName();
                boolean generatorEnabled = world.cauldronConfig.getBoolean("worldgen-" + generatorName, true);
                configWorldGenCache.put(generator.getClass().getName(), generatorEnabled);
            }
            if (!configWorldGenCache.get(generator.getClass().getName()).booleanValue()) continue;
            fmlRandom.setSeed(chunkSeed);
            generator.generate(fmlRandom, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
        }
        if (world instanceof js) {
            ((js)world).b.a = before;
        }
    }

    public static Object buildBlock(ModContainer container, Class<?> type, aqz annotation) throws Exception {
        Object o = type.getConstructor(Integer.TYPE).newInstance(GameRegistry.findSpareBlockId());
        GameRegistry.registerBlock((aqz)o);
        return o;
    }

    private static int findSpareBlockId() {
        return BlockTracker.nextBlockId();
    }

    public static void registerItem(yc item, String name) {
        GameRegistry.registerItem(item, name, null);
    }

    public static void registerItem(yc item, String name, String modId) {
        GameRegistry.registerMaterial(item, name, modId);
        GameData.setName(item, name, modId);
    }

    @Deprecated
    public static void registerBlock(aqz block) {
        GameRegistry.registerBlock(block, zh.class);
    }

    public static void registerBlock(aqz block, String name) {
        GameRegistry.registerBlock(block, zh.class, name);
    }

    @Deprecated
    public static void registerBlock(aqz block, Class<? extends zh> itemclass) {
        GameRegistry.registerBlock(block, itemclass, null);
    }

    public static void registerBlock(aqz block, Class<? extends zh> itemclass, String name) {
        GameRegistry.registerBlock(block, itemclass, name, null);
    }

    public static void registerBlock(aqz block, Class<? extends zh> itemclass, String name, String modId) {
        if (Loader.instance().isInState(LoaderState.CONSTRUCTING)) {
            FMLLog.warning("The mod %s is attempting to register a block whilst it it being constructed. This is bad modding practice - please use a proper mod lifecycle event.", Loader.instance().activeModContainer());
        }
        try {
            yc i;
            assert (block != null) : "registerBlock: block cannot be null";
            assert (itemclass != null) : "registerBlock: itemclass cannot be null";
            int blockItemId = block.cF - 256;
            try {
                Constructor<? extends zh> itemCtor = itemclass.getConstructor(Integer.TYPE);
                i = (yc)itemCtor.newInstance(blockItemId);
            }
            catch (NoSuchMethodException e) {
                Constructor<? extends zh> itemCtor = itemclass.getConstructor(Integer.TYPE, aqz.class);
                i = (yc)itemCtor.newInstance(blockItemId, block);
            }
            GameRegistry.registerItem(i, name, modId);
        }
        catch (Exception e) {
            FMLLog.log(Level.SEVERE, e, "Caught an exception during block registration", new Object[0]);
            throw new LoaderException(e);
        }
        blockRegistry.put((Object)Loader.instance().activeModContainer(), (Object)((BlockProxy)block));
    }

    public static void registerMaterial(yc item, String name, String modId) {
        if (name != null) {
            if (modId == null) {
                modId = Loader.instance().activeModContainer().getModId();
            }
            String materialName = modId + "_" + name;
            Material.setMaterialName((int)item.cv, (String)materialName, (boolean)false);
        } else {
            if (modId == null) {
                modId = Loader.instance().activeModContainer().getModId();
            }
            String materialName = modId + "_" + String.valueOf(item.cv);
            Material.setMaterialName((int)item.cv, (String)materialName, (boolean)false);
        }
    }

    public static void addRecipe(ye output, Object ... params) {
        GameRegistry.addShapedRecipe(output, params);
    }

    public static aah addShapedRecipe(ye output, Object ... params) {
        return aaf.a().a(output, params);
    }

    public static void addShapelessRecipe(ye output, Object ... params) {
        aaf.a().b(output, params);
    }

    public static void addRecipe(aah recipe) {
        aaf.a().b().add(recipe);
    }

    public static void addSmelting(int input, ye output, float xp) {
        aab.a().a(input, output, xp);
    }

    public static void registerTileEntity(Class<? extends asp> tileEntityClass, String id) {
        asp.a(tileEntityClass, (String)id);
    }

    public static void registerTileEntityWithAlternatives(Class<? extends asp> tileEntityClass, String id, String ... alternatives) {
        asp.a(tileEntityClass, (String)id);
        Map teMappings = (Map)ObfuscationReflectionHelper.getPrivateValue(asp.class, null, "field_70326_a", "nameToClassMap", "a");
        for (String s : alternatives) {
            if (teMappings.containsKey(s)) continue;
            teMappings.put(s, tileEntityClass);
        }
    }

    public static void addBiome(acq biome) {
        acg.b.addNewBiome(biome);
    }

    public static void removeBiome(acq biome) {
        acg.b.removeBiome(biome);
    }

    public static void registerFuelHandler(IFuelHandler handler) {
        fuelHandlers.add(handler);
    }

    public static int getFuelValue(ye itemStack) {
        int fuelValue = 0;
        for (IFuelHandler handler : fuelHandlers) {
            fuelValue = Math.max(fuelValue, handler.getBurnTime(itemStack));
        }
        return fuelValue;
    }

    public static void registerCraftingHandler(ICraftingHandler handler) {
        craftingHandlers.add(handler);
    }

    public static void onItemCrafted(uf player, ye item, mo craftMatrix) {
        for (ICraftingHandler handler : craftingHandlers) {
            handler.onCrafting(player, item, craftMatrix);
        }
    }

    public static void onItemSmelted(uf player, ye item) {
        for (ICraftingHandler handler : craftingHandlers) {
            handler.onSmelting(player, item);
        }
    }

    public static void registerPickupHandler(IPickupNotifier handler) {
        pickupHandlers.add(handler);
    }

    public static void onPickupNotification(uf player, ss item) {
        for (IPickupNotifier notify : pickupHandlers) {
            notify.notifyPickup(item, player);
        }
    }

    public static void registerPlayerTracker(IPlayerTracker tracker) {
        playerTrackers.add(tracker);
    }

    public static void onPlayerLogin(uf player) {
        for (IPlayerTracker tracker : playerTrackers) {
            try {
                tracker.onPlayerLogin(player);
            }
            catch (Exception e) {
                FMLLog.log(Level.SEVERE, e, "A critical error occured handling the onPlayerLogin event with player tracker %s", tracker.getClass().getName());
            }
        }
    }

    public static void onPlayerLogout(uf player) {
        for (IPlayerTracker tracker : playerTrackers) {
            try {
                tracker.onPlayerLogout(player);
            }
            catch (Exception e) {
                FMLLog.log(Level.SEVERE, e, "A critical error occured handling the onPlayerLogout event with player tracker %s", tracker.getClass().getName());
            }
        }
    }

    public static void onPlayerChangedDimension(uf player) {
        GameRegistry.onPlayerChangedDimension(player, player.q.getWorld());
    }

    public static void onPlayerChangedDimension(uf player, CraftWorld fromWorld) {
        PlayerChangedWorldEvent event = new PlayerChangedWorldEvent((Player)player.getBukkitEntity(), (World)fromWorld);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        for (IPlayerTracker tracker : playerTrackers) {
            try {
                tracker.onPlayerChangedDimension(player);
                jv playermp = (jv)player;
                playermp.compassTarget = new Location((World)playermp.q.getWorld(), playermp.u, playermp.v, playermp.w);
            }
            catch (Exception e) {
                FMLLog.log(Level.SEVERE, e, "A critical error occured handling the onPlayerChangedDimension event with player tracker %s", tracker.getClass().getName());
            }
        }
    }

    public static void onPlayerRespawn(uf player) {
        for (IPlayerTracker tracker : playerTrackers) {
            try {
                tracker.onPlayerRespawn(player);
            }
            catch (Exception e) {
                FMLLog.log(Level.SEVERE, e, "A critical error occured handling the onPlayerRespawn event with player tracker %s", tracker.getClass().getName());
            }
        }
    }

    public static aqz findBlock(String modId, String name) {
        return GameData.findBlock(modId, name);
    }

    public static yc findItem(String modId, String name) {
        return GameData.findItem(modId, name);
    }

    public static void registerCustomItemStack(String name, ye itemStack) {
        GameData.registerCustomItemStack(name, itemStack);
    }

    public static ye findItemStack(String modId, String name, int stackSize) {
        ye foundStack = GameData.findItemStack(modId, name);
        if (foundStack != null) {
            ye is2 = foundStack.m();
            is2.b = Math.min(stackSize, is2.e());
            return is2;
        }
        return null;
    }

    public static UniqueIdentifier findUniqueIdentifierFor(aqz block) {
        return GameData.getUniqueName(block);
    }

    public static UniqueIdentifier findUniqueIdentifierFor(yc item) {
        return GameData.getUniqueName(item);
    }

    public static class UniqueIdentifier {
        public final String modId;
        public final String name;

        UniqueIdentifier(String modId, String name) {
            this.modId = modId;
            this.name = name;
        }
    }
}

