/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.cauldron;

import com.google.common.io.Files;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import org.bukkit.block.BlockState;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.inventory.InventoryHolder;

public class CauldronUtils {
    private static boolean deobfuscated = false;

    public static boolean isOverridingUpdateEntity(Class<? extends asp> c2) {
        Class<?> clazz = null;
        try {
            clazz = c2.getMethod("func_70316_g", new Class[0]).getDeclaringClass();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return clazz != asp.class;
    }

    public static boolean canTileEntityUpdate(Class<? extends asp> c2) {
        boolean canUpdate = false;
        try {
            Constructor<? extends asp> ctor = c2.getConstructor(new Class[0]);
            asp te = ctor.newInstance(new Object[0]);
            canUpdate = te.canUpdate();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return canUpdate;
    }

    public static <T> void dumpAndSortClassList(List<Class<? extends T>> classList) {
        ArrayList<String> sortedClassList = new ArrayList<String>();
        for (Class<T> clazz : classList) {
            sortedClassList.add(clazz.getName());
        }
        Collections.sort(sortedClassList);
        MinecraftServer.F();
        if (MinecraftServer.tileEntityConfig.enableTECanUpdateWarning.getValue().booleanValue()) {
            for (int i = 0; i < sortedClassList.size(); ++i) {
                MinecraftServer.F().e("Detected TE " + (String)sortedClassList.get(i) + " with canUpdate set to true and no updateEntity override!. This is NOT good, please report to mod author as this can hurt performance.");
            }
        }
    }

    public static boolean migrateWorlds(String worldType, String oldWorldContainer, String newWorldContainer, String worldName) {
        boolean result = true;
        File newWorld = new File(new File(newWorldContainer), worldName);
        File oldWorld = new File(new File(oldWorldContainer), worldName);
        if (!newWorld.isDirectory() && oldWorld.isDirectory()) {
            lp log = MinecraftServer.F().an();
            log.a("---- Migration of old " + worldType + " folder required ----");
            log.a("Cauldron has moved back to using the Forge World structure, your " + worldType + " folder will be moved to a new location in order to operate correctly.");
            log.a("We will move this folder for you, but it will mean that you need to move it back should you wish to stop using Cauldron in the future.");
            log.a("Attempting to move " + oldWorld + " to " + newWorld + "...");
            if (newWorld.exists()) {
                log.c("A file or folder already exists at " + newWorld + "!");
                log.a("---- Migration of old " + worldType + " folder failed ----");
                result = false;
            } else if (newWorld.getParentFile().mkdirs() || newWorld.getParentFile().exists()) {
                log.a("Success! To restore " + worldType + " in the future, simply move " + newWorld + " to " + oldWorld);
                try {
                    Files.move((File)oldWorld, (File)newWorld);
                }
                catch (IOException exception) {
                    log.c("Unable to move world data.");
                    exception.printStackTrace();
                    result = false;
                }
                try {
                    Files.copy((File)new File(oldWorld.getParent(), "level.dat"), (File)new File(newWorld, "level.dat"));
                }
                catch (IOException exception) {
                    log.c("Unable to migrate world level.dat.");
                }
                log.a("---- Migration of old " + worldType + " folder complete ----");
            } else {
                result = false;
            }
        }
        return result;
    }

    public static InventoryHolder getOwner(asp tileentity) {
        BlockState state = tileentity.k.getWorld().getBlockAt(tileentity.l, tileentity.m, tileentity.n).getState();
        if (state instanceof InventoryHolder) {
            return (InventoryHolder)state;
        }
        return null;
    }

    public static Event.Result convertBukkitToForgeResult(Event.Result result) {
        switch (result) {
            case ALLOW: {
                return Event.Result.ALLOW;
            }
            case DENY: {
                return Event.Result.DENY;
            }
        }
        return Event.Result.DEFAULT;
    }

    public static Action convertForgeToBukkitAction(PlayerInteractEvent.Action action) {
        switch (action) {
            case RIGHT_CLICK_AIR: {
                return Action.RIGHT_CLICK_AIR;
            }
            case LEFT_CLICK_BLOCK: {
                return Action.LEFT_CLICK_BLOCK;
            }
        }
        return Action.RIGHT_CLICK_BLOCK;
    }

    public static boolean deobfuscatedEnvironment() {
        try {
            byte[] bs = ((LaunchClassLoader)CauldronUtils.class.getClassLoader()).getClassBytes("net.minecraft.world.World");
            if (bs != null) {
                FMLRelaunchLog.info("Managed to load a deobfuscated Minecraft name- we are in a deobfuscated environment. Skipping runtime deobfuscation", new Object[0]);
                deobfuscated = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return deobfuscated;
    }
}

