/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.cauldron.apiimpl.inventory;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.cauldron.api.inventory.BukkitOreDictionary;
import net.minecraftforge.cauldron.api.inventory.OreDictionaryEntry;
import net.minecraftforge.oredict.OreDictionary;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_6_R3.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;

public class OreDictionaryInterface
implements BukkitOreDictionary {
    private Map<String, String> normalizedToCanonicalMap = null;

    private void initializeMap() {
        this.normalizedToCanonicalMap = new HashMap<String, String>();
        for (String str : this.getAllOreNames()) {
            if (str == null || str.isEmpty()) continue;
            this.normalizedToCanonicalMap.put(Material.normalizeName((String)str), str);
        }
    }

    @Override
    public OreDictionaryEntry getOreEntry(String name) {
        String canonical;
        if (this.normalizedToCanonicalMap == null) {
            this.initializeMap();
        }
        if ((canonical = this.normalizedToCanonicalMap.get(Material.normalizeName((String)name))) == null) {
            return null;
        }
        return OreDictionaryEntry.valueOf(OreDictionary.getOreID(canonical));
    }

    @Override
    public List<OreDictionaryEntry> getOreEntries(ItemStack itemStack) {
        int id = OreDictionary.getOreID(CraftItemStack.asNMSCopy((ItemStack)itemStack));
        return ImmutableList.of((Object)OreDictionaryEntry.valueOf(id));
    }

    @Override
    public List<OreDictionaryEntry> getOreEntries(Material material) {
        return this.getOreEntries(new ItemStack(material));
    }

    @Override
    public String getOreName(OreDictionaryEntry entry) {
        return OreDictionary.getOreName(entry.getId());
    }

    @Override
    public List<ItemStack> getDefinitions(OreDictionaryEntry entry) {
        ArrayList<ye> items = OreDictionary.getOres(entry.getId());
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ye nmsItem : items) {
            builder.add((Object)CraftItemStack.asCraftMirror((ye)nmsItem));
        }
        return builder.build();
    }

    @Override
    public List<String> getAllOreNames() {
        return Arrays.asList(OreDictionary.getOreNames());
    }
}

