/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.cauldron.configuration;

import java.io.File;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.cauldron.CauldronHooks;
import net.minecraftforge.cauldron.TileEntityCache;
import net.minecraftforge.cauldron.command.TileEntityCommand;
import net.minecraftforge.cauldron.configuration.BoolSetting;
import net.minecraftforge.cauldron.configuration.ConfigBase;
import net.minecraftforge.cauldron.configuration.Setting;
import org.bukkit.configuration.file.YamlConfiguration;

public class TileEntityConfig
extends ConfigBase {
    private final String HEADER = "This is the main configuration file for TileEntities.\n\nIf you need help with the configuration or have any questions related to Cauldron,\njoin us at the IRC or drop by our forums and leave a post.\n\nIRC: #cauldron @ irc.esper.net ( http://webchat.esper.net/?channel=cauldron )\nForums: http://cauldron.minecraftforge.net/\n";
    public final BoolSetting skipTileEntityTicks = new BoolSetting(this, "settings.skip-tileentity-ticks", true, "If enabled, turns on tileentity tick skip feature when no players are near.");
    public final BoolSetting enableTECanUpdateWarning = new BoolSetting(this, "debug.enable-te-can-update-warning", false, "Set true to detect which tileentities should not be ticking.");
    public final BoolSetting enableTEInventoryWarning = new BoolSetting(this, "debug.enable-te-inventory-warning", false, "Set true to detect which tileentities with inventory failed to detect size for Bukkit's InventoryType enum. Note: This may detect a false-positive.");
    public final BoolSetting enableTEPlaceWarning = new BoolSetting(this, "debug.enable-te-place-warning", false, "Warn when a mod requests tile entity from a block that doesn't support one");
    public final BoolSetting preventInvalidTileEntityUpdates = new BoolSetting(this, "settings.prevent-invalid-tileentity-updates", true, "Used to determine if a tileentity should tick and if not the TE is added to a ban list. Note: This should help improve performance.");

    public TileEntityConfig(String fileName, String commandName) {
        super(fileName, commandName);
        this.init();
    }

    @Override
    public void addCommands() {
        this.commands.put(this.commandName, new TileEntityCommand());
    }

    public void init() {
        this.settings.put(this.skipTileEntityTicks.path, this.skipTileEntityTicks);
        this.settings.put(this.enableTECanUpdateWarning.path, this.enableTECanUpdateWarning);
        this.settings.put(this.enableTEInventoryWarning.path, this.enableTEInventoryWarning);
        this.settings.put(this.enableTEPlaceWarning.path, this.enableTEPlaceWarning);
        this.settings.put(this.preventInvalidTileEntityUpdates.path, this.preventInvalidTileEntityUpdates);
        this.load();
    }

    @Override
    public void load() {
        try {
            this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
            String header = "This is the main configuration file for TileEntities.\n\nIf you need help with the configuration or have any questions related to Cauldron,\njoin us at the IRC or drop by our forums and leave a post.\n\nIRC: #cauldron @ irc.esper.net ( http://webchat.esper.net/?channel=cauldron )\nForums: http://cauldron.minecraftforge.net/\n\n";
            for (Setting toggle : this.settings.values()) {
                if (!toggle.description.equals("")) {
                    header = header + "Setting: " + toggle.path + " Default: " + toggle.def + "   # " + toggle.description + "\n";
                }
                this.config.addDefault(toggle.path, toggle.def);
                ((Setting)this.settings.get(toggle.path)).setValue(this.config.getString(toggle.path));
            }
            this.config.options().header(header);
            this.config.options().copyDefaults(true);
            this.version = this.getInt("config-version", 1);
            this.set("config-version", 1);
            for (TileEntityCache teCache : CauldronHooks.tileEntityCache.values()) {
                teCache.tickNoPlayers = this.config.getBoolean("world-settings." + teCache.worldName + "." + teCache.configPath + ".tick-no-players", this.config.getBoolean("world-settings.default." + teCache.configPath + ".tick-no-players"));
                teCache.tickInterval = this.config.getInt("world-settings." + teCache.worldName + "." + teCache.configPath + ".tick-interval", this.config.getInt("world-settings.default." + teCache.configPath + ".tick-interval"));
            }
            this.saveWorldConfigs();
            this.save();
        }
        catch (Exception ex) {
            MinecraftServer.F().h("Could not load " + this.configFile);
            ex.printStackTrace();
        }
    }
}

