/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event;

import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.HashMap;
import mcp.mobius.mobiuscore.profiler.ProfilerSection;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.EventPriority;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.IEventListener;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ASMEventHandler
implements IEventListener {
    private static int IDs = 0;
    private static final String HANDLER_DESC = Type.getInternalName(IEventListener.class);
    private static final String HANDLER_FUNC_DESC = Type.getMethodDescriptor((Method)IEventListener.class.getDeclaredMethods()[0]);
    private static final ASMClassLoader LOADER = new ASMClassLoader();
    private static final HashMap<Method, Class<?>> cache = Maps.newHashMap();
    private final IEventListener handler;
    private final ForgeSubscribe subInfo;
    private final String package_;

    public ASMEventHandler(Object target, Method method) throws Exception {
        this.package_ = method.getDeclaringClass().getCanonicalName();
        this.handler = (IEventListener)this.createWrapper(method).getConstructor(Object.class).newInstance(target);
        this.subInfo = method.getAnnotation(ForgeSubscribe.class);
    }

    @Override
    public void invoke(Event event) {
        if (!(this.handler == null || event.isCancelable() && event.isCanceled() && !this.subInfo.receiveCanceled())) {
            ProfilerSection.EVENT_INVOKE.start();
            this.handler.invoke(event);
            ProfilerSection.EVENT_INVOKE.stop(event, this.package_, this.handler);
        }
    }

    public EventPriority getPriority() {
        return this.subInfo.priority();
    }

    public Class<?> createWrapper(Method callback) {
        if (cache.containsKey(callback)) {
            return cache.get(callback);
        }
        ClassWriter cw = new ClassWriter(0);
        String name = this.getUniqueName(callback);
        String desc = name.replace('.', '/');
        String instType = Type.getInternalName(callback.getDeclaringClass());
        String eventType = Type.getInternalName(callback.getParameterTypes()[0]);
        cw.visit(50, 33, desc, null, "java/lang/Object", new String[]{HANDLER_DESC});
        cw.visitSource(".dynamic", null);
        cw.visitField(1, "instance", "Ljava/lang/Object;", null, null).visitEnd();
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(Ljava/lang/Object;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, desc, "instance", "Ljava/lang/Object;");
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        mv = cw.visitMethod(1, "invoke", HANDLER_FUNC_DESC, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, desc, "instance", "Ljava/lang/Object;");
        mv.visitTypeInsn(192, instType);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, eventType);
        mv.visitMethodInsn(182, instType, callback.getName(), Type.getMethodDescriptor((Method)callback));
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        cw.visitEnd();
        Class<?> ret = LOADER.define(name, cw.toByteArray());
        cache.put(callback, ret);
        return ret;
    }

    private String getUniqueName(Method callback) {
        return String.format("%s_%d_%s_%s_%s", this.getClass().getName(), IDs++, callback.getDeclaringClass().getSimpleName(), callback.getName(), callback.getParameterTypes()[0].getSimpleName());
    }

    private static class ASMClassLoader
    extends ClassLoader {
        private ASMClassLoader() {
            super(ASMClassLoader.class.getClassLoader());
        }

        public Class<?> define(String name, byte[] data) {
            return this.defineClass(name, data, 0, data.length);
        }
    }
}

