/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc;

import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.spigotmc.AntiXray;
import org.spigotmc.SpigotConfig;

public class SpigotWorldConfig {
    private final String worldName;
    private final YamlConfiguration config;
    private boolean verbose;
    public int chunksPerTick;
    public int cactusModifier;
    public int caneModifier;
    public int melonModifier;
    public int mushroomModifier;
    public int pumpkinModifier;
    public int saplingModifier;
    public int wheatModifier;
    public double itemMerge;
    public double expMerge;
    public int viewDistance;
    public boolean antiXray = true;
    public int engineMode = 1;
    public List<Integer> blocks = Arrays.asList(1, 5, 14, 15, 16, 21, 48, 49, 54, 56, 73, 74, 82, 129, 130);
    public AntiXray antiXrayInstance;
    public byte mobSpawnRange;
    public int animalActivationRange = 32;
    public int monsterActivationRange = 32;
    public int miscActivationRange = 16;
    public int playerTrackingRange = 48;
    public int animalTrackingRange = 48;
    public int monsterTrackingRange = 48;
    public int miscTrackingRange = 32;
    public int maxTrackingRange = 64;
    public int hopperTransfer = 8;
    public int hopperCheck = 8;
    public boolean randomLightUpdates;
    public boolean saveMineshaftStructureInfo;
    public int itemDespawnRate;
    public int arrowDespawnRate;

    public SpigotWorldConfig(String worldName) {
        this.worldName = worldName;
        this.config = SpigotConfig.config;
        if (worldName.toLowerCase().contains("dummy")) {
            return;
        }
        try {
            this.init();
        }
        catch (Throwable t2) {
            this.log("Something bad happened while trying init the spigot config for [" + worldName + "]");
            t2.printStackTrace();
        }
    }

    public void init() {
        this.verbose = this.getBoolean("verbose", false);
        if (this.verbose) {
            this.log("-------- World Settings For [" + this.worldName + "] --------");
        }
        SpigotConfig.readConfig(SpigotWorldConfig.class, this);
    }

    private void log(String s) {
        if (this.verbose) {
            Bukkit.getLogger().info(s);
        }
    }

    private void set(String path, Object val) {
        this.config.set("world-settings.default." + path, val);
    }

    private boolean getBoolean(String path, boolean def) {
        this.config.addDefault("world-settings.default." + path, (Object)def);
        return this.config.getBoolean("world-settings." + this.worldName + "." + path, this.config.getBoolean("world-settings.default." + path));
    }

    private double getDouble(String path, double def) {
        this.config.addDefault("world-settings.default." + path, (Object)def);
        return this.config.getDouble("world-settings." + this.worldName + "." + path, this.config.getDouble("world-settings.default." + path));
    }

    private int getInt(String path, int def) {
        this.config.addDefault("world-settings.default." + path, (Object)def);
        return this.config.getInt("world-settings." + this.worldName + "." + path, this.config.getInt("world-settings.default." + path));
    }

    private <T> List getList(String path, T def) {
        this.config.addDefault("world-settings.default." + path, def);
        return this.config.getList("world-settings." + this.worldName + "." + path, this.config.getList("world-settings.default." + path));
    }

    private String getString(String path, String def) {
        this.config.addDefault("world-settings.default." + path, (Object)def);
        return this.config.getString("world-settings." + this.worldName + "." + path, this.config.getString("world-settings.default." + path));
    }

    private void chunksPerTick() {
        this.chunksPerTick = this.getInt("chunks-per-tick", 650);
        this.log("Chunks to Grow per Tick: " + this.chunksPerTick);
    }

    private void growthModifiers() {
        this.cactusModifier = this.getInt("growth.cactus-modifier", 100);
        this.log("Cactus Growth Modifier: " + this.cactusModifier + "%");
        this.caneModifier = this.getInt("growth.cane-modifier", 100);
        this.log("Cane Growth Modifier: " + this.caneModifier + "%");
        this.melonModifier = this.getInt("growth.melon-modifier", 100);
        this.log("Melon Growth Modifier: " + this.melonModifier + "%");
        this.mushroomModifier = this.getInt("growth.mushroom-modifier", 100);
        this.log("Mushroom Growth Modifier: " + this.mushroomModifier + "%");
        this.pumpkinModifier = this.getInt("growth.pumpkin-modifier", 100);
        this.log("Pumpkin Growth Modifier: " + this.pumpkinModifier + "%");
        this.saplingModifier = this.getInt("growth.sapling-modifier", 100);
        this.log("Sapling Growth Modifier: " + this.saplingModifier + "%");
        this.wheatModifier = this.getInt("growth.wheat-modifier", 100);
        this.log("Wheat Growth Modifier: " + this.wheatModifier + "%");
    }

    private void itemMerge() {
        this.itemMerge = this.getDouble("merge-radius.item", 2.5);
        this.log("Item Merge Radius: " + this.itemMerge);
    }

    private void expMerge() {
        this.expMerge = this.getDouble("merge-radius.exp", 3.0);
        this.log("Experience Merge Radius: " + this.expMerge);
    }

    private void viewDistance() {
        this.viewDistance = this.getInt("view-distance", Bukkit.getViewDistance());
        this.log("View Distance: " + this.viewDistance);
    }

    private void antiXray() {
        this.antiXray = false;
        this.log("Anti X-Ray: " + this.antiXray);
        this.engineMode = this.getInt("anti-xray.engine-mode", this.engineMode);
        this.log("\tEngine Mode: " + this.engineMode);
        if (SpigotConfig.version < 3) {
            this.set("anti-xray.blocks", this.blocks);
        }
        this.blocks = this.getList("anti-xray.blocks", this.blocks);
        this.log("\tBlocks: " + this.blocks);
        this.antiXrayInstance = new AntiXray(this);
    }

    private void mobSpawnRange() {
        this.mobSpawnRange = (byte)this.getInt("mob-spawn-range", 4);
        this.log("Mob Spawn Range: " + this.mobSpawnRange);
    }

    private void activationRange() {
        this.animalActivationRange = this.getInt("entity-activation-range.animals", this.animalActivationRange);
        this.monsterActivationRange = this.getInt("entity-activation-range.monsters", this.monsterActivationRange);
        this.miscActivationRange = this.getInt("entity-activation-range.misc", this.miscActivationRange);
        this.log("Entity Activation Range: An " + this.animalActivationRange + " / Mo " + this.monsterActivationRange + " / Mi " + this.miscActivationRange);
    }

    private void trackingRange() {
        this.playerTrackingRange = this.getInt("entity-tracking-range.players", this.playerTrackingRange);
        this.animalTrackingRange = this.getInt("entity-tracking-range.animals", this.animalTrackingRange);
        this.monsterTrackingRange = this.getInt("entity-tracking-range.monsters", this.monsterTrackingRange);
        this.miscTrackingRange = this.getInt("entity-tracking-range.misc", this.miscTrackingRange);
        this.maxTrackingRange = this.getInt("entity-tracking-range.other", this.maxTrackingRange);
        this.log("Entity Tracking Range: Pl " + this.playerTrackingRange + " / An " + this.animalTrackingRange + " / Mo " + this.monsterTrackingRange + " / Mi " + this.miscTrackingRange + " / Other " + this.maxTrackingRange);
    }

    private void hoppers() {
        this.hopperTransfer = this.getInt("ticks-per.hopper-transfer", this.hopperTransfer);
        this.hopperCheck = this.getInt("ticks-per.hopper-check", this.hopperTransfer);
        this.log("Hopper Transfer: " + this.hopperTransfer + " Hopper Check: " + this.hopperCheck);
    }

    private void lightUpdates() {
        this.randomLightUpdates = this.getBoolean("random-light-updates", false);
        this.log("Random Lighting Updates: " + this.randomLightUpdates);
    }

    private void mineshaftStructureInfo() {
        this.saveMineshaftStructureInfo = this.getBoolean("save-mineshaft-structure-info", false);
        this.log("Mineshaft Structure Info Saving: " + this.saveMineshaftStructureInfo);
    }

    private void itemDespawnRate() {
        this.itemDespawnRate = this.getInt("item-despawn-rate", 6000);
        this.log("Item Despawn Rate: " + this.itemDespawnRate);
    }

    private void arrowDespawnRate() {
        this.arrowDespawnRate = this.getInt("arrow-despawn-rate", 1200);
        this.log("Arrow Despawn Rate: " + this.arrowDespawnRate);
    }
}

