/*
 * Decompiled with CFR 0.152.
 */
package com.abstractwolf.flags;

import com.abstractwolf.flags.EventListener;
import com.abstractwolf.flags.FlagManager;
import com.abstractwolf.flags.YAMLDataHandler;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.flags.StateFlag;
import java.util.ArrayList;
import java.util.logging.Level;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CDWorldGuardFlags
extends JavaPlugin {
    public static final StateFlag CAN_BREAK_LEGS = new StateFlag("can-break-legs", true);
    public static final StateFlag CAN_WATERLEVELS_UPDATE = new StateFlag("can-waterlevels-update", true);
    public static final StateFlag CAN_USER_VIEW_TAGS = new StateFlag("can-view-tags", true);
    public static final StateFlag CAN_USER_TAKE_BULLET_DAMAGE = new StateFlag("can-take-bullet-damage", true);
    public static final StateFlag CAN_USER_TAKE_BLOOD_DAMAGE = new StateFlag("can-take-blood-damage", true);
    public static final StateFlag CAN_USER_TAKE_INFECTION_DAMAGE = new StateFlag("can-take-infection-damage", true);
    public static final StateFlag CAN_USER_THROW_GRENADE = new StateFlag("can-throw-grenade", true);
    public static final StateFlag CD_BUILD = new StateFlag("cd-build", false);
    public static final StateFlag WARP_SPAWN = new StateFlag("cd-warp-spawn", false);
    public static final StateFlag WARP_RSPAWN = new StateFlag("cd-warp-rspawn", false);
    public static final StateFlag WARP_BACK_TO_MAP = new StateFlag("cd-warp-back-map", false);
    public static WorldGuardPlugin wgPlugin;
    public YAMLDataHandler dataHandler;
    public ArrayList<Integer> toolsWoodMaterials = new ArrayList();
    public ArrayList<Integer> destroyableWoodMaterials = new ArrayList();
    public ArrayList<Integer> toolsStoneMaterials = new ArrayList();
    public ArrayList<Integer> destroyableStoneMaterials = new ArrayList();

    public void onEnable() {
        wgPlugin = this.getWorldGuard();
        if (wgPlugin == null) {
            this.getLogger().warning("This plugin requires WorldGuard, disabling.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.loadConfig();
        this.dataHandler = new YAMLDataHandler(this, wgPlugin);
        this.getServer().getPluginManager().registerEvents((Listener)new EventListener(this), (Plugin)this);
        try {
            FlagManager.injectFlag(CAN_BREAK_LEGS);
            FlagManager.injectFlag(CAN_WATERLEVELS_UPDATE);
            FlagManager.injectFlag(CAN_USER_VIEW_TAGS);
            FlagManager.injectFlag(CAN_USER_TAKE_BULLET_DAMAGE);
            FlagManager.injectFlag(CAN_USER_TAKE_BLOOD_DAMAGE);
            FlagManager.injectFlag(CAN_USER_TAKE_INFECTION_DAMAGE);
            FlagManager.injectFlag(CAN_USER_THROW_GRENADE);
            FlagManager.injectFlag(CD_BUILD);
            FlagManager.injectFlag(WARP_SPAWN);
            FlagManager.injectFlag(WARP_RSPAWN);
            FlagManager.injectFlag(WARP_BACK_TO_MAP);
            FlagManager.injectFlags();
        }
        catch (Exception ex) {
            this.getLogger().log(Level.SEVERE, "", ex);
        }
        this.dataHandler.loadFlagsIntoAllWorlds();
    }

    public void onDisable() {
        this.dataHandler.saveFlagsToAllWorlds();
    }

    public void loadConfig() {
        this.saveDefaultConfig();
        this.toolsWoodMaterials = (ArrayList)this.getConfig().getIntegerList("wood-tools");
        System.out.println("Editeable Wooden Tools: " + this.toolsWoodMaterials);
        this.destroyableWoodMaterials = (ArrayList)this.getConfig().getIntegerList("editable-wood-blocks");
        System.out.println("Editeable Wooden Materials: " + this.destroyableWoodMaterials);
        this.toolsStoneMaterials = (ArrayList)this.getConfig().getIntegerList("stone-tools");
        System.out.println("Editeable Stone Tools: " + this.toolsStoneMaterials);
        this.destroyableStoneMaterials = (ArrayList)this.getConfig().getIntegerList("editable-stone-blocks");
        System.out.println("Editeable Stone Materials: " + this.destroyableStoneMaterials);
    }

    private WorldGuardPlugin getWorldGuard() {
        Plugin plugin = this.getServer().getPluginManager().getPlugin("WorldGuard");
        if (plugin == null || !(plugin instanceof WorldGuardPlugin)) {
            return null;
        }
        return (WorldGuardPlugin)plugin;
    }
}

