/*
 * Decompiled with CFR 0.152.
 */
package com.abstractwolf.flags;

import com.abstractwolf.flags.CDWorldGuardFlags;
import com.abstractwolf.flags.Utils;
import com.mewin.WGRegionEvents.events.RegionEnterEvent;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.inventory.ItemStack;

public class EventListener
implements Listener {
    private CDWorldGuardFlags plugin;

    public EventListener(CDWorldGuardFlags par1) {
        this.plugin = par1;
    }

    @EventHandler
    public void onSaveCalled(WorldSaveEvent event) {
        this.plugin.dataHandler.saveFlagsToAllWorlds();
    }

    @EventHandler
    public void onCreativeInventory(InventoryCreativeEvent e) {
        if (e.getWhoClicked().hasPermission("craftingdead.restrict.gm") && !e.getWhoClicked().isOp()) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onItemRightClicked(PlayerInteractEvent e) {
        Player player = e.getPlayer();
        ProtectedRegion region = Utils.getRegionIn(player.getLocation());
        if (player.isOp()) {
            return;
        }
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (region == null || region.getFlag((Flag)CDWorldGuardFlags.CD_BUILD) == null || region.getFlag((Flag)CDWorldGuardFlags.CD_BUILD) != StateFlag.State.ALLOW || player.getItemInHand() != null) {
            // empty if block
        }
    }

    @EventHandler
    public void onHangingBlockBorken(HangingBreakByEntityEvent e) {
        if (e.getRemover() instanceof Player) {
            Player player = (Player)e.getRemover();
            ProtectedRegion region = Utils.getRegionIn(player.getLocation());
            if (player.isOp()) {
                return;
            }
            if (region != null && region.getFlag((Flag)CDWorldGuardFlags.CD_BUILD) != null && region.getFlag((Flag)CDWorldGuardFlags.CD_BUILD) == StateFlag.State.ALLOW) {
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent e) {
        Player player = e.getPlayer();
        ProtectedRegion region = Utils.getRegionIn(player.getLocation());
        if (player.isOp()) {
            return;
        }
        if (region != null && region.getFlag((Flag)CDWorldGuardFlags.CD_BUILD) != null && region.getFlag((Flag)CDWorldGuardFlags.CD_BUILD) == StateFlag.State.ALLOW) {
            ItemStack stack = player.getItemInHand();
            if (stack != null) {
                if (this.plugin.toolsWoodMaterials.contains(stack.getTypeId()) && this.plugin.destroyableWoodMaterials.contains(e.getBlock().getTypeId())) {
                    e.setCancelled(false);
                    return;
                }
                if (this.plugin.toolsStoneMaterials.contains(stack.getTypeId()) && this.plugin.destroyableStoneMaterials.contains(e.getBlock().getTypeId())) {
                    e.setCancelled(false);
                    return;
                }
            }
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockPlaced(BlockPlaceEvent e) {
        Player player = e.getPlayer();
        ProtectedRegion region = Utils.getRegionIn(player.getLocation());
        if (player.isOp()) {
            return;
        }
        if (region != null && region.getFlag((Flag)CDWorldGuardFlags.CD_BUILD) != null && region.getFlag((Flag)CDWorldGuardFlags.CD_BUILD) == StateFlag.State.ALLOW) {
            e.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onRegionEnter(RegionEnterEvent e) {
        this.updateRegionFlags(e.getRegion(), e.getPlayer().getName());
    }

    @EventHandler
    public void onPlayerMoved(PlayerMoveEvent e) {
        ProtectedRegion region1;
        ProtectedRegion region = Utils.getRegionIn(e.getPlayer().getLocation());
        this.updateRegionFlags(region, e.getPlayer().getName());
        if (region != null) {
            return;
        }
        if (e.getPlayer().isOp()) {
            return;
        }
        WorldGuardPlugin guard = CDWorldGuardFlags.wgPlugin;
        RegionManager manager = guard.getRegionManager(e.getPlayer().getLocation().getWorld());
        if (manager.getRegions().get("__global__") != null && (region1 = (ProtectedRegion)manager.getRegions().get("__global__")).getFlag((Flag)CDWorldGuardFlags.WARP_BACK_TO_MAP) != null && region1.getFlag((Flag)CDWorldGuardFlags.WARP_BACK_TO_MAP) == StateFlag.State.ALLOW) {
            Bukkit.getServer().dispatchCommand((CommandSender)e.getPlayer(), "warp spawn");
        }
    }

    public void updateRegionFlags(ProtectedRegion region, String username) {
        Utils.setPlayersUsernameViewable(username, true);
        Utils.setPlayerCanTakeBulletDamage(username, true);
        Utils.setPlayerCanTakeBloodDamage(username, true);
        Utils.setPlayerCanTakeInfectionDamage(username, true);
        Utils.setPlayerCanThrowGrenades(username, true);
        if (region != null) {
            if (region.getFlag((Flag)CDWorldGuardFlags.WARP_SPAWN) != null && region.getFlag((Flag)CDWorldGuardFlags.WARP_SPAWN) == StateFlag.State.ALLOW) {
                Bukkit.getPlayer((String)username).performCommand("warp spawn");
            }
            if (region.getFlag((Flag)CDWorldGuardFlags.WARP_RSPAWN) != null && region.getFlag((Flag)CDWorldGuardFlags.WARP_RSPAWN) == StateFlag.State.ALLOW) {
                Bukkit.getPlayer((String)username).performCommand("rspawn");
            }
            if (region.getFlag((Flag)CDWorldGuardFlags.CAN_WATERLEVELS_UPDATE) != null && region.getFlag((Flag)CDWorldGuardFlags.CAN_WATERLEVELS_UPDATE) == StateFlag.State.DENY) {
                Utils.increaseWaterLevels(username, 20);
            }
            if (region.getFlag((Flag)CDWorldGuardFlags.CAN_USER_VIEW_TAGS) != null && region.getFlag((Flag)CDWorldGuardFlags.CAN_USER_VIEW_TAGS) == StateFlag.State.DENY) {
                Utils.setPlayersUsernameViewable(username, false);
            }
            if (region.getFlag((Flag)CDWorldGuardFlags.CAN_USER_TAKE_BULLET_DAMAGE) != null && region.getFlag((Flag)CDWorldGuardFlags.CAN_USER_TAKE_BULLET_DAMAGE) == StateFlag.State.DENY) {
                Utils.setPlayerCanTakeBulletDamage(username, false);
            }
            if (region.getFlag((Flag)CDWorldGuardFlags.CAN_USER_TAKE_BLOOD_DAMAGE) != null && region.getFlag((Flag)CDWorldGuardFlags.CAN_USER_TAKE_BLOOD_DAMAGE) == StateFlag.State.DENY) {
                Utils.setPlayerCanTakeBloodDamage(username, false);
            }
            if (region.getFlag((Flag)CDWorldGuardFlags.CAN_USER_TAKE_INFECTION_DAMAGE) != null && region.getFlag((Flag)CDWorldGuardFlags.CAN_USER_TAKE_INFECTION_DAMAGE) == StateFlag.State.DENY) {
                Utils.setPlayerCanTakeInfectionDamage(username, false);
            }
            if (region.getFlag((Flag)CDWorldGuardFlags.CAN_USER_THROW_GRENADE) != null && region.getFlag((Flag)CDWorldGuardFlags.CAN_USER_THROW_GRENADE) == StateFlag.State.DENY) {
                Utils.setPlayerCanThrowGrenades(username, false);
            }
            if (region.getFlag((Flag)CDWorldGuardFlags.CAN_BREAK_LEGS) != null && region.getFlag((Flag)CDWorldGuardFlags.CAN_BREAK_LEGS) == StateFlag.State.DENY) {
                try {
                    Utils.removePotion(username, 29);
                    Utils.removePotion(username, 15);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

