/*
 * Decompiled with CFR 0.152.
 */
package com.abstractwolf.flags;

import com.abstractwolf.flags.CDWorldGuardFlags;
import com.abstractwolf.flags.FlagManager;
import com.sk89q.util.yaml.YAMLFormat;
import com.sk89q.util.yaml.YAMLNode;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.bukkit.World;

public class YAMLDataHandler {
    private CDWorldGuardFlags plugin;
    private WorldGuardPlugin wgPlugin;

    public YAMLDataHandler(CDWorldGuardFlags par1, WorldGuardPlugin par2) {
        this.plugin = par1;
        this.wgPlugin = par2;
    }

    public void loadFlagsIntoAllWorlds() {
        Iterator itr = this.plugin.getServer().getWorlds().iterator();
        while (itr.hasNext()) {
            this.loadFlagsIntoWorld((World)itr.next());
        }
    }

    public void loadFlagsIntoWorld(World world) {
        YAMLProcessor worldConfig = new YAMLProcessor(new File(this.wgPlugin.getDataFolder(), "worlds/" + world.getName() + "/cuztomFlagz.yml"), true, YAMLFormat.EXTENDED);
        try {
            worldConfig.load();
        }
        catch (IOException ex) {
            return;
        }
        RegionManager regionManager = this.wgPlugin.getRegionManager(world);
        List nodeList = worldConfig.getNodeList("regions", null);
        if (nodeList != null && !nodeList.isEmpty()) {
            for (int i = 0; i < nodeList.size(); ++i) {
                YAMLNode node = (YAMLNode)nodeList.get(i);
                String regionName = node.getString("region", null);
                ProtectedRegion region = regionManager.getRegion(regionName);
                YAMLNode flags = node.getNode("flags");
                for (int i1 = 0; i1 < FlagManager.getCustomFlags().size(); ++i1) {
                    Flag<?> checkingFlag = FlagManager.getCustomFlags().get(i1);
                    if (flags.getProperty(checkingFlag.getName()) == null) continue;
                    Object flagState = this.getValue(checkingFlag, flags.getProperty(checkingFlag.getName()));
                    region.setFlag(checkingFlag, flagState);
                }
            }
        }
    }

    public void saveFlagsToAllWorlds() {
        Iterator itr = this.plugin.getServer().getWorlds().iterator();
        while (itr.hasNext()) {
            this.saveFlagsToWorld((World)itr.next());
        }
    }

    public void saveFlagsToWorld(World world) {
        YAMLProcessor worldConfig = new YAMLProcessor(new File(this.wgPlugin.getDataFolder(), "worlds/" + world.getName() + "/cuztomFlagz.yml"), true, YAMLFormat.EXTENDED);
        RegionManager regionManager = this.wgPlugin.getRegionManager(world);
        if (regionManager == null) {
            return;
        }
        ArrayList savingRegionlist = new ArrayList();
        ArrayList regions = new ArrayList(regionManager.getRegions().values());
        for (int i = 0; i < regions.size(); ++i) {
            HashMap<String, Object> regionMapping = new HashMap<String, Object>();
            HashMap<String, String> flagMapping = new HashMap<String, String>();
            ProtectedRegion region = (ProtectedRegion)regions.get(i);
            boolean flag = false;
            for (int i1 = 0; i1 < FlagManager.getCustomFlags().size(); ++i1) {
                Flag<?> checkingFlag = FlagManager.getCustomFlags().get(i1);
                if (!region.getFlags().containsKey(checkingFlag)) continue;
                String flagValue = region.getFlags().get(checkingFlag).toString();
                flagMapping.put(checkingFlag.getName(), flagValue);
                flag = true;
            }
            regionMapping.put("region", region.getId());
            regionMapping.put("flags", flagMapping);
            if (!flag) continue;
            savingRegionlist.add(regionMapping);
        }
        worldConfig.setProperty("regions", savingRegionlist);
        worldConfig.save();
    }

    private Object getValue(Flag flag, Object value) {
        if (flag instanceof StateFlag) {
            return StateFlag.State.valueOf((String)((String)value));
        }
        return null;
    }

    public Flag getFlagFromName(String par1) {
        if (FlagManager.customFlags.containsKey(par1)) {
            return FlagManager.customFlags.get(par1);
        }
        return null;
    }
}

