/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.FluidRegistry;

public class RenderBlockFluid
implements ISimpleBlockRenderingHandler {
    public static RenderBlockFluid instance = new RenderBlockFluid();
    static final float LIGHT_Y_NEG = 0.5f;
    static final float LIGHT_Y_POS = 1.0f;
    static final float LIGHT_XZ_NEG = 0.8f;
    static final float LIGHT_XZ_POS = 0.6f;
    static final double RENDER_OFFSET = (double)0.001f;

    public float getFluidHeightAverage(float[] flow) {
        float total = 0.0f;
        int count = 0;
        float end = 0.0f;
        for (int i = 0; i < flow.length; ++i) {
            if (flow[i] >= 0.875f && end != 1.0f) {
                end = flow[i];
            }
            if (!(flow[i] >= 0.0f)) continue;
            total += flow[i];
            ++count;
        }
        if (end == 0.0f) {
            end = total / (float)count;
        }
        return end;
    }

    public float getFluidHeightForRender(acf world, int x2, int y, int z2, BlockFluidBase block) {
        if (world.a(x2, y, z2) == block.cF) {
            if (world.g(x2, y - block.densityDir, z2).d()) {
                return 1.0f;
            }
            if (world.h(x2, y, z2) == block.getMaxRenderHeightMeta()) {
                return 0.875f;
            }
        }
        return !world.g(x2, y, z2).a() && world.a(x2, y - block.densityDir, z2) == block.cF ? 1.0f : block.getQuantaPercentage(world, x2, y, z2) * 0.875f;
    }

    @Override
    public void renderInventoryBlock(aqz block, int metadata, int modelID, bfr renderer) {
    }

    @Override
    public boolean renderWorldBlock(acf world, int x2, int y, int z2, aqz block, int modelId, bfr renderer) {
        boolean rises;
        double heightNE;
        double heightSE;
        double heightSW;
        double heightNW;
        if (!(block instanceof BlockFluidBase)) {
            return false;
        }
        bfq tessellator = bfq.a;
        int color = block.c(world, x2, y, z2);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        BlockFluidBase theFluid = (BlockFluidBase)block;
        int bMeta = world.h(x2, y, z2);
        boolean renderTop = world.a(x2, y - theFluid.densityDir, z2) != theFluid.cF;
        boolean renderBottom = block.a(world, x2, y + theFluid.densityDir, z2, 0) && world.a(x2, y + theFluid.densityDir, z2) != theFluid.cF;
        boolean[] renderSides = new boolean[]{block.a(world, x2, y, z2 - 1, 2), block.a(world, x2, y, z2 + 1, 3), block.a(world, x2 - 1, y, z2, 4), block.a(world, x2 + 1, y, z2, 5)};
        if (!(renderTop || renderBottom || renderSides[0] || renderSides[1] || renderSides[2] || renderSides[3])) {
            return false;
        }
        boolean rendered = false;
        float flow11 = this.getFluidHeightForRender(world, x2, y, z2, theFluid);
        if (flow11 != 1.0f) {
            float flow00 = this.getFluidHeightForRender(world, x2 - 1, y, z2 - 1, theFluid);
            float flow01 = this.getFluidHeightForRender(world, x2 - 1, y, z2, theFluid);
            float flow02 = this.getFluidHeightForRender(world, x2 - 1, y, z2 + 1, theFluid);
            float flow10 = this.getFluidHeightForRender(world, x2, y, z2 - 1, theFluid);
            float flow12 = this.getFluidHeightForRender(world, x2, y, z2 + 1, theFluid);
            float flow20 = this.getFluidHeightForRender(world, x2 + 1, y, z2 - 1, theFluid);
            float flow21 = this.getFluidHeightForRender(world, x2 + 1, y, z2, theFluid);
            float flow22 = this.getFluidHeightForRender(world, x2 + 1, y, z2 + 1, theFluid);
            heightNW = this.getFluidHeightAverage(new float[]{flow00, flow01, flow10, flow11});
            heightSW = this.getFluidHeightAverage(new float[]{flow01, flow02, flow12, flow11});
            heightSE = this.getFluidHeightAverage(new float[]{flow12, flow21, flow22, flow11});
            heightNE = this.getFluidHeightAverage(new float[]{flow10, flow20, flow21, flow11});
        } else {
            heightNW = flow11;
            heightSW = flow11;
            heightSE = flow11;
            heightNE = flow11;
        }
        boolean bl = rises = theFluid.densityDir == 1;
        if (renderer.f || renderTop) {
            double v3;
            double u3;
            double v4;
            double u4;
            double v1;
            double u1;
            double v2;
            double u2;
            rendered = true;
            ms iconStill = block.a(1, bMeta);
            float flowDir = (float)BlockFluidBase.getFlowDirection(world, x2, y, z2);
            if (flowDir > -999.0f) {
                iconStill = block.a(2, bMeta);
            }
            heightNW -= (double)0.001f;
            heightSW -= (double)0.001f;
            heightSE -= (double)0.001f;
            heightNE -= (double)0.001f;
            if (flowDir < -999.0f) {
                u2 = iconStill.a(0.0);
                v2 = iconStill.b(0.0);
                u1 = u2;
                v1 = iconStill.b(16.0);
                u4 = iconStill.a(16.0);
                v4 = v1;
                u3 = u4;
                v3 = v2;
            } else {
                float xFlow = ls.a((float)flowDir) * 0.25f;
                float zFlow = ls.b((float)flowDir) * 0.25f;
                u2 = iconStill.a((double)(8.0f + (-zFlow - xFlow) * 16.0f));
                v2 = iconStill.b((double)(8.0f + (-zFlow + xFlow) * 16.0f));
                u1 = iconStill.a((double)(8.0f + (-zFlow + xFlow) * 16.0f));
                v1 = iconStill.b((double)(8.0f + (zFlow + xFlow) * 16.0f));
                u4 = iconStill.a((double)(8.0f + (zFlow + xFlow) * 16.0f));
                v4 = iconStill.b((double)(8.0f + (zFlow - xFlow) * 16.0f));
                u3 = iconStill.a((double)(8.0f + (zFlow - xFlow) * 16.0f));
                v3 = iconStill.b((double)(8.0f + (-zFlow - xFlow) * 16.0f));
            }
            tessellator.c(block.e(world, x2, y, z2));
            tessellator.a(1.0f * red, 1.0f * green, 1.0f * blue);
            if (!rises) {
                tessellator.a((double)(x2 + 0), (double)y + heightNW, (double)(z2 + 0), u2, v2);
                tessellator.a((double)(x2 + 0), (double)y + heightSW, (double)(z2 + 1), u1, v1);
                tessellator.a((double)(x2 + 1), (double)y + heightSE, (double)(z2 + 1), u4, v4);
                tessellator.a((double)(x2 + 1), (double)y + heightNE, (double)(z2 + 0), u3, v3);
            } else {
                tessellator.a((double)(x2 + 1), (double)(y + 1) - heightNE, (double)(z2 + 0), u3, v3);
                tessellator.a((double)(x2 + 1), (double)(y + 1) - heightSE, (double)(z2 + 1), u4, v4);
                tessellator.a((double)(x2 + 0), (double)(y + 1) - heightSW, (double)(z2 + 1), u1, v1);
                tessellator.a((double)(x2 + 0), (double)(y + 1) - heightNW, (double)(z2 + 0), u2, v2);
            }
        }
        if (renderer.f || renderBottom) {
            rendered = true;
            tessellator.c(block.e(world, x2, y - 1, z2));
            if (!rises) {
                tessellator.a(0.5f * red, 0.5f * green, 0.5f * blue);
                renderer.a(block, (double)x2, (double)y + (double)0.001f, (double)z2, block.a(0, bMeta));
            } else {
                tessellator.a(1.0f * red, 1.0f * green, 1.0f * blue);
                renderer.b(block, (double)x2, (double)y + (double)0.001f, (double)z2, block.a(1, bMeta));
            }
        }
        for (int side = 0; side < 4; ++side) {
            double tz2;
            double tz1;
            double tx2;
            double tx1;
            double ty2;
            double ty1;
            int x22 = x2;
            int z22 = z2;
            switch (side) {
                case 0: {
                    --z22;
                    break;
                }
                case 1: {
                    ++z22;
                    break;
                }
                case 2: {
                    --x22;
                    break;
                }
                case 3: {
                    ++x22;
                }
            }
            ms iconFlow = block.a(side + 2, bMeta);
            if (!renderer.f && !renderSides[side]) continue;
            rendered = true;
            if (side == 0) {
                ty1 = heightNW;
                ty2 = heightNE;
                tx1 = x2;
                tx2 = x2 + 1;
                tz1 = (double)z2 + (double)0.001f;
                tz2 = (double)z2 + (double)0.001f;
            } else if (side == 1) {
                ty1 = heightSE;
                ty2 = heightSW;
                tx1 = x2 + 1;
                tx2 = x2;
                tz1 = (double)(z2 + 1) - (double)0.001f;
                tz2 = (double)(z2 + 1) - (double)0.001f;
            } else if (side == 2) {
                ty1 = heightSW;
                ty2 = heightNW;
                tx1 = (double)x2 + (double)0.001f;
                tx2 = (double)x2 + (double)0.001f;
                tz1 = z2 + 1;
                tz2 = z2;
            } else {
                ty1 = heightNE;
                ty2 = heightSE;
                tx1 = (double)(x2 + 1) - (double)0.001f;
                tx2 = (double)(x2 + 1) - (double)0.001f;
                tz1 = z2;
                tz2 = z2 + 1;
            }
            float u1Flow = iconFlow.a(0.0);
            float u2Flow = iconFlow.a(8.0);
            float v1Flow = iconFlow.b((1.0 - ty1) * 16.0 * 0.5);
            float v2Flow = iconFlow.b((1.0 - ty2) * 16.0 * 0.5);
            float v3Flow = iconFlow.b(8.0);
            tessellator.c(block.e(world, x22, y, z22));
            float sideLighting = 1.0f;
            sideLighting = side < 2 ? 0.8f : 0.6f;
            tessellator.a(1.0f * sideLighting * red, 1.0f * sideLighting * green, 1.0f * sideLighting * blue);
            if (!rises) {
                tessellator.a(tx1, (double)y + ty1, tz1, (double)u1Flow, (double)v1Flow);
                tessellator.a(tx2, (double)y + ty2, tz2, (double)u2Flow, (double)v2Flow);
                tessellator.a(tx2, (double)(y + 0), tz2, (double)u2Flow, (double)v3Flow);
                tessellator.a(tx1, (double)(y + 0), tz1, (double)u1Flow, (double)v3Flow);
                continue;
            }
            tessellator.a(tx1, (double)(y + 1 - 0), tz1, (double)u1Flow, (double)v3Flow);
            tessellator.a(tx2, (double)(y + 1 - 0), tz2, (double)u2Flow, (double)v3Flow);
            tessellator.a(tx2, (double)(y + 1) - ty2, tz2, (double)u2Flow, (double)v2Flow);
            tessellator.a(tx1, (double)(y + 1) - ty1, tz1, (double)u1Flow, (double)v1Flow);
        }
        renderer.i = 0.0;
        renderer.j = 1.0;
        return rendered;
    }

    @Override
    public boolean shouldRender3DInInventory() {
        return false;
    }

    @Override
    public int getRenderId() {
        return FluidRegistry.renderIdFluid;
    }
}

