/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.chat;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.chat.ChatStore;
import com.earth2me.essentials.chat.EssentialsChatPlayerListenerHighest;
import com.earth2me.essentials.chat.EssentialsChatPlayerListenerLowest;
import com.earth2me.essentials.chat.EssentialsChatPlayerListenerNormal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.ess3.api.IEssentials;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class EssentialsChat
extends JavaPlugin {
    private static final Logger LOGGER = Logger.getLogger("Minecraft");

    public void onEnable() {
        PluginManager pluginManager = this.getServer().getPluginManager();
        IEssentials ess = (IEssentials)pluginManager.getPlugin("Essentials");
        if (!this.getDescription().getVersion().equals(ess.getDescription().getVersion())) {
            LOGGER.log(Level.WARNING, I18n._((String)"versionMismatchAll", (Object[])new Object[0]));
        }
        if (!ess.isEnabled()) {
            this.setEnabled(false);
            return;
        }
        Map<AsyncPlayerChatEvent, ChatStore> chatStore = Collections.synchronizedMap(new HashMap());
        EssentialsChatPlayerListenerLowest playerListenerLowest = new EssentialsChatPlayerListenerLowest(this.getServer(), ess, chatStore);
        EssentialsChatPlayerListenerNormal playerListenerNormal = new EssentialsChatPlayerListenerNormal(this.getServer(), ess, chatStore);
        EssentialsChatPlayerListenerHighest playerListenerHighest = new EssentialsChatPlayerListenerHighest(this.getServer(), ess, chatStore);
        pluginManager.registerEvents((Listener)playerListenerLowest, (Plugin)this);
        pluginManager.registerEvents((Listener)playerListenerNormal, (Plugin)this);
        pluginManager.registerEvents((Listener)playerListenerHighest, (Plugin)this);
    }
}

