/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit;

import com.sk89q.worldedit.ArbitraryShape;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.BlockVector2D;
import com.sk89q.worldedit.Countable;
import com.sk89q.worldedit.DoubleArrayList;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.PlayerDirection;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.bags.BlockBag;
import com.sk89q.worldedit.bags.BlockBagException;
import com.sk89q.worldedit.bags.UnplaceableBlockException;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.BlockType;
import com.sk89q.worldedit.expression.Expression;
import com.sk89q.worldedit.expression.ExpressionException;
import com.sk89q.worldedit.expression.runtime.RValue;
import com.sk89q.worldedit.masks.Mask;
import com.sk89q.worldedit.patterns.Pattern;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.TreeGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;

public class EditSession {
    private static Random prng = new Random();
    protected LocalWorld world;
    private DoubleArrayList<BlockVector, BaseBlock> original = new DoubleArrayList(true);
    private DoubleArrayList<BlockVector, BaseBlock> current = new DoubleArrayList(false);
    private DoubleArrayList<BlockVector, BaseBlock> queueAfter = new DoubleArrayList(false);
    private DoubleArrayList<BlockVector, BaseBlock> queueLast = new DoubleArrayList(false);
    private DoubleArrayList<BlockVector, BaseBlock> queueFinal = new DoubleArrayList(false);
    private int maxBlocks = -1;
    private boolean queued = false;
    private boolean fastMode = false;
    private BlockBag blockBag;
    private Map<Integer, Integer> missingBlocks = new HashMap<Integer, Integer>();
    private Mask mask;
    Vector[] recurseDirections = new Vector[]{PlayerDirection.NORTH.vector(), PlayerDirection.EAST.vector(), PlayerDirection.SOUTH.vector(), PlayerDirection.WEST.vector(), PlayerDirection.UP.vector(), PlayerDirection.DOWN.vector()};

    public EditSession(LocalWorld world, int maxBlocks) {
        if (maxBlocks < -1) {
            throw new IllegalArgumentException("Max blocks must be >= -1");
        }
        this.maxBlocks = maxBlocks;
        this.world = world;
    }

    public EditSession(LocalWorld world, int maxBlocks, BlockBag blockBag) {
        if (maxBlocks < -1) {
            throw new IllegalArgumentException("Max blocks must be >= -1");
        }
        this.maxBlocks = maxBlocks;
        this.blockBag = blockBag;
        this.world = world;
    }

    public boolean rawSetBlock(Vector pt, BaseBlock block) {
        int y = pt.getBlockY();
        int type = block.getType();
        if (y < 0 || y > this.world.getMaxY()) {
            return false;
        }
        this.world.checkLoadedChunk(pt);
        if (!this.world.isValidBlockType(type)) {
            return false;
        }
        if (this.mask != null && !this.mask.matches(this, pt)) {
            return false;
        }
        int existing = this.world.getBlockType(pt);
        if (BlockType.isContainerBlock(existing)) {
            this.world.clearContainerBlockContents(pt);
        } else if (existing == 79) {
            this.world.setBlockType(pt, 0);
        }
        if (this.blockBag != null) {
            if (type > 0) {
                try {
                    this.blockBag.fetchPlacedBlock(type, 0);
                }
                catch (UnplaceableBlockException e) {
                    return false;
                }
                catch (BlockBagException e) {
                    if (!this.missingBlocks.containsKey(type)) {
                        this.missingBlocks.put(type, 1);
                    } else {
                        this.missingBlocks.put(type, this.missingBlocks.get(type) + 1);
                    }
                    return false;
                }
            }
            if (existing > 0) {
                try {
                    this.blockBag.storeDroppedBlock(existing, this.world.getBlockData(pt));
                }
                catch (BlockBagException e) {
                    // empty catch block
                }
            }
        }
        boolean result = type == 0 ? (this.fastMode ? this.world.setBlockTypeFast(pt, 0) : this.world.setBlockType(pt, 0)) : this.world.setBlock(pt, block, !this.fastMode);
        return result;
    }

    public boolean setBlock(Vector pt, BaseBlock block) throws MaxChangedBlocksException {
        BlockVector blockPt = pt.toBlockVector();
        this.original.put(blockPt, this.getBlock(pt));
        if (this.maxBlocks != -1 && this.original.size() > this.maxBlocks) {
            throw new MaxChangedBlocksException(this.maxBlocks);
        }
        this.current.put(pt.toBlockVector(), block);
        return this.smartSetBlock(pt, block);
    }

    public void rememberChange(Vector pt, BaseBlock existing, BaseBlock block) {
        BlockVector blockPt = pt.toBlockVector();
        this.original.put(blockPt, existing);
        this.current.put(pt.toBlockVector(), block);
    }

    public boolean setBlock(Vector pt, Pattern pat) throws MaxChangedBlocksException {
        return this.setBlock(pt, pat.next(pt));
    }

    public boolean setBlockIfAir(Vector pt, BaseBlock block) throws MaxChangedBlocksException {
        if (!this.getBlock(pt).isAir()) {
            return false;
        }
        return this.setBlock(pt, block);
    }

    public boolean smartSetBlock(Vector pt, BaseBlock block) {
        if (this.queued) {
            if (BlockType.shouldPlaceLast(block.getType())) {
                this.queueLast.put(pt.toBlockVector(), block);
                return this.getBlockType(pt) != block.getType() || this.getBlockData(pt) != block.getData();
            }
            if (BlockType.shouldPlaceFinal(block.getType())) {
                this.queueFinal.put(pt.toBlockVector(), block);
                return this.getBlockType(pt) != block.getType() || this.getBlockData(pt) != block.getData();
            }
            if (BlockType.shouldPlaceLast(this.getBlockType(pt))) {
                this.rawSetBlock(pt, new BaseBlock(0));
            } else {
                this.queueAfter.put(pt.toBlockVector(), block);
                return this.getBlockType(pt) != block.getType() || this.getBlockData(pt) != block.getData();
            }
        }
        return this.rawSetBlock(pt, block);
    }

    public BaseBlock getBlock(Vector pt) {
        if (this.queued) {
            // empty if block
        }
        return this.rawGetBlock(pt);
    }

    public int getBlockType(Vector pt) {
        if (this.queued) {
            // empty if block
        }
        return this.world.getBlockType(pt);
    }

    public int getBlockData(Vector pt) {
        if (this.queued) {
            // empty if block
        }
        return this.world.getBlockData(pt);
    }

    public BaseBlock rawGetBlock(Vector pt) {
        return this.world.getBlock(pt);
    }

    public void undo(EditSession sess) {
        for (Map.Entry<BlockVector, BaseBlock> entry : this.original) {
            BlockVector pt = entry.getKey();
            sess.smartSetBlock(pt, entry.getValue());
        }
        sess.flushQueue();
    }

    public void redo(EditSession sess) {
        for (Map.Entry<BlockVector, BaseBlock> entry : this.current) {
            BlockVector pt = entry.getKey();
            sess.smartSetBlock(pt, entry.getValue());
        }
        sess.flushQueue();
    }

    public int size() {
        return this.original.size();
    }

    public int getBlockChangeLimit() {
        return this.maxBlocks;
    }

    public void setBlockChangeLimit(int maxBlocks) {
        if (maxBlocks < -1) {
            throw new IllegalArgumentException("Max blocks must be >= -1");
        }
        this.maxBlocks = maxBlocks;
    }

    public boolean isQueueEnabled() {
        return this.queued;
    }

    public void enableQueue() {
        this.queued = true;
    }

    public void disableQueue() {
        if (this.queued) {
            this.flushQueue();
        }
        this.queued = false;
    }

    public void setFastMode(boolean fastMode) {
        this.fastMode = fastMode;
    }

    public boolean hasFastMode() {
        return this.fastMode;
    }

    public boolean setChanceBlockIfAir(Vector pos, BaseBlock block, double c) throws MaxChangedBlocksException {
        if (Math.random() <= c) {
            return this.setBlockIfAir(pos, block);
        }
        return false;
    }

    public int countBlock(Region region, Set<Integer> searchIDs) {
        HashSet<BaseBlock> passOn = new HashSet<BaseBlock>();
        for (Integer i : searchIDs) {
            passOn.add(new BaseBlock(i, -1));
        }
        return this.countBlocks(region, passOn);
    }

    public int countBlocks(Region region, Set<BaseBlock> searchBlocks) {
        int count = 0;
        HashSet<BaseBlock> newSet = new HashSet<BaseBlock>(){

            @Override
            public boolean contains(Object o) {
                for (BaseBlock b : this.toArray(new BaseBlock[this.size()])) {
                    if (!(o instanceof BaseBlock) || !b.equalsFuzzy((BaseBlock)o)) continue;
                    return true;
                }
                return false;
            }
        };
        newSet.addAll(searchBlocks);
        if (region instanceof CuboidRegion) {
            Vector min = region.getMinimumPoint();
            Vector max = region.getMaximumPoint();
            int minX = min.getBlockX();
            int minY = min.getBlockY();
            int minZ = min.getBlockZ();
            int maxX = max.getBlockX();
            int maxY = max.getBlockY();
            int maxZ = max.getBlockZ();
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        Vector pt = new Vector(x, y, z);
                        BaseBlock compare = new BaseBlock(this.getBlockType(pt), this.getBlockData(pt));
                        if (!newSet.contains(compare)) continue;
                        ++count;
                    }
                }
            }
        } else {
            for (Vector pt : region) {
                BaseBlock compare = new BaseBlock(this.getBlockType(pt), this.getBlockData(pt));
                if (!newSet.contains(compare)) continue;
                ++count;
            }
        }
        return count;
    }

    public int getHighestTerrainBlock(int x, int z, int minY, int maxY) {
        return this.getHighestTerrainBlock(x, z, minY, maxY, false);
    }

    public int getHighestTerrainBlock(int x, int z, int minY, int maxY, boolean naturalOnly) {
        for (int y = maxY; y >= minY; --y) {
            Vector pt = new Vector(x, y, z);
            int id = this.getBlockType(pt);
            if (!(naturalOnly ? BlockType.isNaturalTerrainBlock(id) : !BlockType.canPassThrough(id))) continue;
            return y;
        }
        return minY;
    }

    public Map<Integer, Integer> popMissingBlocks() {
        Map<Integer, Integer> missingBlocks = this.missingBlocks;
        this.missingBlocks = new HashMap<Integer, Integer>();
        return missingBlocks;
    }

    public BlockBag getBlockBag() {
        return this.blockBag;
    }

    public void setBlockBag(BlockBag blockBag) {
        this.blockBag = blockBag;
    }

    public LocalWorld getWorld() {
        return this.world;
    }

    public int getBlockChangeCount() {
        return this.original.size();
    }

    public Mask getMask() {
        return this.mask;
    }

    public void setMask(Mask mask) {
        this.mask = mask;
    }

    public void flushQueue() {
        BlockVector pt;
        if (!this.queued) {
            return;
        }
        HashSet<BlockVector2D> dirtyChunks = new HashSet<BlockVector2D>();
        for (Map.Entry<BlockVector, BaseBlock> entry : this.queueAfter) {
            pt = entry.getKey();
            this.rawSetBlock(pt, entry.getValue());
            if (!this.fastMode) continue;
            dirtyChunks.add(new BlockVector2D(pt.getBlockX() >> 4, pt.getBlockZ() >> 4));
        }
        if (this.blockBag == null || this.missingBlocks.size() == 0) {
            for (Map.Entry<BlockVector, BaseBlock> entry : this.queueLast) {
                pt = entry.getKey();
                this.rawSetBlock(pt, entry.getValue());
                if (!this.fastMode) continue;
                dirtyChunks.add(new BlockVector2D(pt.getBlockX() >> 4, pt.getBlockZ() >> 4));
            }
            HashSet<BlockVector> blocks = new HashSet<BlockVector>();
            HashMap<BlockVector, BaseBlock> hashMap = new HashMap<BlockVector, BaseBlock>();
            for (Map.Entry<BlockVector, BaseBlock> entry : this.queueFinal) {
                BlockVector pt2 = entry.getKey();
                blocks.add(pt2);
                hashMap.put(pt2, entry.getValue());
            }
            while (!blocks.isEmpty()) {
                int data;
                int type;
                PlayerDirection attachment;
                BlockVector current = (BlockVector)blocks.iterator().next();
                if (!blocks.contains(current)) continue;
                LinkedList<BlockVector> linkedList = new LinkedList<BlockVector>();
                block7: do {
                    linkedList.addFirst(current);
                    assert (hashMap.containsKey(current));
                    BaseBlock baseBlock = (BaseBlock)hashMap.get(current);
                    type = baseBlock.getType();
                    data = baseBlock.getData();
                    switch (type) {
                        case 64: 
                        case 71: {
                            BlockVector upperBlock;
                            if ((data & 8) != 0 || !blocks.contains(upperBlock = current.add(0, 1, 0).toBlockVector()) || linkedList.contains(upperBlock)) continue block7;
                            linkedList.addFirst(upperBlock);
                        }
                    }
                } while ((attachment = BlockType.getAttachment(type, data)) != null && blocks.contains(current = current.add(attachment.vector()).toBlockVector()) && !linkedList.contains(current));
                for (BlockVector pt3 : linkedList) {
                    this.rawSetBlock(pt3, (BaseBlock)hashMap.get(pt3));
                    blocks.remove(pt3);
                    if (!this.fastMode) continue;
                    dirtyChunks.add(new BlockVector2D(pt3.getBlockX() >> 4, pt3.getBlockZ() >> 4));
                }
            }
        }
        if (!dirtyChunks.isEmpty()) {
            this.world.fixAfterFastMode(dirtyChunks);
        }
        this.queueAfter.clear();
        this.queueLast.clear();
        this.queueFinal.clear();
    }

    public int fillXZ(Vector origin, BaseBlock block, double radius, int depth, boolean recursive) throws MaxChangedBlocksException {
        int affected = 0;
        int originX = origin.getBlockX();
        int originY = origin.getBlockY();
        int originZ = origin.getBlockZ();
        HashSet<BlockVector> visited = new HashSet<BlockVector>();
        Stack<BlockVector> queue = new Stack<BlockVector>();
        queue.push(new BlockVector(originX, originY, originZ));
        while (!queue.empty()) {
            BlockVector pt = (BlockVector)queue.pop();
            int cx = pt.getBlockX();
            int cy = pt.getBlockY();
            int cz = pt.getBlockZ();
            if (cy < 0 || cy > originY || visited.contains(pt)) continue;
            visited.add(pt);
            if (recursive) {
                if (origin.distance(pt) > radius || !this.getBlock(pt).isAir()) continue;
                if (this.setBlock((Vector)pt, block)) {
                    ++affected;
                }
                queue.push(new BlockVector(cx, cy - 1, cz));
                queue.push(new BlockVector(cx, cy + 1, cz));
            } else {
                double dist = Math.sqrt(Math.pow(originX - cx, 2.0) + Math.pow(originZ - cz, 2.0));
                int minY = originY - depth + 1;
                if (dist > radius || !this.getBlock(pt).isAir()) continue;
                affected += this.fillY(cx, originY, cz, block, minY);
            }
            queue.push(new BlockVector(cx + 1, cy, cz));
            queue.push(new BlockVector(cx - 1, cy, cz));
            queue.push(new BlockVector(cx, cy, cz + 1));
            queue.push(new BlockVector(cx, cy, cz - 1));
        }
        return affected;
    }

    private int fillY(int x, int cy, int z, BaseBlock block, int minY) throws MaxChangedBlocksException {
        Vector pt;
        int affected = 0;
        for (int y = cy; y >= minY && this.getBlock(pt = new Vector(x, y, z)).isAir(); --y) {
            this.setBlock(pt, block);
            ++affected;
        }
        return affected;
    }

    public int fillXZ(Vector origin, Pattern pattern, double radius, int depth, boolean recursive) throws MaxChangedBlocksException {
        int affected = 0;
        int originX = origin.getBlockX();
        int originY = origin.getBlockY();
        int originZ = origin.getBlockZ();
        HashSet<BlockVector> visited = new HashSet<BlockVector>();
        Stack<BlockVector> queue = new Stack<BlockVector>();
        queue.push(new BlockVector(originX, originY, originZ));
        while (!queue.empty()) {
            BlockVector pt = (BlockVector)queue.pop();
            int cx = pt.getBlockX();
            int cy = pt.getBlockY();
            int cz = pt.getBlockZ();
            if (cy < 0 || cy > originY || visited.contains(pt)) continue;
            visited.add(pt);
            if (recursive) {
                if (origin.distance(pt) > radius || !this.getBlock(pt).isAir()) continue;
                if (this.setBlock((Vector)pt, pattern.next(pt))) {
                    ++affected;
                }
                queue.push(new BlockVector(cx, cy - 1, cz));
                queue.push(new BlockVector(cx, cy + 1, cz));
            } else {
                double dist = Math.sqrt(Math.pow(originX - cx, 2.0) + Math.pow(originZ - cz, 2.0));
                int minY = originY - depth + 1;
                if (dist > radius || !this.getBlock(pt).isAir()) continue;
                affected += this.fillY(cx, originY, cz, pattern, minY);
            }
            queue.push(new BlockVector(cx + 1, cy, cz));
            queue.push(new BlockVector(cx - 1, cy, cz));
            queue.push(new BlockVector(cx, cy, cz + 1));
            queue.push(new BlockVector(cx, cy, cz - 1));
        }
        return affected;
    }

    private int fillY(int x, int cy, int z, Pattern pattern, int minY) throws MaxChangedBlocksException {
        Vector pt;
        int affected = 0;
        for (int y = cy; y >= minY && this.getBlock(pt = new Vector(x, y, z)).isAir(); --y) {
            this.setBlock(pt, pattern.next(pt));
            ++affected;
        }
        return affected;
    }

    public int removeAbove(Vector pos, int size, int height) throws MaxChangedBlocksException {
        int maxY = Math.min(this.world.getMaxY(), pos.getBlockY() + height - 1);
        int affected = 0;
        int oX = pos.getBlockX();
        int oY = pos.getBlockY();
        int oZ = pos.getBlockZ();
        for (int x = oX - --size; x <= oX + size; ++x) {
            for (int z = oZ - size; z <= oZ + size; ++z) {
                for (int y = oY; y <= maxY; ++y) {
                    Vector pt = new Vector(x, y, z);
                    if (this.getBlockType(pt) == 0) continue;
                    this.setBlock(pt, new BaseBlock(0));
                    ++affected;
                }
            }
        }
        return affected;
    }

    public int removeBelow(Vector pos, int size, int height) throws MaxChangedBlocksException {
        int minY = Math.max(0, pos.getBlockY() - height);
        int affected = 0;
        int oX = pos.getBlockX();
        int oY = pos.getBlockY();
        int oZ = pos.getBlockZ();
        for (int x = oX - --size; x <= oX + size; ++x) {
            for (int z = oZ - size; z <= oZ + size; ++z) {
                for (int y = oY; y >= minY; --y) {
                    Vector pt = new Vector(x, y, z);
                    if (this.getBlockType(pt) == 0) continue;
                    this.setBlock(pt, new BaseBlock(0));
                    ++affected;
                }
            }
        }
        return affected;
    }

    public int removeNear(Vector pos, int blockType, int size) throws MaxChangedBlocksException {
        int affected = 0;
        BaseBlock air = new BaseBlock(0);
        int minX = pos.getBlockX() - size;
        int maxX = pos.getBlockX() + size;
        int minY = Math.max(0, pos.getBlockY() - size);
        int maxY = Math.min(this.world.getMaxY(), pos.getBlockY() + size);
        int minZ = pos.getBlockZ() - size;
        int maxZ = pos.getBlockZ() + size;
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    Vector p = new Vector(x, y, z);
                    if (this.getBlockType(p) != blockType || !this.setBlock(p, air)) continue;
                    ++affected;
                }
            }
        }
        return affected;
    }

    public int setBlocks(Region region, BaseBlock block) throws MaxChangedBlocksException {
        int affected = 0;
        if (region instanceof CuboidRegion) {
            Vector min = region.getMinimumPoint();
            Vector max = region.getMaximumPoint();
            int minX = min.getBlockX();
            int minY = min.getBlockY();
            int minZ = min.getBlockZ();
            int maxX = max.getBlockX();
            int maxY = max.getBlockY();
            int maxZ = max.getBlockZ();
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        Vector pt = new Vector(x, y, z);
                        if (!this.setBlock(pt, block)) continue;
                        ++affected;
                    }
                }
            }
        } else {
            for (Vector pt : region) {
                if (!this.setBlock(pt, block)) continue;
                ++affected;
            }
        }
        return affected;
    }

    public int setBlocks(Region region, Pattern pattern) throws MaxChangedBlocksException {
        int affected = 0;
        if (region instanceof CuboidRegion) {
            Vector min = region.getMinimumPoint();
            Vector max = region.getMaximumPoint();
            int minX = min.getBlockX();
            int minY = min.getBlockY();
            int minZ = min.getBlockZ();
            int maxX = max.getBlockX();
            int maxY = max.getBlockY();
            int maxZ = max.getBlockZ();
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        Vector pt = new Vector(x, y, z);
                        if (!this.setBlock(pt, pattern.next(pt))) continue;
                        ++affected;
                    }
                }
            }
        } else {
            for (Vector pt : region) {
                if (!this.setBlock(pt, pattern.next(pt))) continue;
                ++affected;
            }
        }
        return affected;
    }

    public int replaceBlocks(Region region, Set<BaseBlock> fromBlockTypes, BaseBlock toBlock) throws MaxChangedBlocksException {
        HashSet<BaseBlock> definiteBlockTypes = new HashSet<BaseBlock>();
        HashSet<Integer> fuzzyBlockTypes = new HashSet<Integer>();
        if (fromBlockTypes != null) {
            for (BaseBlock block : fromBlockTypes) {
                if (block.getData() == -1) {
                    fuzzyBlockTypes.add(block.getType());
                    continue;
                }
                definiteBlockTypes.add(block);
            }
        }
        int affected = 0;
        if (region instanceof CuboidRegion) {
            Vector min = region.getMinimumPoint();
            Vector max = region.getMaximumPoint();
            int minX = min.getBlockX();
            int minY = min.getBlockY();
            int minZ = min.getBlockZ();
            int maxX = max.getBlockX();
            int maxY = max.getBlockY();
            int maxZ = max.getBlockZ();
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        Vector pt = new Vector(x, y, z);
                        BaseBlock curBlockType = this.getBlock(pt);
                        if (fromBlockTypes != null ? !definiteBlockTypes.contains(curBlockType) && !fuzzyBlockTypes.contains(curBlockType.getType()) : curBlockType.isAir()) continue;
                        if (!this.setBlock(pt, toBlock)) continue;
                        ++affected;
                    }
                }
            }
        } else {
            for (Vector pt : region) {
                BaseBlock curBlockType = this.getBlock(pt);
                if (fromBlockTypes != null ? !definiteBlockTypes.contains(curBlockType) && !fuzzyBlockTypes.contains(curBlockType.getType()) : curBlockType.isAir()) continue;
                if (!this.setBlock(pt, toBlock)) continue;
                ++affected;
            }
        }
        return affected;
    }

    public int replaceBlocks(Region region, Set<BaseBlock> fromBlockTypes, Pattern pattern) throws MaxChangedBlocksException {
        HashSet<BaseBlock> definiteBlockTypes = new HashSet<BaseBlock>();
        HashSet<Integer> fuzzyBlockTypes = new HashSet<Integer>();
        if (fromBlockTypes != null) {
            for (BaseBlock block : fromBlockTypes) {
                if (block.getData() == -1) {
                    fuzzyBlockTypes.add(block.getType());
                    continue;
                }
                definiteBlockTypes.add(block);
            }
        }
        int affected = 0;
        if (region instanceof CuboidRegion) {
            Vector min = region.getMinimumPoint();
            Vector max = region.getMaximumPoint();
            int minX = min.getBlockX();
            int minY = min.getBlockY();
            int minZ = min.getBlockZ();
            int maxX = max.getBlockX();
            int maxY = max.getBlockY();
            int maxZ = max.getBlockZ();
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        Vector pt = new Vector(x, y, z);
                        BaseBlock curBlockType = this.getBlock(pt);
                        if (fromBlockTypes != null ? !definiteBlockTypes.contains(curBlockType) && !fuzzyBlockTypes.contains(curBlockType.getType()) : curBlockType.isAir()) continue;
                        if (!this.setBlock(pt, pattern.next(pt))) continue;
                        ++affected;
                    }
                }
            }
        } else {
            for (Vector pt : region) {
                BaseBlock curBlockType = this.getBlock(pt);
                if (fromBlockTypes != null ? !definiteBlockTypes.contains(curBlockType) && !fuzzyBlockTypes.contains(curBlockType.getType()) : curBlockType.isAir()) continue;
                if (!this.setBlock(pt, pattern.next(pt))) continue;
                ++affected;
            }
        }
        return affected;
    }

    public int center(Region region, Pattern pattern) throws MaxChangedBlocksException {
        Vector center = region.getCenter();
        int x2 = center.getBlockX();
        int y2 = center.getBlockY();
        int z2 = center.getBlockZ();
        int affected = 0;
        for (int x = (int)center.getX(); x <= x2; ++x) {
            for (int y = (int)center.getY(); y <= y2; ++y) {
                for (int z = (int)center.getZ(); z <= z2; ++z) {
                    if (!this.setBlock(new Vector(x, y, z), pattern)) continue;
                    ++affected;
                }
            }
        }
        return affected;
    }

    public int makeCuboidFaces(Region region, BaseBlock block) throws MaxChangedBlocksException {
        int affected = 0;
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        int minX = min.getBlockX();
        int minY = min.getBlockY();
        int minZ = min.getBlockZ();
        int maxX = max.getBlockX();
        int maxY = max.getBlockY();
        int maxZ = max.getBlockZ();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                if (this.setBlock(new Vector(x, y, minZ), block)) {
                    ++affected;
                }
                if (this.setBlock(new Vector(x, y, maxZ), block)) {
                    ++affected;
                }
                ++affected;
            }
        }
        for (int y = minY; y <= maxY; ++y) {
            for (int z = minZ; z <= maxZ; ++z) {
                if (this.setBlock(new Vector(minX, y, z), block)) {
                    ++affected;
                }
                if (!this.setBlock(new Vector(maxX, y, z), block)) continue;
                ++affected;
            }
        }
        for (int z = minZ; z <= maxZ; ++z) {
            for (int x = minX; x <= maxX; ++x) {
                if (this.setBlock(new Vector(x, minY, z), block)) {
                    ++affected;
                }
                if (!this.setBlock(new Vector(x, maxY, z), block)) continue;
                ++affected;
            }
        }
        return affected;
    }

    public int makeCuboidFaces(Region region, Pattern pattern) throws MaxChangedBlocksException {
        Vector maxV;
        Vector minV;
        int affected = 0;
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        int minX = min.getBlockX();
        int minY = min.getBlockY();
        int minZ = min.getBlockZ();
        int maxX = max.getBlockX();
        int maxY = max.getBlockY();
        int maxZ = max.getBlockZ();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                minV = new Vector(x, y, minZ);
                if (this.setBlock(minV, pattern.next(minV))) {
                    ++affected;
                }
                if (this.setBlock(maxV = new Vector(x, y, maxZ), pattern.next(maxV))) {
                    ++affected;
                }
                ++affected;
            }
        }
        for (int y = minY; y <= maxY; ++y) {
            for (int z = minZ; z <= maxZ; ++z) {
                minV = new Vector(minX, y, z);
                if (this.setBlock(minV, pattern.next(minV))) {
                    ++affected;
                }
                if (!this.setBlock(maxV = new Vector(maxX, y, z), pattern.next(maxV))) continue;
                ++affected;
            }
        }
        for (int z = minZ; z <= maxZ; ++z) {
            for (int x = minX; x <= maxX; ++x) {
                minV = new Vector(x, minY, z);
                if (this.setBlock(minV, pattern.next(minV))) {
                    ++affected;
                }
                if (!this.setBlock(maxV = new Vector(x, maxY, z), pattern.next(maxV))) continue;
                ++affected;
            }
        }
        return affected;
    }

    public int makeCuboidWalls(Region region, BaseBlock block) throws MaxChangedBlocksException {
        int affected = 0;
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        int minX = min.getBlockX();
        int minY = min.getBlockY();
        int minZ = min.getBlockZ();
        int maxX = max.getBlockX();
        int maxY = max.getBlockY();
        int maxZ = max.getBlockZ();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                if (this.setBlock(new Vector(x, y, minZ), block)) {
                    ++affected;
                }
                if (this.setBlock(new Vector(x, y, maxZ), block)) {
                    ++affected;
                }
                ++affected;
            }
        }
        for (int y = minY; y <= maxY; ++y) {
            for (int z = minZ; z <= maxZ; ++z) {
                if (this.setBlock(new Vector(minX, y, z), block)) {
                    ++affected;
                }
                if (!this.setBlock(new Vector(maxX, y, z), block)) continue;
                ++affected;
            }
        }
        return affected;
    }

    public int makeCuboidWalls(Region region, Pattern pattern) throws MaxChangedBlocksException {
        Vector maxV;
        Vector minV;
        int affected = 0;
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        int minX = min.getBlockX();
        int minY = min.getBlockY();
        int minZ = min.getBlockZ();
        int maxX = max.getBlockX();
        int maxY = max.getBlockY();
        int maxZ = max.getBlockZ();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                minV = new Vector(x, y, minZ);
                if (this.setBlock(minV, pattern.next(minV))) {
                    ++affected;
                }
                if (this.setBlock(maxV = new Vector(x, y, maxZ), pattern.next(maxV))) {
                    ++affected;
                }
                ++affected;
            }
        }
        for (int y = minY; y <= maxY; ++y) {
            for (int z = minZ; z <= maxZ; ++z) {
                minV = new Vector(minX, y, z);
                if (this.setBlock(minV, pattern.next(minV))) {
                    ++affected;
                }
                if (!this.setBlock(maxV = new Vector(maxX, y, z), pattern.next(maxV))) continue;
                ++affected;
            }
        }
        return affected;
    }

    public int overlayCuboidBlocks(Region region, BaseBlock block) throws MaxChangedBlocksException {
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        int upperY = Math.min(this.world.getMaxY(), max.getBlockY() + 1);
        int lowerY = Math.max(0, min.getBlockY() - 1);
        int affected = 0;
        int minX = min.getBlockX();
        int minZ = min.getBlockZ();
        int maxX = max.getBlockX();
        int maxZ = max.getBlockZ();
        for (int x = minX; x <= maxX; ++x) {
            block1: for (int z = minZ; z <= maxZ; ++z) {
                for (int y = upperY; y >= lowerY; --y) {
                    Vector above = new Vector(x, y + 1, z);
                    if (y + 1 > this.world.getMaxY() || this.getBlock(new Vector(x, y, z)).isAir() || !this.getBlock(above).isAir()) continue;
                    if (!this.setBlock(above, block)) continue block1;
                    ++affected;
                    continue block1;
                }
            }
        }
        return affected;
    }

    public int overlayCuboidBlocks(Region region, Pattern pattern) throws MaxChangedBlocksException {
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        int upperY = Math.min(this.world.getMaxY(), max.getBlockY() + 1);
        int lowerY = Math.max(0, min.getBlockY() - 1);
        int affected = 0;
        int minX = min.getBlockX();
        int minZ = min.getBlockZ();
        int maxX = max.getBlockX();
        int maxZ = max.getBlockZ();
        for (int x = minX; x <= maxX; ++x) {
            block1: for (int z = minZ; z <= maxZ; ++z) {
                for (int y = upperY; y >= lowerY; --y) {
                    Vector above = new Vector(x, y + 1, z);
                    if (y + 1 > this.world.getMaxY() || this.getBlock(new Vector(x, y, z)).isAir() || !this.getBlock(above).isAir()) continue;
                    if (!this.setBlock(above, pattern.next(above))) continue block1;
                    ++affected;
                    continue block1;
                }
            }
        }
        return affected;
    }

    public int naturalizeCuboidBlocks(Region region) throws MaxChangedBlocksException {
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        int upperY = Math.min(this.world.getMaxY(), max.getBlockY() + 1);
        int lowerY = Math.max(0, min.getBlockY() - 1);
        int affected = 0;
        int minX = min.getBlockX();
        int minZ = min.getBlockZ();
        int maxX = max.getBlockX();
        int maxZ = max.getBlockZ();
        BaseBlock grass = new BaseBlock(2);
        BaseBlock dirt = new BaseBlock(3);
        BaseBlock stone = new BaseBlock(1);
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                int level = -1;
                for (int y = upperY; y >= lowerY; --y) {
                    boolean isTransformable;
                    Vector pt = new Vector(x, y, z);
                    int blockType = this.getBlockType(pt);
                    boolean bl = isTransformable = blockType == 2 || blockType == 3 || blockType == 1;
                    if (level == -1) {
                        if (!isTransformable) continue;
                        level = 0;
                    }
                    if (level < 0) continue;
                    if (isTransformable) {
                        if (level == 0) {
                            this.setBlock(pt, grass);
                            ++affected;
                        } else if (level <= 2) {
                            this.setBlock(pt, dirt);
                            ++affected;
                        } else {
                            this.setBlock(pt, stone);
                            ++affected;
                        }
                    }
                    ++level;
                }
            }
        }
        return affected;
    }

    public int stackCuboidRegion(Region region, Vector dir, int count, boolean copyAir) throws MaxChangedBlocksException {
        int affected = 0;
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        int minX = min.getBlockX();
        int minY = min.getBlockY();
        int minZ = min.getBlockZ();
        int maxX = max.getBlockX();
        int maxY = max.getBlockY();
        int maxZ = max.getBlockZ();
        int xs = region.getWidth();
        int ys = region.getHeight();
        int zs = region.getLength();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    BaseBlock block = this.getBlock(new Vector(x, y, z));
                    if (block.isAir() && !copyAir) continue;
                    for (int i = 1; i <= count; ++i) {
                        Vector pos = new Vector(x + xs * dir.getBlockX() * i, y + ys * dir.getBlockY() * i, z + zs * dir.getBlockZ() * i);
                        if (!this.setBlock(pos, block)) continue;
                        ++affected;
                    }
                }
            }
        }
        return affected;
    }

    public int moveCuboidRegion(Region region, Vector dir, int distance, boolean copyAir, BaseBlock replace) throws MaxChangedBlocksException {
        int affected = 0;
        Vector shift = dir.multiply(distance);
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        int minX = min.getBlockX();
        int minY = min.getBlockY();
        int minZ = min.getBlockZ();
        int maxX = max.getBlockX();
        int maxY = max.getBlockY();
        int maxZ = max.getBlockZ();
        Vector newMin = min.add(shift);
        Vector newMax = min.add(shift);
        LinkedHashMap<Vector, BaseBlock> delayed = new LinkedHashMap<Vector, BaseBlock>();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    Vector pos = new Vector(x, y, z);
                    BaseBlock block = this.getBlock(pos);
                    if (block.isAir() && !copyAir) continue;
                    Vector newPos = pos.add(shift);
                    delayed.put(newPos, this.getBlock(pos));
                    if (x >= newMin.getBlockX() && x <= newMax.getBlockX() && y >= newMin.getBlockY() && y <= newMax.getBlockY() && z >= newMin.getBlockZ() && z <= newMax.getBlockZ()) continue;
                    this.setBlock(pos, replace);
                }
            }
        }
        for (Map.Entry entry : delayed.entrySet()) {
            this.setBlock((Vector)entry.getKey(), (BaseBlock)entry.getValue());
            ++affected;
        }
        return affected;
    }

    public int drainArea(Vector pos, double radius) throws MaxChangedBlocksException {
        int affected = 0;
        HashSet<BlockVector> visited = new HashSet<BlockVector>();
        Stack<BlockVector> queue = new Stack<BlockVector>();
        for (int x = pos.getBlockX() - 1; x <= pos.getBlockX() + 1; ++x) {
            for (int z = pos.getBlockZ() - 1; z <= pos.getBlockZ() + 1; ++z) {
                for (int y = pos.getBlockY() - 1; y <= pos.getBlockY() + 1; ++y) {
                    queue.push(new BlockVector(x, y, z));
                }
            }
        }
        while (!queue.empty()) {
            BlockVector cur = (BlockVector)queue.pop();
            int type = this.getBlockType(cur);
            if (type != 8 && type != 9 && type != 10 && type != 11 || visited.contains(cur)) continue;
            visited.add(cur);
            if (pos.distance(cur) > radius) continue;
            for (int x = cur.getBlockX() - 1; x <= cur.getBlockX() + 1; ++x) {
                for (int z = cur.getBlockZ() - 1; z <= cur.getBlockZ() + 1; ++z) {
                    for (int y = cur.getBlockY() - 1; y <= cur.getBlockY() + 1; ++y) {
                        BlockVector newPos = new BlockVector(x, y, z);
                        if (cur.equals(newPos)) continue;
                        queue.push(newPos);
                    }
                }
            }
            if (!this.setBlock((Vector)cur, new BaseBlock(0))) continue;
            ++affected;
        }
        return affected;
    }

    public int fixLiquid(Vector pos, double radius, int moving, int stationary) throws MaxChangedBlocksException {
        int affected = 0;
        HashSet<BlockVector> visited = new HashSet<BlockVector>();
        Stack<BlockVector> queue = new Stack<BlockVector>();
        for (int x = pos.getBlockX() - 1; x <= pos.getBlockX() + 1; ++x) {
            for (int z = pos.getBlockZ() - 1; z <= pos.getBlockZ() + 1; ++z) {
                for (int y = pos.getBlockY() - 1; y <= pos.getBlockY() + 1; ++y) {
                    int type = this.getBlock(new Vector(x, y, z)).getType();
                    if (type != moving && type != stationary) continue;
                    queue.push(new BlockVector(x, y, z));
                }
            }
        }
        BaseBlock stationaryBlock = new BaseBlock(stationary);
        while (!queue.empty()) {
            BlockVector cur = (BlockVector)queue.pop();
            int type = this.getBlockType(cur);
            if (type != moving && type != stationary && type != 0 || visited.contains(cur)) continue;
            visited.add(cur);
            if (this.setBlock((Vector)cur, stationaryBlock)) {
                ++affected;
            }
            if (pos.distance(cur) > radius) continue;
            queue.push(cur.add(1, 0, 0).toBlockVector());
            queue.push(cur.add(-1, 0, 0).toBlockVector());
            queue.push(cur.add(0, 0, 1).toBlockVector());
            queue.push(cur.add(0, 0, -1).toBlockVector());
        }
        return affected;
    }

    public int makeCylinder(Vector pos, Pattern block, double radius, int height, boolean filled) throws MaxChangedBlocksException {
        return this.makeCylinder(pos, block, radius, radius, height, filled);
    }

    public int makeCylinder(Vector pos, Pattern block, double radiusX, double radiusZ, int height, boolean filled) throws MaxChangedBlocksException {
        int affected = 0;
        radiusX += 0.5;
        radiusZ += 0.5;
        if (height == 0) {
            return 0;
        }
        if (height < 0) {
            height = -height;
            pos = pos.subtract(0, height, 0);
        }
        if (pos.getBlockY() < 0) {
            pos = pos.setY(0);
        } else if (pos.getBlockY() + height - 1 > this.world.getMaxY()) {
            height = this.world.getMaxY() - pos.getBlockY() + 1;
        }
        double invRadiusX = 1.0 / radiusX;
        double invRadiusZ = 1.0 / radiusZ;
        int ceilRadiusX = (int)Math.ceil(radiusX);
        int ceilRadiusZ = (int)Math.ceil(radiusZ);
        double nextXn = 0.0;
        block0: for (int x = 0; x <= ceilRadiusX; ++x) {
            double xn = nextXn;
            nextXn = (double)(x + 1) * invRadiusX;
            double nextZn = 0.0;
            for (int z = 0; z <= ceilRadiusZ; ++z) {
                double zn = nextZn;
                nextZn = (double)(z + 1) * invRadiusZ;
                double distanceSq = EditSession.lengthSq(xn, zn);
                if (distanceSq > 1.0) {
                    if (z != 0) continue block0;
                    break block0;
                }
                if (!filled && EditSession.lengthSq(nextXn, zn) <= 1.0 && EditSession.lengthSq(xn, nextZn) <= 1.0) continue;
                for (int y = 0; y < height; ++y) {
                    if (this.setBlock(pos.add(x, y, z), block)) {
                        ++affected;
                    }
                    if (this.setBlock(pos.add(-x, y, z), block)) {
                        ++affected;
                    }
                    if (this.setBlock(pos.add(x, y, -z), block)) {
                        ++affected;
                    }
                    if (!this.setBlock(pos.add(-x, y, -z), block)) continue;
                    ++affected;
                }
            }
        }
        return affected;
    }

    public int makeSphere(Vector pos, Pattern block, double radius, boolean filled) throws MaxChangedBlocksException {
        return this.makeSphere(pos, block, radius, radius, radius, filled);
    }

    public int makeSphere(Vector pos, Pattern block, double radiusX, double radiusY, double radiusZ, boolean filled) throws MaxChangedBlocksException {
        int affected = 0;
        double invRadiusX = 1.0 / (radiusX += 0.5);
        double invRadiusY = 1.0 / (radiusY += 0.5);
        double invRadiusZ = 1.0 / (radiusZ += 0.5);
        int ceilRadiusX = (int)Math.ceil(radiusX);
        int ceilRadiusY = (int)Math.ceil(radiusY);
        int ceilRadiusZ = (int)Math.ceil(radiusZ);
        double nextXn = 0.0;
        block0: for (int x = 0; x <= ceilRadiusX; ++x) {
            double xn = nextXn;
            nextXn = (double)(x + 1) * invRadiusX;
            double nextYn = 0.0;
            block1: for (int y = 0; y <= ceilRadiusY; ++y) {
                double yn = nextYn;
                nextYn = (double)(y + 1) * invRadiusY;
                double nextZn = 0.0;
                for (int z = 0; z <= ceilRadiusZ; ++z) {
                    double zn = nextZn;
                    nextZn = (double)(z + 1) * invRadiusZ;
                    double distanceSq = EditSession.lengthSq(xn, yn, zn);
                    if (distanceSq > 1.0) {
                        if (z != 0) continue block1;
                        if (y != 0) continue block0;
                        break block0;
                    }
                    if (!filled && EditSession.lengthSq(nextXn, yn, zn) <= 1.0 && EditSession.lengthSq(xn, nextYn, zn) <= 1.0 && EditSession.lengthSq(xn, yn, nextZn) <= 1.0) continue;
                    if (this.setBlock(pos.add(x, y, z), block)) {
                        ++affected;
                    }
                    if (this.setBlock(pos.add(-x, y, z), block)) {
                        ++affected;
                    }
                    if (this.setBlock(pos.add(x, -y, z), block)) {
                        ++affected;
                    }
                    if (this.setBlock(pos.add(x, y, -z), block)) {
                        ++affected;
                    }
                    if (this.setBlock(pos.add(-x, -y, z), block)) {
                        ++affected;
                    }
                    if (this.setBlock(pos.add(x, -y, -z), block)) {
                        ++affected;
                    }
                    if (this.setBlock(pos.add(-x, y, -z), block)) {
                        ++affected;
                    }
                    if (!this.setBlock(pos.add(-x, -y, -z), block)) continue;
                    ++affected;
                }
            }
        }
        return affected;
    }

    private static final double lengthSq(double x, double y, double z) {
        return x * x + y * y + z * z;
    }

    private static final double lengthSq(double x, double z) {
        return x * x + z * z;
    }

    public int makePyramid(Vector pos, Pattern block, int size, boolean filled) throws MaxChangedBlocksException {
        int affected = 0;
        int height = size;
        for (int y = 0; y <= height; ++y) {
            --size;
            for (int x = 0; x <= size; ++x) {
                for (int z = 0; z <= size; ++z) {
                    if ((!filled || z > size || x > size) && z != size && x != size) continue;
                    if (this.setBlock(pos.add(x, y, z), block)) {
                        ++affected;
                    }
                    if (this.setBlock(pos.add(-x, y, z), block)) {
                        ++affected;
                    }
                    if (this.setBlock(pos.add(x, y, -z), block)) {
                        ++affected;
                    }
                    if (!this.setBlock(pos.add(-x, y, -z), block)) continue;
                    ++affected;
                }
            }
        }
        return affected;
    }

    public int thaw(Vector pos, double radius) throws MaxChangedBlocksException {
        int affected = 0;
        double radiusSq = radius * radius;
        int ox = pos.getBlockX();
        int oy = pos.getBlockY();
        int oz = pos.getBlockZ();
        BaseBlock air = new BaseBlock(0);
        BaseBlock water = new BaseBlock(9);
        int ceilRadius = (int)Math.ceil(radius);
        for (int x = ox - ceilRadius; x <= ox + ceilRadius; ++x) {
            block6: for (int z = oz - ceilRadius; z <= oz + ceilRadius; ++z) {
                if (new Vector(x, oy, z).distanceSq(pos) > radiusSq) continue;
                block7: for (int y = this.world.getMaxY(); y >= 1; --y) {
                    Vector pt = new Vector(x, y, z);
                    int id = this.getBlockType(pt);
                    switch (id) {
                        case 79: {
                            if (!this.setBlock(pt, water)) continue block6;
                            ++affected;
                            continue block6;
                        }
                        case 78: {
                            if (!this.setBlock(pt, air)) continue block6;
                            ++affected;
                            continue block6;
                        }
                        case 0: {
                            continue block7;
                        }
                        default: {
                            continue block6;
                        }
                    }
                }
            }
        }
        return affected;
    }

    public int simulateSnow(Vector pos, double radius) throws MaxChangedBlocksException {
        int affected = 0;
        double radiusSq = radius * radius;
        int ox = pos.getBlockX();
        int oy = pos.getBlockY();
        int oz = pos.getBlockZ();
        BaseBlock ice = new BaseBlock(79);
        BaseBlock snow = new BaseBlock(78);
        int ceilRadius = (int)Math.ceil(radius);
        for (int x = ox - ceilRadius; x <= ox + ceilRadius; ++x) {
            block1: for (int z = oz - ceilRadius; z <= oz + ceilRadius; ++z) {
                if (new Vector(x, oy, z).distanceSq(pos) > radiusSq) continue;
                for (int y = this.world.getMaxY(); y >= 1; --y) {
                    Vector pt = new Vector(x, y, z);
                    int id = this.getBlockType(pt);
                    if (id == 0) continue;
                    if (id == 8 || id == 9) {
                        if (!this.setBlock(pt, ice)) continue block1;
                        ++affected;
                        continue block1;
                    }
                    if (BlockType.isTranslucent(id) || y == this.world.getMaxY() || !this.setBlock(pt.add(0, 1, 0), snow)) continue block1;
                    ++affected;
                    continue block1;
                }
            }
        }
        return affected;
    }

    public int green(Vector pos, double radius) throws MaxChangedBlocksException {
        int affected = 0;
        double radiusSq = radius * radius;
        int ox = pos.getBlockX();
        int oy = pos.getBlockY();
        int oz = pos.getBlockZ();
        BaseBlock grass = new BaseBlock(2);
        int ceilRadius = (int)Math.ceil(radius);
        for (int x = ox - ceilRadius; x <= ox + ceilRadius; ++x) {
            block5: for (int z = oz - ceilRadius; z <= oz + ceilRadius; ++z) {
                if (new Vector(x, oy, z).distanceSq(pos) > radiusSq) continue;
                block6: for (int y = this.world.getMaxY(); y >= 1; --y) {
                    Vector pt = new Vector(x, y, z);
                    int id = this.getBlockType(pt);
                    switch (id) {
                        case 3: {
                            if (!this.setBlock(pt, grass)) continue block5;
                            ++affected;
                            continue block5;
                        }
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: {
                            continue block5;
                        }
                        default: {
                            if (!BlockType.canPassThrough(id)) continue block5;
                            continue block6;
                        }
                    }
                }
            }
        }
        return affected;
    }

    private void makePumpkinPatch(Vector basePos) throws MaxChangedBlocksException {
        BaseBlock leavesBlock = new BaseBlock(18);
        this.setBlockIfAir(basePos, leavesBlock);
        this.makePumpkinPatchVine(basePos, basePos.add(0, 0, 1));
        this.makePumpkinPatchVine(basePos, basePos.add(0, 0, -1));
        this.makePumpkinPatchVine(basePos, basePos.add(1, 0, 0));
        this.makePumpkinPatchVine(basePos, basePos.add(-1, 0, 0));
    }

    private void makePumpkinPatchVine(Vector basePos, Vector pos) throws MaxChangedBlocksException {
        Vector testPos;
        if (pos.distance(basePos) > 4.0) {
            return;
        }
        if (this.getBlockType(pos) != 0) {
            return;
        }
        for (int i = -1; i > -3 && this.getBlockType(testPos = pos.add(0, i, 0)) == 0; --i) {
            pos = testPos;
        }
        this.setBlockIfAir(pos, new BaseBlock(18));
        int t = prng.nextInt(4);
        int h = prng.nextInt(3) - 1;
        BaseBlock log = new BaseBlock(17);
        switch (t) {
            case 0: {
                if (prng.nextBoolean()) {
                    this.makePumpkinPatchVine(basePos, pos.add(1, 0, 0));
                }
                if (prng.nextBoolean()) {
                    this.setBlockIfAir(pos.add(1, h, -1), log);
                }
                this.setBlockIfAir(pos.add(0, 0, -1), new BaseBlock(86, prng.nextInt(4)));
                break;
            }
            case 1: {
                if (prng.nextBoolean()) {
                    this.makePumpkinPatchVine(basePos, pos.add(0, 0, 1));
                }
                if (prng.nextBoolean()) {
                    this.setBlockIfAir(pos.add(1, h, 0), log);
                }
                this.setBlockIfAir(pos.add(1, 0, 1), new BaseBlock(86, prng.nextInt(4)));
                break;
            }
            case 2: {
                if (prng.nextBoolean()) {
                    this.makePumpkinPatchVine(basePos, pos.add(0, 0, -1));
                }
                if (prng.nextBoolean()) {
                    this.setBlockIfAir(pos.add(-1, h, 0), log);
                }
                this.setBlockIfAir(pos.add(-1, 0, 1), new BaseBlock(86, prng.nextInt(4)));
                break;
            }
            case 3: {
                if (prng.nextBoolean()) {
                    this.makePumpkinPatchVine(basePos, pos.add(-1, 0, 0));
                }
                if (prng.nextBoolean()) {
                    this.setBlockIfAir(pos.add(-1, h, -1), log);
                }
                this.setBlockIfAir(pos.add(-1, 0, -1), new BaseBlock(86, prng.nextInt(4)));
            }
        }
    }

    public int makePumpkinPatches(Vector basePos, int size) throws MaxChangedBlocksException {
        int affected = 0;
        for (int x = basePos.getBlockX() - size; x <= basePos.getBlockX() + size; ++x) {
            block1: for (int z = basePos.getBlockZ() - size; z <= basePos.getBlockZ() + size; ++z) {
                if (!this.getBlock(new Vector(x, basePos.getBlockY(), z)).isAir() || Math.random() < 0.98) continue;
                for (int y = basePos.getBlockY(); y >= basePos.getBlockY() - 10; --y) {
                    int t = this.getBlock(new Vector(x, y, z)).getType();
                    if (t == 2 || t == 3) {
                        this.makePumpkinPatch(new Vector(x, y + 1, z));
                        ++affected;
                        continue block1;
                    }
                    if (t != 0) continue block1;
                }
            }
        }
        return affected;
    }

    public int makeForest(Vector basePos, int size, double density, TreeGenerator treeGenerator) throws MaxChangedBlocksException {
        int affected = 0;
        for (int x = basePos.getBlockX() - size; x <= basePos.getBlockX() + size; ++x) {
            block1: for (int z = basePos.getBlockZ() - size; z <= basePos.getBlockZ() + size; ++z) {
                if (!this.getBlock(new Vector(x, basePos.getBlockY(), z)).isAir() || Math.random() >= density) continue;
                for (int y = basePos.getBlockY(); y >= basePos.getBlockY() - 10; --y) {
                    int t = this.getBlock(new Vector(x, y, z)).getType();
                    if (t == 2 || t == 3) {
                        treeGenerator.generate(this, new Vector(x, y + 1, z));
                        ++affected;
                        continue block1;
                    }
                    if (t != 0) continue block1;
                }
            }
        }
        return affected;
    }

    public List<Countable<Integer>> getBlockDistribution(Region region) {
        ArrayList<Countable<Integer>> distribution = new ArrayList<Countable<Integer>>();
        HashMap<Integer, Countable<Integer>> map = new HashMap<Integer, Countable<Integer>>();
        if (region instanceof CuboidRegion) {
            Vector min = region.getMinimumPoint();
            Vector max = region.getMaximumPoint();
            int minX = min.getBlockX();
            int minY = min.getBlockY();
            int minZ = min.getBlockZ();
            int maxX = max.getBlockX();
            int maxY = max.getBlockY();
            int maxZ = max.getBlockZ();
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        Vector pt = new Vector(x, y, z);
                        int id = this.getBlockType(pt);
                        if (map.containsKey(id)) {
                            ((Countable)map.get(id)).increment();
                            continue;
                        }
                        Countable<Integer> c = new Countable<Integer>(id, 1);
                        map.put(id, c);
                        distribution.add(c);
                    }
                }
            }
        } else {
            for (Vector pt : region) {
                int id = this.getBlockType(pt);
                if (map.containsKey(id)) {
                    ((Countable)map.get(id)).increment();
                    continue;
                }
                Countable<Integer> c = new Countable<Integer>(id, 1);
                map.put(id, c);
            }
        }
        Collections.sort(distribution);
        return distribution;
    }

    public List<Countable<BaseBlock>> getBlockDistributionWithData(Region region) {
        ArrayList<Countable<BaseBlock>> distribution = new ArrayList<Countable<BaseBlock>>();
        HashMap<BaseBlock, Countable<BaseBlock>> map = new HashMap<BaseBlock, Countable<BaseBlock>>();
        if (region instanceof CuboidRegion) {
            Vector min = region.getMinimumPoint();
            Vector max = region.getMaximumPoint();
            int minX = min.getBlockX();
            int minY = min.getBlockY();
            int minZ = min.getBlockZ();
            int maxX = max.getBlockX();
            int maxY = max.getBlockY();
            int maxZ = max.getBlockZ();
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        Vector pt = new Vector(x, y, z);
                        BaseBlock blk = new BaseBlock(this.getBlockType(pt), this.getBlockData(pt));
                        if (map.containsKey(blk)) {
                            ((Countable)map.get(blk)).increment();
                            continue;
                        }
                        Countable<BaseBlock> c = new Countable<BaseBlock>(blk, 1);
                        map.put(blk, c);
                        distribution.add(c);
                    }
                }
            }
        } else {
            for (Vector pt : region) {
                BaseBlock blk = new BaseBlock(this.getBlockType(pt), this.getBlockData(pt));
                if (map.containsKey(blk)) {
                    ((Countable)map.get(blk)).increment();
                    continue;
                }
                Countable<BaseBlock> c = new Countable<BaseBlock>(blk, 1);
                map.put(blk, c);
            }
        }
        Collections.sort(distribution);
        return distribution;
    }

    public int makeShape(Region region, final Vector zero, final Vector unit, Pattern pattern, String expressionString, boolean hollow) throws ExpressionException, MaxChangedBlocksException {
        final Expression expression = Expression.compile(expressionString, "x", "y", "z", "type", "data");
        expression.optimize();
        final RValue typeVariable = expression.getVariable("type", false);
        final RValue dataVariable = expression.getVariable("data", false);
        ArbitraryShape shape = new ArbitraryShape(region){

            @Override
            protected BaseBlock getMaterial(int x, int y, int z, BaseBlock defaultMaterial) {
                Vector scaled = new Vector(x, y, z).subtract(zero).divide(unit);
                try {
                    double[] dArray = new double[]{scaled.getX(), scaled.getY(), scaled.getZ(), defaultMaterial.getType(), defaultMaterial.getData()};
                    if (expression.evaluate(dArray) <= 0.0) {
                        return null;
                    }
                    return new BaseBlock((int)typeVariable.getValue(), (int)dataVariable.getValue());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        };
        return shape.generate(this, pattern, hollow);
    }

    public int deformRegion(Region region, Vector zero, Vector unit, String expressionString) throws ExpressionException, MaxChangedBlocksException {
        Expression expression = Expression.compile(expressionString, "x", "y", "z");
        expression.optimize();
        RValue x = expression.getVariable("x", false);
        RValue y = expression.getVariable("y", false);
        RValue z = expression.getVariable("z", false);
        Vector zero2 = zero.add(0.5, 0.5, 0.5);
        DoubleArrayList<BlockVector, BaseBlock> queue = new DoubleArrayList<BlockVector, BaseBlock>(false);
        for (BlockVector position : region) {
            Vector scaled = position.subtract(zero).divide(unit);
            expression.evaluate(scaled.getX(), scaled.getY(), scaled.getZ());
            Vector sourceScaled = new Vector(x.getValue(), y.getValue(), z.getValue());
            BlockVector sourcePosition = sourceScaled.multiply(unit).add(zero2).toBlockPoint();
            BaseBlock material = new BaseBlock(this.world.getBlockType(sourcePosition), this.world.getBlockData(sourcePosition));
            queue.put(position, material);
        }
        int affected = 0;
        for (Map.Entry entry : queue) {
            BaseBlock material;
            BlockVector position = (BlockVector)entry.getKey();
            if (!this.setBlock((Vector)position, material = (BaseBlock)entry.getValue())) continue;
            ++affected;
        }
        return affected;
    }

    public int hollowOutRegion(Region region, int thickness, Pattern pattern) throws MaxChangedBlocksException {
        int affected = 0;
        HashSet<BlockVector> outside = new HashSet<BlockVector>();
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        int minX = min.getBlockX();
        int minY = min.getBlockY();
        int minZ = min.getBlockZ();
        int maxX = max.getBlockX();
        int maxY = max.getBlockY();
        int maxZ = max.getBlockZ();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                this.recurseHollow(region, new BlockVector(x, y, minZ), outside);
                this.recurseHollow(region, new BlockVector(x, y, maxZ), outside);
            }
        }
        for (int y = minY; y <= maxY; ++y) {
            for (int z = minZ; z <= maxZ; ++z) {
                this.recurseHollow(region, new BlockVector(minX, y, z), outside);
                this.recurseHollow(region, new BlockVector(maxX, y, z), outside);
            }
        }
        for (int z = minZ; z <= maxZ; ++z) {
            for (int x = minX; x <= maxX; ++x) {
                this.recurseHollow(region, new BlockVector(x, minY, z), outside);
                this.recurseHollow(region, new BlockVector(x, maxY, z), outside);
            }
        }
        for (int i = 1; i < thickness; ++i) {
            HashSet<BlockVector> newOutside = new HashSet<BlockVector>();
            block7: for (BlockVector position : region) {
                for (Vector recurseDirection : this.recurseDirections) {
                    BlockVector neighbor = position.add(recurseDirection).toBlockVector();
                    if (!outside.contains(neighbor)) continue;
                    newOutside.add(position);
                    continue block7;
                }
            }
            outside.addAll(newOutside);
        }
        block9: for (BlockVector position : region) {
            for (Vector recurseDirection : this.recurseDirections) {
                BlockVector neighbor = position.add(recurseDirection).toBlockVector();
                if (outside.contains(neighbor)) continue block9;
            }
            if (!this.setBlock((Vector)position, pattern.next(position))) continue;
            ++affected;
        }
        return affected;
    }

    private void recurseHollow(Region region, BlockVector origin, Set<BlockVector> outside) {
        LinkedList<BlockVector> queue = new LinkedList<BlockVector>();
        queue.addLast(origin);
        while (!queue.isEmpty()) {
            BlockVector current = (BlockVector)queue.removeFirst();
            if (!BlockType.canPassThrough(this.getBlockType(current)) || !outside.add(current) || !region.contains(current)) continue;
            for (Vector recurseDirection : this.recurseDirections) {
                queue.addLast(current.add(recurseDirection).toBlockVector());
            }
        }
    }
}

