/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.regions;

import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionIterator;
import com.sk89q.worldedit.regions.RegionOperationException;
import java.util.Iterator;

public abstract class AbstractRegion
implements Region {
    protected LocalWorld world;

    public AbstractRegion(LocalWorld world) {
        this.world = world;
    }

    @Override
    public Vector getCenter() {
        return this.getMinimumPoint().add(this.getMaximumPoint()).divide(2);
    }

    @Override
    public Iterator<BlockVector> iterator() {
        return new RegionIterator(this);
    }

    @Override
    public LocalWorld getWorld() {
        return this.world;
    }

    @Override
    public void setWorld(LocalWorld world) {
        this.world = world;
    }

    @Override
    public void shift(Vector change) throws RegionOperationException {
        this.expand(change);
        this.contract(change);
    }

    @Override
    public AbstractRegion clone() {
        try {
            return (AbstractRegion)super.clone();
        }
        catch (CloneNotSupportedException exc) {
            return null;
        }
    }
}

