/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import java.util.Locale;
import org.bukkit.Chunk;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Boat;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Projectile;

public class Commandremove
extends EssentialsCommand {
    public Commandremove() {
        super("remove");
    }

    @Override
    protected void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        ToRemove toRemove;
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        World world = user.getWorld();
        int radius = 0;
        if (args.length >= 2) {
            try {
                radius = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                throw new Exception(I18n._("numberRequired", new Object[0]), e);
            }
        }
        if (args.length >= 3) {
            world = this.ess.getWorld(args[2]);
        }
        try {
            toRemove = ToRemove.valueOf(args[0].toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            try {
                toRemove = ToRemove.valueOf(args[0].concat("S").toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException ee) {
                throw new NotEnoughArgumentsException(ee);
            }
        }
        this.removeEntities(user.getSource(), world, toRemove, radius);
    }

    @Override
    protected void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        ToRemove toRemove;
        if (args.length < 2) {
            throw new NotEnoughArgumentsException();
        }
        World world = this.ess.getWorld(args[1]);
        try {
            toRemove = ToRemove.valueOf(args[0].toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            try {
                toRemove = ToRemove.valueOf(args[0].concat("S").toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException ee) {
                throw new NotEnoughArgumentsException(ee);
            }
        }
        this.removeEntities(sender, world, toRemove, 0);
    }

    private void removeEntities(CommandSource sender, World world, ToRemove toRemove, int radius) throws Exception {
        int removed = 0;
        if (radius > 0) {
            radius *= radius;
        }
        for (Chunk chunk : world.getLoadedChunks()) {
            for (Entity e : chunk.getEntities()) {
                if (radius > 0 && sender.getPlayer().getLocation().distanceSquared(e.getLocation()) > (double)radius) continue;
                if (toRemove == ToRemove.DROPS) {
                    if (!(e instanceof Item)) continue;
                    e.remove();
                    ++removed;
                    continue;
                }
                if (toRemove == ToRemove.ARROWS) {
                    if (!(e instanceof Projectile)) continue;
                    e.remove();
                    ++removed;
                    continue;
                }
                if (toRemove == ToRemove.BOATS) {
                    if (!(e instanceof Boat)) continue;
                    e.remove();
                    ++removed;
                    continue;
                }
                if (toRemove == ToRemove.MINECARTS) {
                    if (!(e instanceof Minecart)) continue;
                    e.remove();
                    ++removed;
                    continue;
                }
                if (toRemove == ToRemove.XP) {
                    if (!(e instanceof ExperienceOrb)) continue;
                    e.remove();
                    ++removed;
                    continue;
                }
                if (toRemove == ToRemove.PAINTINGS) {
                    if (!(e instanceof Painting)) continue;
                    e.remove();
                    ++removed;
                    continue;
                }
                if (toRemove == ToRemove.ITEMFRAMES) {
                    if (!(e instanceof ItemFrame)) continue;
                    e.remove();
                    ++removed;
                    continue;
                }
                if (toRemove != ToRemove.ENDERCRYSTALS || !(e instanceof EnderCrystal)) continue;
                e.remove();
                ++removed;
            }
        }
        sender.sendMessage(I18n._("removed", removed));
    }

    private static enum ToRemove {
        DROPS,
        ARROWS,
        BOATS,
        MINECARTS,
        XP,
        PAINTINGS,
        ITEMFRAMES,
        ENDERCRYSTALS;

    }
}

