/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.Validate;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.MultipleCommandAlias;
import org.bukkit.command.defaults.BanCommand;
import org.bukkit.command.defaults.BanIpCommand;
import org.bukkit.command.defaults.BanListCommand;
import org.bukkit.command.defaults.ClearCommand;
import org.bukkit.command.defaults.DefaultGameModeCommand;
import org.bukkit.command.defaults.DeopCommand;
import org.bukkit.command.defaults.DifficultyCommand;
import org.bukkit.command.defaults.EffectCommand;
import org.bukkit.command.defaults.EnchantCommand;
import org.bukkit.command.defaults.ExpCommand;
import org.bukkit.command.defaults.GameModeCommand;
import org.bukkit.command.defaults.GameRuleCommand;
import org.bukkit.command.defaults.GiveCommand;
import org.bukkit.command.defaults.HelpCommand;
import org.bukkit.command.defaults.KickCommand;
import org.bukkit.command.defaults.KillCommand;
import org.bukkit.command.defaults.ListCommand;
import org.bukkit.command.defaults.MeCommand;
import org.bukkit.command.defaults.OpCommand;
import org.bukkit.command.defaults.PardonCommand;
import org.bukkit.command.defaults.PardonIpCommand;
import org.bukkit.command.defaults.PlaySoundCommand;
import org.bukkit.command.defaults.PluginsCommand;
import org.bukkit.command.defaults.ReloadCommand;
import org.bukkit.command.defaults.SaveCommand;
import org.bukkit.command.defaults.SaveOffCommand;
import org.bukkit.command.defaults.SaveOnCommand;
import org.bukkit.command.defaults.SayCommand;
import org.bukkit.command.defaults.ScoreboardCommand;
import org.bukkit.command.defaults.SeedCommand;
import org.bukkit.command.defaults.SpawnpointCommand;
import org.bukkit.command.defaults.SpreadPlayersCommand;
import org.bukkit.command.defaults.StopCommand;
import org.bukkit.command.defaults.TeleportCommand;
import org.bukkit.command.defaults.TellCommand;
import org.bukkit.command.defaults.TestForCommand;
import org.bukkit.command.defaults.TimeCommand;
import org.bukkit.command.defaults.TimingsCommand;
import org.bukkit.command.defaults.ToggleDownfallCommand;
import org.bukkit.command.defaults.VanillaCommand;
import org.bukkit.command.defaults.VersionCommand;
import org.bukkit.command.defaults.WeatherCommand;
import org.bukkit.command.defaults.WhitelistCommand;
import org.bukkit.entity.Player;
import org.bukkit.util.Java15Compat;
import org.bukkit.util.StringUtil;

public class SimpleCommandMap
implements CommandMap {
    private static final Pattern PATTERN_ON_SPACE = Pattern.compile(" ", 16);
    protected final Map<String, Command> knownCommands = new HashMap<String, Command>();
    protected final Set<String> aliases = new HashSet<String>();
    private final Server server;
    protected static final Set<VanillaCommand> fallbackCommands = new HashSet<VanillaCommand>();

    public SimpleCommandMap(Server server) {
        this.server = server;
        this.setDefaultCommands(server);
    }

    private void setDefaultCommands(Server server) {
        this.register("bukkit", new SaveCommand());
        this.register("bukkit", new SaveOnCommand());
        this.register("bukkit", new SaveOffCommand());
        this.register("bukkit", new StopCommand());
        this.register("bukkit", new VersionCommand("version"));
        this.register("bukkit", new ReloadCommand("reload"));
        this.register("bukkit", new PluginsCommand("plugins"));
        this.register("bukkit", new TimingsCommand("timings"));
    }

    @Override
    public void registerAll(String fallbackPrefix, List<Command> commands) {
        if (commands != null) {
            for (Command c : commands) {
                this.register(fallbackPrefix, c);
            }
        }
    }

    @Override
    public boolean register(String fallbackPrefix, Command command) {
        return this.register(command.getName(), fallbackPrefix, command);
    }

    @Override
    public boolean register(String label, String fallbackPrefix, Command command) {
        boolean registeredPassedLabel = this.register(label, fallbackPrefix, command, false);
        Iterator<String> iterator = command.getAliases().iterator();
        while (iterator.hasNext()) {
            if (this.register(iterator.next(), fallbackPrefix, command, true)) continue;
            iterator.remove();
        }
        command.register(this);
        return registeredPassedLabel;
    }

    private synchronized boolean register(String label, String fallbackPrefix, Command command, boolean isAlias) {
        String lowerLabel = label.trim().toLowerCase();
        if (isAlias && this.knownCommands.containsKey(lowerLabel)) {
            return false;
        }
        String lowerPrefix = fallbackPrefix.trim().toLowerCase();
        boolean registerdPassedLabel = true;
        while (this.knownCommands.containsKey(lowerLabel) && !this.aliases.contains(lowerLabel)) {
            lowerLabel = lowerPrefix + ":" + lowerLabel;
            registerdPassedLabel = false;
        }
        if (isAlias) {
            this.aliases.add(lowerLabel);
        } else {
            this.aliases.remove(lowerLabel);
            command.setLabel(lowerLabel);
        }
        this.knownCommands.put(lowerLabel, command);
        return registerdPassedLabel;
    }

    protected Command getFallback(String label) {
        for (VanillaCommand cmd : fallbackCommands) {
            if (!cmd.matches(label)) continue;
            return cmd;
        }
        return null;
    }

    public Set<VanillaCommand> getFallbackCommands() {
        return Collections.unmodifiableSet(fallbackCommands);
    }

    @Override
    public boolean dispatch(CommandSender sender, String commandLine) throws CommandException {
        String[] args = PATTERN_ON_SPACE.split(commandLine);
        if (args.length == 0) {
            return false;
        }
        String sentCommandLabel = args[0].toLowerCase();
        Command target = this.getCommand(sentCommandLabel);
        if (target == null) {
            return false;
        }
        try {
            target.timings.startTiming();
            target.execute(sender, sentCommandLabel, Java15Compat.Arrays_copyOfRange(args, 1, args.length));
            target.timings.stopTiming();
        }
        catch (CommandException ex) {
            target.timings.stopTiming();
            throw ex;
        }
        catch (Throwable ex) {
            target.timings.stopTiming();
            throw new CommandException("Unhandled exception executing '" + commandLine + "' in " + target, ex);
        }
        return true;
    }

    @Override
    public synchronized void clearCommands() {
        for (Map.Entry<String, Command> entry : this.knownCommands.entrySet()) {
            entry.getValue().unregister(this);
        }
        this.knownCommands.clear();
        this.aliases.clear();
        this.setDefaultCommands(this.server);
    }

    @Override
    public Command getCommand(String name) {
        Command target = this.knownCommands.get(name.toLowerCase());
        if (target == null) {
            target = this.getFallback(name);
        }
        return target;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String cmdLine) {
        Validate.notNull((Object)sender, (String)"Sender cannot be null");
        Validate.notNull((Object)cmdLine, (String)"Command line cannot null");
        int spaceIndex = cmdLine.indexOf(32);
        if (spaceIndex == -1) {
            ArrayList<String> completions = new ArrayList<String>();
            Map<String, Command> knownCommands = this.knownCommands;
            String prefix = sender instanceof Player ? "/" : "";
            for (VanillaCommand vanillaCommand : fallbackCommands) {
                String name = vanillaCommand.getName();
                if (!vanillaCommand.testPermissionSilent(sender) || knownCommands.containsKey(name) || !StringUtil.startsWithIgnoreCase(name, cmdLine)) continue;
                completions.add(prefix + name);
            }
            for (Map.Entry entry : knownCommands.entrySet()) {
                String name;
                Command command = (Command)entry.getValue();
                if (!command.testPermissionSilent(sender) || !StringUtil.startsWithIgnoreCase(name = (String)entry.getKey(), cmdLine)) continue;
                completions.add(prefix + name);
            }
            Collections.sort(completions, String.CASE_INSENSITIVE_ORDER);
            return completions;
        }
        String commandName = cmdLine.substring(0, spaceIndex);
        Command target = this.getCommand(commandName);
        if (target == null) {
            return null;
        }
        if (!target.testPermissionSilent(sender)) {
            return null;
        }
        String argLine = cmdLine.substring(spaceIndex + 1, cmdLine.length());
        String[] args = PATTERN_ON_SPACE.split(argLine, -1);
        try {
            return target.tabComplete(sender, commandName, args);
        }
        catch (CommandException commandException) {
            throw commandException;
        }
        catch (Throwable throwable) {
            throw new CommandException("Unhandled exception executing tab-completer for '" + cmdLine + "' in " + target, throwable);
        }
    }

    public Collection<Command> getCommands() {
        return this.knownCommands.values();
    }

    public void registerServerAliases() {
        Map<String, String[]> values = this.server.getCommandAliases();
        for (String alias : values.keySet()) {
            String[] targetNames = values.get(alias);
            ArrayList<Command> targets = new ArrayList<Command>();
            StringBuilder bad = new StringBuilder();
            for (String name : targetNames) {
                Command command = this.getCommand(name);
                if (command == null) {
                    if (bad.length() > 0) {
                        bad.append(", ");
                    }
                    bad.append(name);
                    continue;
                }
                targets.add(command);
            }
            if (targets.size() > 0) {
                this.knownCommands.put(alias.toLowerCase(), new MultipleCommandAlias(alias.toLowerCase(), targets.toArray(new Command[0])));
            } else {
                this.knownCommands.remove(alias.toLowerCase());
            }
            if (bad.length() <= 0) continue;
            this.server.getLogger().warning("The following command(s) could not be aliased under '" + alias + "' because they do not exist: " + bad);
        }
    }

    static {
        fallbackCommands.add(new ListCommand());
        fallbackCommands.add(new OpCommand());
        fallbackCommands.add(new DeopCommand());
        fallbackCommands.add(new BanIpCommand());
        fallbackCommands.add(new PardonIpCommand());
        fallbackCommands.add(new BanCommand());
        fallbackCommands.add(new PardonCommand());
        fallbackCommands.add(new KickCommand());
        fallbackCommands.add(new TeleportCommand());
        fallbackCommands.add(new GiveCommand());
        fallbackCommands.add(new TimeCommand());
        fallbackCommands.add(new SayCommand());
        fallbackCommands.add(new WhitelistCommand());
        fallbackCommands.add(new TellCommand());
        fallbackCommands.add(new MeCommand());
        fallbackCommands.add(new KillCommand());
        fallbackCommands.add(new GameModeCommand());
        fallbackCommands.add(new HelpCommand());
        fallbackCommands.add(new ExpCommand());
        fallbackCommands.add(new ToggleDownfallCommand());
        fallbackCommands.add(new BanListCommand());
        fallbackCommands.add(new DefaultGameModeCommand());
        fallbackCommands.add(new SeedCommand());
        fallbackCommands.add(new DifficultyCommand());
        fallbackCommands.add(new WeatherCommand());
        fallbackCommands.add(new SpawnpointCommand());
        fallbackCommands.add(new ClearCommand());
        fallbackCommands.add(new GameRuleCommand());
        fallbackCommands.add(new EnchantCommand());
        fallbackCommands.add(new TestForCommand());
        fallbackCommands.add(new EffectCommand());
        fallbackCommands.add(new ScoreboardCommand());
        fallbackCommands.add(new PlaySoundCommand());
        fallbackCommands.add(new SpreadPlayersCommand());
    }
}

