/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.command.defaults;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.VanillaCommand;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.StringUtil;

public class ScoreboardCommand
extends VanillaCommand {
    private static final List<String> MAIN_CHOICES = ImmutableList.of((Object)"objectives", (Object)"players", (Object)"teams");
    private static final List<String> OBJECTIVES_CHOICES = ImmutableList.of((Object)"list", (Object)"add", (Object)"remove", (Object)"setdisplay");
    private static final List<String> OBJECTIVES_CRITERIA = ImmutableList.of((Object)"health", (Object)"playerKillCount", (Object)"totalKillCount", (Object)"deathCount", (Object)"dummy");
    private static final List<String> PLAYERS_CHOICES = ImmutableList.of((Object)"set", (Object)"add", (Object)"remove", (Object)"reset", (Object)"list");
    private static final List<String> TEAMS_CHOICES = ImmutableList.of((Object)"add", (Object)"remove", (Object)"join", (Object)"leave", (Object)"empty", (Object)"list", (Object)"option");
    private static final List<String> TEAMS_OPTION_CHOICES = ImmutableList.of((Object)"color", (Object)"friendlyfire", (Object)"seeFriendlyInvisibles");
    private static final Map<String, DisplaySlot> OBJECTIVES_DISPLAYSLOT = ImmutableMap.of((Object)"belowName", (Object)((Object)DisplaySlot.BELOW_NAME), (Object)"list", (Object)((Object)DisplaySlot.PLAYER_LIST), (Object)"sidebar", (Object)((Object)DisplaySlot.SIDEBAR));
    private static final Map<String, ChatColor> TEAMS_OPTION_COLOR = ImmutableMap.builder().put((Object)"aqua", (Object)ChatColor.AQUA).put((Object)"black", (Object)ChatColor.BLACK).put((Object)"blue", (Object)ChatColor.BLUE).put((Object)"bold", (Object)ChatColor.BOLD).put((Object)"dark_aqua", (Object)ChatColor.DARK_AQUA).put((Object)"dark_blue", (Object)ChatColor.DARK_BLUE).put((Object)"dark_gray", (Object)ChatColor.DARK_GRAY).put((Object)"dark_green", (Object)ChatColor.DARK_GREEN).put((Object)"dark_purple", (Object)ChatColor.DARK_PURPLE).put((Object)"dark_red", (Object)ChatColor.DARK_RED).put((Object)"gold", (Object)ChatColor.GOLD).put((Object)"gray", (Object)ChatColor.GRAY).put((Object)"green", (Object)ChatColor.GREEN).put((Object)"italic", (Object)ChatColor.ITALIC).put((Object)"light_purple", (Object)ChatColor.LIGHT_PURPLE).put((Object)"obfuscated", (Object)ChatColor.MAGIC).put((Object)"red", (Object)ChatColor.RED).put((Object)"reset", (Object)ChatColor.RESET).put((Object)"strikethrough", (Object)ChatColor.STRIKETHROUGH).put((Object)"underline", (Object)ChatColor.UNDERLINE).put((Object)"white", (Object)ChatColor.WHITE).put((Object)"yellow", (Object)ChatColor.YELLOW).build();
    private static final List<String> BOOLEAN = ImmutableList.of((Object)"true", (Object)"false");

    public ScoreboardCommand() {
        super("scoreboard");
        this.description = "Scoreboard control";
        this.usageMessage = "/scoreboard";
        this.setPermission("bukkit.command.scoreboard");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute(CommandSender sender, String currentAlias, String[] args) {
        HashSet<String> noTeam;
        HashSet<String> left;
        block87: {
            Scoreboard mainScoreboard;
            block92: {
                HashSet<String> addedPlayers;
                Team team;
                block90: {
                    block89: {
                        block91: {
                            block88: {
                                if (!this.testPermission(sender)) {
                                    return true;
                                }
                                if (args.length < 1 || args[0].length() == 0) {
                                    sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: /scoreboard <objectives|players|teams>");
                                    return false;
                                }
                                mainScoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
                                if (args[0].equalsIgnoreCase("objectives")) {
                                    if (args.length == 1) {
                                        sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: /scoreboard objectives <list|add|remove|setdisplay>");
                                        return false;
                                    }
                                    if (args[1].equalsIgnoreCase("list")) {
                                        Set<Objective> objectives = mainScoreboard.getObjectives();
                                        if (objectives.isEmpty()) {
                                            sender.sendMessage((Object)((Object)ChatColor.RED) + "There are no objectives on the scoreboard");
                                            return false;
                                        }
                                        sender.sendMessage((Object)((Object)ChatColor.DARK_GREEN) + "Showing " + objectives.size() + " objective(s) on scoreboard");
                                        Iterator<Objective> i$ = objectives.iterator();
                                        while (i$.hasNext()) {
                                            Objective objective = i$.next();
                                            sender.sendMessage("- " + objective.getName() + ": displays as '" + objective.getDisplayName() + "' and is type '" + objective.getCriteria() + "'");
                                        }
                                        return true;
                                    }
                                    if (args[1].equalsIgnoreCase("add")) {
                                        if (args.length < 4) {
                                            sender.sendMessage((Object)((Object)ChatColor.RED) + "/scoreboard objectives add <name> <criteriaType> [display name ...]");
                                            return false;
                                        }
                                        String name = args[2];
                                        String criteria = args[3];
                                        if (criteria == null) {
                                            sender.sendMessage((Object)((Object)ChatColor.RED) + "Invalid objective criteria type. Valid types are: " + ScoreboardCommand.stringCollectionToString(OBJECTIVES_CRITERIA));
                                            return true;
                                        }
                                        if (name.length() > 16) {
                                            sender.sendMessage((Object)((Object)ChatColor.RED) + "The name '" + name + "' is too long for an objective, it can be at most 16 characters long");
                                            return true;
                                        }
                                        if (mainScoreboard.getObjective(name) != null) {
                                            sender.sendMessage((Object)((Object)ChatColor.RED) + "An objective with the name '" + name + "' already exists");
                                            return true;
                                        }
                                        String displayName = null;
                                        if (args.length > 4 && (displayName = StringUtils.join((Object[])ArrayUtils.subarray((Object[])args, (int)4, (int)args.length), (char)' ')).length() > 32) {
                                            sender.sendMessage((Object)((Object)ChatColor.RED) + "The name '" + displayName + "' is too long for an objective, it can be at most 32 characters long");
                                            return false;
                                        }
                                        Objective objective = mainScoreboard.registerNewObjective(name, criteria);
                                        if (displayName != null && displayName.length() > 0) {
                                            objective.setDisplayName(displayName);
                                        }
                                        sender.sendMessage("Added new objective '" + name + "' successfully");
                                        return true;
                                    }
                                    if (args[1].equalsIgnoreCase("remove")) {
                                        if (args.length != 3) {
                                            sender.sendMessage((Object)((Object)ChatColor.RED) + "/scoreboard objectives remove <name>");
                                            return false;
                                        }
                                        String name = args[2];
                                        Objective objective = mainScoreboard.getObjective(name);
                                        if (objective == null) {
                                            sender.sendMessage((Object)((Object)ChatColor.RED) + "No objective was found by the name '" + name + "'");
                                            return true;
                                        }
                                        objective.unregister();
                                        sender.sendMessage("Removed objective '" + name + "' successfully");
                                        return true;
                                    }
                                    if (!args[1].equalsIgnoreCase("setdisplay")) return true;
                                    if (args.length != 3 && args.length != 4) {
                                        sender.sendMessage((Object)((Object)ChatColor.RED) + "/scoreboard objectives setdisplay <slot> [objective]");
                                        return false;
                                    }
                                    String slotName = args[2];
                                    DisplaySlot slot = OBJECTIVES_DISPLAYSLOT.get(slotName);
                                    if (slot == null) {
                                        sender.sendMessage((Object)((Object)ChatColor.RED) + "No such display slot '" + slotName + "'");
                                        return true;
                                    }
                                    if (args.length == 4) {
                                        String objectiveName = args[3];
                                        Objective objective = mainScoreboard.getObjective(objectiveName);
                                        if (objective == null) {
                                            sender.sendMessage((Object)((Object)ChatColor.RED) + "No objective was found by the name '" + objectiveName + "'");
                                            return false;
                                        }
                                        objective.setDisplaySlot(slot);
                                        sender.sendMessage("Set the display objective in slot '" + slotName + "' to '" + objective.getName() + "'");
                                        return true;
                                    }
                                    Objective objective = mainScoreboard.getObjective(slot);
                                    if (objective != null) {
                                        objective.setDisplaySlot(null);
                                    }
                                    sender.sendMessage("Cleared objective display slot '" + slotName + "'");
                                    return true;
                                }
                                if (args[0].equalsIgnoreCase("players")) {
                                    if (args.length == 1) {
                                        sender.sendMessage((Object)((Object)ChatColor.RED) + "/scoreboard players <set|add|remove|reset|list>");
                                        return false;
                                    }
                                    if (args[1].equalsIgnoreCase("set") || args[1].equalsIgnoreCase("add") || args[1].equalsIgnoreCase("remove")) {
                                        int value;
                                        if (args.length != 5) {
                                            if (args[1].equalsIgnoreCase("set")) {
                                                sender.sendMessage((Object)((Object)ChatColor.RED) + "/scoreboard players set <player> <objective> <score>");
                                                return false;
                                            }
                                            if (args[1].equalsIgnoreCase("add")) {
                                                sender.sendMessage((Object)((Object)ChatColor.RED) + "/scoreboard players add <player> <objective> <count>");
                                                return false;
                                            }
                                            sender.sendMessage((Object)((Object)ChatColor.RED) + "/scoreboard players remove <player> <objective> <count>");
                                            return false;
                                        }
                                        String objectiveName = args[3];
                                        Objective objective = mainScoreboard.getObjective(objectiveName);
                                        if (objective == null) {
                                            sender.sendMessage((Object)((Object)ChatColor.RED) + "No objective was found by the name '" + objectiveName + "'");
                                            return false;
                                        }
                                        if (!objective.isModifiable()) {
                                            sender.sendMessage((Object)((Object)ChatColor.RED) + "The objective '" + objectiveName + "' is read-only and cannot be set");
                                            return false;
                                        }
                                        String valueString = args[4];
                                        try {
                                            value = Integer.parseInt(valueString);
                                        }
                                        catch (NumberFormatException e) {
                                            sender.sendMessage((Object)((Object)ChatColor.RED) + "'" + valueString + "' is not a valid number");
                                            return false;
                                        }
                                        if (value < 1 && !args[1].equalsIgnoreCase("set")) {
                                            sender.sendMessage((Object)((Object)ChatColor.RED) + "The number you have entered (" + value + ") is too small, it must be at least 1");
                                            return false;
                                        }
                                        String playerName = args[2];
                                        if (playerName.length() > 16) {
                                            sender.sendMessage((Object)((Object)ChatColor.RED) + "'" + playerName + "' is too long for a player name");
                                            return false;
                                        }
                                        Score score = objective.getScore(Bukkit.getOfflinePlayer(playerName));
                                        int newScore = args[1].equalsIgnoreCase("set") ? value : (args[1].equalsIgnoreCase("add") ? score.getScore() + value : score.getScore() - value);
                                        score.setScore(newScore);
                                        sender.sendMessage("Set score of " + objectiveName + " for player " + playerName + " to " + newScore);
                                        return true;
                                    }
                                    if (args[1].equalsIgnoreCase("reset")) {
                                        if (args.length != 3) {
                                            sender.sendMessage((Object)((Object)ChatColor.RED) + "/scoreboard players reset <player>");
                                            return false;
                                        }
                                        String playerName = args[2];
                                        if (playerName.length() > 16) {
                                            sender.sendMessage((Object)((Object)ChatColor.RED) + "'" + playerName + "' is too long for a player name");
                                            return false;
                                        }
                                        mainScoreboard.resetScores(Bukkit.getOfflinePlayer(playerName));
                                        sender.sendMessage("Reset all scores of player " + playerName);
                                        return true;
                                    }
                                    if (!args[1].equalsIgnoreCase("list")) return true;
                                    if (args.length > 3) {
                                        sender.sendMessage((Object)((Object)ChatColor.RED) + "/scoreboard players list <player>");
                                        return false;
                                    }
                                    if (args.length == 2) {
                                        Set<OfflinePlayer> players = mainScoreboard.getPlayers();
                                        if (players.isEmpty()) {
                                            sender.sendMessage((Object)((Object)ChatColor.RED) + "There are no tracked players on the scoreboard");
                                            return true;
                                        }
                                        sender.sendMessage((Object)((Object)ChatColor.DARK_GREEN) + "Showing " + players.size() + " tracked players on the scoreboard");
                                        sender.sendMessage(ScoreboardCommand.offlinePlayerSetToString(players));
                                        return true;
                                    }
                                    String playerName = args[2];
                                    if (playerName.length() > 16) {
                                        sender.sendMessage((Object)((Object)ChatColor.RED) + "'" + playerName + "' is too long for a player name");
                                        return false;
                                    }
                                    Set<Score> scores = mainScoreboard.getScores(Bukkit.getOfflinePlayer(playerName));
                                    if (scores.isEmpty()) {
                                        sender.sendMessage((Object)((Object)ChatColor.RED) + "Player " + playerName + " has no scores recorded");
                                        return true;
                                    }
                                    sender.sendMessage((Object)((Object)ChatColor.DARK_GREEN) + "Showing " + scores.size() + " tracked objective(s) for " + playerName);
                                    Iterator<Score> i$ = scores.iterator();
                                    while (i$.hasNext()) {
                                        Score score = i$.next();
                                        sender.sendMessage("- " + score.getObjective().getDisplayName() + ": " + score.getScore() + " (" + score.getObjective().getName() + ")");
                                    }
                                    return true;
                                }
                                if (!args[0].equalsIgnoreCase("teams")) {
                                    sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: /scoreboard <objectives|players|teams>");
                                    return false;
                                }
                                if (args.length == 1) {
                                    sender.sendMessage((Object)((Object)ChatColor.RED) + "/scoreboard teams <list|add|remove|empty|join|leave|option>");
                                    return false;
                                }
                                if (args[1].equalsIgnoreCase("list")) {
                                    if (args.length == 2) {
                                        Set<Team> teams = mainScoreboard.getTeams();
                                        if (teams.isEmpty()) {
                                            sender.sendMessage((Object)((Object)ChatColor.RED) + "There are no teams registered on the scoreboard");
                                            return true;
                                        }
                                        sender.sendMessage((Object)((Object)ChatColor.DARK_GREEN) + "Showing " + teams.size() + " teams on the scoreboard");
                                        Iterator<Team> i$ = teams.iterator();
                                        while (i$.hasNext()) {
                                            Team team2 = i$.next();
                                            sender.sendMessage("- " + team2.getName() + ": '" + team2.getDisplayName() + "' has " + team2.getSize() + " players");
                                        }
                                        return true;
                                    }
                                    if (args.length != 3) {
                                        sender.sendMessage((Object)((Object)ChatColor.RED) + "/scoreboard teams list [name]");
                                        return false;
                                    }
                                    String teamName = args[2];
                                    Team team3 = mainScoreboard.getTeam(teamName);
                                    if (team3 == null) {
                                        sender.sendMessage((Object)((Object)ChatColor.RED) + "No team was found by the name '" + teamName + "'");
                                        return true;
                                    }
                                    Set<OfflinePlayer> players = team3.getPlayers();
                                    if (players.isEmpty()) {
                                        sender.sendMessage((Object)((Object)ChatColor.RED) + "Team " + team3.getName() + " has no players");
                                        return true;
                                    }
                                    sender.sendMessage((Object)((Object)ChatColor.DARK_GREEN) + "Showing " + players.size() + " player(s) in team " + team3.getName());
                                    sender.sendMessage(ScoreboardCommand.offlinePlayerSetToString(players));
                                    return true;
                                }
                                if (args[1].equalsIgnoreCase("add")) {
                                    if (args.length < 3) {
                                        sender.sendMessage((Object)((Object)ChatColor.RED) + "/scoreboard teams add <name> [display name ...]");
                                        return false;
                                    }
                                    String name = args[2];
                                    if (name.length() > 16) {
                                        sender.sendMessage((Object)((Object)ChatColor.RED) + "The name '" + name + "' is too long for a team, it can be at most 16 characters long");
                                        return true;
                                    }
                                    if (mainScoreboard.getTeam(name) != null) {
                                        sender.sendMessage((Object)((Object)ChatColor.RED) + "A team with the name '" + name + "' already exists");
                                        return true;
                                    }
                                    String displayName = null;
                                    if (args.length > 3 && (displayName = StringUtils.join((Object[])ArrayUtils.subarray((Object[])args, (int)3, (int)args.length), (char)' ')).length() > 32) {
                                        sender.sendMessage((Object)((Object)ChatColor.RED) + "The display name '" + displayName + "' is too long for a team, it can be at most 32 characters long");
                                        return false;
                                    }
                                    Team team4 = mainScoreboard.registerNewTeam(name);
                                    if (displayName != null && displayName.length() > 0) {
                                        team4.setDisplayName(displayName);
                                    }
                                    sender.sendMessage("Added new team '" + team4.getName() + "' successfully");
                                    return true;
                                }
                                if (args[1].equalsIgnoreCase("remove")) {
                                    if (args.length != 3) {
                                        sender.sendMessage((Object)((Object)ChatColor.RED) + "/scoreboard teams remove <name>");
                                        return false;
                                    }
                                    String name = args[2];
                                    Team team5 = mainScoreboard.getTeam(name);
                                    if (team5 == null) {
                                        sender.sendMessage((Object)((Object)ChatColor.RED) + "No team was found by the name '" + name + "'");
                                        return true;
                                    }
                                    team5.unregister();
                                    sender.sendMessage("Removed team " + name);
                                    return true;
                                }
                                if (args[1].equalsIgnoreCase("empty")) {
                                    if (args.length != 3) {
                                        sender.sendMessage((Object)((Object)ChatColor.RED) + "/scoreboard teams clear <name>");
                                        return false;
                                    }
                                    String name = args[2];
                                    Team team6 = mainScoreboard.getTeam(name);
                                    if (team6 == null) {
                                        sender.sendMessage((Object)((Object)ChatColor.RED) + "No team was found by the name '" + name + "'");
                                        return true;
                                    }
                                    Set<OfflinePlayer> players = team6.getPlayers();
                                    if (players.isEmpty()) {
                                        sender.sendMessage((Object)((Object)ChatColor.RED) + "Team " + team6.getName() + " is already empty, cannot remove nonexistant players");
                                        return true;
                                    }
                                    Iterator<OfflinePlayer> i$ = players.iterator();
                                    while (true) {
                                        if (!i$.hasNext()) {
                                            sender.sendMessage("Removed all " + players.size() + " player(s) from team " + team6.getName());
                                            return true;
                                        }
                                        OfflinePlayer player = i$.next();
                                        team6.removePlayer(player);
                                    }
                                }
                                if (!args[1].equalsIgnoreCase("join")) break block88;
                                if (sender instanceof Player ? args.length < 3 : args.length < 4) {
                                    sender.sendMessage((Object)((Object)ChatColor.RED) + "/scoreboard teams join <team> [player...]");
                                    return false;
                                }
                                String teamName = args[2];
                                team = mainScoreboard.getTeam(teamName);
                                if (team == null) {
                                    sender.sendMessage((Object)((Object)ChatColor.RED) + "No team was found by the name '" + teamName + "'");
                                    return true;
                                }
                                addedPlayers = new HashSet<String>();
                                if (!(sender instanceof Player) || args.length != 3) break block89;
                                team.addPlayer((Player)sender);
                                addedPlayers.add(sender.getName());
                                break block90;
                            }
                            if (!args[1].equalsIgnoreCase("leave")) break block91;
                            if (!(sender instanceof Player) && args.length < 3) {
                                sender.sendMessage((Object)((Object)ChatColor.RED) + "/scoreboard teams leave [player...]");
                                return false;
                            }
                            left = new HashSet<String>();
                            noTeam = new HashSet<String>();
                            if (!(sender instanceof Player) || args.length != 2) break block92;
                            Team team7 = mainScoreboard.getPlayerTeam((Player)sender);
                            if (team7 != null) {
                                team7.removePlayer((Player)sender);
                                left.add(sender.getName());
                                break block87;
                            } else {
                                noTeam.add(sender.getName());
                            }
                            break block87;
                        }
                        if (!args[1].equalsIgnoreCase("option")) return true;
                        if (args.length != 4 && args.length != 5) {
                            sender.sendMessage((Object)((Object)ChatColor.RED) + "/scoreboard teams option <team> <friendlyfire|color|seefriendlyinvisibles> <value>");
                            return false;
                        }
                        String teamName = args[2];
                        Team team8 = mainScoreboard.getTeam(teamName);
                        if (team8 == null) {
                            sender.sendMessage((Object)((Object)ChatColor.RED) + "No team was found by the name '" + teamName + "'");
                            return false;
                        }
                        String option = args[3].toLowerCase();
                        if (!(option.equals("friendlyfire") || option.equals("color") || option.equals("seefriendlyinvisibles"))) {
                            sender.sendMessage((Object)((Object)ChatColor.RED) + "/scoreboard teams option <team> <friendlyfire|color|seefriendlyinvisibles> <value>");
                            return false;
                        }
                        if (args.length == 4) {
                            if (option.equals("color")) {
                                sender.sendMessage((Object)((Object)ChatColor.RED) + "Valid values for option color are: " + ScoreboardCommand.stringCollectionToString(TEAMS_OPTION_COLOR.keySet()));
                                return true;
                            }
                            sender.sendMessage((Object)((Object)ChatColor.RED) + "Valid values for option " + option + " are: true and false");
                            return true;
                        }
                        String value = args[4].toLowerCase();
                        if (option.equals("color")) {
                            ChatColor color = TEAMS_OPTION_COLOR.get(value);
                            if (color == null) {
                                sender.sendMessage((Object)((Object)ChatColor.RED) + "Valid values for option color are: " + ScoreboardCommand.stringCollectionToString(TEAMS_OPTION_COLOR.keySet()));
                                return false;
                            }
                            team8.setPrefix(color.toString());
                            team8.setSuffix(ChatColor.RESET.toString());
                        } else {
                            if (!value.equals("true") && !value.equals("false")) {
                                sender.sendMessage((Object)((Object)ChatColor.RED) + "Valid values for option " + option + " are: true and false");
                                return false;
                            }
                            if (option.equals("friendlyfire")) {
                                team8.setAllowFriendlyFire(value.equals("true"));
                            } else {
                                team8.setCanSeeFriendlyInvisibles(value.equals("true"));
                            }
                        }
                        sender.sendMessage("Set option " + option + " for team " + team8.getName() + " to " + value);
                        return true;
                    }
                    for (int i = 3; i < args.length; ++i) {
                        String playerName = args[i];
                        Player player = Bukkit.getPlayerExact(playerName);
                        OfflinePlayer offlinePlayer = player != null ? player : Bukkit.getOfflinePlayer(playerName);
                        team.addPlayer(offlinePlayer);
                        addedPlayers.add(offlinePlayer.getName());
                    }
                }
                sender.sendMessage("Added " + addedPlayers.size() + " player(s) to team " + team.getName() + ": " + ScoreboardCommand.stringCollectionToString(addedPlayers));
                return true;
            }
            for (int i = 2; i < args.length; ++i) {
                String playerName = args[i];
                Player player = Bukkit.getPlayerExact(playerName);
                OfflinePlayer offlinePlayer = player != null ? player : Bukkit.getOfflinePlayer(playerName);
                Team team = mainScoreboard.getPlayerTeam(offlinePlayer);
                if (team != null) {
                    team.removePlayer(offlinePlayer);
                    left.add(offlinePlayer.getName());
                    continue;
                }
                noTeam.add(offlinePlayer.getName());
            }
        }
        if (!left.isEmpty()) {
            sender.sendMessage("Removed " + left.size() + " player(s) from their teams: " + ScoreboardCommand.stringCollectionToString(left));
        }
        if (noTeam.isEmpty()) return true;
        sender.sendMessage("Could not remove " + noTeam.size() + " player(s) from their teams: " + ScoreboardCommand.stringCollectionToString(noTeam));
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        Validate.notNull((Object)sender, (String)"Sender cannot be null");
        Validate.notNull((Object)args, (String)"Arguments cannot be null");
        Validate.notNull((Object)alias, (String)"Alias cannot be null");
        if (args.length == 1) {
            return StringUtil.copyPartialMatches(args[0], MAIN_CHOICES, new ArrayList());
        }
        if (args.length > 1) {
            if (args[0].equalsIgnoreCase("objectives")) {
                if (args.length == 2) {
                    return StringUtil.copyPartialMatches(args[1], OBJECTIVES_CHOICES, new ArrayList());
                }
                if (args[1].equalsIgnoreCase("add")) {
                    if (args.length == 4) {
                        return StringUtil.copyPartialMatches(args[3], OBJECTIVES_CRITERIA, new ArrayList());
                    }
                } else if (args[1].equalsIgnoreCase("remove")) {
                    if (args.length == 3) {
                        return StringUtil.copyPartialMatches(args[2], this.getCurrentObjectives(), new ArrayList());
                    }
                } else if (args[1].equalsIgnoreCase("setdisplay")) {
                    if (args.length == 3) {
                        return StringUtil.copyPartialMatches(args[2], OBJECTIVES_DISPLAYSLOT.keySet(), new ArrayList());
                    }
                    if (args.length == 4) {
                        return StringUtil.copyPartialMatches(args[3], this.getCurrentObjectives(), new ArrayList());
                    }
                }
            } else if (args[0].equalsIgnoreCase("players")) {
                if (args.length == 2) {
                    return StringUtil.copyPartialMatches(args[1], PLAYERS_CHOICES, new ArrayList());
                }
                if (args[1].equalsIgnoreCase("set") || args[1].equalsIgnoreCase("add") || args[1].equalsIgnoreCase("remove")) {
                    if (args.length == 3) {
                        return super.tabComplete(sender, alias, args);
                    }
                    if (args.length == 4) {
                        return StringUtil.copyPartialMatches(args[3], this.getCurrentObjectives(), new ArrayList());
                    }
                } else if (args.length == 3) {
                    return StringUtil.copyPartialMatches(args[2], this.getCurrentPlayers(), new ArrayList());
                }
            } else if (args[0].equalsIgnoreCase("teams")) {
                if (args.length == 2) {
                    return StringUtil.copyPartialMatches(args[1], TEAMS_CHOICES, new ArrayList());
                }
                if (args[1].equalsIgnoreCase("join")) {
                    if (args.length == 3) {
                        return StringUtil.copyPartialMatches(args[2], this.getCurrentTeams(), new ArrayList());
                    }
                    if (args.length >= 4) {
                        return super.tabComplete(sender, alias, args);
                    }
                } else {
                    if (args[1].equalsIgnoreCase("leave")) {
                        return super.tabComplete(sender, alias, args);
                    }
                    if (args[1].equalsIgnoreCase("option")) {
                        if (args.length == 3) {
                            return StringUtil.copyPartialMatches(args[2], this.getCurrentTeams(), new ArrayList());
                        }
                        if (args.length == 4) {
                            return StringUtil.copyPartialMatches(args[3], TEAMS_OPTION_CHOICES, new ArrayList());
                        }
                        if (args.length == 5) {
                            if (args[3].equalsIgnoreCase("color")) {
                                return StringUtil.copyPartialMatches(args[4], TEAMS_OPTION_COLOR.keySet(), new ArrayList());
                            }
                            return StringUtil.copyPartialMatches(args[4], BOOLEAN, new ArrayList());
                        }
                    } else if (args.length == 3) {
                        return StringUtil.copyPartialMatches(args[2], this.getCurrentTeams(), new ArrayList());
                    }
                }
            }
        }
        return ImmutableList.of();
    }

    private static String offlinePlayerSetToString(Set<OfflinePlayer> set) {
        StringBuilder string = new StringBuilder();
        String lastValue = null;
        for (OfflinePlayer value : set) {
            lastValue = value.getName();
            string.append(lastValue).append(", ");
        }
        string.delete(string.length() - 2, Integer.MAX_VALUE);
        if (string.length() != lastValue.length()) {
            string.insert(string.length() - lastValue.length(), "and ");
        }
        return string.toString();
    }

    private static String stringCollectionToString(Collection<String> set) {
        StringBuilder string = new StringBuilder();
        String lastValue = null;
        Iterator<String> i$ = set.iterator();
        while (i$.hasNext()) {
            String value;
            lastValue = value = i$.next();
            string.append(lastValue).append(", ");
        }
        string.delete(string.length() - 2, Integer.MAX_VALUE);
        if (string.length() != lastValue.length()) {
            string.insert(string.length() - lastValue.length(), "and ");
        }
        return string.toString();
    }

    private List<String> getCurrentObjectives() {
        ArrayList<String> list = new ArrayList<String>();
        for (Objective objective : Bukkit.getScoreboardManager().getMainScoreboard().getObjectives()) {
            list.add(objective.getName());
        }
        Collections.sort(list, String.CASE_INSENSITIVE_ORDER);
        return list;
    }

    private List<String> getCurrentPlayers() {
        ArrayList<String> list = new ArrayList<String>();
        for (OfflinePlayer player : Bukkit.getScoreboardManager().getMainScoreboard().getPlayers()) {
            list.add(player.getName());
        }
        Collections.sort(list, String.CASE_INSENSITIVE_ORDER);
        return list;
    }

    private List<String> getCurrentTeams() {
        ArrayList<String> list = new ArrayList<String>();
        for (Team team : Bukkit.getScoreboardManager().getMainScoreboard().getTeams()) {
            list.add(team.getName());
        }
        Collections.sort(list, String.CASE_INSENSITIVE_ORDER);
        return list;
    }
}

