/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_6_R3.block;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.cauldron.block.CraftCustomContainer;
import net.minecraftforge.common.EnumHelper;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.craftbukkit.v1_6_R3.CraftChunk;
import org.bukkit.craftbukkit.v1_6_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_6_R3.block.CraftBeacon;
import org.bukkit.craftbukkit.v1_6_R3.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_6_R3.block.CraftBrewingStand;
import org.bukkit.craftbukkit.v1_6_R3.block.CraftChest;
import org.bukkit.craftbukkit.v1_6_R3.block.CraftCommandBlock;
import org.bukkit.craftbukkit.v1_6_R3.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_6_R3.block.CraftDispenser;
import org.bukkit.craftbukkit.v1_6_R3.block.CraftDropper;
import org.bukkit.craftbukkit.v1_6_R3.block.CraftFurnace;
import org.bukkit.craftbukkit.v1_6_R3.block.CraftHopper;
import org.bukkit.craftbukkit.v1_6_R3.block.CraftJukebox;
import org.bukkit.craftbukkit.v1_6_R3.block.CraftNoteBlock;
import org.bukkit.craftbukkit.v1_6_R3.block.CraftSign;
import org.bukkit.craftbukkit.v1_6_R3.block.CraftSkull;
import org.bukkit.craftbukkit.v1_6_R3.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BlockVector;

public class CraftBlock
implements Block {
    private final CraftChunk chunk;
    private final int x;
    private final int y;
    private final int z;
    private static final Biome[] BIOME_MAPPING = new Biome[acq.a.length];
    private static final acq[] BIOMEBASE_MAPPING = new acq[acq.a.length];

    public CraftBlock(CraftChunk chunk, int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.chunk = chunk;
    }

    @Override
    public World getWorld() {
        return this.chunk.getWorld();
    }

    @Override
    public Location getLocation() {
        return new Location(this.getWorld(), this.x, this.y, this.z);
    }

    @Override
    public Location getLocation(Location loc) {
        if (loc != null) {
            loc.setWorld(this.getWorld());
            loc.setX(this.x);
            loc.setY(this.y);
            loc.setZ(this.z);
            loc.setYaw(0.0f);
            loc.setPitch(0.0f);
        }
        return loc;
    }

    public BlockVector getVector() {
        return new BlockVector(this.x, this.y, this.z);
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    @Override
    public Chunk getChunk() {
        return this.chunk;
    }

    @Override
    public void setData(byte data) {
        this.chunk.getHandle().e.b(this.x, this.y, this.z, (int)data, 3);
    }

    @Override
    public void setData(byte data, boolean applyPhysics) {
        if (applyPhysics) {
            this.chunk.getHandle().e.b(this.x, this.y, this.z, (int)data, 3);
        } else {
            this.chunk.getHandle().e.b(this.x, this.y, this.z, (int)data, 2);
        }
    }

    @Override
    public byte getData() {
        return (byte)this.chunk.getHandle().c(this.x & 0xF, this.y & 0xFF, this.z & 0xF);
    }

    @Override
    public void setType(Material type) {
        this.setTypeId(type.getId());
    }

    @Override
    public boolean setTypeId(int type) {
        return this.chunk.getHandle().e.f(this.x, this.y, this.z, type, (int)this.getData(), 3);
    }

    @Override
    public boolean setTypeId(int type, boolean applyPhysics) {
        if (applyPhysics) {
            return this.setTypeId(type);
        }
        return this.chunk.getHandle().e.f(this.x, this.y, this.z, type, (int)this.getData(), 2);
    }

    @Override
    public boolean setTypeIdAndData(int type, byte data, boolean applyPhysics) {
        if (applyPhysics) {
            return this.chunk.getHandle().e.f(this.x, this.y, this.z, type, (int)data, 3);
        }
        boolean success = this.chunk.getHandle().e.f(this.x, this.y, this.z, type, (int)data, 2);
        if (success) {
            this.chunk.getHandle().e.j(this.x, this.y, this.z);
        }
        return success;
    }

    @Override
    public Material getType() {
        return Material.getMaterial(this.getTypeId());
    }

    @Override
    public int getTypeId() {
        return this.chunk.getHandle().a(this.x & 0xF, this.y & 0xFF, this.z & 0xF);
    }

    @Override
    public byte getLightLevel() {
        return (byte)this.chunk.getHandle().e.n(this.x, this.y, this.z);
    }

    @Override
    public byte getLightFromSky() {
        return (byte)this.chunk.getHandle().a(ach.a, this.x & 0xF, this.y & 0xFF, this.z & 0xF);
    }

    @Override
    public byte getLightFromBlocks() {
        return (byte)this.chunk.getHandle().a(ach.b, this.x & 0xF, this.y & 0xFF, this.z & 0xF);
    }

    public Block getFace(BlockFace face) {
        return this.getRelative(face, 1);
    }

    public Block getFace(BlockFace face, int distance) {
        return this.getRelative(face, distance);
    }

    @Override
    public Block getRelative(int modX, int modY, int modZ) {
        return this.getWorld().getBlockAt(this.getX() + modX, this.getY() + modY, this.getZ() + modZ);
    }

    @Override
    public Block getRelative(BlockFace face) {
        return this.getRelative(face, 1);
    }

    @Override
    public Block getRelative(BlockFace face, int distance) {
        return this.getRelative(face.getModX() * distance, face.getModY() * distance, face.getModZ() * distance);
    }

    @Override
    public BlockFace getFace(Block block) {
        BlockFace[] values;
        for (BlockFace face : values = BlockFace.values()) {
            if (this.getX() + face.getModX() != block.getX() || this.getY() + face.getModY() != block.getY() || this.getZ() + face.getModZ() != block.getZ()) continue;
            return face;
        }
        return null;
    }

    public String toString() {
        return "CraftBlock{chunk=" + this.chunk + ",x=" + this.x + ",y=" + this.y + ",z=" + this.z + ",type=" + (Object)((Object)this.getType()) + ",data=" + this.getData() + '}';
    }

    public static BlockFace notchToBlockFace(int notch) {
        switch (notch) {
            case 0: {
                return BlockFace.DOWN;
            }
            case 1: {
                return BlockFace.UP;
            }
            case 2: {
                return BlockFace.NORTH;
            }
            case 3: {
                return BlockFace.SOUTH;
            }
            case 4: {
                return BlockFace.WEST;
            }
            case 5: {
                return BlockFace.EAST;
            }
        }
        return BlockFace.SELF;
    }

    public static int blockFaceToNotch(BlockFace face) {
        switch (face) {
            case DOWN: {
                return 0;
            }
            case UP: {
                return 1;
            }
            case NORTH: {
                return 2;
            }
            case SOUTH: {
                return 3;
            }
            case WEST: {
                return 4;
            }
            case EAST: {
                return 5;
            }
        }
        return 7;
    }

    @Override
    public BlockState getState() {
        Material material = this.getType();
        if (material == null) {
            asp te = ((CraftWorld)this.getWorld()).getHandle().r(this.getX(), this.getY(), this.getZ());
            if (te != null && te instanceof mo) {
                return new CraftCustomContainer((Block)this);
            }
            return new CraftBlockState(this);
        }
        switch (material) {
            case SIGN: 
            case SIGN_POST: 
            case WALL_SIGN: {
                return new CraftSign(this);
            }
            case CHEST: 
            case TRAPPED_CHEST: {
                return new CraftChest(this);
            }
            case BURNING_FURNACE: 
            case FURNACE: {
                return new CraftFurnace(this);
            }
            case DISPENSER: {
                return new CraftDispenser(this);
            }
            case DROPPER: {
                return new CraftDropper(this);
            }
            case HOPPER: {
                return new CraftHopper(this);
            }
            case MOB_SPAWNER: {
                return new CraftCreatureSpawner(this);
            }
            case NOTE_BLOCK: {
                return new CraftNoteBlock(this);
            }
            case JUKEBOX: {
                return new CraftJukebox(this);
            }
            case BREWING_STAND: {
                return new CraftBrewingStand(this);
            }
            case SKULL: {
                return new CraftSkull(this);
            }
            case COMMAND: {
                return new CraftCommandBlock(this);
            }
            case BEACON: {
                return new CraftBeacon(this);
            }
        }
        asp te = ((CraftWorld)this.getWorld()).getHandle().r(this.getX(), this.getY(), this.getZ());
        if (te != null && te instanceof mo) {
            return new CraftCustomContainer((Block)this);
        }
        return new CraftBlockState(this);
    }

    @Override
    public Biome getBiome() {
        return this.getWorld().getBiome(this.x, this.z);
    }

    @Override
    public void setBiome(Biome bio) {
        this.getWorld().setBiome(this.x, this.z, bio);
    }

    public static Biome biomeBaseToBiome(acq base) {
        if (base == null) {
            return null;
        }
        return BIOME_MAPPING[base.N];
    }

    public static acq biomeToBiomeBase(Biome bio) {
        if (bio == null) {
            return null;
        }
        return BIOMEBASE_MAPPING[bio.ordinal()];
    }

    @Override
    public double getTemperature() {
        return this.getWorld().getTemperature(this.x, this.z);
    }

    @Override
    public double getHumidity() {
        return this.getWorld().getHumidity(this.x, this.z);
    }

    @Override
    public boolean isBlockPowered() {
        return this.chunk.getHandle().e.B(this.x, this.y, this.z) > 0;
    }

    @Override
    public boolean isBlockIndirectlyPowered() {
        return this.chunk.getHandle().e.C(this.x, this.y, this.z);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CraftBlock)) {
            return false;
        }
        CraftBlock other = (CraftBlock)o;
        return this.x == other.x && this.y == other.y && this.z == other.z && this.getWorld().equals(other.getWorld());
    }

    public int hashCode() {
        return this.y << 24 ^ this.x ^ this.z ^ this.getWorld().hashCode();
    }

    @Override
    public boolean isBlockFacePowered(BlockFace face) {
        return this.chunk.getHandle().e.k(this.x, this.y, this.z, CraftBlock.blockFaceToNotch(face));
    }

    @Override
    public boolean isBlockFaceIndirectlyPowered(BlockFace face) {
        int power = this.chunk.getHandle().e.l(this.x, this.y, this.z, CraftBlock.blockFaceToNotch(face));
        Block relative = this.getRelative(face);
        if (relative.getType() == Material.REDSTONE_WIRE) {
            return Math.max(power, relative.getData()) > 0;
        }
        return power > 0;
    }

    @Override
    public int getBlockPower(BlockFace face) {
        int power = 0;
        aqb wire = aqz.aA;
        abw world = this.chunk.getHandle().e;
        if ((face == BlockFace.DOWN || face == BlockFace.SELF) && world.k(this.x, this.y - 1, this.z, 0)) {
            power = wire.d(world, this.x, this.y - 1, this.z, power);
        }
        if ((face == BlockFace.UP || face == BlockFace.SELF) && world.k(this.x, this.y + 1, this.z, 1)) {
            power = wire.d(world, this.x, this.y + 1, this.z, power);
        }
        if ((face == BlockFace.EAST || face == BlockFace.SELF) && world.k(this.x + 1, this.y, this.z, 2)) {
            power = wire.d(world, this.x + 1, this.y, this.z, power);
        }
        if ((face == BlockFace.WEST || face == BlockFace.SELF) && world.k(this.x - 1, this.y, this.z, 3)) {
            power = wire.d(world, this.x - 1, this.y, this.z, power);
        }
        if ((face == BlockFace.NORTH || face == BlockFace.SELF) && world.k(this.x, this.y, this.z - 1, 4)) {
            power = wire.d(world, this.x, this.y, this.z - 1, power);
        }
        if ((face == BlockFace.SOUTH || face == BlockFace.SELF) && world.k(this.x, this.y, this.z + 1, 5)) {
            power = wire.d(world, this.x, this.y, this.z - 1, power);
        }
        return power > 0 ? power : ((face == BlockFace.SELF ? this.isBlockIndirectlyPowered() : this.isBlockFaceIndirectlyPowered(face)) ? 15 : 0);
    }

    @Override
    public int getBlockPower() {
        return this.getBlockPower(BlockFace.SELF);
    }

    @Override
    public boolean isEmpty() {
        if (this.getType() == Material.AIR) {
            return true;
        }
        if (!(this.getWorld() instanceof CraftWorld)) {
            return false;
        }
        return ((CraftWorld)this.getWorld()).getHandle().c(this.getX(), this.getY(), this.getZ());
    }

    @Override
    public boolean isLiquid() {
        return this.getType() == Material.WATER || this.getType() == Material.STATIONARY_WATER || this.getType() == Material.LAVA || this.getType() == Material.STATIONARY_LAVA;
    }

    @Override
    public PistonMoveReaction getPistonMoveReaction() {
        return PistonMoveReaction.getById(aqz.s[this.getTypeId()].cU.m());
    }

    private boolean itemCausesDrops(ItemStack item) {
        aqz block = aqz.s[this.getTypeId()];
        yc itemType = item != null ? yc.g[item.getTypeId()] : null;
        return block != null && (block.cU.l() || itemType != null && itemType.a(block));
    }

    @Override
    public boolean breakNaturally() {
        aqz block = aqz.s[this.getTypeId()];
        byte data = this.getData();
        boolean result = false;
        if (block != null) {
            block.a(this.chunk.getHandle().e, this.x, this.y, this.z, (int)data, 1.0f, 0);
            result = true;
        }
        this.setTypeId(Material.AIR.getId());
        return result;
    }

    @Override
    public boolean breakNaturally(ItemStack item) {
        if (this.itemCausesDrops(item)) {
            return this.breakNaturally();
        }
        return this.setTypeId(Material.AIR.getId());
    }

    @Override
    public Collection<ItemStack> getDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        aqz block = aqz.s[this.getTypeId()];
        if (block != null) {
            byte data = this.getData();
            int count = block.a(0, this.chunk.getHandle().e.s);
            for (int i = 0; i < count; ++i) {
                int item = block.a((int)data, this.chunk.getHandle().e.s, 0);
                if (item <= 0) continue;
                if (aqz.cl.cF == this.getTypeId()) {
                    ye nmsStack = new ye(item, 1, block.h(this.chunk.getHandle().e, this.x, this.y, this.z));
                    asn tileentityskull = (asn)this.chunk.getHandle().e.r(this.x, this.y, this.z);
                    if (tileentityskull.a() == 3 && tileentityskull.c() != null && tileentityskull.c().length() > 0) {
                        nmsStack.d(new by());
                        nmsStack.q().a("SkullOwner", tileentityskull.c());
                    }
                    drops.add(CraftItemStack.asBukkitCopy(nmsStack));
                    continue;
                }
                drops.add(new ItemStack(item, 1, (short)block.a((int)data)));
            }
        }
        return drops;
    }

    @Override
    public Collection<ItemStack> getDrops(ItemStack item) {
        if (this.itemCausesDrops(item)) {
            return this.getDrops();
        }
        return Collections.emptyList();
    }

    public static void initMappings() {
        CraftBlock.BIOME_MAPPING[acq.h.N] = Biome.SWAMPLAND;
        CraftBlock.BIOME_MAPPING[acq.f.N] = Biome.FOREST;
        CraftBlock.BIOME_MAPPING[acq.g.N] = Biome.TAIGA;
        CraftBlock.BIOME_MAPPING[acq.d.N] = Biome.DESERT;
        CraftBlock.BIOME_MAPPING[acq.c.N] = Biome.PLAINS;
        CraftBlock.BIOME_MAPPING[acq.j.N] = Biome.HELL;
        CraftBlock.BIOME_MAPPING[acq.k.N] = Biome.SKY;
        CraftBlock.BIOME_MAPPING[acq.i.N] = Biome.RIVER;
        CraftBlock.BIOME_MAPPING[acq.e.N] = Biome.EXTREME_HILLS;
        CraftBlock.BIOME_MAPPING[acq.b.N] = Biome.OCEAN;
        CraftBlock.BIOME_MAPPING[acq.l.N] = Biome.FROZEN_OCEAN;
        CraftBlock.BIOME_MAPPING[acq.m.N] = Biome.FROZEN_RIVER;
        CraftBlock.BIOME_MAPPING[acq.n.N] = Biome.ICE_PLAINS;
        CraftBlock.BIOME_MAPPING[acq.o.N] = Biome.ICE_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[acq.p.N] = Biome.MUSHROOM_ISLAND;
        CraftBlock.BIOME_MAPPING[acq.q.N] = Biome.MUSHROOM_SHORE;
        CraftBlock.BIOME_MAPPING[acq.r.N] = Biome.BEACH;
        CraftBlock.BIOME_MAPPING[acq.s.N] = Biome.DESERT_HILLS;
        CraftBlock.BIOME_MAPPING[acq.t.N] = Biome.FOREST_HILLS;
        CraftBlock.BIOME_MAPPING[acq.u.N] = Biome.TAIGA_HILLS;
        CraftBlock.BIOME_MAPPING[acq.v.N] = Biome.SMALL_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[acq.w.N] = Biome.JUNGLE;
        CraftBlock.BIOME_MAPPING[acq.x.N] = Biome.JUNGLE_HILLS;
        for (int i = 0; i < BIOME_MAPPING.length; ++i) {
            if (acq.a[i] != null && BIOME_MAPPING[i] == null) {
                String name = acq.a[i].y;
                int id = acq.a[i].N;
                System.out.println("Adding biome mapping " + acq.a[i].N + " " + name + " at BiomeBase[" + i + "]");
                EnumHelper.addBukkitBiome((String)name);
                CraftBlock.BIOME_MAPPING[acq.a[i].N] = Enum.valueOf(Biome.class, name);
            }
            if (BIOME_MAPPING[i] == null) continue;
            CraftBlock.BIOMEBASE_MAPPING[CraftBlock.BIOME_MAPPING[i].ordinal()] = acq.a[i];
        }
    }

    public static void dumpMaterials() {
        MinecraftServer.F();
        if (MinecraftServer.cauldronConfig.dumpMaterials.getValue().booleanValue()) {
            FMLLog.info((String)"Cauldron Dump Materials is ENABLED. Starting dump...", (Object[])new Object[0]);
            for (int i = 0; i < 32000; ++i) {
                Material material = Material.getMaterial(i);
                if (material == null) continue;
                FMLLog.info((String)("Found material " + (Object)((Object)material) + " with ID " + i), (Object[])new Object[0]);
            }
            FMLLog.info((String)"Cauldron Dump Materials complete.", (Object[])new Object[0]);
            FMLLog.info((String)"To disable these dumps, set cauldron.dump-materials to false in bukkit.yml.", (Object[])new Object[0]);
        }
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.chunk.getCraftWorld().getBlockMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.chunk.getCraftWorld().getBlockMetadata().getMetadata(this, metadataKey);
    }

    @Override
    public boolean hasMetadata(String metadataKey) {
        return this.chunk.getCraftWorld().getBlockMetadata().hasMetadata(this, metadataKey);
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.chunk.getCraftWorld().getBlockMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }
}

