/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_6_R3.entity;

import org.apache.commons.lang.Validate;
import org.bukkit.Rotation;
import org.bukkit.craftbukkit.v1_6_R3.CraftServer;
import org.bukkit.craftbukkit.v1_6_R3.entity.CraftHanging;
import org.bukkit.craftbukkit.v1_6_R3.inventory.CraftItemStack;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemFrame;
import org.bukkit.inventory.ItemStack;

public class CraftItemFrame
extends CraftHanging
implements ItemFrame {
    public CraftItemFrame(CraftServer server, od entity) {
        super(server, (oc)entity);
    }

    @Override
    public void setItem(ItemStack item) {
        if (item == null || item.getTypeId() == 0) {
            this.getHandle().v().a(2, 5);
            this.getHandle().v().h(2);
        } else {
            this.getHandle().a(CraftItemStack.asNMSCopy(item));
        }
    }

    @Override
    public ItemStack getItem() {
        return CraftItemStack.asBukkitCopy(this.getHandle().h());
    }

    @Override
    public Rotation getRotation() {
        return this.toBukkitRotation(this.getHandle().i());
    }

    Rotation toBukkitRotation(int value) {
        switch (value) {
            case 0: {
                return Rotation.NONE;
            }
            case 1: {
                return Rotation.CLOCKWISE;
            }
            case 2: {
                return Rotation.FLIPPED;
            }
            case 3: {
                return Rotation.COUNTER_CLOCKWISE;
            }
        }
        throw new AssertionError((Object)("Unknown rotation " + value + " for " + this.getHandle()));
    }

    @Override
    public void setRotation(Rotation rotation) {
        Validate.notNull((Object)((Object)rotation), (String)"Rotation cannot be null");
        this.getHandle().c(CraftItemFrame.toInteger(rotation));
    }

    static int toInteger(Rotation rotation) {
        switch (rotation) {
            case NONE: {
                return 0;
            }
            case CLOCKWISE: {
                return 1;
            }
            case FLIPPED: {
                return 2;
            }
            case COUNTER_CLOCKWISE: {
                return 3;
            }
        }
        throw new IllegalArgumentException((Object)((Object)rotation) + " is not applicable to an ItemFrame");
    }

    public od getHandle() {
        return (od)this.entity;
    }

    @Override
    public String toString() {
        return "CraftItemFrame{item=" + this.getItem() + ", rotation=" + (Object)((Object)this.getRotation()) + "}";
    }

    @Override
    public EntityType getType() {
        return EntityType.ITEM_FRAME;
    }
}

