/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_6_R3.inventory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import net.minecraftforge.cauldron.CauldronUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_6_R3.inventory.CraftInventoryCustom;
import org.bukkit.craftbukkit.v1_6_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_6_R3.inventory.InventoryIterator;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class CraftInventory
implements Inventory {
    protected final mo inventory;

    public CraftInventory(mo inventory) {
        this.inventory = inventory;
    }

    public mo getInventory() {
        return this.inventory;
    }

    @Override
    public int getSize() {
        return this.getInventory().j_();
    }

    @Override
    public String getName() {
        return this.getInventory().b();
    }

    @Override
    public ItemStack getItem(int index) {
        ye item = this.getInventory().a(index);
        return item == null ? null : CraftItemStack.asCraftMirror(item);
    }

    @Override
    public ItemStack[] getContents() {
        ItemStack[] items = new ItemStack[this.getSize()];
        ye[] mcItems = null;
        try {
            mcItems = this.getInventory().getContents();
        }
        catch (AbstractMethodError e) {
            return new ItemStack[0];
        }
        int size = Math.min(items.length, mcItems.length);
        for (int i = 0; i < size; ++i) {
            items[i] = mcItems[i] == null ? null : CraftItemStack.asCraftMirror(mcItems[i]);
        }
        return items;
    }

    @Override
    public void setContents(ItemStack[] items) {
        if (this.getInventory().getContents().length < items.length) {
            throw new IllegalArgumentException("Invalid inventory size; expected " + this.getInventory().getContents().length + " or less");
        }
        ye[] mcItems = this.getInventory().getContents();
        for (int i = 0; i < mcItems.length; ++i) {
            mcItems[i] = i >= items.length ? null : CraftItemStack.asNMSCopy(items[i]);
        }
    }

    @Override
    public void setItem(int index, ItemStack item) {
        this.getInventory().a(index, item == null || item.getTypeId() == 0 ? null : CraftItemStack.asNMSCopy(item));
    }

    @Override
    public boolean contains(int materialId) {
        for (ItemStack item : this.getContents()) {
            if (item == null || item.getTypeId() != materialId) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Material material) {
        Validate.notNull((Object)((Object)material), (String)"Material cannot be null");
        return this.contains(material.getId());
    }

    @Override
    public boolean contains(ItemStack item) {
        if (item == null) {
            return false;
        }
        for (ItemStack i : this.getContents()) {
            if (!item.equals(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(int materialId, int amount) {
        if (amount <= 0) {
            return true;
        }
        for (ItemStack item : this.getContents()) {
            if (item == null || item.getTypeId() != materialId || (amount -= item.getAmount()) > 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Material material, int amount) {
        Validate.notNull((Object)((Object)material), (String)"Material cannot be null");
        return this.contains(material.getId(), amount);
    }

    @Override
    public boolean contains(ItemStack item, int amount) {
        if (item == null) {
            return false;
        }
        if (amount <= 0) {
            return true;
        }
        for (ItemStack i : this.getContents()) {
            if (!item.equals(i) || --amount > 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAtLeast(ItemStack item, int amount) {
        if (item == null) {
            return false;
        }
        if (amount <= 0) {
            return true;
        }
        for (ItemStack i : this.getContents()) {
            if (!item.isSimilar(i) || (amount -= i.getAmount()) > 0) continue;
            return true;
        }
        return false;
    }

    public HashMap<Integer, ItemStack> all(int materialId) {
        HashMap<Integer, ItemStack> slots = new HashMap<Integer, ItemStack>();
        ItemStack[] inventory = this.getContents();
        for (int i = 0; i < inventory.length; ++i) {
            ItemStack item = inventory[i];
            if (item == null || item.getTypeId() != materialId) continue;
            slots.put(i, item);
        }
        return slots;
    }

    public HashMap<Integer, ItemStack> all(Material material) {
        Validate.notNull((Object)((Object)material), (String)"Material cannot be null");
        return this.all(material.getId());
    }

    public HashMap<Integer, ItemStack> all(ItemStack item) {
        HashMap<Integer, ItemStack> slots = new HashMap<Integer, ItemStack>();
        if (item != null) {
            ItemStack[] inventory = this.getContents();
            for (int i = 0; i < inventory.length; ++i) {
                if (!item.equals(inventory[i])) continue;
                slots.put(i, inventory[i]);
            }
        }
        return slots;
    }

    @Override
    public int first(int materialId) {
        ItemStack[] inventory = this.getContents();
        for (int i = 0; i < inventory.length; ++i) {
            ItemStack item = inventory[i];
            if (item == null || item.getTypeId() != materialId) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int first(Material material) {
        Validate.notNull((Object)((Object)material), (String)"Material cannot be null");
        return this.first(material.getId());
    }

    @Override
    public int first(ItemStack item) {
        return this.first(item, true);
    }

    private int first(ItemStack item, boolean withAmount) {
        if (item == null) {
            return -1;
        }
        ItemStack[] inventory = this.getContents();
        for (int i = 0; i < inventory.length; ++i) {
            if (inventory[i] == null || !(withAmount ? item.equals(inventory[i]) : item.isSimilar(inventory[i]))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int firstEmpty() {
        ItemStack[] inventory = this.getContents();
        for (int i = 0; i < inventory.length; ++i) {
            if (inventory[i] != null) continue;
            return i;
        }
        return -1;
    }

    public int firstPartial(int materialId) {
        ItemStack[] inventory = this.getContents();
        for (int i = 0; i < inventory.length; ++i) {
            ItemStack item = inventory[i];
            if (item == null || item.getTypeId() != materialId || item.getAmount() >= item.getMaxStackSize()) continue;
            return i;
        }
        return -1;
    }

    public int firstPartial(Material material) {
        Validate.notNull((Object)((Object)material), (String)"Material cannot be null");
        return this.firstPartial(material.getId());
    }

    private int firstPartial(ItemStack item) {
        ItemStack[] inventory = this.getContents();
        CraftItemStack filteredItem = CraftItemStack.asCraftCopy(item);
        if (item == null) {
            return -1;
        }
        for (int i = 0; i < inventory.length; ++i) {
            ItemStack cItem = inventory[i];
            if (cItem == null || cItem.getAmount() >= cItem.getMaxStackSize() || !cItem.isSimilar(filteredItem)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public HashMap<Integer, ItemStack> addItem(ItemStack ... items) {
        Validate.noNullElements((Object[])items, (String)"Item cannot be null");
        HashMap<Integer, ItemStack> leftover = new HashMap<Integer, ItemStack>();
        block0: for (int i = 0; i < items.length; ++i) {
            ItemStack item = items[i];
            while (true) {
                int maxAmount;
                int partialAmount;
                int firstPartial;
                if ((firstPartial = this.firstPartial(item)) == -1) {
                    int firstFree = this.firstEmpty();
                    if (firstFree == -1) {
                        leftover.put(i, item);
                        continue block0;
                    }
                    if (item.getAmount() > this.getMaxItemStack()) {
                        CraftItemStack stack = CraftItemStack.asCraftCopy(item);
                        stack.setAmount(this.getMaxItemStack());
                        this.setItem(firstFree, stack);
                        item.setAmount(item.getAmount() - this.getMaxItemStack());
                        continue;
                    }
                    this.setItem(firstFree, item);
                    continue block0;
                }
                ItemStack partialItem = this.getItem(firstPartial);
                int amount = item.getAmount();
                if (amount + (partialAmount = partialItem.getAmount()) <= (maxAmount = partialItem.getMaxStackSize())) {
                    partialItem.setAmount(amount + partialAmount);
                    continue block0;
                }
                partialItem.setAmount(maxAmount);
                item.setAmount(amount + partialAmount - maxAmount);
            }
        }
        return leftover;
    }

    @Override
    public HashMap<Integer, ItemStack> removeItem(ItemStack ... items) {
        Validate.notNull((Object)items, (String)"Items cannot be null");
        HashMap<Integer, ItemStack> leftover = new HashMap<Integer, ItemStack>();
        block0: for (int i = 0; i < items.length; ++i) {
            ItemStack item = items[i];
            int toDelete = item.getAmount();
            do {
                int first;
                if ((first = this.first(item, false)) == -1) {
                    item.setAmount(toDelete);
                    leftover.put(i, item);
                    continue block0;
                }
                ItemStack itemStack = this.getItem(first);
                int amount = itemStack.getAmount();
                if (amount <= toDelete) {
                    toDelete -= amount;
                    this.clear(first);
                    continue;
                }
                itemStack.setAmount(amount - toDelete);
                this.setItem(first, itemStack);
                toDelete = 0;
            } while (toDelete > 0);
        }
        return leftover;
    }

    private int getMaxItemStack() {
        return this.getInventory().d();
    }

    @Override
    public void remove(int materialId) {
        ItemStack[] items = this.getContents();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || items[i].getTypeId() != materialId) continue;
            this.clear(i);
        }
    }

    @Override
    public void remove(Material material) {
        Validate.notNull((Object)((Object)material), (String)"Material cannot be null");
        this.remove(material.getId());
    }

    @Override
    public void remove(ItemStack item) {
        ItemStack[] items = this.getContents();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || !items[i].equals(item)) continue;
            this.clear(i);
        }
    }

    @Override
    public void clear(int index) {
        this.setItem(index, null);
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.getSize(); ++i) {
            this.clear(i);
        }
    }

    @Override
    public ListIterator<ItemStack> iterator() {
        return new InventoryIterator(this);
    }

    @Override
    public ListIterator<ItemStack> iterator(int index) {
        if (index < 0) {
            index += this.getSize() + 1;
        }
        return new InventoryIterator(this, index);
    }

    @Override
    public List<HumanEntity> getViewers() {
        try {
            return this.inventory.getViewers();
        }
        catch (AbstractMethodError e) {
            return new ArrayList<HumanEntity>();
        }
    }

    @Override
    public String getTitle() {
        return this.inventory.b();
    }

    @Override
    public InventoryType getType() {
        if (this.inventory instanceof vk) {
            return this.inventory.j_() >= 9 ? InventoryType.WORKBENCH : InventoryType.CRAFTING;
        }
        if (this.inventory instanceof ud) {
            return InventoryType.PLAYER;
        }
        if (this.inventory instanceof asd) {
            return InventoryType.DROPPER;
        }
        if (this.inventory instanceof asc) {
            return InventoryType.DISPENSER;
        }
        if (this.inventory instanceof asg) {
            return InventoryType.FURNACE;
        }
        if (this.inventory instanceof vn) {
            return InventoryType.ENCHANTING;
        }
        if (this.inventory instanceof arx) {
            return InventoryType.BREWING;
        }
        if (this.inventory instanceof CraftInventoryCustom.MinecraftInventory) {
            return ((CraftInventoryCustom.MinecraftInventory)this.inventory).getType();
        }
        if (this.inventory instanceof wb) {
            return InventoryType.ENDER_CHEST;
        }
        if (this.inventory instanceof vy) {
            return InventoryType.MERCHANT;
        }
        if (this.inventory instanceof arw) {
            return InventoryType.BEACON;
        }
        if (this.inventory instanceof vb) {
            return InventoryType.ANVIL;
        }
        if (this.inventory instanceof ash) {
            return InventoryType.HOPPER;
        }
        return InventoryType.CHEST;
    }

    @Override
    public InventoryHolder getHolder() {
        try {
            return this.inventory.getOwner();
        }
        catch (AbstractMethodError e) {
            if (this.inventory instanceof asp) {
                return CauldronUtils.getOwner((asp)((asp)this.inventory));
            }
            return null;
        }
    }

    @Override
    public int getMaxStackSize() {
        return this.inventory.d();
    }

    @Override
    public void setMaxStackSize(int size) {
        this.inventory.setMaxStackSize(size);
    }
}

