/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_6_R3.scoreboard;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_6_R3.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.v1_6_R3.scoreboard.CraftScoreboardComponent;
import org.bukkit.scoreboard.Team;

final class CraftTeam
extends CraftScoreboardComponent
implements Team {
    private final atf team;

    CraftTeam(CraftScoreboard scoreboard, atf team) {
        super(scoreboard);
        this.team = team;
        scoreboard.teams.put(team.b(), this);
    }

    @Override
    public String getName() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return this.team.b();
    }

    @Override
    public String getDisplayName() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return this.team.c();
    }

    @Override
    public void setDisplayName(String displayName) throws IllegalStateException {
        Validate.notNull((Object)displayName, (String)"Display name cannot be null");
        Validate.isTrue((displayName.length() <= 32 ? 1 : 0) != 0, (String)("Display name '" + displayName + "' is longer than the limit of 32 characters"));
        CraftScoreboard scoreboard = this.checkState();
        this.team.a(displayName);
    }

    @Override
    public String getPrefix() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return this.team.e();
    }

    @Override
    public void setPrefix(String prefix) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull((Object)prefix, (String)"Prefix cannot be null");
        Validate.isTrue((prefix.length() <= 32 ? 1 : 0) != 0, (String)("Prefix '" + prefix + "' is longer than the limit of 32 characters"));
        CraftScoreboard scoreboard = this.checkState();
        this.team.b(prefix);
    }

    @Override
    public String getSuffix() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return this.team.f();
    }

    @Override
    public void setSuffix(String suffix) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull((Object)suffix, (String)"Suffix cannot be null");
        Validate.isTrue((suffix.length() <= 32 ? 1 : 0) != 0, (String)("Suffix '" + suffix + "' is longer than the limit of 32 characters"));
        CraftScoreboard scoreboard = this.checkState();
        this.team.c(suffix);
    }

    @Override
    public boolean allowFriendlyFire() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return this.team.g();
    }

    @Override
    public void setAllowFriendlyFire(boolean enabled) throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        this.team.a(enabled);
    }

    @Override
    public boolean canSeeFriendlyInvisibles() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return this.team.h();
    }

    @Override
    public void setCanSeeFriendlyInvisibles(boolean enabled) throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        this.team.b(enabled);
    }

    @Override
    public Set<OfflinePlayer> getPlayers() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        ImmutableSet.Builder players = ImmutableSet.builder();
        for (Object o : this.team.d()) {
            players.add((Object)Bukkit.getOfflinePlayer(o.toString()));
        }
        return players.build();
    }

    @Override
    public int getSize() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return this.team.d().size();
    }

    @Override
    public void addPlayer(OfflinePlayer player) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull((Object)player, (String)"OfflinePlayer cannot be null");
        CraftScoreboard scoreboard = this.checkState();
        scoreboard.board.a(player.getName(), this.team);
    }

    @Override
    public boolean removePlayer(OfflinePlayer player) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull((Object)player, (String)"OfflinePlayer cannot be null");
        CraftScoreboard scoreboard = this.checkState();
        if (!this.team.d().contains(player.getName())) {
            return false;
        }
        scoreboard.board.b(player.getName(), this.team);
        return true;
    }

    @Override
    public boolean hasPlayer(OfflinePlayer player) throws IllegalArgumentException, IllegalStateException {
        Validate.notNull((Object)player, (String)"OfflinePlayer cannot be null");
        CraftScoreboard scoreboard = this.checkState();
        return this.team.d().contains(player.getName());
    }

    @Override
    public void unregister() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        scoreboard.board.d(this.team);
        scoreboard.teams.remove(this.team.b());
        this.setUnregistered();
    }
}

