/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.map;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public final class MapPalette {
    private static final Color[] colors = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), MapPalette.c(89, 125, 39), MapPalette.c(109, 153, 48), MapPalette.c(27, 178, 56), MapPalette.c(109, 153, 48), MapPalette.c(174, 164, 115), MapPalette.c(213, 201, 140), MapPalette.c(247, 233, 163), MapPalette.c(213, 201, 140), MapPalette.c(117, 117, 117), MapPalette.c(144, 144, 144), MapPalette.c(167, 167, 167), MapPalette.c(144, 144, 144), MapPalette.c(180, 0, 0), MapPalette.c(220, 0, 0), MapPalette.c(255, 0, 0), MapPalette.c(220, 0, 0), MapPalette.c(112, 112, 180), MapPalette.c(138, 138, 220), MapPalette.c(160, 160, 255), MapPalette.c(138, 138, 220), MapPalette.c(117, 117, 117), MapPalette.c(144, 144, 144), MapPalette.c(167, 167, 167), MapPalette.c(144, 144, 144), MapPalette.c(0, 87, 0), MapPalette.c(0, 106, 0), MapPalette.c(0, 124, 0), MapPalette.c(0, 106, 0), MapPalette.c(180, 180, 180), MapPalette.c(220, 220, 220), MapPalette.c(255, 255, 255), MapPalette.c(220, 220, 220), MapPalette.c(115, 118, 129), MapPalette.c(141, 144, 158), MapPalette.c(164, 168, 184), MapPalette.c(141, 144, 158), MapPalette.c(129, 74, 33), MapPalette.c(157, 91, 40), MapPalette.c(183, 106, 47), MapPalette.c(157, 91, 40), MapPalette.c(79, 79, 79), MapPalette.c(96, 96, 96), MapPalette.c(112, 112, 112), MapPalette.c(96, 96, 96), MapPalette.c(45, 45, 180), MapPalette.c(55, 55, 220), MapPalette.c(64, 64, 255), MapPalette.c(55, 55, 220), MapPalette.c(73, 58, 35), MapPalette.c(89, 71, 43), MapPalette.c(104, 83, 50), MapPalette.c(89, 71, 43)};
    @Deprecated
    public static final byte TRANSPARENT = 0;
    @Deprecated
    public static final byte LIGHT_GREEN = 4;
    @Deprecated
    public static final byte LIGHT_BROWN = 8;
    @Deprecated
    public static final byte GRAY_1 = 12;
    @Deprecated
    public static final byte RED = 16;
    @Deprecated
    public static final byte PALE_BLUE = 20;
    @Deprecated
    public static final byte GRAY_2 = 24;
    @Deprecated
    public static final byte DARK_GREEN = 28;
    @Deprecated
    public static final byte WHITE = 32;
    @Deprecated
    public static final byte LIGHT_GRAY = 36;
    @Deprecated
    public static final byte BROWN = 40;
    @Deprecated
    public static final byte DARK_GRAY = 44;
    @Deprecated
    public static final byte BLUE = 48;
    @Deprecated
    public static final byte DARK_BROWN = 52;

    private MapPalette() {
    }

    private static Color c(int r, int g, int b) {
        return new Color(r, g, b);
    }

    private static double getDistance(Color c1, Color c2) {
        double rmean = (double)(c1.getRed() + c2.getRed()) / 2.0;
        double r = c1.getRed() - c2.getRed();
        double g = c1.getGreen() - c2.getGreen();
        int b = c1.getBlue() - c2.getBlue();
        double weightR = 2.0 + rmean / 256.0;
        double weightG = 4.0;
        double weightB = 2.0 + (255.0 - rmean) / 256.0;
        return weightR * r * r + weightG * g * g + weightB * (double)b * (double)b;
    }

    public static BufferedImage resizeImage(Image image) {
        BufferedImage result = new BufferedImage(128, 128, 2);
        Graphics2D graphics = result.createGraphics();
        graphics.drawImage(image, 0, 0, 128, 128, null);
        graphics.dispose();
        return result;
    }

    @Deprecated
    public static byte[] imageToBytes(Image image) {
        BufferedImage temp = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D graphics = temp.createGraphics();
        graphics.drawImage(image, 0, 0, null);
        graphics.dispose();
        int[] pixels = new int[temp.getWidth() * temp.getHeight()];
        temp.getRGB(0, 0, temp.getWidth(), temp.getHeight(), pixels, 0, temp.getWidth());
        byte[] result = new byte[temp.getWidth() * temp.getHeight()];
        for (int i = 0; i < pixels.length; ++i) {
            result[i] = MapPalette.matchColor(new Color(pixels[i], true));
        }
        return result;
    }

    @Deprecated
    public static byte matchColor(int r, int g, int b) {
        return MapPalette.matchColor(new Color(r, g, b));
    }

    @Deprecated
    public static byte matchColor(Color color) {
        if (color.getAlpha() < 128) {
            return 0;
        }
        int index = 0;
        double best = -1.0;
        for (int i = 4; i < colors.length; ++i) {
            double distance = MapPalette.getDistance(color, colors[i]);
            if (!(distance < best) && best != -1.0) continue;
            best = distance;
            index = i;
        }
        return (byte)index;
    }

    @Deprecated
    public static Color getColor(byte index) {
        if (index < 0 || index >= colors.length) {
            throw new IndexOutOfBoundsException();
        }
        return colors[index];
    }
}

